/*
 * Decompiled with CFR 0.152.
 */
package com.sothawo.mapjfx;

import com.sothawo.mapjfx.Coordinate;
import com.sothawo.mapjfx.MapCoordinateElement;
import com.sothawo.mapjfx.Marker;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;

public class MapLabel
extends MapCoordinateElement {
    private static final AtomicLong nextId = new AtomicLong(1L);
    private final String id;
    private final String text;
    private Optional<Marker> optMarker = Optional.empty();

    public MapLabel(String text) {
        this(text, 0, 0);
    }

    public MapLabel(String text, int offsetX, int offsetY) {
        super(offsetX, offsetY);
        this.text = Objects.requireNonNull(text);
        if (text.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.id = "label-" + nextId.getAndIncrement();
    }

    @Override
    public MapLabel setCssClass(String cssClass) {
        return (MapLabel)super.setCssClass(cssClass);
    }

    @Override
    public MapLabel setRotation(Integer rotation) {
        super.setRotation(rotation);
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String toString() {
        return "Label{id='" + this.id + "', text='" + this.text + "'} " + super.toString();
    }

    @Override
    public MapLabel setPosition(Coordinate position) {
        return (MapLabel)super.setPosition(position);
    }

    public String getText() {
        return this.text;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapLabel mapLabel = (MapLabel)o;
        return Objects.equals(this.id, mapLabel.id);
    }

    public Optional<Marker> getMarker() {
        return this.optMarker;
    }

    void setMarker(Marker marker) {
        this.optMarker = Optional.ofNullable(marker);
    }

    @Override
    public MapLabel setVisible(boolean visible) {
        if (!this.optMarker.isPresent()) {
            return (MapLabel)super.setVisible(visible);
        }
        this.optMarker.get().setVisible(visible);
        return this;
    }
}

