/*
 * Decompiled with CFR 0.152.
 */
package com.sothawo.mapjfx.app;

import com.sothawo.mapjfx.Configuration;
import com.sothawo.mapjfx.Coordinate;
import com.sothawo.mapjfx.CoordinateLine;
import com.sothawo.mapjfx.Extent;
import com.sothawo.mapjfx.MapCircle;
import com.sothawo.mapjfx.MapLabel;
import com.sothawo.mapjfx.MapType;
import com.sothawo.mapjfx.MapView;
import com.sothawo.mapjfx.Marker;
import com.sothawo.mapjfx.WMSParam;
import com.sothawo.mapjfx.XYZParam;
import com.sothawo.mapjfx.event.MapLabelEvent;
import com.sothawo.mapjfx.event.MapViewEvent;
import com.sothawo.mapjfx.event.MarkerEvent;
import com.sothawo.mapjfx.offline.OfflineCache;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.util.Collections;
import java.util.LinkedList;
import javafx.application.Application;
import javafx.beans.property.Property;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestApp
extends Application {
    private static final Logger logger = LoggerFactory.getLogger(TestApp.class);
    private static final Coordinate coordKarlsruheCastle = new Coordinate(49.013517, 8.404435);
    private static final Coordinate coordKarlsruheHarbour = new Coordinate(49.015511, 8.323497);
    private static final Coordinate coordKarlsruheStation = new Coordinate(48.993284, 8.402186);
    private static final Extent extentAll = Extent.forCoordinates(coordKarlsruheHarbour, coordKarlsruheCastle, coordKarlsruheStation);
    private static final CoordinateLine coordinateLine = new CoordinateLine(coordKarlsruheCastle, coordKarlsruheHarbour, coordKarlsruheStation).setVisible(true).setColor(Color.DODGERBLUE).setWidth(7).setClosed(true).setFillColor(Color.web((String)"lawngreen", (double)0.5));
    private static final Marker marker = Marker.createProvided(Marker.Provided.BLUE).setPosition(coordKarlsruheCastle).setRotation(90).setVisible(true);
    private static final MapCircle circle;
    private static final MapLabel mapLabel;
    private static final WMSParam wmsParam;
    private static final XYZParam xyzParam;
    private MapView mapView;
    private TextField bingApiKey;

    public static void main(String[] args) {
        TestApp.launch((String[])args);
    }

    public void start(Stage primaryStage) throws Exception {
        logger.info("starting devtest program...");
        BorderPane borderPane = new BorderPane();
        this.mapView = new MapView();
        this.mapView.setAnimationDuration(500);
        borderPane.setCenter((Node)this.mapView);
        Pane topPane = this.createTopPane();
        borderPane.setTop((Node)topPane);
        borderPane.setBottom((Node)this.createBottomPane());
        this.mapView.setWMSParam(wmsParam);
        this.mapView.setXYZParam(xyzParam);
        this.mapView.addEventHandler(MapViewEvent.MAP_CLICKED, event -> {
            logger.info("MAP_CLICKED event at {}", (Object)event.getCoordinate().normalize());
            event.consume();
            if (marker.getVisible()) {
                marker.setPosition(event.getCoordinate());
            }
            if (mapLabel.getVisible()) {
                mapLabel.setPosition(event.getCoordinate());
            }
        });
        this.mapView.addEventHandler(MapViewEvent.MAP_RIGHTCLICKED, event -> {
            logger.info("MAP_RIGHTCLICKED event at {}", (Object)event.getCoordinate());
            event.consume();
        });
        this.mapView.addEventHandler(MapViewEvent.MAP_EXTENT, event -> {
            logger.info("MAP_EXTENT event: {}", (Object)event.getExtent());
            this.mapView.setExtent(event.getExtent());
            event.consume();
        });
        this.mapView.addEventHandler(MapViewEvent.MAP_BOUNDING_EXTENT, event -> {
            logger.info("MAP_BOUNDING_EXTENT event: {}", (Object)event.getExtent());
            event.consume();
        });
        this.mapView.addEventHandler(MarkerEvent.MARKER_CLICKED, event -> {
            Marker marker = event.getMarker();
            logger.info("MARKER_CLICKED event: {}", (Object)marker);
            event.consume();
            marker.setRotation(marker.getRotation() + 5);
        });
        this.mapView.addEventHandler(MarkerEvent.MARKER_MOUSEDOWN, event -> {
            logger.info("MARKER_MOUSEDOWN event: {}", (Object)event.getMarker());
            event.consume();
        });
        this.mapView.addEventHandler(MarkerEvent.MARKER_MOUSEUP, event -> {
            logger.info("MARKER_MOUSEUP event: {}", (Object)event.getMarker());
            event.consume();
        });
        this.mapView.addEventHandler(MarkerEvent.MARKER_DOUBLECLICKED, event -> {
            logger.info("MARKER_DOUBLECLICKED event: {}", (Object)event.getMarker());
            event.consume();
        });
        this.mapView.addEventHandler(MarkerEvent.MARKER_RIGHTCLICKED, event -> {
            logger.info("MARKER_RIGHTCLICKED event: {}", (Object)event.getMarker());
            event.consume();
        });
        this.mapView.addEventHandler(MarkerEvent.MARKER_ENTERED, event -> {
            logger.info("MARKER_ENTERED event: {}", (Object)event.getMarker());
            event.consume();
        });
        this.mapView.addEventHandler(MarkerEvent.MARKER_EXITED, event -> {
            logger.info("MARKER_EXITED event: {}", (Object)event.getMarker());
            event.consume();
        });
        this.mapView.addEventHandler(MapLabelEvent.MAPLABEL_MOUSEDOWN, event -> {
            logger.info("MAPLABEL_MOUSEDOWN event: {}", (Object)event.getMapLabel());
            event.consume();
        });
        this.mapView.addEventHandler(MapLabelEvent.MAPLABEL_MOUSEUP, event -> {
            logger.info("MAPLABEL_MOUSEUP event: {}", (Object)event.getMapLabel());
            event.consume();
        });
        this.mapView.addEventHandler(MapLabelEvent.MAPLABEL_CLICKED, event -> {
            logger.info("MAPLABEL_CLICKED event: {}", (Object)event.getMapLabel());
            event.consume();
        });
        this.mapView.addEventHandler(MapLabelEvent.MAPLABEL_RIGHTCLICKED, event -> {
            logger.info("MAPLABEL_RIGHTCLICKED event: {}", (Object)event.getMapLabel());
            event.consume();
        });
        this.mapView.addEventHandler(MapLabelEvent.MAPLABEL_DOUBLECLICKED, event -> {
            logger.info("MAPLABEL_DOUBLECLICKED event:{}", (Object)event.getMapLabel());
            event.consume();
        });
        this.mapView.addEventHandler(MapLabelEvent.MAPLABEL_ENTERED, event -> {
            logger.info("MAPLABEL_ENTERED event: {}", (Object)event.getMapLabel());
            event.consume();
            event.getMapLabel().setCssClass("green-label");
        });
        this.mapView.addEventHandler(MapLabelEvent.MAPLABEL_EXITED, event -> {
            logger.info("MAPLABEL_EXITED event: {}", (Object)event.getMapLabel());
            event.consume();
            event.getMapLabel().setCssClass("blue-label");
        });
        this.mapView.addEventHandler(MapViewEvent.MAP_POINTER_MOVED, event -> {
            logger.info("MAP_POINTER_MOVED event: {}", (Object)event.getCoordinate());
            event.consume();
        });
        this.initOfflineCache();
        this.mapView.initializedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.mapView.setCenter(coordKarlsruheHarbour);
                this.mapView.setExtent(extentAll);
                this.mapView.addMarker(Marker.createProvided(Marker.Provided.GREEN).setPosition(coordKarlsruheHarbour).setVisible(true));
                this.mapView.addMarker(Marker.createProvided(Marker.Provided.ORANGE).setPosition(coordKarlsruheStation).setVisible(true));
                this.mapView.addCoordinateLine(new CoordinateLine(coordKarlsruheHarbour, coordKarlsruheStation, coordKarlsruheCastle).setVisible(true).setColor(Color.FUCHSIA).setWidth(5));
                this.mapView.addLabel(new MapLabel("clean me up").setPosition(coordKarlsruheStation).setVisible(true));
                this.mapView.addMapCircle(circle);
                this.mapView.addMapCircle(new MapCircle(coordKarlsruheHarbour, 100.0).setVisible(true));
                topPane.setDisable(false);
            }
        });
        this.mapView.setCustomMapviewCssURL(((Object)((Object)this)).getClass().getResource("/custom_mapview.css"));
        this.mapView.setMapType(MapType.XYZ);
        this.mapView.initialize(Configuration.builder().build());
        Scene scene = new Scene((Parent)borderPane, 1200.0, 800.0);
        primaryStage.setTitle("sothawo mapjfx devtest program");
        primaryStage.setScene(scene);
        primaryStage.show();
        logger.debug("application started.");
    }

    public void stop() throws Exception {
        this.mapView.close();
        super.stop();
    }

    private void initOfflineCache() {
        OfflineCache offlineCache = OfflineCache.INSTANCE;
        offlineCache.setCacheDirectory(FileSystems.getDefault().getPath("tmpdata/cache", new String[0]));
        offlineCache.setActive(true);
        offlineCache.setNoCacheFilters(Collections.singletonList(".*\\.sothawo\\.com/.*"));
        LinkedList<String> urls = new LinkedList<String>();
        urls.add("https://c.tile.openstreetmap.org/14/8572/5626.png");
        urls.add("https://b.tile.openstreetmap.org/14/8571/5626.png");
        urls.add("https://a.tile.openstreetmap.org/14/8572/5625.png");
        urls.add("https://c.tile.openstreetmap.org/14/8571/5625.png");
        urls.add("https://b.tile.openstreetmap.org/14/8570/5625.png");
        urls.add("https://a.tile.openstreetmap.org/14/8572/5625.png");
        urls.add("https://a.tile.openstreetmap.org/14/8570/5626.png");
        urls.add("https://a.tile.openstreetmap.org/14/8571/5627.png");
        urls.add("https://a.tile.openstreetmap.org/14/8573/5626.png");
        urls.add("https://a.tile.openstreetmap.org/14/8574/5627.png");
        urls.add("https://b.tile.openstreetmap.org/14/8571/5626.png");
        urls.add("https://b.tile.openstreetmap.org/14/8573/5625.png");
        urls.add("https://b.tile.openstreetmap.org/14/8572/5627.png");
        urls.add("https://b.tile.openstreetmap.org/14/8574/5626.png");
        urls.add("https://c.tile.openstreetmap.org/14/8572/5626.png");
        urls.add("https://c.tile.openstreetmap.org/14/8570/5627.png");
        urls.add("https://c.tile.openstreetmap.org/14/8574/5625.png");
        urls.add("https://c.tile.openstreetmap.org/14/8573/5627.png");
        offlineCache.preloadURLs(urls, 2);
    }

    private Pane createBottomPane() {
        HBox hbox = new HBox();
        hbox.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        hbox.setSpacing(10.0);
        Label labelCenter = new Label();
        hbox.getChildren().add((Object)labelCenter);
        this.mapView.centerProperty().addListener((observable, oldValue, newValue) -> labelCenter.setText((String)(newValue == null ? "" : "center: " + newValue.toString())));
        Label labelZoom = new Label();
        hbox.getChildren().add((Object)labelZoom);
        this.mapView.zoomProperty().addListener((observable, oldValue, newValue) -> labelZoom.setText((String)(null == newValue ? "" : "zoom: " + newValue.toString())));
        return hbox;
    }

    private Pane createTopPane() {
        VBox vbox = new VBox();
        vbox.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        HBox hbox = new HBox();
        hbox.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        hbox.setSpacing(5.0);
        vbox.getChildren().add((Object)hbox);
        Button btn = new Button();
        btn.setText("Karlsruhe castle");
        btn.setOnAction(event -> this.mapView.setCenter(coordKarlsruheCastle));
        hbox.getChildren().add((Object)btn);
        btn = new Button();
        btn.setText("Karlsruhe harbour");
        btn.setOnAction(event -> this.mapView.setCenter(coordKarlsruheHarbour));
        hbox.getChildren().add((Object)btn);
        btn = new Button();
        btn.setText("Karlsruhe station");
        btn.setOnAction(event -> this.mapView.setCenter(coordKarlsruheStation));
        hbox.getChildren().add((Object)btn);
        btn = new Button();
        btn.setText("all");
        btn.setOnAction(event -> this.mapView.setExtent(extentAll));
        hbox.getChildren().add((Object)btn);
        Slider slider = new Slider(0.0, 28.0, 14.0);
        slider.setBlockIncrement(1.0);
        slider.setShowTickMarks(true);
        slider.setShowTickLabels(true);
        slider.setSnapToTicks(true);
        slider.setMajorTickUnit(7.0);
        slider.setMinorTickCount(6);
        slider.valueProperty().bindBidirectional((Property)this.mapView.zoomProperty());
        slider.setSnapToTicks(true);
        HBox.setHgrow((Node)slider, (Priority)Priority.ALWAYS);
        hbox.getChildren().add((Object)slider);
        hbox = new HBox();
        hbox.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        hbox.setSpacing(5.0);
        vbox.getChildren().add((Object)hbox);
        btn = new Button();
        btn.setText("OSM");
        btn.setOnAction(evt -> this.mapView.setMapType(MapType.OSM));
        hbox.getChildren().add((Object)btn);
        btn = new Button();
        btn.setText("ST");
        btn.setOnAction(evt -> this.mapView.setMapType(MapType.STAMEN_WC));
        hbox.getChildren().add((Object)btn);
        LinkedList<MenuItem> bingOptions = new LinkedList<MenuItem>();
        MenuItem item = new MenuItem("Bing Roads");
        item.setOnAction(evt -> {
            this.mapView.setBingMapsApiKey(this.bingApiKey.getText());
            this.mapView.setMapType(MapType.BINGMAPS_ROAD);
        });
        bingOptions.add(item);
        item = new MenuItem("Bing Aerial");
        item.setOnAction(evt -> {
            this.mapView.setBingMapsApiKey(this.bingApiKey.getText());
            this.mapView.setMapType(MapType.BINGMAPS_AERIAL);
        });
        bingOptions.add(item);
        item = new MenuItem("Bing Aerial with Labels");
        item.setOnAction(evt -> {
            this.mapView.setBingMapsApiKey(this.bingApiKey.getText());
            this.mapView.setMapType(MapType.BINGMAPS_AERIAL_WITH_LABELS);
        });
        bingOptions.add(item);
        item = new MenuItem("Bing Roads - dark");
        item.setOnAction(evt -> {
            this.mapView.setBingMapsApiKey(this.bingApiKey.getText());
            this.mapView.setMapType(MapType.BINGMAPS_CANVAS_DARK);
        });
        bingOptions.add(item);
        item = new MenuItem("Bing Roads - grayscale");
        item.setOnAction(evt -> {
            this.mapView.setBingMapsApiKey(this.bingApiKey.getText());
            this.mapView.setMapType(MapType.BINGMAPS_CANVAS_GRAY);
        });
        bingOptions.add(item);
        item = new MenuItem("Bing Roads - light");
        item.setOnAction(evt -> {
            this.mapView.setBingMapsApiKey(this.bingApiKey.getText());
            this.mapView.setMapType(MapType.BINGMAPS_CANVAS_LIGHT);
        });
        bingOptions.add(item);
        MenuButton menuButton = new MenuButton("Bing", null, bingOptions.toArray(new MenuItem[0]));
        hbox.getChildren().add((Object)menuButton);
        btn = new Button();
        btn.setText("WMS");
        btn.setOnAction(evt -> this.mapView.setMapType(MapType.WMS));
        hbox.getChildren().add((Object)btn);
        btn = new Button();
        btn.setText("XYZ");
        btn.setOnAction(evt -> this.mapView.setMapType(MapType.XYZ));
        hbox.getChildren().add((Object)btn);
        btn = new Button();
        btn.setText("add marker");
        btn.setOnAction(evt -> this.mapView.addMarker(marker));
        hbox.getChildren().add((Object)btn);
        btn = new Button();
        btn.setText("toggle marker visibility");
        btn.setOnAction(evt -> marker.setVisible(!marker.getVisible()));
        hbox.getChildren().add((Object)btn);
        btn = new Button();
        btn.setText("remove marker");
        btn.setOnAction(evt -> this.mapView.removeMarker(marker));
        hbox.getChildren().add((Object)btn);
        btn = new Button();
        btn.setText("add Track");
        btn.setOnAction(evt -> this.mapView.addCoordinateLine(coordinateLine));
        hbox.getChildren().add((Object)btn);
        btn = new Button();
        btn.setText("remove Track");
        btn.setOnAction(evt -> this.mapView.removeCoordinateLine(coordinateLine));
        hbox.getChildren().add((Object)btn);
        btn = new Button();
        btn.setText("toggle Track visibilty");
        btn.setOnAction(evt -> coordinateLine.setVisible(!coordinateLine.getVisible()));
        hbox.getChildren().add((Object)btn);
        btn = new Button();
        btn.setText("GC");
        btn.setOnAction(evt -> System.gc());
        hbox.getChildren().add((Object)btn);
        hbox = new HBox();
        hbox.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        hbox.setSpacing(5.0);
        hbox.getChildren().add((Object)new Label("Bing Maps API Key:"));
        this.bingApiKey = new TextField();
        hbox.getChildren().add((Object)this.bingApiKey);
        btn = new Button();
        btn.setText("add label");
        btn.setOnAction(evt -> this.mapView.addLabel(mapLabel));
        hbox.getChildren().add((Object)btn);
        btn = new Button();
        btn.setText("toggle label visibility");
        btn.setOnAction(evt -> mapLabel.setVisible(!mapLabel.getVisible()));
        hbox.getChildren().add((Object)btn);
        btn = new Button();
        btn.setText("remove label");
        btn.setOnAction(evt -> this.mapView.removeLabel(mapLabel));
        hbox.getChildren().add((Object)btn);
        btn = new Button();
        btn.setText("clear cache");
        btn.setOnAction(evt -> {
            try {
                this.mapView.getOfflineCache().clear();
            }
            catch (IOException e) {
                logger.warn("could not clear cache", (Throwable)e);
            }
        });
        hbox.getChildren().add((Object)btn);
        btn = new Button();
        btn.setText("set constrain");
        btn.setOnAction(evt -> this.mapView.constrainExtent(extentAll));
        hbox.getChildren().add((Object)btn);
        btn = new Button();
        btn.setText("clear constrain");
        btn.setOnAction(evt -> this.mapView.clearConstrainExtent());
        hbox.getChildren().add((Object)btn);
        vbox.getChildren().add((Object)hbox);
        vbox.setDisable(true);
        return vbox;
    }

    static {
        mapLabel = new MapLabel("blau!").setCssClass("blue-label").setPosition(coordKarlsruheCastle).setRotation(90).setVisible(true);
        marker.attachLabel(mapLabel);
        circle = new MapCircle(coordKarlsruheCastle, 1000.0).setVisible(true);
        wmsParam = new WMSParam().setUrl("http://ows.terrestris.de/osm/service").addParam("layers", "OSM-WMS");
        xyzParam = new XYZParam().withUrl("https://server.arcgisonline.com/ArcGIS/rest/services/World_Topo_Map/MapServer/tile/{z}/{y}/{x})").withAttributions("'Tiles &copy; <a href=\"https://services.arcgisonline.com/ArcGIS/rest/services/World_Topo_Map/MapServer\">ArcGIS</a>'");
    }
}

