/*
 * Decompiled with CFR 0.152.
 */
package com.sothawo.mapjfx.offline;

import com.sothawo.mapjfx.offline.CachedDataInfo;
import com.sothawo.mapjfx.offline.CachingURLStreamHandlerFactory;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum OfflineCache {
    INSTANCE;

    private static final Logger logger;
    private static final String TILE_OPENSTREETMAP_ORG = "[a-z]\\.tile\\.openstreetmap\\.org";
    private static final int PRELOAD_DATABUFFER_SIZE = 0x100000;
    private final Collection<Pattern> noCachePatterns = new ArrayList<Pattern>();
    private final Collection<Pattern> cachePatterns = new ArrayList<Pattern>();
    private boolean urlStreamHandlerFactoryIsInitialized = false;
    private boolean active = false;
    private Path cacheDirectory;

    static void clearDirectory(Path path) throws IOException {
        Files.walkFileTree(path, new DeletingFileVisitor(path));
    }

    public Collection<String> getNoCacheFilters() {
        return this.noCachePatterns.stream().map(Pattern::toString).collect(Collectors.toList());
    }

    public void clearAllCacheFilters() {
        this.cachePatterns.clear();
        this.noCachePatterns.clear();
    }

    public void setCacheFilters(Collection<String> cacheFilters) {
        if (!this.noCachePatterns.isEmpty()) {
            throw new IllegalStateException("cannot set both cacheFilters and noCacheFilters");
        }
        this.cachePatterns.clear();
        if (null != cacheFilters) {
            cacheFilters.stream().map(Pattern::compile).forEach(this.cachePatterns::add);
        }
    }

    public void setNoCacheFilters(Collection<String> noCacheFilters) {
        if (!this.cachePatterns.isEmpty()) {
            throw new IllegalStateException("cannot set both cacheFilters and noCacheFilters");
        }
        this.noCachePatterns.clear();
        if (null != noCacheFilters) {
            noCacheFilters.stream().map(Pattern::compile).forEach(this.noCachePatterns::add);
        }
    }

    public Path getCacheDirectory() {
        return this.cacheDirectory;
    }

    public void setCacheDirectory(Path cacheDirectory) {
        Path dir = Objects.requireNonNull(cacheDirectory);
        if (!Files.isDirectory(dir, new LinkOption[0]) || !Files.isWritable(dir)) {
            throw new IllegalArgumentException("cacheDirectory: " + dir);
        }
        this.cacheDirectory = dir;
    }

    public void setCacheDirectory(String cacheDirectory) {
        this.setCacheDirectory(FileSystems.getDefault().getPath(Objects.requireNonNull(cacheDirectory), new String[0]));
    }

    boolean urlShouldBeCached(URL u) {
        String urlString = u.toString();
        if (!this.noCachePatterns.isEmpty()) {
            return this.noCachePatterns.stream().noneMatch(pattern -> pattern.matcher(urlString).matches());
        }
        if (!this.cachePatterns.isEmpty()) {
            return this.cachePatterns.stream().anyMatch(pattern -> pattern.matcher(urlString).matches());
        }
        return true;
    }

    public boolean isNotActive() {
        return !this.active;
    }

    public void setActive(boolean active) {
        if (active && null == this.cacheDirectory) {
            throw new IllegalArgumentException("cannot setActive when no cacheDirectory is set");
        }
        if (active) {
            this.setupURLStreamHandlerFactory();
        }
        this.active = active;
    }

    private void setupURLStreamHandlerFactory() {
        if (!this.urlStreamHandlerFactoryIsInitialized) {
            String msg;
            block5: {
                try {
                    URL.setURLStreamHandlerFactory(new CachingURLStreamHandlerFactory(this));
                    this.urlStreamHandlerFactoryIsInitialized = true;
                    return;
                }
                catch (Error e) {
                    msg = "cannot setup URLStreamFactoryHandler, it is already set in this application. " + e.getMessage();
                    if (logger.isErrorEnabled()) {
                        logger.error(msg);
                    }
                }
                catch (SecurityException e) {
                    msg = "cannot setup URLStreamFactoryHandler. " + e.getMessage();
                    if (!logger.isErrorEnabled()) break block5;
                    logger.error(msg);
                }
            }
            throw new IllegalStateException(msg);
        }
    }

    boolean isCached(URL url) {
        try {
            Path cacheFile = this.filenameForURL(url);
            return Files.exists(cacheFile, new LinkOption[0]) && Files.isReadable(cacheFile) && Files.size(cacheFile) > 0L;
        }
        catch (IOException e) {
            if (logger.isWarnEnabled()) {
                logger.warn(e.getMessage());
            }
            return false;
        }
    }

    Path filenameForURL(URL url) throws UnsupportedEncodingException {
        if (null == this.cacheDirectory) {
            throw new IllegalStateException("cannot resolve filename for url");
        }
        String mappedString = Objects.requireNonNull(this.doMappings(url.toExternalForm()));
        String encodedString = URLEncoder.encode(mappedString, "UTF-8");
        return this.cacheDirectory.resolve(encodedString);
    }

    private String doMappings(String urlString) {
        if (null == urlString || urlString.isEmpty()) {
            return urlString;
        }
        return urlString.replaceAll(TILE_OPENSTREETMAP_ORG, "x.tile.openstreetmap.org");
    }

    void saveCachedDataInfo(Path cacheFile, CachedDataInfo cachedDataInfo) {
        block8: {
            Path cacheDataFile = Paths.get(cacheFile + ".dataInfo", new String[0]);
            try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(cacheDataFile.toFile()));){
                oos.writeObject(cachedDataInfo);
                oos.flush();
                if (logger.isTraceEnabled()) {
                    logger.trace("saving dataInfo {}", (Object)cachedDataInfo);
                    logger.trace("saved dataInfo to {}", (Object)cacheDataFile);
                }
            }
            catch (Exception e) {
                if (!logger.isWarnEnabled()) break block8;
                logger.warn("could not save dataInfo {}", (Object)cacheDataFile);
            }
        }
    }

    CachedDataInfo readCachedDataInfo(Path cacheFile) {
        CachedDataInfo cachedDataInfo;
        block8: {
            cachedDataInfo = null;
            Path cacheDataFile = Paths.get(cacheFile + ".dataInfo", new String[0]);
            if (Files.exists(cacheDataFile, new LinkOption[0])) {
                try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(cacheDataFile.toFile()));){
                    cachedDataInfo = (CachedDataInfo)ois.readObject();
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block8;
                    logger.warn("could not read dataInfo from {}, {}", (Object)cacheDataFile, (Object)e.getMessage());
                }
            }
        }
        return cachedDataInfo;
    }

    public void clear() throws IOException {
        if (null != this.cacheDirectory) {
            OfflineCache.clearDirectory(this.cacheDirectory);
        }
    }

    public void preloadURLs(Collection<String> urls) {
        this.preloadURLs(urls, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preloadURLs(Collection<String> urls, int parallelism) {
        if (urls == null || this.isNotActive()) {
            return;
        }
        ForkJoinPool customThreadPool = new ForkJoinPool(parallelism < 1 ? Runtime.getRuntime().availableProcessors() : parallelism);
        try {
            customThreadPool.submit(() -> urls.parallelStream().forEach(url -> {
                block8: {
                    try {
                        URLConnection urlConnection = new URL((String)url).openConnection();
                        urlConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (X11; Linux x86_64; rv:66.0) Gecko/20100101 Firefox/66.0");
                        try (BufferedInputStream in = new BufferedInputStream(urlConnection.getInputStream());){
                            byte[] dataBuffer = new byte[0x100000];
                            while (in.read(dataBuffer, 0, 0x100000) != -1) {
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isDebugEnabled()) break block8;
                        logger.debug("could not load data from url {}", url, (Object)e);
                    }
                }
            }));
        }
        finally {
            customThreadPool.shutdown();
        }
    }

    static {
        logger = LoggerFactory.getLogger(OfflineCache.class);
    }

    private static class DeletingFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path rootDir;

        public DeletingFileVisitor(Path path) {
            this.rootDir = path;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (!attrs.isDirectory()) {
                Files.delete(file);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (!dir.equals(this.rootDir)) {
                Files.delete(dir);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

