/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.scip_semanticdb;

import com.sourcegraph.scip_semanticdb.JavaVersion;
import com.sourcegraph.scip_semanticdb.JdkPackage;
import com.sourcegraph.scip_semanticdb.MavenPackage;
import com.sourcegraph.scip_semanticdb.Package;
import com.sourcegraph.scip_semanticdb.ScipSemanticdbOptions;
import com.sourcegraph.scip_semanticdb.ScipWriter;
import com.sourcegraph.scip_semanticdb.SymbolDescriptor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PackageTable
implements Function<Package, Integer> {
    private final Map<String, Package> byClassfile = new HashMap<String, Package>();
    private final Set<String> cachedJdkSymbols = new HashSet<String>();
    private final Map<Package, Integer> scip = new ConcurrentHashMap<Package, Integer>();
    private final JavaVersion javaVersion;
    private final ScipWriter writer;
    private final boolean indexDirectoryEntries;
    private static final PathMatcher CLASS_PATTERN = FileSystems.getDefault().getPathMatcher("glob:**.class");
    private static final PathMatcher JAR_PATTERN = FileSystems.getDefault().getPathMatcher("glob:**.jar");

    public PackageTable(ScipSemanticdbOptions scipSemanticdbOptions, ScipWriter scipWriter) throws IOException {
        this.writer = scipWriter;
        this.javaVersion = new JavaVersion();
        this.indexDirectoryEntries = scipSemanticdbOptions.allowExportingGlobalSymbolsFromDirectoryEntries;
        this.indexJdk();
        for (MavenPackage mavenPackage : scipSemanticdbOptions.packages) {
            this.indexPackage(mavenPackage);
        }
    }

    public void writeMonikerPackage(int n, Package package_) {
        int n2 = this.scip.computeIfAbsent(package_, this);
        this.writer.emitPackageInformationEdge(n, n2);
    }

    public Optional<Package> packageForSymbol(String string) {
        return SymbolDescriptor.toplevel(string).flatMap(symbolDescriptor -> {
            String string = symbolDescriptor.owner + symbolDescriptor.descriptor.name + ".class";
            return this.packageForClassfile(string);
        });
    }

    private Optional<Package> packageForClassfile(String string) {
        Package package_ = this.byClassfile.get(string);
        if (package_ != null) {
            return Optional.of(package_);
        }
        if (!this.javaVersion.isJava8 && this.isJrtClassfile(string)) {
            return Optional.of(this.javaVersion.pkg);
        }
        return Optional.empty();
    }

    private void indexPackage(MavenPackage mavenPackage) throws IOException {
        if (JAR_PATTERN.matches(mavenPackage.jar) && Files.isRegularFile(mavenPackage.jar, new LinkOption[0])) {
            this.indexJarFile(mavenPackage.jar, mavenPackage);
        } else if (this.indexDirectoryEntries && Files.isDirectory(mavenPackage.jar, new LinkOption[0])) {
            this.indexDirectoryPackage(mavenPackage);
        }
    }

    private void indexDirectoryPackage(final MavenPackage mavenPackage) throws IOException {
        Files.walkFileTree(mavenPackage.jar, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                String string;
                if (CLASS_PATTERN.matches(path) && !(string = mavenPackage.jar.relativize(path).toString()).contains("$")) {
                    PackageTable.this.byClassfile.put(string, mavenPackage);
                }
                return super.visitFile(path, basicFileAttributes);
            }
        });
    }

    private void indexJarFile(Path path, Package package_) throws IOException {
        try (JarFile jarFile = new JarFile(path.toFile());){
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                if (!jarEntry.getName().endsWith(".class") || jarEntry.getName().contains("$")) continue;
                this.byClassfile.put(jarEntry.getName(), package_);
            }
        }
    }

    private void indexJdk() throws IOException {
        if (this.javaVersion.isJava8) {
            this.indexBootstrapClasspath();
        }
    }

    private boolean isJrtClassfile(String string) {
        boolean bl;
        if (this.cachedJdkSymbols.contains(string)) {
            return true;
        }
        URL uRL = this.getClass().getResource("/" + string);
        boolean bl2 = bl = uRL != null && "jrt".equals(uRL.getProtocol());
        if (bl) {
            this.cachedJdkSymbols.add(string);
        }
        return bl;
    }

    private void indexBootstrapClasspath() throws IOException {
        for (Object object : System.getProperties().keySet()) {
            String string;
            JdkPackage jdkPackage = new JdkPackage("8");
            if (!(object instanceof String) || !(string = (String)object).endsWith(".boot.class.path")) continue;
            String string2 = System.getProperty(string);
            for (String string3 : string2.split(File.pathSeparator)) {
                Path path = Paths.get(string3, new String[0]);
                if (!JAR_PATTERN.matches(path) || !Files.isRegularFile(path, new LinkOption[0])) continue;
                this.indexJarFile(path, jdkPackage);
            }
        }
    }

    @Override
    public Integer apply(Package package_) {
        return this.writer.emitpackageinformationVertex(package_);
    }
}

