/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.scip_semanticdb;

import com.sourcegraph.scip_semanticdb.RangeComparator;
import com.sourcegraph.scip_semanticdb.ResultIds;
import com.sourcegraph.scip_semanticdb.SemanticdbTreeVisitor;
import com.sourcegraph.scip_semanticdb.SymbolDescriptor;
import com.sourcegraph.scip_semanticdb.SymbolOccurrences;
import com.sourcegraph.semanticdb_javac.Semanticdb;
import com.sourcegraph.semanticdb_javac.SemanticdbSymbols;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ScipTextDocument {
    public final Path semanticdbPath;
    public Semanticdb.TextDocument semanticdb;
    public int id;
    public final Map<String, Semanticdb.SymbolInformation> symbols;
    public final Map<String, ResultIds> localSymbols;
    public final Map<String, ArrayList<String>> definitionCliques = new HashMap<String, ArrayList<String>>();
    public static final Set<String> syntheticCaseClassMethodNames = new HashSet<String>(Arrays.asList("copy", "productElement", "productElementName"));
    public static final Set<String> syntheticCompanionObjectNames = new HashSet<String>(Arrays.asList("apply", "copy"));

    public ScipTextDocument(Path path, Semanticdb.TextDocument textDocument, Path path2) {
        this.semanticdbPath = path;
        this.symbols = new HashMap<String, Semanticdb.SymbolInformation>();
        this.localSymbols = new HashMap<String, ResultIds>();
        String string = path2.resolve(textDocument.getUri()).toUri().toString();
        this.setSemanticdb(Semanticdb.TextDocument.newBuilder((Semanticdb.TextDocument)textDocument).setUri(string).build());
    }

    public String toString() {
        return "ScipDocument{path=" + this.semanticdbPath + ", semanticdb=" + this.semanticdb + ", id=" + this.id + '}';
    }

    public List<Semanticdb.SymbolOccurrence> sortedSymbolOccurrences() {
        return ScipTextDocument.sortedSymbolOccurrences(this.semanticdb);
    }

    public static List<Semanticdb.SymbolOccurrence> sortedSymbolOccurrences(Semanticdb.TextDocument textDocument) {
        ArrayList<Semanticdb.SymbolOccurrence> arrayList = new ArrayList<Semanticdb.SymbolOccurrence>(textDocument.getOccurrencesList().size());
        arrayList.addAll(textDocument.getOccurrencesList());
        for (Semanticdb.Synthetic synthetic : textDocument.getSyntheticsList()) {
            ScipTextDocument.addAllSyntheticOccurrences(synthetic, arrayList);
        }
        arrayList.sort((symbolOccurrence, symbolOccurrence2) -> new RangeComparator().compare(symbolOccurrence.getRange(), symbolOccurrence2.getRange()));
        return arrayList;
    }

    private static void addAllSyntheticOccurrences(Semanticdb.Synthetic synthetic, final ArrayList<Semanticdb.SymbolOccurrence> arrayList) {
        final Semanticdb.Range range = Semanticdb.Range.newBuilder((Semanticdb.Range)synthetic.getRange()).setStartLine(synthetic.getRange().getEndLine()).setStartCharacter(synthetic.getRange().getEndCharacter()).build();
        new SemanticdbTreeVisitor(){

            @Override
            void visitIdTree(Semanticdb.IdTree idTree) {
                Semanticdb.SymbolOccurrence symbolOccurrence = Semanticdb.SymbolOccurrence.newBuilder().setRange(range).setSymbol(idTree.getSymbol()).setRole(Semanticdb.SymbolOccurrence.Role.REFERENCE).build();
                arrayList.add(symbolOccurrence);
            }
        }.visitTree(synthetic.getTree());
    }

    private void setSemanticdb(Semanticdb.TextDocument textDocument) {
        this.semanticdb = this.manifestOccurrencesForSyntheticSymbols(textDocument);
        for (Semanticdb.SymbolInformation symbolInformation : textDocument.getSymbolsList()) {
            this.symbols.put(symbolInformation.getSymbol(), symbolInformation);
        }
    }

    public Semanticdb.TextDocument manifestOccurrencesForSyntheticSymbols(Semanticdb.TextDocument textDocument) {
        if (textDocument.getLanguage() != Semanticdb.Language.SCALA) {
            return textDocument;
        }
        Semanticdb.TextDocument.Builder builder = Semanticdb.TextDocument.newBuilder((Semanticdb.TextDocument)textDocument);
        builder.clearSymbols();
        HashMap<String, Semanticdb.SymbolOccurrence> hashMap = new HashMap<String, Semanticdb.SymbolOccurrence>();
        for (Semanticdb.SymbolOccurrence symbolOccurrence : textDocument.getOccurrencesList()) {
            if (symbolOccurrence.getRole() != Semanticdb.SymbolOccurrence.Role.DEFINITION) continue;
            hashMap.put(symbolOccurrence.getSymbol(), symbolOccurrence);
        }
        for (Semanticdb.SymbolOccurrence symbolOccurrence : textDocument.getSymbolsList()) {
            Semanticdb.SymbolInformation.Builder builder2 = Semanticdb.SymbolInformation.newBuilder((Semanticdb.SymbolInformation)symbolOccurrence);
            Semanticdb.SymbolOccurrence symbolOccurrence2 = (Semanticdb.SymbolOccurrence)hashMap.get(symbolOccurrence.getSymbol());
            if (symbolOccurrence2 != null) {
                builder.addSymbols(builder2);
                continue;
            }
            for (Semanticdb.SymbolOccurrence symbolOccurrence3 : ScipTextDocument.alternativeSymbols((Semanticdb.SymbolInformation)symbolOccurrence)) {
                Semanticdb.SymbolOccurrence symbolOccurrence4 = (Semanticdb.SymbolOccurrence)hashMap.get(symbolOccurrence3.getSymbol());
                if (symbolOccurrence4 == null) continue;
                ArrayList arrayList = this.definitionCliques.computeIfAbsent(symbolOccurrence3.getSymbol(), string -> new ArrayList());
                arrayList.add(symbolOccurrence.getSymbol());
                builder2.addDefinitionRelationships(symbolOccurrence4.getSymbol());
                break;
            }
            builder.addSymbols(builder2);
        }
        return builder.build();
    }

    /*
     * Unable to fully structure code
     */
    public static List<Semanticdb.SymbolOccurrence> alternativeSymbols(Semanticdb.SymbolInformation var0) {
        var1_1 = new SymbolOccurrences();
        var2_2 = SymbolDescriptor.parseFromSymbol(var0.getSymbol());
        switch (2.$SwitchMap$com$sourcegraph$semanticdb_javac$SemanticdbSymbols$Descriptor$Kind[var2_2.descriptor.kind.ordinal()]) {
            case 1: {
                if (var2_2.descriptor.name.endsWith("_=")) {
                    var3_3 = var2_2.descriptor.name.substring(0, var2_2.descriptor.name.length() - 2);
                    var1_1.addDefinition(SemanticdbSymbols.global((String)var2_2.owner, (SemanticdbSymbols.Descriptor)var2_2.descriptor.withName(var3_3)));
                    break;
                }
                if (ScipTextDocument.syntheticCaseClassMethodNames.contains(var2_2.descriptor.name)) {
                    var1_1.addSyntheticDefinition(var2_2.owner);
                    break;
                }
                if (!ScipTextDocument.syntheticCompanionObjectNames.contains(var2_2.descriptor.name)) break;
                var1_1.addSyntheticDefinition(var2_2.owner);
                var3_4 = SymbolDescriptor.parseFromSymbol(var2_2.owner);
                var1_1.addSyntheticDefinition(SemanticdbSymbols.global((String)var3_4.owner, (SemanticdbSymbols.Descriptor)var3_4.descriptor.withKind(SemanticdbSymbols.Descriptor.Kind.Type)));
                break;
            }
            case 2: {
                var3_5 = SymbolDescriptor.parseFromSymbol(var2_2.owner);
                if (!var3_5.descriptor.name.equals("copy") && !var3_5.descriptor.name.equals("<init>")) ** GOTO lbl22
                var1_1.addDefinition(SemanticdbSymbols.global((String)var3_5.owner, (SemanticdbSymbols.Descriptor)var2_2.descriptor.withKind(SemanticdbSymbols.Descriptor.Kind.Term)));
                ** GOTO lbl26
lbl22:
                // 1 sources

                if (var3_5.descriptor.name.equals("apply")) {
                    var4_6 = SymbolDescriptor.parseFromSymbol(var3_5.owner);
                    var5_7 = SemanticdbSymbols.global((String)var4_6.owner, (SemanticdbSymbols.Descriptor)var4_6.descriptor.withKind(SemanticdbSymbols.Descriptor.Kind.Type));
                    var1_1.addDefinition(SemanticdbSymbols.global((String)var5_7, (SemanticdbSymbols.Descriptor)var2_2.descriptor.withKind(SemanticdbSymbols.Descriptor.Kind.Term)));
                }
            }
lbl26:
            // 5 sources

            case 3: {
                var1_1.addDefinition(SemanticdbSymbols.global((String)var2_2.owner, (SemanticdbSymbols.Descriptor)var2_2.descriptor.withKind(SemanticdbSymbols.Descriptor.Kind.Type)));
                break;
            }
        }
        return var1_1.occurrences;
    }
}

