/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.scip_semanticdb;

import com.sourcegraph.semanticdb_javac.Semanticdb;

public abstract class SemanticdbTreeVisitor {
    public void visitTree(Semanticdb.Tree tree) {
        if (tree.hasApplyTree()) {
            this.visitApplyTree(tree.getApplyTree());
        } else if (tree.hasFunctionTree()) {
            this.visitFunctionTree(tree.getFunctionTree());
        } else if (tree.hasIdTree()) {
            this.visitIdTree(tree.getIdTree());
        } else if (tree.hasLiteralTree()) {
            this.visitLiteralTree(tree.getLiteralTree());
        } else if (tree.hasMacroExpansionTree()) {
            this.visitMacroExpansionTree(tree.getMacroExpansionTree());
        } else if (tree.hasOriginalTree()) {
            this.visitOriginalTree(tree.getOriginalTree());
        } else if (tree.hasSelectTree()) {
            this.visitSelectTree(tree.getSelectTree());
        } else if (tree.hasTypeApplyTree()) {
            this.visitTypeApplyTree(tree.getTypeApplyTree());
        } else if (tree.hasAnnotationTree()) {
            this.visitAnnotationTree(tree.getAnnotationTree());
        } else if (tree.hasAssignTree()) {
            this.visitAssignTree(tree.getAssignTree());
        } else if (tree.hasBinopTree()) {
            this.visitBinaryOperatorTree(tree.getBinopTree());
        }
    }

    void visitApplyTree(Semanticdb.ApplyTree applyTree) {
        this.visitTree(applyTree.getFunction());
        for (Semanticdb.Tree tree : applyTree.getArgumentsList()) {
            this.visitTree(tree);
        }
    }

    void visitFunctionTree(Semanticdb.FunctionTree functionTree) {
        for (Semanticdb.IdTree idTree : functionTree.getParametersList()) {
            this.visitIdTree(idTree);
        }
        this.visitTree(functionTree.getBody());
    }

    void visitIdTree(Semanticdb.IdTree idTree) {
    }

    void visitLiteralTree(Semanticdb.LiteralTree literalTree) {
    }

    void visitMacroExpansionTree(Semanticdb.MacroExpansionTree macroExpansionTree) {
        this.visitTree(macroExpansionTree.getBeforeExpansion());
    }

    void visitOriginalTree(Semanticdb.OriginalTree originalTree) {
    }

    void visitSelectTree(Semanticdb.SelectTree selectTree) {
        this.visitTree(selectTree.getQualifier());
        this.visitIdTree(selectTree.getId());
    }

    void visitTypeApplyTree(Semanticdb.TypeApplyTree typeApplyTree) {
        this.visitTree(typeApplyTree.getFunction());
    }

    void visitAnnotationTree(Semanticdb.AnnotationTree annotationTree) {
        for (Semanticdb.Tree tree : annotationTree.getParametersList()) {
            this.visitTree(tree);
        }
    }

    void visitAssignTree(Semanticdb.AssignTree assignTree) {
        this.visitTree(assignTree.getLhs());
        this.visitTree(assignTree.getRhs());
    }

    void visitBinaryOperatorTree(Semanticdb.BinaryOperatorTree binaryOperatorTree) {
        this.visitTree(binaryOperatorTree.getLhs());
        this.visitTree(binaryOperatorTree.getRhs());
    }
}

