/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.scip_semanticdb;

import com.google.protobuf.CodedInputStream;
import com.sourcegraph.Scip;
import com.sourcegraph.lsif_protocol.MarkupKind;
import com.sourcegraph.scip_semanticdb.InputStreamBytes;
import com.sourcegraph.scip_semanticdb.MarkupContent;
import com.sourcegraph.scip_semanticdb.Package;
import com.sourcegraph.scip_semanticdb.PackageTable;
import com.sourcegraph.scip_semanticdb.ResultIds;
import com.sourcegraph.scip_semanticdb.ResultSets;
import com.sourcegraph.scip_semanticdb.ScipProcessingException;
import com.sourcegraph.scip_semanticdb.ScipSemanticdbOptions;
import com.sourcegraph.scip_semanticdb.ScipTextDocument;
import com.sourcegraph.scip_semanticdb.ScipWriter;
import com.sourcegraph.scip_semanticdb.SemanticdbWalker;
import com.sourcegraph.scip_semanticdb.SignatureFormatter;
import com.sourcegraph.scip_semanticdb.SymbolRelationship;
import com.sourcegraph.scip_semanticdb.Symtab;
import com.sourcegraph.semanticdb_javac.Semanticdb;
import com.sourcegraph.semanticdb_javac.SemanticdbSymbols;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public class ScipSemanticdb {
    private final ScipWriter writer;
    private final ScipSemanticdbOptions options;
    private final Map<String, ResultIds> globals;
    private static PathMatcher jarPattern = FileSystems.getDefault().getPathMatcher("glob:**.jar");

    public ScipSemanticdb(ScipWriter scipWriter, ScipSemanticdbOptions scipSemanticdbOptions) {
        this.writer = scipWriter;
        this.options = scipSemanticdbOptions;
        this.globals = new ConcurrentHashMap<String, ResultIds>();
    }

    public static void run(ScipSemanticdbOptions scipSemanticdbOptions) throws IOException {
        ScipWriter scipWriter = new ScipWriter(scipSemanticdbOptions);
        new ScipSemanticdb(scipWriter, scipSemanticdbOptions).run();
    }

    private void run() throws IOException {
        PackageTable packageTable = new PackageTable(this.options, this.writer);
        List<Path> list = SemanticdbWalker.findSemanticdbFiles(this.options);
        Collections.sort(list);
        if (this.options.reporter.hasErrors()) {
            return;
        }
        if (list.isEmpty() && !this.options.allowEmptyIndex) {
            this.options.reporter.error("No SemanticDB files found. This typically means that `scip-java` is unable to automatically index this codebase. If you are using Gradle or Maven, please report an issue to https://github.com/sourcegraph/scip-java and include steps to reproduce. If you are using a different build tool, make sure that you have followed all of the steps from https://sourcegraph.github.io/scip-java/docs/manual-configuration.html");
            return;
        }
        this.options.reporter.startProcessing(list.size());
        if (this.options.format.isTyped()) {
            this.runTyped(list, packageTable);
        } else {
            this.runGraph(list, packageTable);
        }
        this.writer.build();
        this.options.reporter.endProcessing();
    }

    private void runTyped(List<Path> list, PackageTable packageTable) {
        this.writer.emitTyped(this.typedMetadata());
        InverseReferenceRelationships inverseReferenceRelationships = this.inverseReferenceRelationships(list);
        this.filesStream(list).forEach(path -> this.processTypedDocument((Path)path, packageTable, inverseReferenceRelationships));
    }

    private String typedSymbol(String string, Package package_) {
        if (string.isEmpty()) {
            return "";
        }
        if (string.startsWith("local")) {
            return "local " + string.substring("local".length());
        }
        return "semanticdb maven " + package_.repoName() + " " + package_.version() + " " + string;
    }

    private static Scip.SymbolInformation.Kind scipKind(Semanticdb.SymbolInformation symbolInformation) {
        Semanticdb.SymbolInformation.Kind kind = symbolInformation.getKind();
        int n = symbolInformation.getProperties();
        boolean bl = (n & 0x1000) > 0;
        boolean bl2 = (n & 4) > 0;
        boolean bl3 = (n & 0x4000) > 0;
        switch (kind) {
            case CLASS: {
                if (bl3) {
                    return Scip.SymbolInformation.Kind.Enum;
                }
                return Scip.SymbolInformation.Kind.Class;
            }
            case CONSTRUCTOR: {
                return Scip.SymbolInformation.Kind.Constructor;
            }
            case FIELD: {
                if (bl) {
                    return Scip.SymbolInformation.Kind.StaticField;
                }
                return Scip.SymbolInformation.Kind.Field;
            }
            case INTERFACE: {
                return Scip.SymbolInformation.Kind.Interface;
            }
            case LOCAL: {
                if (bl) {
                    return Scip.SymbolInformation.Kind.StaticVariable;
                }
                return Scip.SymbolInformation.Kind.Variable;
            }
            case MACRO: {
                return Scip.SymbolInformation.Kind.Macro;
            }
            case METHOD: {
                if (bl) {
                    return Scip.SymbolInformation.Kind.StaticMethod;
                }
                if (bl2) {
                    return Scip.SymbolInformation.Kind.AbstractMethod;
                }
                return Scip.SymbolInformation.Kind.Method;
            }
            case OBJECT: {
                return Scip.SymbolInformation.Kind.Object;
            }
            case PACKAGE: {
                return Scip.SymbolInformation.Kind.Package;
            }
            case PACKAGE_OBJECT: {
                return Scip.SymbolInformation.Kind.PackageObject;
            }
            case PARAMETER: {
                return Scip.SymbolInformation.Kind.Parameter;
            }
            case SELF_PARAMETER: {
                return Scip.SymbolInformation.Kind.SelfParameter;
            }
            case TRAIT: {
                return Scip.SymbolInformation.Kind.Trait;
            }
            case TYPE: {
                if (bl3) {
                    return Scip.SymbolInformation.Kind.Enum;
                }
                return Scip.SymbolInformation.Kind.Type;
            }
            case TYPE_PARAMETER: {
                return Scip.SymbolInformation.Kind.TypeParameter;
            }
            case UNKNOWN_KIND: {
                return Scip.SymbolInformation.Kind.UnspecifiedKind;
            }
        }
        return Scip.SymbolInformation.Kind.UnspecifiedKind;
    }

    public static boolean isDefinitionRole(Semanticdb.SymbolOccurrence.Role role) {
        return role == Semanticdb.SymbolOccurrence.Role.DEFINITION || role == Semanticdb.SymbolOccurrence.Role.SYNTHETIC_DEFINITION;
    }

    private void processTypedDocument(Path path2, PackageTable packageTable, InverseReferenceRelationships inverseReferenceRelationships) {
        for (ScipTextDocument scipTextDocument : this.parseTextDocument(path2).collect(Collectors.toList())) {
            Object object;
            Object object2;
            if (scipTextDocument.semanticdb.getOccurrencesCount() == 0) continue;
            Path path3 = Paths.get(URI.create(scipTextDocument.semanticdb.getUri()));
            String string = StreamSupport.stream(this.options.sourceroot.relativize(path3).spliterator(), false).map(path -> path.getFileName().toString()).collect(Collectors.joining("/"));
            Scip.Document.Builder builder = Scip.Document.newBuilder().setRelativePath(string);
            for (Semanticdb.SymbolOccurrence symbolOccurrence : scipTextDocument.sortedSymbolOccurrences()) {
                if (symbolOccurrence.getSymbol().isEmpty()) continue;
                int n = 0;
                if (ScipSemanticdb.isDefinitionRole(symbolOccurrence.getRole())) {
                    n |= 1;
                }
                boolean bl = symbolOccurrence.getRange().getStartLine() == symbolOccurrence.getRange().getEndLine();
                object2 = bl ? Arrays.asList(symbolOccurrence.getRange().getStartLine(), symbolOccurrence.getRange().getStartCharacter(), symbolOccurrence.getRange().getEndCharacter()) : Arrays.asList(symbolOccurrence.getRange().getStartLine(), symbolOccurrence.getRange().getStartCharacter(), symbolOccurrence.getRange().getEndLine(), symbolOccurrence.getRange().getEndCharacter());
                object = packageTable.packageForSymbol(symbolOccurrence.getSymbol()).orElse(Package.EMPTY);
                builder.addOccurrences(Scip.Occurrence.newBuilder().addAllRange((Iterable)object2).setSymbol(this.typedSymbol(symbolOccurrence.getSymbol(), (Package)object)).setSymbolRoles(n));
            }
            Symtab symtab = new Symtab(scipTextDocument.semanticdb);
            for (Semanticdb.SymbolInformation symbolInformation : scipTextDocument.semanticdb.getSymbolsList()) {
                int n;
                Package package_;
                String string2;
                Object string3;
                if (symbolInformation.getSymbol().isEmpty()) continue;
                Package package_2 = packageTable.packageForSymbol(symbolInformation.getSymbol()).orElse(Package.EMPTY);
                object2 = Scip.SymbolInformation.newBuilder().setSymbol(this.typedSymbol(symbolInformation.getSymbol(), package_2));
                object2.setDisplayName(symbolInformation.getDisplayName());
                if (!symbolInformation.getEnclosingSymbol().isEmpty()) {
                    object2.setEnclosingSymbol(this.typedSymbol(symbolInformation.getEnclosingSymbol(), package_2));
                }
                object2.setKind(ScipSemanticdb.scipKind(symbolInformation));
                object = inverseReferenceRelationships.map.get(symbolInformation.getSymbol());
                if (object != null) {
                    string3 = ((ArrayList)object).iterator();
                    while (string3.hasNext()) {
                        string2 = (String)string3.next();
                        package_ = packageTable.packageForSymbol(string2).orElse(Package.EMPTY);
                        object2.addRelationships(Scip.Relationship.newBuilder().setSymbol(this.typedSymbol(string2, package_)).setIsImplementation(true).setIsReference(true));
                    }
                }
                for (n = 0; n < symbolInformation.getDefinitionRelationshipsCount(); ++n) {
                    string2 = symbolInformation.getDefinitionRelationships(n);
                    if (string2.isEmpty()) continue;
                    package_ = packageTable.packageForSymbol(string2).orElse(Package.EMPTY);
                    Semanticdb.SymbolInformation symbolInformation2 = symtab.symbols.get(string2);
                    object2.addRelationships(Scip.Relationship.newBuilder().setSymbol(this.typedSymbol(string2, package_)).setIsDefinition(true).setIsReference(symbolInformation2 != null && symbolInformation2.getDisplayName().equals(symbolInformation.getDisplayName()) && ScipSemanticdb.supportsReferenceRelationship(symbolInformation)));
                    this.addReferenceRelationships(symtab, symbolInformation, (Scip.SymbolInformation.Builder)object2, scipTextDocument.definitionCliques.get(string2), packageTable);
                }
                this.addReferenceRelationships(symtab, symbolInformation, (Scip.SymbolInformation.Builder)object2, scipTextDocument.definitionCliques.get(symbolInformation.getSymbol()), packageTable);
                for (n = 0; n < symbolInformation.getOverriddenSymbolsCount(); ++n) {
                    string2 = symbolInformation.getOverriddenSymbols(n);
                    if (string2.isEmpty() || this.isIgnoredOverriddenSymbol(string2)) continue;
                    package_ = packageTable.packageForSymbol(string2).orElse(Package.EMPTY);
                    object2.addRelationships(Scip.Relationship.newBuilder().setSymbol(this.typedSymbol(string2, package_)).setIsImplementation(true).setIsReference(ScipSemanticdb.supportsReferenceRelationship(symbolInformation)));
                }
                if (symbolInformation.hasSignature()) {
                    String string4 = scipTextDocument.semanticdb.getLanguage().toString().toLowerCase(Locale.ROOT).intern();
                    string2 = new SignatureFormatter(symbolInformation, symtab).formatSymbol();
                    package_ = Scip.Document.newBuilder().setRelativePath(string).setLanguage(string4).setText(string2);
                    object2.setSignatureDocumentation((Scip.Document.Builder)package_);
                }
                if (!((String)(string3 = symbolInformation.getDocumentation().getMessage())).isEmpty()) {
                    object2.addDocumentation((String)string3);
                }
                builder.addSymbols(object2);
            }
            this.writer.emitTyped(Scip.Index.newBuilder().addDocuments(builder).build());
        }
    }

    private void addReferenceRelationships(Symtab symtab, Semanticdb.SymbolInformation symbolInformation, Scip.SymbolInformation.Builder builder, @Nullable ArrayList<String> arrayList, PackageTable packageTable) {
        if (arrayList == null) {
            return;
        }
        for (String string : arrayList) {
            Semanticdb.SymbolInformation symbolInformation2;
            if (string.equals(symbolInformation.getSymbol()) || (symbolInformation2 = symtab.symbols.get(string)) == null || !string.endsWith(".apply().") && !symbolInformation2.getDisplayName().equals(symbolInformation.getDisplayName())) continue;
            Package package_ = packageTable.packageForSymbol(string).orElse(Package.EMPTY);
            builder.addRelationships(Scip.Relationship.newBuilder().setSymbol(this.typedSymbol(string, package_)).setIsReference(true));
        }
    }

    private Scip.Index typedMetadata() {
        return Scip.Index.newBuilder().setMetadata(Scip.Metadata.newBuilder().setVersion(Scip.ProtocolVersion.UnspecifiedProtocolVersion).setProjectRoot(this.options.sourceroot.toUri().toString()).setTextDocumentEncoding(Scip.TextEncoding.UTF8).setToolInfo(Scip.ToolInfo.newBuilder().setName(this.options.toolInfo.getName()).setVersion(this.options.toolInfo.getVersion()).addAllArguments((Iterable)this.options.toolInfo.getArgsList()))).build();
    }

    private void runGraph(List<Path> list, PackageTable packageTable) {
        this.writer.emitMetaData();
        int n = this.writer.emitProject(this.options.language);
        Set<String> set = this.exportSymbols(list);
        List<Integer> list2 = this.filesStream(list).flatMap(path -> this.processPath((Path)path, set, packageTable)).collect(Collectors.toList());
        this.writer.emitContains(n, list2);
    }

    private Stream<Path> filesStream(List<Path> list) {
        return this.options.parallel ? list.parallelStream() : list.stream();
    }

    private InverseReferenceRelationships inverseReferenceRelationships(List<Path> list) {
        if (!this.options.emitInverseRelationships) {
            return new InverseReferenceRelationships(Collections.emptyMap());
        }
        return new InverseReferenceRelationships(this.filesStream(list).flatMap(this::parseTextDocument).flatMap(this::referenceRelationships).collect(Collectors.groupingBy(SymbolRelationship::getTo, Collectors.mapping(SymbolRelationship::getFrom, Collectors.toCollection(ArrayList::new)))));
    }

    private Stream<SymbolRelationship> referenceRelationships(ScipTextDocument scipTextDocument) {
        ArrayList<SymbolRelationship> arrayList = new ArrayList<SymbolRelationship>();
        for (int i = 0; i < scipTextDocument.semanticdb.getSymbolsCount(); ++i) {
            Semanticdb.SymbolInformation symbolInformation = scipTextDocument.semanticdb.getSymbols(i);
            if (!ScipSemanticdb.supportsReferenceRelationship(symbolInformation) || symbolInformation.getSymbol().isEmpty() || SemanticdbSymbols.isLocal((String)symbolInformation.getSymbol())) continue;
            for (int j = 0; j < symbolInformation.getOverriddenSymbolsCount(); ++j) {
                String string = symbolInformation.getOverriddenSymbols(j);
                if (SemanticdbSymbols.isLocal((String)string)) continue;
                arrayList.add(new SymbolRelationship(symbolInformation.getSymbol(), string));
            }
        }
        return arrayList.stream();
    }

    private Set<String> exportSymbols(List<Path> list) {
        return this.filesStream(list).flatMap(this::parseTextDocument).flatMap(scipTextDocument -> scipTextDocument.semanticdb.getOccurrencesList().stream().filter(symbolOccurrence -> ScipSemanticdb.isDefinitionRole(symbolOccurrence.getRole())).map(Semanticdb.SymbolOccurrence::getSymbol).filter(SemanticdbSymbols::isGlobal)).collect(Collectors.toSet());
    }

    private Stream<Integer> processPath(Path path, Set<String> set, PackageTable packageTable) {
        return this.parseTextDocument(path).flatMap(scipTextDocument -> this.processDocument((ScipTextDocument)scipTextDocument, set, packageTable));
    }

    private Stream<Integer> processDocument(ScipTextDocument scipTextDocument, Set<String> set, PackageTable packageTable) {
        try {
            return Stream.of(this.processDocumentUnsafe(scipTextDocument, set, packageTable));
        }
        catch (Exception exception) {
            this.options.reporter.error(new ScipProcessingException(scipTextDocument, (Throwable)exception));
            return Stream.empty();
        }
    }

    private Integer processDocumentUnsafe(ScipTextDocument scipTextDocument, Set<String> set, PackageTable packageTable) {
        Symtab symtab = new Symtab(scipTextDocument.semanticdb);
        int n = this.writer.emitDocument(scipTextDocument);
        Set<String> set2 = scipTextDocument.semanticdb.getOccurrencesList().stream().filter(symbolOccurrence -> ScipSemanticdb.isDefinitionRole(symbolOccurrence.getRole()) && SemanticdbSymbols.isLocal((String)symbolOccurrence.getSymbol())).map(Semanticdb.SymbolOccurrence::getSymbol).collect(Collectors.toSet());
        scipTextDocument.id = n;
        ResultSets resultSets = new ResultSets(this.writer, this.globals, set, set2, packageTable, this.options);
        LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>();
        for (Semanticdb.SymbolOccurrence symbolOccurrence2 : scipTextDocument.sortedSymbolOccurrences()) {
            for (String string : symbolOccurrence2.getSymbol().split(";")) {
                Object object;
                Object object2;
                Semanticdb.SymbolInformation symbolInformation = scipTextDocument.symbols.getOrDefault(string, Semanticdb.SymbolInformation.getDefaultInstance());
                ResultIds resultIds = resultSets.getOrInsertResultSet(string);
                int n2 = this.writer.emitRange(symbolOccurrence2.getRange());
                linkedHashSet.add(n2);
                if (symbolOccurrence2.getRole() != Semanticdb.SymbolOccurrence.Role.SYNTHETIC_DEFINITION) {
                    this.writer.emitNext(n2, resultIds.resultSet);
                }
                this.writer.emitItem(resultIds.referenceResult, n2, scipTextDocument.id);
                if (ScipSemanticdb.isDefinitionRole(symbolOccurrence2.getRole())) {
                    if (resultIds.isDefinitionDefined()) {
                        this.writer.emitItem(resultIds.definitionResult, n2, scipTextDocument.id);
                    } else {
                        this.options.reporter.error(new NoSuchElementException(String.format("no definition ID for symbol '%s'", string)));
                    }
                    object2 = symbolInformation.getDocumentation().getMessage();
                    StringBuilder stringBuilder = new StringBuilder(((String)object2).length());
                    if (symbolInformation.hasSignature()) {
                        String string2 = scipTextDocument.semanticdb.getLanguage().toString().toLowerCase(Locale.ROOT).intern();
                        object = new SignatureFormatter(symbolInformation, symtab).formatSymbol();
                        stringBuilder.append("```").append(string2).append('\n').append((String)object).append("\n```");
                    }
                    if (!((String)object2).isEmpty()) {
                        if (stringBuilder.length() != 0) {
                            stringBuilder.append("\n---\n");
                        }
                        stringBuilder.append(((String)object2).replaceAll("\n", "\n\n"));
                    }
                    if (stringBuilder.length() == 0) {
                        stringBuilder.append(symbolInformation.getDisplayName());
                    }
                    int n3 = this.writer.emitHoverResult(new MarkupContent(MarkupKind.MARKDOWN, stringBuilder.toString()));
                    this.writer.emitHoverEdge(resultIds.resultSet, n3);
                }
                if (symbolInformation.getOverriddenSymbolsCount() <= 0 || !ScipSemanticdb.supportsReferenceRelationship(symbolInformation) || symbolOccurrence2.getRole() != Semanticdb.SymbolOccurrence.Role.DEFINITION) continue;
                object2 = new ArrayList(symbolInformation.getOverriddenSymbolsCount());
                for (int i = 0; i < symbolInformation.getOverriddenSymbolsCount(); ++i) {
                    String string3 = symbolInformation.getOverriddenSymbols(i);
                    if (this.isIgnoredOverriddenSymbol(string3)) continue;
                    object = resultSets.getOrInsertResultSet(string3);
                    object2.add(((ResultIds)object).referenceResult);
                    this.writer.emitReferenceResultsItemEdge(((ResultIds)object).referenceResult, Collections.singletonList(n2), scipTextDocument.id);
                }
                if (object2.size() <= 0) continue;
                this.writer.emitReferenceResultsItemEdge(resultIds.referenceResult, (Iterable<Integer>)object2, scipTextDocument.id);
            }
        }
        this.writer.emitContains(scipTextDocument.id, new ArrayList<Integer>(linkedHashSet));
        this.writer.flush();
        this.options.reporter.processedOneItem();
        return n;
    }

    private static boolean supportsReferenceRelationship(Semanticdb.SymbolInformation symbolInformation) {
        switch (symbolInformation.getKind()) {
            case CLASS: 
            case INTERFACE: 
            case OBJECT: 
            case PACKAGE_OBJECT: 
            case TYPE: {
                return false;
            }
        }
        return true;
    }

    private Stream<ScipTextDocument> parseTextDocument(Path path) {
        try {
            return this.textDocumentsParseFrom(path).getDocumentsList().stream().filter(textDocument -> !textDocument.getOccurrencesList().isEmpty()).map(textDocument -> new ScipTextDocument(path, (Semanticdb.TextDocument)textDocument, this.options.sourceroot));
        }
        catch (IOException iOException) {
            this.options.reporter.error("invalid protobuf: " + path);
            this.options.reporter.error(iOException);
            return Stream.empty();
        }
    }

    private Semanticdb.TextDocuments textDocumentsParseFrom(Path path) throws IOException {
        if (jarPattern.matches(path)) {
            return this.textDocumentsParseJarFile(path);
        }
        return this.textDocumentsParseFromBytes(Files.readAllBytes(path));
    }

    private Semanticdb.TextDocuments textDocumentsParseJarFile(Path path) throws IOException {
        Semanticdb.TextDocuments.Builder builder = Semanticdb.TextDocuments.newBuilder();
        try (JarFile jarFile = new JarFile(path.toFile());){
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                if (!jarEntry.getName().endsWith(".semanticdb")) continue;
                byte[] byArray = InputStreamBytes.readAll(jarFile.getInputStream(jarEntry));
                builder.addAllDocuments((Iterable)this.textDocumentsParseFromBytes(byArray).getDocumentsList());
            }
        }
        return builder.build();
    }

    private Semanticdb.TextDocuments textDocumentsParseFromBytes(byte[] byArray) throws IOException {
        try {
            CodedInputStream codedInputStream = CodedInputStream.newInstance((byte[])byArray);
            codedInputStream.setRecursionLimit(1000);
            return Semanticdb.TextDocuments.parseFrom((CodedInputStream)codedInputStream);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return Semanticdb.TextDocuments.parseFrom((byte[])byArray);
        }
    }

    private boolean isIgnoredOverriddenSymbol(String string) {
        return string.equals("java/lang/Object#");
    }

    private static class InverseReferenceRelationships {
        public final Map<String, ArrayList<String>> map;

        private InverseReferenceRelationships(Map<String, ArrayList<String>> map) {
            this.map = map;
        }
    }
}

