/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.scip_semanticdb;

import com.sourcegraph.scip_semanticdb.ScipSemanticdbOptions;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

public class SemanticdbWalker
extends SimpleFileVisitor<Path> {
    private final ArrayList<Path> result;
    private final ScipSemanticdbOptions options;
    private final PathMatcher semanticdbPattern = FileSystems.getDefault().getPathMatcher("glob:**.semanticdb");

    public SemanticdbWalker(ScipSemanticdbOptions scipSemanticdbOptions) {
        this.options = scipSemanticdbOptions;
        this.result = new ArrayList();
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        if (this.semanticdbPattern.matches(path)) {
            this.result.add(path);
        }
        return super.visitFile(path, basicFileAttributes);
    }

    @Override
    public FileVisitResult visitFileFailed(Path path, IOException iOException) {
        this.options.reporter.error(iOException);
        return FileVisitResult.CONTINUE;
    }

    public static List<Path> findSemanticdbFiles(ScipSemanticdbOptions scipSemanticdbOptions) throws IOException {
        SemanticdbWalker semanticdbWalker = new SemanticdbWalker(scipSemanticdbOptions);
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:**.jar");
        for (Path path : scipSemanticdbOptions.targetroots) {
            if (pathMatcher.matches(path)) {
                semanticdbWalker.result.add(path);
                continue;
            }
            Files.walkFileTree(path, semanticdbWalker);
        }
        return semanticdbWalker.result;
    }
}

