/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.scip_semanticdb;

import com.sourcegraph.scip_semanticdb.SignatureFormatterException;
import com.sourcegraph.scip_semanticdb.SymbolDescriptor;
import com.sourcegraph.scip_semanticdb.Symtab;
import com.sourcegraph.semanticdb_javac.Semanticdb;
import com.sourcegraph.semanticdb_javac.SemanticdbBuilders;
import com.sourcegraph.semanticdb_javac.SemanticdbSymbols;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class SignatureFormatter {
    private static final Semanticdb.Type OBJECT_TYPE_REF = SemanticdbBuilders.typeRef((String)"java/lang/Object#");
    private static final Semanticdb.Type PRODUCT_TYPE_REF = SemanticdbBuilders.typeRef((String)"scala/Product#");
    private static final Semanticdb.Type SCALA_SERIALIZABLE_TYPE_REF = SemanticdbBuilders.typeRef((String)"scala/package.Serializable#");
    private static final Semanticdb.Type JAVA_SERIALIZABLE_TYPE_REF = SemanticdbBuilders.typeRef((String)"java/util/Serializable#");
    private static final Semanticdb.Type SCALA_ANY_TYPE_REF = SemanticdbBuilders.typeRef((String)"scala/Any#");
    private static final Semanticdb.Type SCALA_ANYREF_TYPE_REF = SemanticdbBuilders.typeRef((String)"scala/AnyRef#");
    private static final Semanticdb.Type WILDCARD_TYPE_REF = SemanticdbBuilders.typeRef((String)"local_wildcard");
    private static final Semanticdb.Type NOTHING_SYMBOL = SemanticdbBuilders.typeRef((String)"scala/Nothing#");
    private static final String FUNCTION_SYMBOL_PREFIX = "scala/Function";
    private static final String FUNCTION_OBJECT = "scala/Function.";
    private static final String TUPLE_SYMBOL_PREFIX = "scala/Tuple";
    private static final String ARRAY_SYMBOL = "scala/Array#";
    private static final String ENUM_SYMBOL = "java/lang/Enum#";
    private static final String ANNOTATION_SYMBOL = "java/lang/annotation/Annotation#";
    private static final Set<Semanticdb.Type> REDUNDANT_CLASS_PARENTS = new HashSet<Semanticdb.Type>();
    private static final Set<Semanticdb.Type> CASE_CLASS_PARENTS = new HashSet<Semanticdb.Type>();
    private final StringBuilder s;
    private final Semanticdb.SymbolInformation symbolInformation;
    private final Symtab symtab;
    private final boolean isScala;

    public SignatureFormatter(Semanticdb.SymbolInformation symbolInformation, Symtab symtab) {
        REDUNDANT_CLASS_PARENTS.add(OBJECT_TYPE_REF);
        REDUNDANT_CLASS_PARENTS.add(SCALA_ANY_TYPE_REF);
        REDUNDANT_CLASS_PARENTS.add(SCALA_ANYREF_TYPE_REF);
        CASE_CLASS_PARENTS.add(PRODUCT_TYPE_REF);
        CASE_CLASS_PARENTS.add(SCALA_SERIALIZABLE_TYPE_REF);
        CASE_CLASS_PARENTS.add(JAVA_SERIALIZABLE_TYPE_REF);
        this.s = new StringBuilder();
        this.symbolInformation = symbolInformation;
        this.symtab = symtab;
        this.isScala = symbolInformation.getLanguage() == Semanticdb.Language.SCALA;
    }

    public String formatSymbol() {
        try {
            return this.formatSymbolUnsafe();
        }
        catch (Exception exception) {
            throw new SignatureFormatterException(this.symbolInformation, (Throwable)exception);
        }
    }

    private String formatSymbolUnsafe() {
        Semanticdb.Signature signature = this.symbolInformation.getSignature();
        if (signature.hasClassSignature()) {
            this.formatClassSignature(signature.getClassSignature());
        } else if (signature.hasMethodSignature()) {
            this.formatMethodSignature(signature.getMethodSignature());
        } else if (signature.hasValueSignature()) {
            this.formatValueSignature(signature.getValueSignature());
        } else if (signature.hasTypeSignature()) {
            this.formatTypeParameterSignature(signature.getTypeSignature());
        }
        return this.s.toString();
    }

    private void formatClassSignature(Semanticdb.ClassSignature classSignature) {
        List<Semanticdb.SymbolInformation> list;
        boolean bl = classSignature.getParentsList().stream().anyMatch(type -> type.getTypeRef().getSymbol().equals(ANNOTATION_SYMBOL));
        boolean bl2 = this.has(Semanticdb.SymbolInformation.Property.ENUM);
        boolean bl3 = this.symbolInformation.getKind() == Semanticdb.SymbolInformation.Kind.INTERFACE;
        this.printKeywordln(this.formatAnnotations());
        this.printKeyword(this.formatAccess());
        if (!(bl2 || bl || bl3)) {
            this.printKeyword(this.formatModifiers());
        }
        switch (this.symbolInformation.getKind()) {
            case CLASS: {
                if (bl2) {
                    this.printKeyword("enum");
                    break;
                }
                this.printKeyword("class");
                break;
            }
            case INTERFACE: {
                if (bl) {
                    this.printKeyword("@interface");
                    break;
                }
                this.printKeyword("interface");
                break;
            }
            case OBJECT: {
                this.printKeyword("object");
                break;
            }
            case TRAIT: {
                this.printKeyword("trait");
                break;
            }
            case PACKAGE_OBJECT: {
                this.printKeyword("package object");
                break;
            }
        }
        this.s.append(this.symbolInformation.getDisplayName());
        if (this.symbolInformation.getKind() == Semanticdb.SymbolInformation.Kind.CLASS && this.has(Semanticdb.SymbolInformation.Property.CASE)) {
            this.primaryConstructor(classSignature).ifPresent(methodSignature -> this.formatScalaParameterList(methodSignature.getParameterListsList()));
        }
        if (!(list = this.getSymlinks(classSignature.getTypeParameters())).isEmpty()) {
            this.s.append(list.stream().map(this::formatTypeParameter).collect(Collectors.joining(", ", this.isScala ? "[" : "<", this.isScala ? "]" : ">")));
        }
        boolean bl4 = classSignature.getParentsList().size() > 0 && !REDUNDANT_CLASS_PARENTS.contains(classSignature.getParentsList().get(0));
        boolean bl5 = this.isScala && this.symbolInformation.getKind() == Semanticdb.SymbolInformation.Kind.CLASS && this.has(Semanticdb.SymbolInformation.Property.CASE);
        List list2 = classSignature.getParentsList().stream().filter(type -> !REDUNDANT_CLASS_PARENTS.contains(type)).filter(type -> !type.getTypeRef().getSymbol().equals(ENUM_SYMBOL)).filter(type -> bl5 && !CASE_CLASS_PARENTS.contains(type)).filter(type -> !type.getTypeRef().getSymbol().equals(ANNOTATION_SYMBOL)).collect(Collectors.toList());
        if (list2.isEmpty()) {
            return;
        }
        if (this.isScala) {
            this.printKeyword(" extends");
            this.s.append(list2.stream().map(this::formatType).collect(Collectors.joining(" with ")));
            return;
        }
        switch (this.symbolInformation.getKind()) {
            case CLASS: {
                if (bl2 || !bl4) {
                    this.printKeyword(" implements");
                    String string = list2.stream().map(this::formatType).collect(Collectors.joining(", "));
                    this.s.append(string);
                    break;
                }
                this.printKeyword(" extends");
                this.s.append(this.formatType((Semanticdb.Type)list2.get(0)));
                String string = list2.stream().skip(1L).map(this::formatType).collect(Collectors.joining(", "));
                if (string.isEmpty()) break;
                this.printKeyword(" implements");
                this.s.append(string);
                break;
            }
            case INTERFACE: {
                this.printKeyword(" extends");
                String string = list2.stream().map(this::formatType).collect(Collectors.joining(", "));
                this.s.append(string);
            }
        }
    }

    private void formatMethodSignature(Semanticdb.MethodSignature methodSignature) {
        if (this.isScala) {
            this.formatScalaMethodSignature(methodSignature);
            return;
        }
        this.printKeywordln(this.formatAnnotations());
        this.printKeyword(this.formatAccess());
        this.printKeyword(this.formatModifiers());
        List<Semanticdb.SymbolInformation> list = this.getSymlinks(methodSignature.getTypeParameters());
        if (!list.isEmpty()) {
            this.printKeyword(list.stream().map(this::formatTypeParameter).collect(Collectors.joining(", ", "<", ">")));
        }
        if (this.symbolInformation.getKind() == Semanticdb.SymbolInformation.Kind.CONSTRUCTOR) {
            String string = SymbolDescriptor.parseFromSymbol((String)this.symbolInformation.getSymbol()).owner;
            if (!string.equals(SemanticdbSymbols.NONE)) {
                this.s.append(SymbolDescriptor.parseFromSymbol((String)string).descriptor.name);
            }
        } else {
            this.printKeyword(this.formatType(methodSignature.getReturnType()));
            this.s.append(this.symbolInformation.getDisplayName());
        }
        this.s.append(methodSignature.getParameterListsList().stream().flatMap(scope -> this.getSymlinks((Semanticdb.Scope)scope).stream()).map(this::formatTermParameter).collect(Collectors.joining(", ", "(", ")")));
        if (!methodSignature.getThrowsList().isEmpty()) {
            this.printKeyword(" throws");
            this.s.append(methodSignature.getThrowsList().stream().map(this::formatType).collect(Collectors.joining(", ")));
        }
    }

    private String formatTermParameter(Semanticdb.SymbolInformation symbolInformation) {
        if (symbolInformation == null) {
            return "";
        }
        if (this.isScala) {
            return symbolInformation.getDisplayName() + ": " + this.formatType(symbolInformation.getSignature().getValueSignature().getTpe());
        }
        return this.formatType(symbolInformation.getSignature().getValueSignature().getTpe()) + " " + symbolInformation.getDisplayName();
    }

    private void formatScalaMethodSignature(Semanticdb.MethodSignature methodSignature) {
        this.printKeywordln(this.formatAnnotations());
        this.printKeyword(this.formatAccess());
        this.printKeyword(this.formatModifiers());
        if (this.has(Semanticdb.SymbolInformation.Property.VAL)) {
            this.printKeyword("val");
        } else if (this.has(Semanticdb.SymbolInformation.Property.VAR)) {
            this.printKeyword("var");
        } else {
            this.printKeyword("def");
        }
        this.s.append(this.symbolInformation.getKind() == Semanticdb.SymbolInformation.Kind.CONSTRUCTOR ? "this" : this.symbolInformation.getDisplayName());
        this.formatScalaParameterList(methodSignature.getParameterListsList());
        if (this.symbolInformation.getKind() != Semanticdb.SymbolInformation.Kind.CONSTRUCTOR) {
            this.printKeyword(":");
            this.s.append(this.formatType(methodSignature.getReturnType()));
        }
    }

    private Optional<Semanticdb.MethodSignature> primaryConstructor(Semanticdb.ClassSignature classSignature) {
        Symtab symtab = this.symtab.withHardlinks(classSignature.getDeclarations());
        int n = classSignature.getDeclarations().getSymlinksCount();
        for (int i = 0; i < n; ++i) {
            String string = classSignature.getDeclarations().getSymlinks(i);
            Semanticdb.SymbolInformation symbolInformation = symtab.symbols.get(string);
            if (symbolInformation == null || symbolInformation.getKind() != Semanticdb.SymbolInformation.Kind.CONSTRUCTOR || !this.has(Semanticdb.SymbolInformation.Property.PRIMARY, symbolInformation) || !symbolInformation.hasSignature() || !symbolInformation.getSignature().hasMethodSignature()) continue;
            return Optional.of(symbolInformation.getSignature().getMethodSignature());
        }
        return Optional.empty();
    }

    private void formatScalaParameterList(List<Semanticdb.Scope> list) {
        for (Semanticdb.Scope scope : list) {
            List<Semanticdb.SymbolInformation> list2 = scope.getHardlinksCount() > 0 ? scope.getHardlinksList() : this.getSymlinks(scope);
            this.s.append(list2.stream().map(this::formatTermParameter).collect(Collectors.joining(", ", "(", ")")));
        }
    }

    private void formatValueSignature(Semanticdb.ValueSignature valueSignature) {
        this.printKeywordln(this.formatAnnotations());
        if (this.isEnumConstant()) {
            String string = SymbolDescriptor.parseFromSymbol((String)this.symbolInformation.getSymbol()).owner;
            Semanticdb.SymbolInformation symbolInformation = this.symtab.symbols.get(string);
            List list = this.getSymlinks(symbolInformation.getSignature().getClassSignature().getDeclarations()).stream().filter(Objects::nonNull).filter(this::isEnumConstant).collect(Collectors.toList());
            int n = list.indexOf(this.symbolInformation);
            this.s.append(symbolInformation.getDisplayName()).append('.');
            this.s.append(this.symbolInformation.getDisplayName());
            this.s.append(" /* ordinal ").append(n).append(" */");
        } else {
            this.printKeyword(this.formatAccess());
            this.printKeyword(this.formatModifiers());
            if (this.isScala) {
                this.s.append(this.symbolInformation.getDisplayName());
                this.printKeyword(":");
                this.printKeyword(this.formatType(valueSignature.getTpe()));
            } else {
                this.printKeyword(this.formatType(valueSignature.getTpe()));
                this.s.append(this.symbolInformation.getDisplayName());
            }
        }
    }

    private void formatTypeParameterSignature(Semanticdb.TypeSignature typeSignature) {
        if (this.isScala && this.symbolInformation.getKind() == Semanticdb.SymbolInformation.Kind.TYPE) {
            this.printKeyword("type");
        }
        this.s.append(this.symbolInformation.getDisplayName());
        if (!(!typeSignature.hasLowerBound() || this.isScala && typeSignature.getLowerBound().equals((Object)NOTHING_SYMBOL))) {
            this.printKeyword(this.isScala ? " >:" : " super");
            this.s.append(this.formatType(typeSignature.getLowerBound()));
        }
        if (typeSignature.hasUpperBound() && !typeSignature.getUpperBound().equals((Object)(this.isScala ? SCALA_ANY_TYPE_REF : OBJECT_TYPE_REF))) {
            this.printKeyword(this.isScala ? " <:" : " extends");
            this.s.append(this.formatType(typeSignature.getUpperBound()));
        }
    }

    private List<Semanticdb.SymbolInformation> getSymlinks(Semanticdb.Scope scope) {
        ArrayList<Semanticdb.SymbolInformation> arrayList = new ArrayList<Semanticdb.SymbolInformation>();
        for (int i = 0; i < scope.getSymlinksCount(); ++i) {
            Semanticdb.SymbolInformation symbolInformation = this.symtab.symbols.get(scope.getSymlinks(i));
            if (symbolInformation == null) continue;
            arrayList.add(symbolInformation);
        }
        return arrayList;
    }

    private String formatTypeParameter(Semanticdb.SymbolInformation symbolInformation) {
        return new SignatureFormatter(symbolInformation, this.symtab).formatSymbol();
    }

    private String formatTypeArguments(List<Semanticdb.Type> list) {
        if (list.isEmpty()) {
            return "";
        }
        return list.stream().map(this::formatType).collect(Collectors.joining(", ", this.isScala ? "[" : "<", this.isScala ? "]" : ">"));
    }

    private String formatAnnotations() {
        return this.formatAnnotations(this.symbolInformation);
    }

    private String formatAnnotations(Semanticdb.SymbolInformation symbolInformation) {
        return symbolInformation.getAnnotationsList().stream().map(this::formatAnnotation).collect(Collectors.joining("\n"));
    }

    private String formatAnnotation(Semanticdb.AnnotationTree annotationTree) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('@');
        stringBuilder.append(this.formatType(annotationTree.getTpe()));
        if (annotationTree.getParametersCount() == 1) {
            stringBuilder.append('(');
            Semanticdb.Tree tree = annotationTree.getParameters(0);
            Semanticdb.AssignTree assignTree = tree.getAssignTree();
            if (tree.hasAssignTree() && SymbolDescriptor.parseFromSymbol((String)assignTree.getLhs().getIdTree().getSymbol()).descriptor.name.equals("value")) {
                stringBuilder.append(this.formatTree(assignTree.getRhs()));
            } else {
                stringBuilder.append(this.formatTree(tree));
            }
            stringBuilder.append(')');
        } else if (annotationTree.getParametersCount() > 1) {
            stringBuilder.append('(');
            String string = annotationTree.getParametersList().stream().map(this::formatTree).collect(Collectors.joining(", "));
            stringBuilder.append(string);
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    private String formatTree(Semanticdb.Tree tree) {
        if (tree.hasIdTree()) {
            return SymbolDescriptor.parseFromSymbol((String)tree.getIdTree().getSymbol()).descriptor.name;
        }
        if (tree.hasLiteralTree()) {
            return this.formatConstant(tree.getLiteralTree().getConstant());
        }
        if (tree.hasSelectTree()) {
            return this.formatTree(tree.getSelectTree().getQualifier()) + "." + SymbolDescriptor.parseFromSymbol((String)tree.getSelectTree().getId().getSymbol()).descriptor.name;
        }
        if (tree.hasAnnotationTree()) {
            return this.formatAnnotation(tree.getAnnotationTree());
        }
        if (tree.hasApplyTree()) {
            if (tree.getApplyTree().getFunction().hasIdTree() && tree.getApplyTree().getFunction().getIdTree().getSymbol().equals(ARRAY_SYMBOL)) {
                return tree.getApplyTree().getArgumentsList().stream().map(this::formatTree).collect(Collectors.joining(", ", "{", "}"));
            }
            throw new IllegalArgumentException("unexpected apply tree function " + tree.getApplyTree().getFunction());
        }
        if (tree.hasBinopTree()) {
            return this.formatTree(tree.getBinopTree().getLhs()) + " " + this.formatBinaryOperator(tree.getBinopTree().getOp()) + " " + this.formatTree(tree.getBinopTree().getRhs());
        }
        if (tree.hasAssignTree()) {
            return this.formatTree(tree.getAssignTree().getLhs()) + " = " + this.formatTree(tree.getAssignTree().getRhs());
        }
        if (tree.hasUnaryopTree()) {
            return this.formatUnaryOperation(tree.getUnaryopTree());
        }
        throw new IllegalArgumentException("tree was of unexpected type " + tree);
    }

    private String formatUnaryOperation(Semanticdb.UnaryOperatorTree unaryOperatorTree) {
        String string = this.formatTree(unaryOperatorTree.getTree());
        switch (unaryOperatorTree.getOp()) {
            case UNARY_MINUS: {
                return "-" + string;
            }
            case UNARY_PLUS: {
                return "-" + string;
            }
            case UNARY_POSTFIX_INCREMENT: {
                return string + "++";
            }
            case UNARY_POSTFIX_DECREMENT: {
                return string + "--";
            }
            case UNARY_PREFIX_DECREMENT: {
                return "--" + string;
            }
            case UNARY_PREFIX_INCREMENT: {
                return "++" + string;
            }
            case UNARY_BITWISE_COMPLEMENT: {
                return "~" + string;
            }
            case UNARY_LOGICAL_COMPLEMENT: {
                return "!" + string;
            }
        }
        throw new IllegalArgumentException("unary operation of unexpected type" + unaryOperatorTree.getOp().toString());
    }

    private String formatConstant(Semanticdb.Constant constant) {
        if (constant.hasUnitConstant()) {
            return this.isScala ? "()" : "scala.Unit()";
        }
        if (constant.hasBooleanConstant()) {
            return Boolean.toString(constant.getBooleanConstant().getValue());
        }
        if (constant.hasByteConstant()) {
            return Integer.toString(constant.getByteConstant().getValue());
        }
        if (constant.hasShortConstant()) {
            return Integer.toString(constant.getShortConstant().getValue());
        }
        if (constant.hasCharConstant()) {
            return String.format("'%s'", Character.valueOf((char)constant.getCharConstant().getValue()));
        }
        if (constant.hasIntConstant()) {
            return Integer.toString(constant.getIntConstant().getValue());
        }
        if (constant.hasLongConstant()) {
            return Long.toString(constant.getLongConstant().getValue());
        }
        if (constant.hasFloatConstant()) {
            return Float.toString(constant.getFloatConstant().getValue()) + 'f';
        }
        if (constant.hasDoubleConstant()) {
            return Double.toString(constant.getDoubleConstant().getValue());
        }
        if (constant.hasStringConstant()) {
            return '\"' + constant.getStringConstant().getValue() + '\"';
        }
        if (constant.hasNullConstant()) {
            return "null";
        }
        throw new IllegalArgumentException("constant was not of known type " + constant);
    }

    private String formatBinaryOperator(Semanticdb.BinaryOperator binaryOperator) {
        switch (binaryOperator) {
            case PLUS: {
                return "+";
            }
            case MINUS: {
                return "-";
            }
            case MULTIPLY: {
                return "*";
            }
            case DIVIDE: {
                return "/";
            }
            case REMAINDER: {
                return "%";
            }
            case GREATER_THAN: {
                return ">";
            }
            case LESS_THAN: {
                return "<";
            }
            case AND: {
                return "&";
            }
            case XOR: {
                return "^";
            }
            case OR: {
                return "|";
            }
            case CONDITIONAL_AND: {
                return "&&";
            }
            case CONDITIONAL_OR: {
                return "||";
            }
            case SHIFT_LEFT: {
                return "<<";
            }
            case SHIFT_RIGHT: {
                return ">>";
            }
            case SHIFT_RIGHT_UNSIGNED: {
                return ">>>";
            }
            case EQUAL_TO: {
                return "==";
            }
            case NOT_EQUAL_TO: {
                return "!=";
            }
            case GREATER_THAN_EQUAL: {
                return ">=";
            }
            case LESS_THAN_EQUAL: {
                return "<=";
            }
            case UNRECOGNIZED: {
                throw new IllegalArgumentException("unexpected binary operator " + binaryOperator);
            }
        }
        return null;
    }

    private String formatType(Semanticdb.Type type) {
        StringBuilder stringBuilder = new StringBuilder();
        if (type.hasTypeRef()) {
            Semanticdb.TypeRef typeRef = type.getTypeRef();
            if (typeRef.getSymbol().equals(ARRAY_SYMBOL)) {
                if (this.isScala) {
                    stringBuilder.append("Array[");
                    stringBuilder.append(this.formatType(typeRef.getTypeArguments(0)));
                    stringBuilder.append("]");
                } else {
                    stringBuilder.append(this.formatType(typeRef.getTypeArguments(0)));
                    stringBuilder.append("[]");
                }
            } else if (this.isScala && typeRef.getSymbol().startsWith(FUNCTION_SYMBOL_PREFIX) && typeRef.getTypeArgumentsCount() > 0 && !typeRef.getSymbol().startsWith(FUNCTION_OBJECT)) {
                int n = typeRef.getTypeArgumentsCount() - 1;
                if (n == 0) {
                    this.s.append(this.formatType(typeRef.getTypeArguments(0)));
                } else {
                    stringBuilder.append(typeRef.getTypeArgumentsList().stream().limit(Math.max(0, n)).map(this::formatType).collect(Collectors.joining(", ", "(", ")")));
                }
                stringBuilder.append(" => ");
                stringBuilder.append(this.formatType(typeRef.getTypeArguments(n)));
            } else if (this.isScala && typeRef.getSymbol().startsWith(TUPLE_SYMBOL_PREFIX)) {
                stringBuilder.append(typeRef.getTypeArgumentsList().stream().map(this::formatType).collect(Collectors.joining(", ", "(", ")")));
            } else {
                stringBuilder.append(this.symbolDisplayName(typeRef.getSymbol()));
                stringBuilder.append(this.formatTypeArguments(typeRef.getTypeArgumentsList()));
            }
        } else if (type.hasSingleType()) {
            Semanticdb.SymbolInformation symbolInformation;
            Semanticdb.SingleType singleType = type.getSingleType();
            if (singleType.hasPrefix()) {
                stringBuilder.append(this.formatType(singleType.getPrefix()));
            }
            if ((symbolInformation = this.symtab.symbols.get(singleType.getSymbol())) != null) {
                stringBuilder.append(symbolInformation.getDisplayName()).append(".type");
            }
        } else if (type.hasThisType()) {
            stringBuilder.append("this.type");
        } else if (type.hasSuperType()) {
            Semanticdb.SuperType superType = type.getSuperType();
            if (superType.hasPrefix()) {
                stringBuilder.append(this.formatType(superType.getPrefix())).append(".");
            }
            stringBuilder.append("super");
        } else if (type.hasConstantType()) {
            stringBuilder.append(this.formatConstant(type.getConstantType().getConstant()));
        } else if (type.hasIntersectionType()) {
            stringBuilder.append(type.getIntersectionType().getTypesList().stream().map(this::formatType).collect(Collectors.joining(this.isScala ? " with " : " & ")));
        } else if (type.hasUnionType()) {
            stringBuilder.append(type.getIntersectionType().getTypesList().stream().map(this::formatType).collect(Collectors.joining(" | ")));
        } else if (type.hasStructuralType()) {
            Semanticdb.StructuralType structuralType = type.getStructuralType();
            int n = structuralType.getDeclarations().getHardlinksCount();
            if (n == 0) {
                stringBuilder.append(" {}");
            } else {
                stringBuilder.append(this.formatType(structuralType.getTpe())).append(" {");
                Symtab symtab = this.symtab.withHardlinks(structuralType.getDeclarations());
                for (int i = 0; i < n; ++i) {
                    Semanticdb.SymbolInformation symbolInformation = structuralType.getDeclarations().getHardlinks(i);
                    if (i > 0) {
                        stringBuilder.append(";");
                    }
                    stringBuilder.append(" ").append(new SignatureFormatter(symbolInformation, symtab).formatSymbol());
                }
                stringBuilder.append(" }");
            }
        } else if (type.hasExistentialType()) {
            AtomicInteger atomicInteger = new AtomicInteger();
            Semanticdb.TypeRef typeRef = type.getExistentialType().getTpe().getTypeRef();
            stringBuilder.append(this.symbolDisplayName(type.getExistentialType().getTpe().getTypeRef().getSymbol()));
            stringBuilder.append(typeRef.getTypeArgumentsList().stream().map(type2 -> {
                if (type2.equals((Object)WILDCARD_TYPE_REF)) {
                    Semanticdb.SymbolInformation symbolInformation = type.getExistentialType().getDeclarations().getHardlinks(atomicInteger.getAndIncrement());
                    return this.symbolDisplayName(symbolInformation.getSymbol()) + new SignatureFormatter(symbolInformation, this.symtab).formatSymbol();
                }
                return this.formatType((Semanticdb.Type)type2);
            }).collect(Collectors.joining(", ", this.isScala ? "[" : "<", this.isScala ? "[" : ">")));
        } else if (type.hasByNameType()) {
            stringBuilder.append("=> ").append(this.formatType(type.getByNameType().getTpe()));
        } else if (type.hasRepeatedType()) {
            stringBuilder.append(this.formatType(type.getRepeatedType().getTpe())).append("*");
        }
        return stringBuilder.toString().trim();
    }

    private String formatAccess() {
        Semanticdb.Access access = this.symbolInformation.getAccess();
        if (access.hasPrivateAccess()) {
            return "private";
        }
        if (!this.isScala && access.hasPublicAccess()) {
            return "public";
        }
        if (access.hasProtectedAccess()) {
            return "protected";
        }
        if (this.isScala && access.hasPrivateThisAccess()) {
            return "private[this]";
        }
        if (this.isScala && access.hasPrivateWithinAccess()) {
            String string = SymbolDescriptor.parseFromSymbol((String)access.getPrivateWithinAccess().getSymbol()).descriptor.name;
            return String.format("protected[%s]", string);
        }
        return "";
    }

    private String formatModifiers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.has(Semanticdb.SymbolInformation.Property.ABSTRACT) && (!this.isScala || this.symbolInformation.getKind() == Semanticdb.SymbolInformation.Kind.CLASS)) {
            arrayList.add("abstract");
        }
        if (this.has(Semanticdb.SymbolInformation.Property.DEFAULT)) {
            arrayList.add("default");
        }
        if (this.has(Semanticdb.SymbolInformation.Property.STATIC)) {
            arrayList.add("static");
        }
        if (this.has(Semanticdb.SymbolInformation.Property.FINAL) && this.symbolInformation.getKind() != Semanticdb.SymbolInformation.Kind.OBJECT && this.symbolInformation.getKind() != Semanticdb.SymbolInformation.Kind.PACKAGE_OBJECT) {
            arrayList.add("final");
        }
        if (this.has(Semanticdb.SymbolInformation.Property.IMPLICIT)) {
            arrayList.add("implicit");
        }
        if (this.has(Semanticdb.SymbolInformation.Property.SEALED)) {
            arrayList.add("sealed");
        }
        if (this.has(Semanticdb.SymbolInformation.Property.CASE)) {
            arrayList.add("case");
        }
        return String.join((CharSequence)" ", arrayList);
    }

    private void printKeyword(String string) {
        if (string.isEmpty()) {
            return;
        }
        this.s.append(string).append(' ');
    }

    private void printKeywordln(String string) {
        if (string.isEmpty()) {
            return;
        }
        this.s.append(string).append('\n');
    }

    private boolean isEnumConstant(Semanticdb.SymbolInformation symbolInformation) {
        if (!(this.has(Semanticdb.SymbolInformation.Property.ENUM, symbolInformation) && this.has(Semanticdb.SymbolInformation.Property.FINAL, symbolInformation) && this.has(Semanticdb.SymbolInformation.Property.STATIC, symbolInformation) && symbolInformation.getAccess().hasPublicAccess())) {
            return false;
        }
        Semanticdb.SymbolInformation symbolInformation2 = this.symtab.symbols.get(SymbolDescriptor.parseFromSymbol((String)symbolInformation.getSymbol()).owner);
        if (symbolInformation2 == null) {
            return false;
        }
        return symbolInformation2.getKind() == Semanticdb.SymbolInformation.Kind.CLASS && this.has(Semanticdb.SymbolInformation.Property.ENUM, symbolInformation2);
    }

    private boolean isEnumConstant() {
        return this.isEnumConstant(this.symbolInformation);
    }

    private boolean has(Semanticdb.SymbolInformation.Property property, Semanticdb.SymbolInformation symbolInformation) {
        return (symbolInformation.getProperties() & property.getNumber()) > 0;
    }

    private boolean has(Semanticdb.SymbolInformation.Property property) {
        return this.has(property, this.symbolInformation);
    }

    public String symbolDisplayName(String string) {
        if (this.isScala) {
            return this.symbolScalaDisplayName(string);
        }
        return this.symbolJavaDisplayName(string);
    }

    private String symbolScalaDisplayName(String string) {
        if ("local_wildcard".equals(string)) {
            return "*";
        }
        return SymbolDescriptor.parseFromSymbol((String)string).descriptor.name;
    }

    private String symbolJavaDisplayName(String string) {
        switch (string) {
            case "local_wildcard": {
                return "?";
            }
            case "scala/Boolean#": {
                return "boolean";
            }
            case "scala/Byte#": {
                return "byte";
            }
            case "scala/Short#": {
                return "short";
            }
            case "scala/Int#": {
                return "int";
            }
            case "scala/Long#": {
                return "long";
            }
            case "scala/Char#": {
                return "char";
            }
            case "scala/Float#": {
                return "float";
            }
            case "scala/Double#": {
                return "double";
            }
            case "scala/Unit#": {
                return "void";
            }
        }
        return SymbolDescriptor.parseFromSymbol((String)string).descriptor.name;
    }
}

