/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.scip_semanticdb;

import com.sourcegraph.semanticdb_javac.SemanticdbSymbols;
import java.util.Optional;

public class SymbolDescriptor {
    public final SemanticdbSymbols.Descriptor descriptor;
    public final String owner;
    public static SymbolDescriptor NONE = new SymbolDescriptor(SemanticdbSymbols.Descriptor.NONE, SemanticdbSymbols.NONE);

    public SymbolDescriptor(SemanticdbSymbols.Descriptor descriptor, String string) {
        this.descriptor = descriptor;
        this.owner = string;
    }

    public static SymbolDescriptor parseFromSymbol(String string) {
        return new Parser(string).entryPoint();
    }

    public static Optional<SymbolDescriptor> toplevel(String string) {
        if (string == null || string.isEmpty()) {
            return Optional.empty();
        }
        if (SemanticdbSymbols.isLocal((String)string)) {
            return Optional.empty();
        }
        SymbolDescriptor symbolDescriptor = SymbolDescriptor.parseFromSymbol(string);
        if (symbolDescriptor.descriptor.kind == SemanticdbSymbols.Descriptor.Kind.Package) {
            return Optional.empty();
        }
        SymbolDescriptor symbolDescriptor2 = SymbolDescriptor.parseFromSymbol(symbolDescriptor.owner);
        if (symbolDescriptor2.descriptor.kind == SemanticdbSymbols.Descriptor.Kind.Package) {
            return Optional.of(symbolDescriptor);
        }
        return SymbolDescriptor.toplevel(symbolDescriptor.owner);
    }

    public static class Parser {
        private int i;
        private char currChar = (char)26;
        private final String symbol;
        private static final char BOF = '\u0000';
        private static final char EOF = '\u001a';

        public Parser(String string) {
            this.i = string.length();
            this.symbol = string;
        }

        public SymbolDescriptor entryPoint() {
            if (SemanticdbSymbols.isLocal((String)this.symbol)) {
                return new SymbolDescriptor(SemanticdbSymbols.Descriptor.local((String)this.symbol), SemanticdbSymbols.NONE);
            }
            if (SemanticdbSymbols.NONE.equals(this.symbol)) {
                return NONE;
            }
            this.readChar();
            SemanticdbSymbols.Descriptor descriptor = this.parseDescriptor();
            String string = this.i < 0 ? SemanticdbSymbols.ROOT_PACKAGE : this.symbol.substring(0, this.i + 1);
            return new SymbolDescriptor(descriptor, string);
        }

        public IllegalArgumentException fail() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.i; ++i) {
                stringBuilder.append(' ');
            }
            stringBuilder.append('^');
            return new IllegalArgumentException("invalid symbol format\n" + this.symbol + "\n" + stringBuilder.toString());
        }

        public char readChar() {
            if (this.i < 0) {
                throw this.fail();
            }
            if (this.i == 0) {
                --this.i;
                this.currChar = '\u0000';
                return this.currChar;
            }
            --this.i;
            this.currChar = this.symbol.charAt(this.i);
            return this.currChar;
        }

        public String parseValue() {
            if (this.currChar == '`') {
                int n = this.i;
                while (this.readChar() != '`') {
                }
                this.readChar();
                return this.symbol.substring(this.i + 2, n);
            }
            int n = this.i + 1;
            if (!Character.isJavaIdentifierPart(this.currChar)) {
                throw this.fail();
            }
            while (Character.isJavaIdentifierPart(this.readChar()) && this.currChar != '\u0000') {
            }
            return this.symbol.substring(this.i + 1, n);
        }

        public String parseDisambiguator() {
            int n = this.i + 1;
            if (this.currChar != ')') {
                throw this.fail();
            }
            while (this.readChar() != '(') {
            }
            this.readChar();
            return this.symbol.substring(this.i + 1, n);
        }

        public SemanticdbSymbols.Descriptor parseDescriptor() {
            switch (this.currChar) {
                case '.': {
                    this.readChar();
                    if (this.currChar == ')') {
                        String string = this.parseDisambiguator();
                        String string2 = this.parseValue();
                        return new SemanticdbSymbols.Descriptor(SemanticdbSymbols.Descriptor.Kind.Method, string2, string);
                    }
                    return new SemanticdbSymbols.Descriptor(SemanticdbSymbols.Descriptor.Kind.Term, this.parseValue());
                }
                case '#': {
                    this.readChar();
                    return new SemanticdbSymbols.Descriptor(SemanticdbSymbols.Descriptor.Kind.Type, this.parseValue());
                }
                case '/': {
                    this.readChar();
                    return new SemanticdbSymbols.Descriptor(SemanticdbSymbols.Descriptor.Kind.Package, this.parseValue());
                }
                case ')': {
                    this.readChar();
                    String string = this.parseValue();
                    if (this.currChar != '(') {
                        throw this.fail();
                    }
                    this.readChar();
                    return new SemanticdbSymbols.Descriptor(SemanticdbSymbols.Descriptor.Kind.Parameter, string);
                }
                case ']': {
                    this.readChar();
                    String string = this.parseValue();
                    if (this.currChar != '[') {
                        throw this.fail();
                    }
                    this.readChar();
                    return new SemanticdbSymbols.Descriptor(SemanticdbSymbols.Descriptor.Kind.TypeParameter, string);
                }
            }
            throw this.fail();
        }
    }
}

