/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.scip_semanticdb;

import com.sourcegraph.lsif_protocol.LsifToolInfo;
import com.sourcegraph.scip_java.Bazelbuild;
import com.sourcegraph.scip_semanticdb.BazelOptions;
import com.sourcegraph.scip_semanticdb.InputStreamBytes;
import com.sourcegraph.scip_semanticdb.MavenPackage;
import com.sourcegraph.scip_semanticdb.ScipOutputFormat;
import com.sourcegraph.scip_semanticdb.ScipSemanticdb;
import com.sourcegraph.scip_semanticdb.ScipSemanticdbOptions;
import com.sourcegraph.scip_semanticdb.ScipSemanticdbReporter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BazelBuildTool {
    public static int runAndReturnExitCode(String[] stringArray) throws IOException, InterruptedException {
        Optional<BazelOptions> optional = BazelOptions.parse(stringArray);
        if (!optional.isPresent()) {
            return 1;
        }
        BazelOptions bazelOptions = optional.get();
        if (bazelOptions.isHelp) {
            BazelOptions.printHelp();
            return 0;
        }
        if (bazelOptions.isVersion) {
            System.out.println("This command-line tool has no version because it is supposed to be compiled from source.");
            return 0;
        }
        List<MavenPackage> list = BazelBuildTool.mavenPackages(bazelOptions);
        ScipSemanticdbReporter scipSemanticdbReporter = new ScipSemanticdbReporter(){
            private boolean hasErrors = false;

            @Override
            public void error(Throwable throwable) {
                throwable.printStackTrace(System.err);
                this.hasErrors = true;
            }

            @Override
            public void error(String string) {
                System.err.println("ERROR[scip-semanticdb]: " + string);
                this.hasErrors = true;
            }

            @Override
            public boolean hasErrors() {
                return this.hasErrors;
            }
        };
        ScipSemanticdbOptions scipSemanticdbOptions = new ScipSemanticdbOptions(bazelOptions.targetroots, bazelOptions.output, bazelOptions.sourceroot, scipSemanticdbReporter, LsifToolInfo.newBuilder().setName("scip-java").setVersion("HEAD").build(), "java", ScipOutputFormat.TYPED_PROTOBUF, bazelOptions.parallel, list, "", true, true, false);
        ScipSemanticdb.run(scipSemanticdbOptions);
        if (!scipSemanticdbOptions.reporter.hasErrors()) {
            System.out.println("done: " + scipSemanticdbOptions.output);
            return 0;
        }
        System.out.println("SCIP index generation failed");
        return 1;
    }

    public static List<MavenPackage> mavenPackages(BazelOptions bazelOptions) throws IOException, InterruptedException {
        ArrayList<MavenPackage> arrayList = new ArrayList<MavenPackage>();
        if (!bazelOptions.isQueryMavenImports) {
            return arrayList;
        }
        Bazelbuild.QueryResult queryResult = BazelBuildTool.runBazelQuery(bazelOptions, "kind('.*_import', @maven//...)");
        Path path = bazelOptions.sourceroot.resolve("bazel-bin").resolve("external").resolve("maven");
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:**.jar");
        for (Bazelbuild.Target target : queryResult.getTargetList()) {
            String[] throwable;
            if (target.getType() != Bazelbuild.Target.Discriminator.RULE) continue;
            Bazelbuild.Rule rule = target.getRule();
            MavenPackage mavenPackage = null;
            ArrayList<Path> arrayList2 = new ArrayList<Path>();
            for (Bazelbuild.Attribute attribute : rule.getAttributeList()) {
                if (attribute.getName().equals("jars")) {
                    for (Object object : attribute.getStringListValueList()) {
                        if (!((String)object).startsWith("@maven//:")) continue;
                        arrayList2.add(path.resolve(((String)object).substring("@maven//:".length())).getParent());
                    }
                }
                if (!attribute.getName().equals("tags")) continue;
                for (Object object : attribute.getStringListValueList()) {
                    if (!((String)object).startsWith("maven_coordinates=") || (throwable = ((String)object).substring("maven_coordinates=".length()).split(":")).length != 3) continue;
                    mavenPackage = new MavenPackage(null, throwable[0], throwable[1], throwable[2]);
                }
            }
            if (mavenPackage == null) continue;
            for (Path path2 : arrayList2) {
                Object object;
                Stream<Path> stream = Files.list(path2);
                object = null;
                try {
                    throwable = stream.filter(pathMatcher::matches).collect(Collectors.toList());
                    for (Path path3 : throwable) {
                        arrayList.add(mavenPackage.withJar(path3));
                    }
                }
                catch (Throwable throwable2) {
                    object = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (object != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            ((Throwable)object).addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
        }
        return arrayList;
    }

    public static Bazelbuild.QueryResult runBazelQuery(BazelOptions bazelOptions, String string) throws IOException, InterruptedException {
        List<String> list = Arrays.asList(bazelOptions.bazelBinary, "query", string, "--output=proto");
        System.out.println("running: " + String.join((CharSequence)" ", list));
        Process process = new ProcessBuilder(list).directory(bazelOptions.sourceroot.toFile()).start();
        byte[] byArray = InputStreamBytes.readAll(process.getInputStream());
        int n = process.waitFor();
        if (n != 0) {
            throw new RuntimeException("bazel command failed\n" + new String(byArray));
        }
        return Bazelbuild.QueryResult.parseFrom(byArray);
    }

    public static void main(String[] stringArray) throws IOException, InterruptedException {
        System.exit(BazelBuildTool.runAndReturnExitCode(stringArray));
    }
}

