/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.scip_semanticdb;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class BazelOptions {
    public final List<Path> targetroots = new ArrayList<Path>();
    public Path sourceroot;
    public Path output;
    public String bazelBinary = "bazel";
    public boolean isQueryMavenImports = true;
    public boolean isHelp = false;
    public boolean isVersion = false;
    public boolean parallel = false;

    public static void printHelp() {
        System.out.println("bazel run @scip_java//scip-semanticdb:bazel -- [..options]");
        System.out.println();
        System.out.println("Command-line tool to generate SCIP for Java targets in a Bazel build.");
        System.out.println("The idiomatic way to run this tool is to compile it from source via Bazel\nand invoke it through `bazel run ...`.");
        System.out.println();
        System.out.println("OPTIONS:");
        System.out.println("  --sourceroot <path> the absolute path to the root directory of the Bazel codebase");
        System.out.println("                      TIP: use --sourceroot \"$PWD\" to pass the current working directory");
        System.out.println("  --output <path> the absolute path to the file that should be generated");
        System.out.println("  --parallel whether to process files in parallel");
        System.out.println("  --no-query-maven-imports whether to skip the `bazel query @maven//...` phase.");
    }

    public static Optional<BazelOptions> parse(String[] stringArray) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        BazelOptions bazelOptions = new BazelOptions();
        if (stringArray.length == 1 && (stringArray[0].equals("--help") || stringArray[0].equals("help") || stringArray[0].equals("-h") || stringArray[0].equals("-help"))) {
            bazelOptions.isHelp = true;
            return Optional.of(bazelOptions);
        }
        if (stringArray.length == 1 && (stringArray[0].equals("--version") || stringArray[0].equals("version") || stringArray[0].equals("-v") || stringArray[0].equals("-version"))) {
            bazelOptions.isVersion = true;
            return Optional.of(bazelOptions);
        }
        Iterator<String> iterator = Arrays.asList(stringArray).iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.equals("--sourceroot") && iterator.hasNext()) {
                bazelOptions.sourceroot = Paths.get(iterator.next(), new String[0]);
            }
            if (string.equals("--output")) {
                if (iterator.hasNext()) {
                    bazelOptions.output = Paths.get(iterator.next(), new String[0]);
                } else {
                    arrayList.add("missing argument for flag --output <path>");
                }
            }
            if (string.equals("--parallel")) {
                bazelOptions.parallel = true;
            }
            if (string.equals("--query-maven-imports")) {
                bazelOptions.isQueryMavenImports = true;
            }
            if (string.equals("--no-query-maven-imports")) {
                bazelOptions.isQueryMavenImports = false;
            }
            if (!string.equals("--bazel-binary")) continue;
            if (iterator.hasNext()) {
                bazelOptions.bazelBinary = iterator.next();
                continue;
            }
            arrayList.add("missing argument for flag --bazel-binary <path>");
        }
        if (bazelOptions.sourceroot == null) {
            if (stringArray.length == 0) {
                arrayList.add("missing required flag --sourceroot <path>. To fix this problem, pass in the `--sourceroot` flag like this: bazel run @scip_java//scip-semanticdb:bazel -- --sourceroot \"$PWD\"");
            } else {
                arrayList.add("missing required flag --sourceroot <path>");
            }
        } else if (!bazelOptions.sourceroot.isAbsolute()) {
            arrayList.add(String.format("relative path --sourceroot '%s'. To fix this problem, pass in an an absolute path.", bazelOptions.sourceroot));
        } else if (!Files.isDirectory(bazelOptions.sourceroot, new LinkOption[0])) {
            arrayList.add(String.format("not a directory --sourceroot '%s'", bazelOptions.sourceroot));
        }
        if (bazelOptions.output == null) {
            bazelOptions.output = Paths.get("index.scip", new String[0]);
        }
        if (!arrayList.isEmpty()) {
            if (arrayList.size() == 1) {
                System.err.printf("error: %s\n", arrayList.get(0));
            } else {
                for (int i = 0; i < arrayList.size(); ++i) {
                    System.err.printf("[%d] error: %s\n", i, arrayList.get(i));
                }
            }
            return Optional.empty();
        }
        BazelOptions.inferTargetrootsAndPackages(bazelOptions);
        bazelOptions.output = BazelOptions.absolutePath(bazelOptions.sourceroot, bazelOptions.output);
        return Optional.of(bazelOptions);
    }

    public static void inferTargetrootsAndPackages(final BazelOptions bazelOptions) throws IOException {
        final PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:**-0.params");
        Path path = bazelOptions.sourceroot.resolve("bazel-bin");
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(path, Collections.singleton(FileVisitOption.FOLLOW_LINKS), 1000, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFileFailed(Path path, IOException iOException) {
                iOException.printStackTrace(System.err);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                if (pathMatcher.matches(path)) {
                    BazelOptions.visitParamsFile(path, bazelOptions);
                }
                return super.visitFile(path, basicFileAttributes);
            }
        });
    }

    private static Path absolutePath(Path path, Path path2) {
        return path2.isAbsolute() ? path2 : path.resolve(path2);
    }

    public static void visitParamsFile(Path path, BazelOptions bazelOptions) throws IOException {
        List<String> list = Files.readAllLines(path);
        Optional<String> optional = list.stream().filter(string -> string.startsWith("-Xplugin:semanticdb")).findFirst();
        if (optional.isPresent()) {
            String string2 = path.getFileName().toString();
            Path path2 = path.resolveSibling(string2 = string2.substring(0, string2.length() - "-0.param".length() - 1));
            if (Files.isRegularFile(path2, new LinkOption[0])) {
                bazelOptions.targetroots.add(path2);
            }
        }
    }
}

