/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.scip_semanticdb;

import com.sourcegraph.scip_semanticdb.JdkPackage;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Enumeration;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JavaVersion {
    public final boolean isJava8;
    public final JdkPackage pkg;
    private static final PathMatcher CLASS_PATTERN = FileSystems.getDefault().getPathMatcher("glob:**.class");
    private static final PathMatcher JAR_PATTERN = FileSystems.getDefault().getPathMatcher("glob:**.jar");
    public static final int JAVA8_VERSION = 8;
    public static final int JAVA11_VERSION = 11;
    public static final int JAVA17_VERSION = 17;
    public static final int DEFAULT_JAVA_VERSION = 8;
    private static final int JAVA0_MAJOR_VERSION = 44;

    public JavaVersion() {
        this(System.getProperty("java.version"));
    }

    public JavaVersion(String string) {
        this.isJava8 = string.startsWith("1.8");
        this.pkg = new JdkPackage(this.isJava8 ? "8" : this.javaVersion(string));
    }

    private String javaVersion(String string) {
        if (string.startsWith("1.8")) {
            return "8";
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length > 0) {
            return stringArray[0];
        }
        return string;
    }

    public static int roundToNearestStableRelease(int n) {
        if (n <= 8) {
            return 8;
        }
        if (n <= 11) {
            return 11;
        }
        if (n <= 17) {
            return 17;
        }
        return n;
    }

    public static Optional<Integer> classfileJvmVersion(Path path) {
        try {
            int n = JavaVersion.classfileMajorVersion(path);
            return n < 0 ? Optional.empty() : Optional.of(n - 44);
        }
        catch (IOException iOException) {
            return Optional.empty();
        }
    }

    private static int classfileMajorVersion(Path path) throws IOException {
        if (CLASS_PATTERN.matches(path)) {
            return JavaVersion.classfileMajorVersion(Files.newInputStream(path, new OpenOption[0]));
        }
        if (JAR_PATTERN.matches(path)) {
            try (JarFile jarFile = new JarFile(path.toFile());){
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    if (!jarEntry.getName().endsWith(".class")) continue;
                    int n = JavaVersion.classfileMajorVersion(jarFile.getInputStream(jarEntry));
                    return n;
                }
            }
        }
        return -1;
    }

    private static int classfileMajorVersion(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = dataInputStream.readInt();
        if (n != -889275714) {
            return -1;
        }
        dataInputStream.readUnsignedShort();
        return dataInputStream.readUnsignedShort();
    }
}

