/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.scip_semanticdb;

import com.sourcegraph.scip_semanticdb.JdkPackage;
import com.sourcegraph.scip_semanticdb.Package;
import com.sourcegraph.scip_semanticdb.PackageTable;
import com.sourcegraph.scip_semanticdb.ResultIds;
import com.sourcegraph.scip_semanticdb.ScipSemanticdbOptions;
import com.sourcegraph.scip_semanticdb.ScipWriter;
import com.sourcegraph.semanticdb_javac.SemanticdbSymbols;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class ResultSets
implements Function<String, ResultIds> {
    private final ScipWriter writer;
    private final Map<String, ResultIds> globals;
    private final HashMap<String, ResultIds> locals;
    private final Set<String> exportedSymbols;
    private final Set<String> localDefinitions;
    private final PackageTable packages;
    private final boolean isJdkRepo;

    public ResultSets(ScipWriter scipWriter, Map<String, ResultIds> map, Set<String> set, Set<String> set2, PackageTable packageTable, ScipSemanticdbOptions scipSemanticdbOptions) {
        this.writer = scipWriter;
        this.globals = map;
        this.exportedSymbols = set;
        this.localDefinitions = set2;
        this.packages = packageTable;
        this.isJdkRepo = scipSemanticdbOptions.buildKind.equals("jdk");
        this.locals = new HashMap();
    }

    public ResultIds getOrInsertResultSet(String string) {
        boolean bl = SemanticdbSymbols.isLocal((String)string);
        Map<String, ResultIds> map = bl ? this.locals : this.globals;
        return map.computeIfAbsent(string, this);
    }

    @Override
    public ResultIds apply(String string) {
        boolean bl = this.exportedSymbols.contains(string);
        boolean bl2 = bl || this.localDefinitions.contains(string);
        int n = this.writer.emitResultSet();
        Optional<Package> optional = this.packages.packageForSymbol(string);
        if (optional.isPresent() && optional.get() instanceof JdkPackage && !this.isJdkRepo) {
            bl = false;
        }
        int n2 = this.writer.emitMonikerVertex(string, bl2);
        this.writer.emitMonikerEdge(n, n2);
        if (optional.isPresent()) {
            this.packages.writeMonikerPackage(n2, optional.get());
        }
        int n3 = bl2 ? this.writer.emitDefinitionResult(n) : -1;
        return new ResultIds(n, n3, this.writer.emitReferenceResult(n));
    }
}

