/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.scip_semanticdb;

import com.google.protobuf.Descriptors;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.sourcegraph.lsif_protocol.LsifObject;
import com.sourcegraph.lsif_protocol.LsifPosition;
import com.sourcegraph.scip_semanticdb.ScipByteOutputStream;
import com.sourcegraph.scip_semanticdb.ScipSemanticdbOptions;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;

public class ScipOutputStream {
    private final ScipSemanticdbOptions options;
    private final OutputStream out;
    private final ConcurrentLinkedDeque<byte[]> buffer;
    private final AtomicBoolean isFlushing;
    private static final byte[] NEWLINE = "\n".getBytes(StandardCharsets.UTF_8);
    private final ThreadLocal<ScipByteOutputStream> baos = ThreadLocal.withInitial(ScipByteOutputStream::new);
    private final JsonFormat.Printer jsonPrinter;

    public ScipOutputStream(ScipSemanticdbOptions scipSemanticdbOptions, OutputStream outputStream) {
        this.options = scipSemanticdbOptions;
        this.out = outputStream;
        this.buffer = new ConcurrentLinkedDeque();
        this.isFlushing = new AtomicBoolean(false);
        HashSet<Descriptors.FieldDescriptor> hashSet = new HashSet<Descriptors.FieldDescriptor>(LsifPosition.getDescriptor().getFields());
        hashSet.add(LsifObject.getDescriptor().findFieldByName("id"));
        this.jsonPrinter = JsonFormat.printer().includingDefaultValueFields(hashSet).omittingInsignificantWhitespace();
    }

    public void write(byte[] byArray) {
        if (byArray.length == 0) {
            return;
        }
        this.buffer.add(byArray);
    }

    public void writeLsifObject(LsifObject.Builder builder) {
        ScipByteOutputStream scipByteOutputStream = this.baos.get();
        scipByteOutputStream.output.reset();
        try {
            switch (this.options.format) {
                case GRAPH_PROTOBUF: {
                    builder.buildPartial().writeTo(scipByteOutputStream.output);
                    break;
                }
                default: {
                    this.jsonPrinter.appendTo((MessageOrBuilder)builder, (Appendable)scipByteOutputStream.writer);
                    scipByteOutputStream.writer.flush();
                    break;
                }
            }
        }
        catch (IOException iOException) {
            this.options.reporter.error(iOException);
        }
        this.write(scipByteOutputStream.output.toByteArray());
    }

    public void flush() throws IOException {
        if (this.isFlushing.compareAndSet(false, true)) {
            byte[] byArray = this.buffer.poll();
            while (byArray != null) {
                this.out.write(byArray);
                if (this.options.format.isNewlineDelimitedJSON()) {
                    this.out.write(NEWLINE);
                }
                byArray = this.buffer.poll();
            }
            this.out.flush();
            this.isFlushing.set(false);
        }
    }
}

