/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.scip_semanticdb;

import com.sourcegraph.Scip;
import com.sourcegraph.lsif_protocol.LsifHover;
import com.sourcegraph.lsif_protocol.LsifObject;
import com.sourcegraph.lsif_protocol.LsifPosition;
import com.sourcegraph.scip_semanticdb.MarkupContent;
import com.sourcegraph.scip_semanticdb.OperatingSystem;
import com.sourcegraph.scip_semanticdb.Package;
import com.sourcegraph.scip_semanticdb.ScipOutputStream;
import com.sourcegraph.scip_semanticdb.ScipSemanticdbOptions;
import com.sourcegraph.scip_semanticdb.ScipTextDocument;
import com.sourcegraph.semanticdb_javac.Semanticdb;
import com.sourcegraph.semanticdb_javac.SemanticdbSymbols;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class ScipWriter
implements AutoCloseable {
    private final Path tmp;
    private final ScipOutputStream output;
    private final ScipSemanticdbOptions options;
    private final AtomicInteger id = new AtomicInteger();

    public ScipWriter(ScipSemanticdbOptions scipSemanticdbOptions) throws IOException {
        this.tmp = OperatingSystem.isWindows() ? Files.createTempFile("scip-semanticdb", "index.scip", new FileAttribute[0]) : Files.createTempFile("scip-semanticdb", "index.scip", PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-r--r--")));
        this.output = new ScipOutputStream(scipSemanticdbOptions, new BufferedOutputStream(Files.newOutputStream(this.tmp, new OpenOption[0])));
        this.options = scipSemanticdbOptions;
    }

    public void emitTyped(Scip.Index index) {
        this.output.write(index.toByteArray());
    }

    public void emitMetaData() {
        this.emitObject(this.scipVertex("metaData").setVersion("0.4.3").setProjectRoot(this.options.sourceroot.toUri().toString()).setPositionEncoding("utf-16").setToolInfo(this.options.toolInfo));
    }

    public int emitProject(String string) {
        return this.emitObject(this.scipVertex("project").setKind(string));
    }

    public int emitDocument(ScipTextDocument scipTextDocument) {
        return this.emitObject(this.scipVertex("document").setUri(scipTextDocument.semanticdb.getUri()).setLanguage(scipTextDocument.semanticdb.getLanguage().toString().toLowerCase()));
    }

    public void emitContains(int n, List<Integer> list) {
        this.emitObject(this.scipEdge("contains").setOutV(n).addAllInVs(list));
    }

    public int emitRange(Semanticdb.Range range) {
        return this.emitObject(this.scipVertex("range").setStart(LsifPosition.newBuilder().setLine(range.getStartLine()).setCharacter(range.getStartCharacter())).setEnd(LsifPosition.newBuilder().setLine(range.getEndLine()).setCharacter(range.getEndCharacter())));
    }

    public int emitResultSet() {
        return this.emitObject(this.scipVertex("resultSet"));
    }

    public void emitNext(int n, int n2) {
        this.emitObject(this.scipEdge("next").setOutV(n).setInV(n2));
    }

    public void emitEdge(String string, int n, int n2) {
        this.emitObject(this.scipEdge(string).setOutV(n).setInV(n2));
    }

    public int emitReferenceResult(int n) {
        int n2 = this.emitObject(this.scipVertex("referenceResult"));
        this.emitEdge("textDocument/references", n, n2);
        return n2;
    }

    public int emitDefinitionResult(int n) {
        int n2 = this.emitObject(this.scipVertex("definitionResult"));
        this.emitEdge("textDocument/definition", n, n2);
        return n2;
    }

    public int emitHoverResult(MarkupContent markupContent) {
        return this.emitObject(this.scipVertex("hoverResult").setResult(LsifHover.newBuilder().setContents(LsifHover.Content.newBuilder().setKind(markupContent.kind.toString().toLowerCase()).setValue(markupContent.value))));
    }

    public void emitHoverEdge(int n, int n2) {
        this.emitObject(this.scipEdge("textDocument/hover").setOutV(n).setInV(n2));
    }

    public void emitMonikerEdge(int n, int n2) {
        this.emitObject(this.scipEdge("moniker").setOutV(n).setInV(n2));
    }

    public int emitMonikerVertex(String string, boolean bl) {
        String string2 = SemanticdbSymbols.isLocal((String)string) ? "local" : (bl ? "export" : "import");
        return this.emitObject(this.scipVertex("moniker").setKind(string2).setScheme("semanticdb").setIdentifier(string));
    }

    public void emitPackageInformationEdge(int n, int n2) {
        this.emitObject(this.scipEdge("packageInformation").setOutV(n).setInV(n2));
    }

    public int emitpackageinformationVertex(Package package_) {
        return this.emitObject(this.scipVertex("packageInformation").setName(package_.repoName()).setManager("jvm-dependencies").setVersion(package_.version()));
    }

    public void emitItem(int n, int n2, int n3) {
        this.emitObject(this.scipEdge("item").setOutV(n).addInVs(n2).setDocument(n3));
    }

    public void emitReferenceResultsItemEdge(int n, Iterable<Integer> iterable, int n2) {
        this.emitObject(this.scipEdge("item").setOutV(n).addAllInVs(iterable).setDocument(n2).setProperty("referenceResults"));
    }

    public void build() throws IOException {
        this.close();
        Files.move(this.tmp, this.options.output, StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public void close() throws IOException {
        this.output.flush();
    }

    public void flush() {
        try {
            this.output.flush();
        }
        catch (IOException iOException) {
            this.options.reporter.error(iOException);
        }
    }

    public int emitObject(LsifObject.Builder builder) {
        this.output.writeLsifObject(builder);
        return builder.getId();
    }

    private LsifObject.Builder scipObject() {
        return LsifObject.newBuilder().setId(this.nextId());
    }

    private LsifObject.Builder scipEdge(String string) {
        return this.scipObject().setType("edge").setLabel(string);
    }

    private LsifObject.Builder scipVertex(String string) {
        return this.scipObject().setType("vertex").setLabel(string);
    }

    private int nextId() {
        return this.id.incrementAndGet();
    }
}

