/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.semanticdb_javac;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.instrument.Instrumentation;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatchers;

public class SemanticdbAgent {
    public static void premain(String string, Instrumentation instrumentation) {
        new AgentBuilder.Default().disableClassFormatChanges().type(ElementMatchers.named("org.gradle.api.internal.tasks.compile.DefaultJvmLanguageCompileSpec").or(ElementMatchers.named("tests.GradleDefaultJvmLanguageCompileSpec"))).transform(new AgentBuilder.Transformer.ForAdvice().advice(ElementMatchers.named("getCompileClasspath"), DefaultJvmLanguageCompileSpecAdvice.class.getName())).installOn(instrumentation);
        new AgentBuilder.Default().disableClassFormatChanges().type(ElementMatchers.named("org.gradle.api.internal.tasks.compile.DefaultJavaCompileSpec").or(ElementMatchers.named("tests.GradleDefaultJavaCompileSpec"))).transform(new AgentBuilder.Transformer.ForAdvice().advice(ElementMatchers.named("getAnnotationProcessorPath"), DefaultJavaCompileSpecAdvice.class.getName())).installOn(instrumentation);
        new AgentBuilder.Default().type(ElementMatchers.named("org.gradle.api.internal.tasks.compile.JavaCompilerArgumentsBuilder").or(ElementMatchers.named("tests.GradleJavaCompilerArgumentsBuilder"))).transform(new AgentBuilder.Transformer.ForAdvice().advice(ElementMatchers.named("build"), JavaCompilerArgumentsBuilderAdvice.class.getName())).installOn(instrumentation);
    }

    private static PrintStream newLogger() {
        Path path = Paths.get(System.getProperty("user.home"), ".scip-java", "logs.txt");
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            OutputStream outputStream = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            return new PrintStream(outputStream);
        }
        catch (IOException iOException) {
            return new PrintStream(new OutputStream(){

                @Override
                public void write(int n) {
                }
            });
        }
    }

    public static class JavaCompilerArgumentsBuilderAdvice {
        @Advice.OnMethodExit
        public static void build(@Advice.Return(readOnly=false, typing=Assigner.Typing.DYNAMIC) List<String> list) {
            String string = System.getProperty("semanticdb.pluginpath");
            if (string == null) {
                throw new NoSuchElementException("-Dsemanticdb.pluginpath");
            }
            String string2 = System.getProperty("semanticdb.sourceroot");
            if (string2 == null) {
                throw new NoSuchElementException("-Dsemanticdb.sourceroot");
            }
            String string3 = System.getProperty("semanticdb.targetroot");
            if (string3 == null) {
                throw new NoSuchElementException("-Dsemanticdb.targetroot");
            }
            String string4 = System.getProperty("semanticdb.debugpath");
            String string5 = System.getProperty("semanticdb.javacopts");
            if (string5 != null) {
                try {
                    Files.write(Paths.get(string5, new String[0]), list, StandardCharsets.UTF_8, StandardOpenOption.APPEND, StandardOpenOption.CREATE);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            boolean bl = false;
            String string6 = "";
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string7 : list) {
                switch (string6) {
                    case "-processorpath": 
                    case "-processor-path": 
                    case "-cp": 
                    case "-classpath": 
                    case "-class-path": {
                        bl = true;
                        arrayList.add(string + File.pathSeparator + string7);
                        break;
                    }
                    case "-Xlint": {
                        break;
                    }
                    default: {
                        if (string7.startsWith("-Xplugin:ErrorProne")) break;
                        arrayList.add(string7);
                    }
                }
                string6 = string7;
            }
            if (!bl) {
                arrayList.add("-classpath");
                arrayList.add(string);
            }
            arrayList.add(String.format("-Xplugin:semanticdb -sourceroot:%s -targetroot:%s", string2, string3));
            if (string4 != null) {
                ArrayList arrayList2 = new ArrayList();
                arrayList2.add("============== Java Home: " + System.getProperty("java.home"));
                arrayList2.add("============== Old Options");
                arrayList2.addAll(list);
                arrayList2.add("============== New Options");
                arrayList2.addAll(arrayList);
                try {
                    Files.write(Paths.get(string4, new String[0]), (Iterable<? extends CharSequence>)arrayList2, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            list = arrayList;
        }
    }

    public static class DefaultJavaCompileSpecAdvice {
        @Advice.OnMethodExit
        public static void getAnnotationProcessorPath(@Advice.Return(readOnly=false, typing=Assigner.Typing.DYNAMIC) List<File> list) {
            if (list == null) {
                return;
            }
            String string = System.getProperty("semanticdb.pluginpath");
            if (string == null) {
                throw new NoSuchElementException("-Dsemanticdb.pluginpath");
            }
            File file = new File(string);
            if (!list.contains(file)) {
                ArrayList<File> arrayList = new ArrayList<File>(list);
                arrayList.add(file);
                list = arrayList;
            }
        }
    }

    public static class DefaultJvmLanguageCompileSpecAdvice {
        @Advice.OnMethodExit
        public static void getClasspath(@Advice.Return(readOnly=false, typing=Assigner.Typing.DYNAMIC) List<File> list) {
            String string = System.getProperty("semanticdb.pluginpath");
            if (string == null) {
                throw new NoSuchElementException("-Dsemanticdb.pluginpath");
            }
            File file = new File(string);
            if (!list.contains(file)) {
                ArrayList<File> arrayList = new ArrayList<File>(list);
                arrayList.add(file);
                list = arrayList;
            }
        }
    }
}

