/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac;

import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.GlobalSymbolsCache;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.LocalSymbolsCache;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.Semanticdb;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.SemanticdbBuilders;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.SemanticdbTypeVisitor;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Types;

public final class SemanticdbSignatures {
    private final GlobalSymbolsCache cache;
    private final LocalSymbolsCache locals;
    private final Types types;

    public SemanticdbSignatures(GlobalSymbolsCache cache, LocalSymbolsCache locals, Types types) {
        this.cache = cache;
        this.locals = locals;
        this.types = types;
    }

    public Semanticdb.Signature generateSignature(Element sym) {
        if (sym instanceof TypeElement) {
            return this.generateClassSignature((TypeElement)sym);
        }
        if (sym instanceof ExecutableElement) {
            return this.generateMethodSignature((ExecutableElement)sym);
        }
        if (sym instanceof VariableElement) {
            return this.generateFieldSignature((VariableElement)sym);
        }
        if (sym instanceof TypeParameterElement) {
            return this.generateTypeSignature((TypeParameterElement)sym);
        }
        return null;
    }

    private Semanticdb.Signature generateClassSignature(TypeElement sym) {
        Semanticdb.ClassSignature.Builder builder = Semanticdb.ClassSignature.newBuilder();
        builder.setTypeParameters(this.generateScope(sym.getTypeParameters()));
        for (TypeMirror typeMirror : this.types.directSupertypes(sym.asType())) {
            Semanticdb.Type semanticdbType = this.generateType(typeMirror);
            if (semanticdbType == null) {
                semanticdbType = SemanticdbTypeVisitor.UNRESOLVED_TYPE_REF;
            }
            builder.addParents(semanticdbType);
        }
        builder.setDeclarations(this.generateScope(sym.getEnclosedElements()));
        return SemanticdbBuilders.signature(builder);
    }

    private Semanticdb.Signature generateMethodSignature(ExecutableElement sym) {
        Semanticdb.MethodSignature.Builder builder = Semanticdb.MethodSignature.newBuilder();
        builder.setTypeParameters(this.generateScope(sym.getTypeParameters()));
        builder.addParameterLists(this.generateScope(sym.getParameters()));
        Semanticdb.Type returnType = this.generateType(sym.getReturnType());
        if (returnType != null) {
            builder.setReturnType(returnType);
        }
        List thrownTypes = sym.getThrownTypes().stream().map(this::generateType).collect(Collectors.toList());
        builder.addAllThrows(thrownTypes);
        return SemanticdbBuilders.signature(builder);
    }

    private Semanticdb.Signature generateFieldSignature(VariableElement sym) {
        Semanticdb.Type generateType = this.generateType(sym.asType());
        if (generateType == null) {
            generateType = SemanticdbTypeVisitor.UNRESOLVED_TYPE_REF;
        }
        return SemanticdbBuilders.signature(Semanticdb.ValueSignature.newBuilder().setTpe(generateType));
    }

    private Semanticdb.Signature generateTypeSignature(TypeParameterElement sym) {
        TypeMirror varType;
        Semanticdb.TypeSignature.Builder builder = Semanticdb.TypeSignature.newBuilder();
        if (sym instanceof TypeElement) {
            builder.setTypeParameters(this.generateScope(((TypeElement)((Object)sym)).getTypeParameters()));
        }
        if ((varType = sym.asType()) instanceof TypeVariable) {
            Semanticdb.Type upperBound = this.generateType(((TypeVariable)varType).getUpperBound());
            if (upperBound != null) {
                builder.setUpperBound(upperBound);
            } else {
                builder.setUpperBound(SemanticdbTypeVisitor.UNRESOLVED_TYPE_REF);
            }
        } else {
            builder.setUpperBound(SemanticdbTypeVisitor.UNRESOLVED_TYPE_REF);
        }
        return SemanticdbBuilders.signature(builder);
    }

    private Semanticdb.Scope generateScope(List<? extends Element> elements) {
        Semanticdb.Scope.Builder scope = Semanticdb.Scope.newBuilder();
        for (Element element : elements) {
            scope.addSymlinks(this.cache.semanticdbSymbol(element, this.locals));
        }
        return scope.build();
    }

    private Semanticdb.Type generateType(TypeMirror mirror) {
        return new SemanticdbTypeVisitor(this.cache, this.locals, this.types).semanticdbType(mirror);
    }
}

