/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac;

import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.GlobalSymbolsCache;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.LocalSymbolsCache;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.Semanticdb;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.SemanticdbBuilders;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.SemanticdbTypeVisitor;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public class SemanticdbTrees {
    private final GlobalSymbolsCache globals;
    private final LocalSymbolsCache locals;
    private final String semanticdbUri;
    private final Types types;
    private final Trees trees;
    private final HashMap<Tree, TreePath> nodes;
    private final SemanticdbTypeVisitor typeVisitor;

    public SemanticdbTrees(GlobalSymbolsCache globals, LocalSymbolsCache locals, String semanticdbUri, Types types, Trees trees, HashMap<Tree, TreePath> nodes) {
        this.globals = globals;
        this.locals = locals;
        this.semanticdbUri = semanticdbUri;
        this.types = types;
        this.trees = trees;
        this.nodes = nodes;
        this.typeVisitor = new SemanticdbTypeVisitor(globals, locals, types);
    }

    public List<Semanticdb.AnnotationTree> annotations(Tree node) {
        if (!(node instanceof ClassTree || node instanceof MethodTree || node instanceof VariableTree)) {
            return null;
        }
        ArrayList<Semanticdb.AnnotationTree> annotations = new ArrayList<Semanticdb.AnnotationTree>();
        ModifiersTree mods = node instanceof ClassTree ? ((ClassTree)node).getModifiers() : (node instanceof MethodTree ? ((MethodTree)node).getModifiers() : ((VariableTree)node).getModifiers());
        for (AnnotationTree annotationTree : mods.getAnnotations()) {
            annotations.add(this.annotationBuilder(annotationTree));
        }
        return annotations;
    }

    public Semanticdb.AnnotationTree annotationBuilder(AnnotationTree annotation) {
        ArrayList<Semanticdb.Tree> params = new ArrayList<Semanticdb.Tree>(annotation.getArguments().size());
        for (ExpressionTree expressionTree : annotation.getArguments()) {
            if (expressionTree instanceof AssignmentTree) {
                AssignmentTree assign = (AssignmentTree)expressionTree;
                ExpressionTree assignValue = assign.getExpression();
                TreePath variableTreePath = this.nodes.get(assign.getVariable());
                if (variableTreePath == null) continue;
                Element variableSym = this.trees.getElement(variableTreePath);
                String symbol = this.globals.semanticdbSymbol(variableSym, this.locals);
                params.add(SemanticdbBuilders.tree(SemanticdbBuilders.assignTree(SemanticdbBuilders.tree(SemanticdbBuilders.idTree(symbol)), this.annotationParameter(assignValue))));
                continue;
            }
            params.add(this.annotationParameter(expressionTree));
        }
        TreePath annotationTreePath = this.nodes.get(annotation);
        Element element = this.trees.getElement(annotationTreePath);
        Semanticdb.Type type = this.typeVisitor.semanticdbType(element.asType());
        return SemanticdbBuilders.annotationTree(type, params);
    }

    private TypeMirror getTreeType(Tree tree) {
        TreePath path = this.nodes.get(tree);
        return this.trees.getTypeMirror(path);
    }

    private Semanticdb.Tree annotationParameter(ExpressionTree expr) {
        if (expr instanceof MemberSelectTree) {
            TreePath expressionTreePath = this.nodes.get(expr);
            Element expressionSym = this.trees.getElement(expressionTreePath);
            return SemanticdbBuilders.tree(SemanticdbBuilders.selectTree(SemanticdbBuilders.tree(SemanticdbBuilders.idTree(this.globals.semanticdbSymbol(expressionSym.getEnclosingElement(), this.locals))), SemanticdbBuilders.idTree(this.globals.semanticdbSymbol(expressionSym, this.locals))));
        }
        if (expr instanceof NewArrayTree) {
            NewArrayTree rhs = (NewArrayTree)expr;
            return SemanticdbBuilders.tree(SemanticdbBuilders.applyTree(SemanticdbBuilders.tree(SemanticdbBuilders.idTree("scala/Array#")), rhs.getInitializers().stream().map(this::annotationParameter).collect(Collectors.toList())));
        }
        if (expr instanceof LiteralTree) {
            Semanticdb.Constant constant;
            Object value = ((LiteralTree)expr).getValue();
            if (value == null) {
                constant = SemanticdbBuilders.nullConst();
            } else if (value instanceof String) {
                constant = SemanticdbBuilders.stringConst((String)value);
            } else if (value instanceof Boolean) {
                constant = SemanticdbBuilders.booleanConst((Boolean)value);
            } else if (value instanceof Byte) {
                constant = SemanticdbBuilders.byteConst((Byte)value);
            } else if (value instanceof Short) {
                constant = SemanticdbBuilders.shortConst((Short)value);
            } else if (value instanceof Integer) {
                constant = SemanticdbBuilders.intConst((Integer)value);
            } else if (value instanceof Long) {
                constant = SemanticdbBuilders.longConst((Long)value);
            } else if (value instanceof Character) {
                constant = SemanticdbBuilders.charConst((Character)value);
            } else if (value instanceof Float) {
                constant = SemanticdbBuilders.floatConst((Float)value);
            } else if (value instanceof Double) {
                constant = SemanticdbBuilders.doubleConst((Double)value);
            } else {
                throw new IllegalStateException(this.semanticdbUri + ": annotation parameter rhs was of unexpected class type " + value.getClass() + "\n" + value);
            }
            return SemanticdbBuilders.tree(SemanticdbBuilders.literalTree(constant));
        }
        if (expr instanceof AnnotationTree) {
            return SemanticdbBuilders.tree(this.annotationBuilder((AnnotationTree)expr));
        }
        if (expr instanceof IdentifierTree) {
            TreePath expressionTreePath = this.nodes.get(expr);
            Element expressionSym = this.trees.getElement(expressionTreePath);
            return SemanticdbBuilders.tree(SemanticdbBuilders.idTree(this.globals.semanticdbSymbol(expressionSym, this.locals)));
        }
        if (expr instanceof BinaryTree) {
            BinaryTree binExpr = (BinaryTree)expr;
            return SemanticdbBuilders.tree(SemanticdbBuilders.binopTree(this.annotationParameter(binExpr.getLeftOperand()), this.semanticdbBinaryOperator(expr.getKind()), this.annotationParameter(binExpr.getRightOperand())));
        }
        if (expr instanceof UnaryTree) {
            UnaryTree unaryExpr = (UnaryTree)expr;
            return SemanticdbBuilders.tree(SemanticdbBuilders.unaryOpTree(this.semanticdbUnaryOperator(unaryExpr.getKind()), this.annotationParameter(unaryExpr.getExpression())));
        }
        if (expr instanceof ParenthesizedTree) {
            ParenthesizedTree parenExpr = (ParenthesizedTree)expr;
            return this.annotationParameter(parenExpr.getExpression());
        }
        if (expr instanceof TypeCastTree) {
            TypeCastTree tree = (TypeCastTree)expr;
            return SemanticdbBuilders.tree(SemanticdbBuilders.castTree(this.typeVisitor.semanticdbType(this.getTreeType(tree.getType())), this.annotationParameter(tree.getExpression())));
        }
        throw new IllegalArgumentException(this.semanticdbUri + ": annotation parameter rhs was of unexpected tree node type " + expr.getClass() + "\n" + expr);
    }

    private Semanticdb.BinaryOperator semanticdbBinaryOperator(Tree.Kind kind) {
        switch (kind) {
            case PLUS: {
                return Semanticdb.BinaryOperator.PLUS;
            }
            case MINUS: {
                return Semanticdb.BinaryOperator.MINUS;
            }
            case MULTIPLY: {
                return Semanticdb.BinaryOperator.MULTIPLY;
            }
            case DIVIDE: {
                return Semanticdb.BinaryOperator.DIVIDE;
            }
            case REMAINDER: {
                return Semanticdb.BinaryOperator.REMAINDER;
            }
            case LESS_THAN: {
                return Semanticdb.BinaryOperator.LESS_THAN;
            }
            case GREATER_THAN: {
                return Semanticdb.BinaryOperator.GREATER_THAN;
            }
            case LEFT_SHIFT: {
                return Semanticdb.BinaryOperator.SHIFT_LEFT;
            }
            case RIGHT_SHIFT: {
                return Semanticdb.BinaryOperator.SHIFT_RIGHT;
            }
            case UNSIGNED_RIGHT_SHIFT: {
                return Semanticdb.BinaryOperator.SHIFT_RIGHT_UNSIGNED;
            }
            case EQUAL_TO: {
                return Semanticdb.BinaryOperator.EQUAL_TO;
            }
            case NOT_EQUAL_TO: {
                return Semanticdb.BinaryOperator.NOT_EQUAL_TO;
            }
            case LESS_THAN_EQUAL: {
                return Semanticdb.BinaryOperator.LESS_THAN_EQUAL;
            }
            case GREATER_THAN_EQUAL: {
                return Semanticdb.BinaryOperator.GREATER_THAN_EQUAL;
            }
            case CONDITIONAL_AND: {
                return Semanticdb.BinaryOperator.CONDITIONAL_AND;
            }
            case CONDITIONAL_OR: {
                return Semanticdb.BinaryOperator.CONDITIONAL_OR;
            }
            case AND: {
                return Semanticdb.BinaryOperator.AND;
            }
            case OR: {
                return Semanticdb.BinaryOperator.OR;
            }
            case XOR: {
                return Semanticdb.BinaryOperator.XOR;
            }
        }
        throw new IllegalStateException(this.semanticdbUri + ": unexpected binary expression operator kind " + (Object)((Object)kind));
    }

    private Semanticdb.UnaryOperator semanticdbUnaryOperator(Tree.Kind kind) {
        switch (kind) {
            case UNARY_MINUS: {
                return Semanticdb.UnaryOperator.UNARY_MINUS;
            }
            case UNARY_PLUS: {
                return Semanticdb.UnaryOperator.UNARY_PLUS;
            }
            case POSTFIX_INCREMENT: {
                return Semanticdb.UnaryOperator.UNARY_POSTFIX_INCREMENT;
            }
            case POSTFIX_DECREMENT: {
                return Semanticdb.UnaryOperator.UNARY_POSTFIX_DECREMENT;
            }
            case PREFIX_INCREMENT: {
                return Semanticdb.UnaryOperator.UNARY_PREFIX_INCREMENT;
            }
            case PREFIX_DECREMENT: {
                return Semanticdb.UnaryOperator.UNARY_PREFIX_DECREMENT;
            }
            case BITWISE_COMPLEMENT: {
                return Semanticdb.UnaryOperator.UNARY_BITWISE_COMPLEMENT;
            }
            case LOGICAL_COMPLEMENT: {
                return Semanticdb.UnaryOperator.UNARY_LOGICAL_COMPLEMENT;
            }
        }
        throw new IllegalStateException(this.semanticdbUri + ": unexpected unary expression operator kind " + (Object)((Object)kind));
    }
}

