/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac;

import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.CompilationUnitException;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.GlobalSymbolsCache;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.NoRelativePathMode;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.Result;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.Semanticdb;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.SemanticdbJavacOptions;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.SemanticdbReporter;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.SemanticdbVisitor;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.UriScheme;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.Trees;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;

public final class SemanticdbTaskListener
implements TaskListener {
    private final SemanticdbJavacOptions options;
    private final GlobalSymbolsCache globals;
    private final SemanticdbReporter reporter;
    private final Types types;
    private final Trees trees;
    private final Elements elements;
    private int noRelativePathCounter = 0;

    public SemanticdbTaskListener(SemanticdbJavacOptions options, JavacTask task, Trees trees, GlobalSymbolsCache globals, SemanticdbReporter reporter) {
        this.options = options;
        this.globals = globals;
        this.reporter = reporter;
        this.types = task.getTypes();
        this.trees = trees;
        this.elements = task.getElements();
    }

    @Override
    public void started(TaskEvent e) {
        if (e.getKind() == TaskEvent.Kind.ENTER) {
            this.inferBazelSourceroot(e.getSourceFile());
            Result<Path, String> semanticdbPath = this.semanticdbOutputPath(this.options, e);
            if (semanticdbPath.isOk()) {
                try {
                    Files.deleteIfExists(semanticdbPath.getOrThrow());
                }
                catch (IOException ex) {
                    this.reportException(ex, e);
                }
            }
        }
    }

    @Override
    public void finished(TaskEvent e) {
        if (e.getKind() != TaskEvent.Kind.ANALYZE) {
            return;
        }
        if (!this.options.errors.isEmpty()) {
            if (!this.options.alreadyReportedErrors) {
                this.options.alreadyReportedErrors = true;
                for (String error : this.options.errors) {
                    this.reporter.error(error, e);
                }
            }
            return;
        }
        this.inferBazelSourceroot(e.getSourceFile());
        try {
            this.onFinishedAnalyze(e);
        }
        catch (Throwable ex) {
            Throwable throwable = ex;
            if (e.getSourceFile() != null) {
                throwable = new CompilationUnitException(String.valueOf(e.getSourceFile().toUri().toString()), throwable);
            }
            this.reportException(throwable, e);
        }
    }

    private void reportException(Throwable exception, TaskEvent e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        exception.printStackTrace(pw);
        pw.close();
        this.reporter.error(baos.toString(), e.getCompilationUnit(), e.getCompilationUnit());
    }

    private void onFinishedAnalyze(TaskEvent e) {
        Result<Path, String> path = this.semanticdbOutputPath(this.options, e);
        if (path != null) {
            if (path.isOk()) {
                Semanticdb.TextDocument textDocument = new SemanticdbVisitor(this.globals, e.getCompilationUnit(), this.options, this.types, this.trees, this.elements).buildTextDocument(e.getCompilationUnit());
                Path output = path.getOrThrow();
                if (Files.exists(output, new LinkOption[0])) {
                    this.appendSemanticdb(e, output, textDocument);
                } else {
                    this.writeSemanticdb(e, output, textDocument);
                }
            } else {
                this.reporter.error(path.getErrorOrThrow(), e);
            }
        }
    }

    private void writeSemanticdb(TaskEvent event, Path output, Semanticdb.TextDocument textDocument) {
        try {
            byte[] bytes = Semanticdb.TextDocuments.newBuilder().addDocuments(textDocument).build().toByteArray();
            Files.createDirectories(output.getParent(), new FileAttribute[0]);
            Files.write(output, bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            this.reportException(e, event);
        }
    }

    private void appendSemanticdb(TaskEvent event, Path output, Semanticdb.TextDocument textDocument) {
        Semanticdb.TextDocument document = null;
        int documentIndex = -1;
        Semanticdb.TextDocuments documents = null;
        try (InputStream is = Files.newInputStream(output.toFile().toPath(), new OpenOption[0]);){
            documents = Semanticdb.TextDocuments.parseFrom(is);
            for (int i = 0; i < documents.getDocumentsCount(); ++i) {
                Semanticdb.TextDocument candidate = documents.getDocuments(i);
                if (document != null || !candidate.getUri().equals(textDocument.getUri())) continue;
                document = candidate;
                documentIndex = i;
            }
        }
        catch (IOException e) {
            this.reportException(e, event);
            return;
        }
        if (document != null) {
            HashSet<Semanticdb.SymbolInformation> symbols = new HashSet<Semanticdb.SymbolInformation>(textDocument.getSymbolsList());
            HashSet<Semanticdb.SymbolOccurrence> occurrences = new HashSet<Semanticdb.SymbolOccurrence>(textDocument.getOccurrencesList());
            HashSet<Semanticdb.Synthetic> synthetics = new HashSet<Semanticdb.Synthetic>(textDocument.getSyntheticsList());
            symbols.addAll(document.getSymbolsList());
            occurrences.addAll(document.getOccurrencesList());
            synthetics.addAll(document.getSyntheticsList());
            documents.toBuilder().addDocuments(documentIndex, document.toBuilder().clearOccurrences().addAllOccurrences(occurrences).clearSymbols().addAllSymbols(symbols).clearSynthetics().addAllSynthetics(synthetics));
        } else {
            documents = documents.toBuilder().addDocuments(textDocument).build();
        }
        byte[] bytes = documents.toByteArray();
        try {
            Files.createDirectories(output.getParent(), new FileAttribute[0]);
            Files.write(output, bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            this.reportException(e, event);
        }
    }

    public static Path absolutePathFromUri(SemanticdbJavacOptions options, JavaFileObject file) {
        URI uri = file.toUri();
        if ((options.uriScheme == UriScheme.SBT || options.uriScheme == UriScheme.ZINC) && uri.getScheme().equals("vf") && uri.toString().startsWith("vf://tmp/")) {
            String[] parts = uri.toString().split("/", 5);
            if (parts.length == 5) {
                return options.sourceroot.resolve(Paths.get(parts[4], new String[0]));
            }
            throw new IllegalArgumentException("unsupported URI: " + uri);
        }
        if (options.uriScheme == UriScheme.BAZEL) {
            String[] knownBazelToStringPatterns;
            String toString = file.toString().replace(":", "/");
            for (String pattern : knownBazelToStringPatterns = new String[]{"SimpleFileObject[", "DirectoryFileObject["}) {
                if (!toString.startsWith(pattern) || !toString.endsWith("]")) continue;
                Path path = Paths.get(toString.substring(pattern.length(), toString.length() - 1), new String[0]);
                if (path.isAbsolute()) {
                    return path;
                }
                return options.sourceroot.resolve(path);
            }
        }
        return Paths.get(uri);
    }

    private void inferBazelSourceroot(JavaFileObject file) {
        String pathName;
        String uriName;
        int relativePathDepth;
        if (this.options.uriScheme != UriScheme.BAZEL || this.options.sourceroot != null) {
            return;
        }
        Path absolutePath = SemanticdbTaskListener.absolutePathFromUri(this.options, file);
        Path uriPath = Paths.get(file.toUri());
        int uriPathDepth = uriPath.getNameCount();
        int absolutePathDepth = absolutePath.getNameCount();
        for (relativePathDepth = 0; relativePathDepth < uriPathDepth && relativePathDepth < absolutePathDepth && (uriName = uriPath.getName(uriPathDepth - relativePathDepth - 1).toString()).equals(pathName = absolutePath.getName(absolutePathDepth - relativePathDepth - 1).toString()); ++relativePathDepth) {
        }
        this.options.sourceroot = absolutePath.getRoot().resolve(absolutePath.subpath(0, absolutePathDepth - relativePathDepth));
    }

    private Result<Path, String> semanticdbOutputPath(SemanticdbJavacOptions options, TaskEvent e) {
        Path absolutePath = SemanticdbTaskListener.absolutePathFromUri(options, e.getSourceFile());
        if (absolutePath.startsWith(options.sourceroot)) {
            Path relativePath = options.sourceroot.relativize(absolutePath);
            String filename = relativePath.getFileName().toString() + ".semanticdb";
            Path semanticdbOutputPath = options.targetroot.resolve("META-INF").resolve("semanticdb").resolve(relativePath).resolveSibling(filename);
            return Result.ok(semanticdbOutputPath);
        }
        switch (options.noRelativePath) {
            case INDEX_ANYWAY: {
                String uniqueFilename = String.format("%d.%s.semanticdb", ++this.noRelativePathCounter, absolutePath.getFileName());
                Path semanticdbOutputPath = options.targetroot.resolve("META-INF").resolve("semanticdb").resolve("no-relative-path").resolve(uniqueFilename);
                return Result.ok(semanticdbOutputPath);
            }
            case WARNING: {
                this.reporter.info(String.format("Skipping file '%s' because it is not under the sourceroot '%s'", absolutePath, options.sourceroot), e);
            }
            case SKIP: {
                return null;
            }
        }
        String baseMessage = String.format("Unable to detect the relative path of '%s'. A common reason for this error is that the file is that this file is auto-generated. To fix this problem update the flag -no-relative-path:VALUE to have one of the following values: %s.", absolutePath, NoRelativePathMode.validStringValuesWithoutError());
        if (options.uriScheme == UriScheme.BAZEL) {
            return Result.error(baseMessage);
        }
        return Result.error(baseMessage + " Alternatively, configure the -sourceroot:PATH flag to point to a directory path that is the parent of all indexed files.");
    }
}

