/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac;

import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.Debugging;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.LocalSymbolsCache;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.SemanticdbJavacOptions;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.SemanticdbSymbols;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.NoType;

public final class GlobalSymbolsCache {
    private final IdentityHashMap<Element, String> globals = new IdentityHashMap();
    private final SemanticdbJavacOptions options;

    public GlobalSymbolsCache(SemanticdbJavacOptions options) {
        this.options = options;
    }

    public String semanticdbSymbol(Element sym, LocalSymbolsCache locals) {
        String result = this.globals.get(sym);
        if (result != null) {
            return result;
        }
        String localResult = locals.get(sym);
        if (localResult != null) {
            return localResult;
        }
        result = this.uncachedSemanticdbSymbol(sym, locals);
        if (SemanticdbSymbols.isGlobal(result)) {
            this.globals.put(sym, result);
        }
        return result;
    }

    public boolean isNone(Element sym) {
        return sym == null;
    }

    private String uncachedSemanticdbSymbol(Element sym, LocalSymbolsCache locals) {
        if (this.isNone(sym)) {
            return SemanticdbSymbols.ROOT_PACKAGE;
        }
        if (sym instanceof PackageElement) {
            if (((PackageElement)sym).isUnnamed()) {
                return SemanticdbSymbols.ROOT_PACKAGE;
            }
            StringBuilder sb = new StringBuilder();
            String qualifiedName = ((PackageElement)sym).getQualifiedName().toString();
            int i = 0;
            int j = 0;
            while (j < qualifiedName.length()) {
                if (i == qualifiedName.length() || qualifiedName.charAt(i) == '.') {
                    String name = qualifiedName.substring(j, i);
                    SemanticdbSymbols.Descriptor desc = new SemanticdbSymbols.Descriptor(SemanticdbSymbols.Descriptor.Kind.Package, name);
                    sb.append(desc.encode());
                    j = i + 1;
                }
                ++i;
            }
            return sb.toString();
        }
        if (sym.asType() instanceof NoType) {
            return SemanticdbSymbols.ROOT_PACKAGE;
        }
        if (this.isAnonymousClass(sym) || this.isLocalVariable(sym)) {
            return locals.put(sym);
        }
        String owner = this.semanticdbSymbol(sym.getEnclosingElement(), locals);
        if (SemanticdbSymbols.isLocal(owner)) {
            return locals.put(sym);
        }
        SemanticdbSymbols.Descriptor desc = this.semanticdbDescriptor(sym);
        if (this.options.verboseEnabled && desc.kind == SemanticdbSymbols.Descriptor.Kind.None) {
            if (sym instanceof QualifiedNameable) {
                Debugging.pprint(((QualifiedNameable)sym).getQualifiedName().toString());
            } else {
                Debugging.pprint(sym.getSimpleName().toString());
            }
            Debugging.pprint(String.format("sym: %s (%s - superclass %s)", sym, sym.getClass(), sym.getClass().getSuperclass()));
        }
        return SemanticdbSymbols.global(owner, desc);
    }

    private boolean isLocalVariable(Element sym) {
        switch (sym.getKind()) {
            case PARAMETER: 
            case EXCEPTION_PARAMETER: 
            case LOCAL_VARIABLE: {
                return true;
            }
        }
        return false;
    }

    private boolean isAnonymousClass(Element sym) {
        return sym instanceof TypeElement && sym.getSimpleName().length() == 0;
    }

    private SemanticdbSymbols.Descriptor semanticdbDescriptor(Element sym) {
        if (sym instanceof TypeElement) {
            return new SemanticdbSymbols.Descriptor(SemanticdbSymbols.Descriptor.Kind.Type, sym.getSimpleName().toString());
        }
        if (sym instanceof ExecutableElement) {
            return new SemanticdbSymbols.Descriptor(SemanticdbSymbols.Descriptor.Kind.Method, sym.getSimpleName().toString(), this.methodDisambiguator((ExecutableElement)sym));
        }
        if (sym instanceof TypeParameterElement) {
            return new SemanticdbSymbols.Descriptor(SemanticdbSymbols.Descriptor.Kind.TypeParameter, sym.getSimpleName().toString());
        }
        if (sym instanceof VariableElement) {
            return new SemanticdbSymbols.Descriptor(SemanticdbSymbols.Descriptor.Kind.Term, sym.getSimpleName().toString());
        }
        return SemanticdbSymbols.Descriptor.NONE;
    }

    private String methodDisambiguator(ExecutableElement sym) {
        List<? extends Element> elements = sym.getEnclosingElement().getEnclosedElements();
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        for (Element element : elements) {
            if (!(element instanceof ExecutableElement) || element.getSimpleName() != sym.getSimpleName()) continue;
            methods.add((ExecutableElement)element);
        }
        methods.sort((a, b) -> Boolean.compare(a.getReceiverType() == null, b.getReceiverType() == null));
        int index = methods.indexOf(sym);
        if (index == 0) {
            return "()";
        }
        return String.format("(+%d)", index);
    }
}

