/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;

public class SemanticdbOptionBuilder {
    private String previousArg = "";
    private final ArrayList<String> oldArgs = new ArrayList();
    private final ArrayList<String> result = new ArrayList();
    private boolean isClasspathUpdated = false;
    public static final String ERRORPATH = System.getProperty("semanticdb.errorpath", "");
    private static final String PLUGINPATH = System.getProperty("semanticdb.pluginpath", "");
    private static final String SOURCEROOT = System.getProperty("semanticdb.sourceroot", "");
    private static final String TARGETROOT = System.getProperty("semanticdb.targetroot", "");
    private static final String OUTPUT = System.getProperty("semanticdb.output", "");
    private static final String OLD_OUTPUT = System.getProperty("semanticdb.old-output", "");

    public void processArgument(String arg) {
        this.oldArgs.add(arg);
        arg = this.unwrapQuote(arg);
        if ("-processorpath".equals(this.previousArg) || "-classpath".equals(this.previousArg) || "-cp".equals(this.previousArg)) {
            this.isClasspathUpdated = true;
            this.result.add(PLUGINPATH + File.pathSeparator + arg);
        } else if (!(arg.startsWith("-J") || arg.startsWith("-Xplugin:ErrorProne") || arg.startsWith("-Xlint"))) {
            this.result.add(arg);
        }
        this.previousArg = arg;
    }

    private String unwrapQuote(String arg) {
        if (arg.startsWith("\"") && arg.endsWith("\"")) {
            return arg.substring(1, arg.length() - 1);
        }
        return arg;
    }

    private String wrapQuote(String arg) {
        if (arg.startsWith("\"") && arg.endsWith("\"")) {
            return arg;
        }
        return "\"" + arg + "\"";
    }

    private String xpluginOption() {
        return String.format("\"-Xplugin:semanticdb -sourceroot:%s -targetroot:%s\"", SOURCEROOT, TARGETROOT);
    }

    public ArrayList<String> finalResult() {
        if (!this.isClasspathUpdated) {
            this.result.add("-classpath");
            this.result.add(PLUGINPATH);
        }
        this.result.add(this.xpluginOption());
        ArrayList<String> finalResult = new ArrayList<String>();
        for (String arg : this.result) {
            finalResult.add(this.wrapQuote(arg));
        }
        return finalResult;
    }

    public void writeFile(String file, List<String> lines, OpenOption ... options) throws IOException {
        Path path = Paths.get(file, new String[0]);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.write(path, lines, StandardCharsets.UTF_8, options);
    }

    public void write() throws IOException {
        this.writeFile(OUTPUT, this.finalResult(), new OpenOption[0]);
        this.writeFile(OLD_OUTPUT, this.oldArgs, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
    }
}

