/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.semanticdb_javac;

import java.util.Objects;

public final class SemanticdbSymbols {
    public static String NONE = "";
    public static String ROOT_PACKAGE = "_root_/";

    public static String global(String string, Descriptor descriptor) {
        if (descriptor == Descriptor.NONE) {
            return NONE;
        }
        if (!ROOT_PACKAGE.equals(string)) {
            return string + descriptor.encode();
        }
        return descriptor.encode();
    }

    public static String local(int n) {
        return "local" + n;
    }

    public static boolean isLocal(String string) {
        return string.startsWith("local");
    }

    public static boolean isGlobal(String string) {
        return !SemanticdbSymbols.isLocal(string);
    }

    public static final class Descriptor {
        public static Descriptor NONE = new Descriptor(Kind.None, "", "");
        public final Kind kind;
        public final String name;
        public final String disambiguator;

        public Descriptor(Kind kind, String string) {
            this(kind, string, "");
        }

        public Descriptor(Kind kind, String string, String string2) {
            this.kind = kind;
            this.name = string;
            this.disambiguator = string2;
        }

        public static Descriptor local(String string) {
            return new Descriptor(Kind.Local, string);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Descriptor descriptor = (Descriptor)object;
            return this.kind == descriptor.kind && Objects.equals(this.name, descriptor.name) && Objects.equals(this.disambiguator, descriptor.disambiguator);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind, this.name, this.disambiguator});
        }

        public String toString() {
            return "Descriptor{kind=" + (Object)((Object)this.kind) + ", name='" + this.name + '\'' + ", disambiguator='" + this.disambiguator + '\'' + '}';
        }

        public String encode() {
            switch (this.kind) {
                case None: {
                    return "";
                }
                case Term: {
                    return Descriptor.encodeName(this.name) + ".";
                }
                case Method: {
                    return Descriptor.encodeName(this.name) + this.disambiguator + ".";
                }
                case Type: {
                    return Descriptor.encodeName(this.name) + "#";
                }
                case Package: {
                    return Descriptor.encodeName(this.name) + "/";
                }
                case Parameter: {
                    return "(" + Descriptor.encodeName(this.name) + ")";
                }
                case TypeParameter: {
                    return "[" + Descriptor.encodeName(this.name) + "]";
                }
            }
            throw new IllegalArgumentException(String.format("%s", new Object[]{this.kind}));
        }

        private static String encodeName(String string) {
            if (string == null || string.isEmpty()) {
                return "``";
            }
            boolean bl = Character.isJavaIdentifierStart(string.charAt(0));
            boolean bl2 = true;
            for (int i = 1; bl2 && i < string.length(); ++i) {
                bl2 = Character.isJavaIdentifierPart(string.charAt(i));
            }
            if (bl && bl2) {
                return string;
            }
            return "`" + string + "`";
        }

        public static enum Kind {
            None,
            Local,
            Term,
            Method,
            Type,
            Package,
            Parameter,
            TypeParameter;

        }
    }
}

