/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.semanticdb_javac;

import com.sourcegraph.semanticdb_javac.CompilationUnitException;
import com.sourcegraph.semanticdb_javac.GlobalSymbolsCache;
import com.sourcegraph.semanticdb_javac.Result;
import com.sourcegraph.semanticdb_javac.Semanticdb;
import com.sourcegraph.semanticdb_javac.SemanticdbJavacOptions;
import com.sourcegraph.semanticdb_javac.SemanticdbReporter;
import com.sourcegraph.semanticdb_javac.SemanticdbVisitor;
import com.sourcegraph.semanticdb_javac.UriScheme;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.model.JavacTypes;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public final class SemanticdbTaskListener
implements TaskListener {
    private final SemanticdbJavacOptions options;
    private final JavacTask task;
    private final GlobalSymbolsCache globals;
    private final SemanticdbReporter reporter;
    private final JavacTypes javacTypes;

    public SemanticdbTaskListener(SemanticdbJavacOptions options, JavacTask task, GlobalSymbolsCache globals, SemanticdbReporter reporter, JavacTypes javacTypes) {
        this.options = options;
        this.task = task;
        this.globals = globals;
        this.reporter = reporter;
        this.javacTypes = javacTypes;
    }

    @Override
    public void started(TaskEvent e) {
    }

    @Override
    public void finished(TaskEvent e) {
        if (e.getKind() != TaskEvent.Kind.ANALYZE) {
            return;
        }
        try {
            this.onFinishedAnalyze(e);
        }
        catch (Throwable ex) {
            Throwable throwable = ex;
            if (e.getSourceFile() != null) {
                throwable = new CompilationUnitException(String.valueOf(e.getSourceFile().toUri().toString()), throwable);
            }
            this.reporter.exception(throwable);
        }
    }

    private void onFinishedAnalyze(TaskEvent e) {
        Result<Path, String> path = this.semanticdbOutputPath(this.options, e);
        if (path.isOk()) {
            Semanticdb.TextDocument textDocument = new SemanticdbVisitor(this.task, this.globals, e, this.options, this.javacTypes).buildTextDocument(e.getCompilationUnit());
            this.writeSemanticdb(path.getOrThrow(), textDocument);
        } else {
            this.reporter.error(path.getErrorOrThrow());
        }
    }

    private void writeSemanticdb(Path output, Semanticdb.TextDocument textDocument) {
        try {
            byte[] bytes = Semanticdb.TextDocuments.newBuilder().addDocuments(textDocument).build().toByteArray();
            Files.createDirectories(output.getParent(), new FileAttribute[0]);
            Files.write(output, bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            this.reporter.exception(e);
        }
    }

    public static Path absolutePathFromUri(SemanticdbJavacOptions options, URI uri) {
        if (options.uriScheme == UriScheme.SBT && uri.getScheme().equals("vf") && uri.toString().startsWith("vf://tmp/")) {
            String[] parts = uri.toString().split("/", 5);
            if (parts.length == 5) {
                return options.sourceroot.resolve(Paths.get(parts[4], new String[0]));
            }
            throw new IllegalArgumentException("unsupported URI: " + uri);
        }
        return Paths.get(uri);
    }

    private Result<Path, String> semanticdbOutputPath(SemanticdbJavacOptions options, TaskEvent e) {
        Path absolutePath = SemanticdbTaskListener.absolutePathFromUri(options, e.getSourceFile().toUri());
        if (absolutePath.startsWith(options.sourceroot)) {
            Path relativePath = options.sourceroot.relativize(absolutePath);
            String filename = relativePath.getFileName().toString() + ".semanticdb";
            Path semanticdbOutputPath = options.targetroot.resolve("META-INF").resolve("semanticdb").resolve(relativePath).resolveSibling(filename);
            return Result.ok(semanticdbOutputPath);
        }
        return Result.error(String.format("sourceroot '%s does not contain path '%s'. To fix this problem, update the -sourceroot flag to be a parent directory of this source file.", options.sourceroot, absolutePath));
    }
}

