/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac;

import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.Debugging;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.LocalSymbolsCache;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.SemanticdbJavacOptions;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.SemanticdbSymbols;
import com.sun.tools.javac.code.Symbol;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

public final class GlobalSymbolsCache {
    private final IdentityHashMap<Symbol, String> globals = new IdentityHashMap();
    private final SemanticdbJavacOptions options;

    public GlobalSymbolsCache(SemanticdbJavacOptions options) {
        this.options = options;
    }

    public String semanticdbSymbol(Symbol sym, LocalSymbolsCache locals) {
        String result = this.globals.get(sym);
        if (result != null) {
            return result;
        }
        String localResult = locals.get(sym);
        if (localResult != null) {
            return localResult;
        }
        result = this.uncachedSemanticdbSymbol(sym, locals);
        if (SemanticdbSymbols.isGlobal(result)) {
            this.globals.put(sym, result);
        }
        return result;
    }

    public String semanticdbSymbol(Element element, LocalSymbolsCache locals) {
        return this.semanticdbSymbol((Symbol)element, locals);
    }

    public boolean isNone(Symbol sym) {
        return sym == null;
    }

    private String uncachedSemanticdbSymbol(Symbol sym, LocalSymbolsCache locals) {
        if (this.isNone(sym)) {
            return SemanticdbSymbols.NONE;
        }
        String owner = this.semanticdbSymbol(sym.owner, locals);
        if (owner.equals(SemanticdbSymbols.NONE)) {
            return SemanticdbSymbols.ROOT_PACKAGE;
        }
        if (SemanticdbSymbols.isLocal(owner) || this.isAnonymousClass(sym) || this.isLocalVariable(sym)) {
            return locals.put(sym);
        }
        SemanticdbSymbols.Descriptor desc = this.semanticdbDescriptor(sym);
        if (this.options.verboseEnabled && desc.kind == SemanticdbSymbols.Descriptor.Kind.None) {
            Debugging.pprint(sym.getQualifiedName().toString());
            Debugging.pprint(String.format("sym: %s (%s - superclass %s)", sym, sym.getClass(), sym.getClass().getSuperclass()));
        }
        return SemanticdbSymbols.global(owner, desc);
    }

    private boolean isLocalVariable(Symbol sym) {
        switch (sym.getKind()) {
            case PARAMETER: 
            case EXCEPTION_PARAMETER: 
            case LOCAL_VARIABLE: {
                return true;
            }
        }
        return false;
    }

    private boolean isAnonymousClass(Symbol sym) {
        return sym instanceof Symbol.ClassSymbol && sym.name.isEmpty();
    }

    private SemanticdbSymbols.Descriptor semanticdbDescriptor(Symbol sym) {
        if (sym instanceof Symbol.ClassSymbol) {
            return new SemanticdbSymbols.Descriptor(SemanticdbSymbols.Descriptor.Kind.Type, sym.name.toString());
        }
        if (sym instanceof Symbol.MethodSymbol) {
            return new SemanticdbSymbols.Descriptor(SemanticdbSymbols.Descriptor.Kind.Method, sym.name.toString(), this.methodDisambiguator((Symbol.MethodSymbol)sym));
        }
        if (sym instanceof Symbol.PackageSymbol) {
            return new SemanticdbSymbols.Descriptor(SemanticdbSymbols.Descriptor.Kind.Package, sym.name.toString());
        }
        if (sym instanceof Symbol.TypeVariableSymbol) {
            return new SemanticdbSymbols.Descriptor(SemanticdbSymbols.Descriptor.Kind.TypeParameter, sym.name.toString());
        }
        if (sym instanceof Symbol.VarSymbol) {
            return new SemanticdbSymbols.Descriptor(SemanticdbSymbols.Descriptor.Kind.Term, sym.name.toString());
        }
        return SemanticdbSymbols.Descriptor.NONE;
    }

    private String methodDisambiguator(Symbol.MethodSymbol sym) {
        List<Symbol> elements = sym.owner.getEnclosedElements();
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        for (Element element : elements) {
            if (!(element instanceof ExecutableElement) || element.getSimpleName() != sym.name) continue;
            methods.add((ExecutableElement)element);
        }
        methods.sort((a, b) -> Boolean.compare(a.getReceiverType() == null, b.getReceiverType() == null));
        int index = methods.indexOf(sym);
        if (index == 0) {
            return "()";
        }
        return String.format("(+%d)", index);
    }
}

