/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac;

import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.GlobalSymbolsCache;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.LocalSymbolsCache;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.Semanticdb;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.SemanticdbBuilders;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.SemanticdbTypeVisitor;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

public final class SemanticdbSignatures {
    private final GlobalSymbolsCache cache;
    private final LocalSymbolsCache locals;

    public SemanticdbSignatures(GlobalSymbolsCache cache, LocalSymbolsCache locals) {
        this.cache = cache;
        this.locals = locals;
    }

    public Semanticdb.Signature generateSignature(Symbol sym) {
        if (sym instanceof Symbol.ClassSymbol) {
            return this.generateClassSignature((Symbol.ClassSymbol)sym);
        }
        if (sym instanceof Symbol.MethodSymbol) {
            return this.generateMethodSignature((Symbol.MethodSymbol)sym);
        }
        if (sym instanceof Symbol.VarSymbol) {
            return this.generateFieldSignature((Symbol.VarSymbol)sym);
        }
        if (sym instanceof Symbol.TypeVariableSymbol) {
            return this.generateTypeSignature((Symbol.TypeVariableSymbol)sym);
        }
        return null;
    }

    private Semanticdb.Signature generateClassSignature(Symbol.ClassSymbol sym) {
        Semanticdb.ClassSignature.Builder builder = Semanticdb.ClassSignature.newBuilder();
        builder.setTypeParameters(this.generateScope(sym.getTypeParameters()));
        if (sym.getSuperclass() != Type.noType) {
            Semanticdb.Type superType = this.generateType(sym.getSuperclass());
            if (superType == null) {
                superType = SemanticdbTypeVisitor.UNRESOLVED_TYPE_REF;
            }
            builder.addParents(superType);
        }
        for (Type iType : sym.getInterfaces()) {
            Semanticdb.Type type = this.generateType(iType);
            if (type == null) {
                type = SemanticdbTypeVisitor.UNRESOLVED_TYPE_REF;
            }
            builder.addParents(type);
        }
        builder.setDeclarations(this.generateScope(sym.getEnclosedElements()));
        return SemanticdbBuilders.signature(builder);
    }

    private Semanticdb.Signature generateMethodSignature(Symbol.MethodSymbol sym) {
        Semanticdb.MethodSignature.Builder builder = Semanticdb.MethodSignature.newBuilder();
        builder.setTypeParameters(this.generateScope(sym.getTypeParameters()));
        builder.addParameterLists(this.generateScope(sym.params()));
        Semanticdb.Type returnType = this.generateType(sym.getReturnType());
        if (returnType != null) {
            builder.setReturnType(returnType);
        }
        List thrownTypes = sym.getThrownTypes().stream().map(this::generateType).collect(Collectors.toList());
        builder.addAllThrows(thrownTypes);
        return SemanticdbBuilders.signature(builder);
    }

    private Semanticdb.Signature generateFieldSignature(Symbol.VarSymbol sym) {
        Semanticdb.Type generateType = this.generateType(sym.type);
        if (generateType == null) {
            generateType = SemanticdbTypeVisitor.UNRESOLVED_TYPE_REF;
        }
        return SemanticdbBuilders.signature(Semanticdb.ValueSignature.newBuilder().setTpe(generateType));
    }

    private Semanticdb.Signature generateTypeSignature(Symbol.TypeVariableSymbol sym) {
        Semanticdb.TypeSignature.Builder builder = Semanticdb.TypeSignature.newBuilder();
        builder.setTypeParameters(this.generateScope(sym.getTypeParameters()));
        Semanticdb.Type upperBound = this.generateType(sym.type.getUpperBound());
        if (upperBound != null) {
            builder.setUpperBound(upperBound);
        } else {
            builder.setUpperBound(SemanticdbTypeVisitor.UNRESOLVED_TYPE_REF);
        }
        return SemanticdbBuilders.signature(builder);
    }

    private Semanticdb.Scope generateScope(List<? extends Element> elements) {
        Semanticdb.Scope.Builder scope = Semanticdb.Scope.newBuilder();
        for (Element element : elements) {
            scope.addSymlinks(this.cache.semanticdbSymbol(element, this.locals));
        }
        return scope.build();
    }

    private Semanticdb.Type generateType(TypeMirror mirror) {
        return new SemanticdbTypeVisitor(this.cache, this.locals).semanticdbType(mirror);
    }
}

