/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac;

import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.CompilerRange;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.EmptyEndPosTable;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.GlobalSymbolsCache;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.LocalSymbolsCache;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.MD5;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.RangeFinder;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.Semanticdb;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.SemanticdbBuilders;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.SemanticdbJavacOptions;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.SemanticdbSignatures;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.SemanticdbSymbols;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.SemanticdbTaskListener;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.SemanticdbTrees;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.JCDiagnostic;
import java.io.IOException;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.util.Elements;

public class SemanticdbVisitor
extends TreePathScanner<Void, Void> {
    private final GlobalSymbolsCache globals;
    private final LocalSymbolsCache locals;
    private final JavacTask task;
    private final TaskEvent event;
    private final JavacTypes javacTypes;
    private final Trees trees;
    private final SemanticdbJavacOptions options;
    private final EndPosTable endPosTable;
    private final ArrayList<Semanticdb.SymbolOccurrence> occurrences;
    private final ArrayList<Semanticdb.SymbolInformation> symbolInfos;
    private String source;

    public SemanticdbVisitor(JavacTask task, GlobalSymbolsCache globals, TaskEvent event, SemanticdbJavacOptions options, JavacTypes javacTypes) {
        this.task = task;
        this.globals = globals;
        this.locals = new LocalSymbolsCache();
        this.event = event;
        this.options = options;
        this.javacTypes = javacTypes;
        this.trees = Trees.instance(task);
        this.endPosTable = event.getCompilationUnit() instanceof JCTree.JCCompilationUnit ? ((JCTree.JCCompilationUnit)event.getCompilationUnit()).endPositions : new EmptyEndPosTable();
        this.occurrences = new ArrayList();
        this.symbolInfos = new ArrayList();
        this.source = this.semanticdbText();
    }

    public Semanticdb.TextDocument buildTextDocument(CompilationUnitTree tree) {
        this.scan(tree, null);
        return Semanticdb.TextDocument.newBuilder().setSchema(Semanticdb.Schema.SEMANTICDB4).setLanguage(Semanticdb.Language.JAVA).setUri(this.semanticdbUri()).setText(this.options.includeText ? this.source : "").setMd5(this.semanticdbMd5()).addAllOccurrences(this.occurrences).addAllSymbols(this.symbolInfos).build();
    }

    private <T extends JCTree> void emitSymbolOccurrence(Symbol sym, T posTree, Semanticdb.SymbolOccurrence.Role role, CompilerRange kind) {
        if (sym == null) {
            return;
        }
        Optional<Semanticdb.SymbolOccurrence> occ = this.semanticdbOccurrence(sym, posTree, kind, role);
        occ.ifPresent(this.occurrences::add);
        if (role == Semanticdb.SymbolOccurrence.Role.DEFINITION) {
            this.emitSymbolInformation(sym, posTree);
        }
    }

    private void emitSymbolInformation(Symbol sym, JCTree tree) {
        List<Semanticdb.AnnotationTree> annotations;
        Semanticdb.Signature signature;
        Semanticdb.SymbolInformation.Builder builder = SemanticdbBuilders.symbolInformation(this.semanticdbSymbol(sym));
        Semanticdb.Documentation documentation = this.semanticdbDocumentation(sym);
        if (documentation != null) {
            builder.setDocumentation(documentation);
        }
        if ((signature = this.semanticdbSignature(sym)) != null) {
            builder.setSignature(signature);
        }
        if ((annotations = new SemanticdbTrees(this.globals, this.locals, this.semanticdbUri()).annotations(tree)) != null) {
            builder.addAllAnnotations(annotations);
        }
        builder.setProperties(this.semanticdbSymbolInfoProperties(sym)).setDisplayName(sym.name.toString()).setAccess(this.semanticdbAccess(sym));
        switch (sym.getKind()) {
            case ENUM: 
            case CLASS: {
                builder.setKind(Semanticdb.SymbolInformation.Kind.CLASS);
                builder.addAllOverriddenSymbols(this.semanticdbParentSymbols(sym, new ArrayList<String>()));
                break;
            }
            case INTERFACE: 
            case ANNOTATION_TYPE: {
                builder.setKind(Semanticdb.SymbolInformation.Kind.INTERFACE);
                builder.addAllOverriddenSymbols(this.semanticdbParentSymbols(sym, new ArrayList<String>()));
                break;
            }
            case FIELD: {
                builder.setKind(Semanticdb.SymbolInformation.Kind.FIELD);
                break;
            }
            case METHOD: {
                builder.setKind(Semanticdb.SymbolInformation.Kind.METHOD);
                builder.addAllOverriddenSymbols(this.semanticdbOverrides(sym));
                break;
            }
            case CONSTRUCTOR: {
                builder.setKind(Semanticdb.SymbolInformation.Kind.CONSTRUCTOR);
                break;
            }
            case TYPE_PARAMETER: {
                builder.setKind(Semanticdb.SymbolInformation.Kind.TYPE_PARAMETER);
                break;
            }
            case ENUM_CONSTANT: {
                String args = ((JCTree.JCNewClass)((JCTree.JCVariableDecl)tree).init).args.stream().map(JCTree::toString).collect(Collectors.joining(", "));
                if (args.isEmpty()) break;
                builder.setDisplayName(sym.name.toString() + "(" + args + ")");
            }
        }
        Semanticdb.SymbolInformation info = builder.build();
        this.symbolInfos.add(info);
    }

    @Override
    public Void visitClass(ClassTree node, Void unused) {
        if (node instanceof JCTree.JCClassDecl) {
            JCTree.JCClassDecl cls = (JCTree.JCClassDecl)node;
            if (cls.sym == null) {
                return (Void)super.visitClass(node, unused);
            }
            this.emitSymbolOccurrence(cls.sym, cls, Semanticdb.SymbolOccurrence.Role.DEFINITION, CompilerRange.FROM_POINT_WITH_TEXT_SEARCH);
            List typeParameters = cls.getTypeParameters();
            int i = 0;
            for (Symbol.TypeVariableSymbol typeSym : cls.sym.getTypeParameters()) {
                if (i >= typeParameters.size()) break;
                this.emitSymbolOccurrence(typeSym, (JCTree)typeParameters.get(i), Semanticdb.SymbolOccurrence.Role.DEFINITION, CompilerRange.FROM_POINT_TO_SYMBOL_NAME);
                ++i;
            }
        }
        return (Void)super.visitClass(node, unused);
    }

    @Override
    public Void visitMethod(MethodTree node, Void unused) {
        if (node instanceof JCTree.JCMethodDecl) {
            JCTree.JCMethodDecl meth = (JCTree.JCMethodDecl)node;
            if (meth.sym == null) {
                return (Void)super.visitMethod(node, unused);
            }
            CompilerRange range = CompilerRange.FROM_POINT_TO_SYMBOL_NAME;
            if (meth.sym.isConstructor()) {
                if (meth.sym.owner.isAnonymous()) {
                    return null;
                }
                range = CompilerRange.FROM_POINT_WITH_TEXT_SEARCH;
            }
            this.emitSymbolOccurrence(meth.sym, meth, Semanticdb.SymbolOccurrence.Role.DEFINITION, range);
            List typeParameters = meth.getTypeParameters();
            int i = 0;
            for (Symbol.TypeVariableSymbol typeSym : meth.sym.getTypeParameters()) {
                this.emitSymbolOccurrence(typeSym, (JCTree)typeParameters.get(i), Semanticdb.SymbolOccurrence.Role.DEFINITION, CompilerRange.FROM_POINT_TO_SYMBOL_NAME);
                ++i;
            }
        }
        return (Void)super.visitMethod(node, unused);
    }

    @Override
    public Void visitVariable(VariableTree node, Void unused) {
        if (node instanceof JCTree.JCVariableDecl) {
            JCTree.JCVariableDecl decl = (JCTree.JCVariableDecl)node;
            this.emitSymbolOccurrence(decl.sym, decl, Semanticdb.SymbolOccurrence.Role.DEFINITION, CompilerRange.FROM_POINT_TO_SYMBOL_NAME);
        }
        return (Void)super.visitVariable(node, unused);
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, Void unused) {
        if (node instanceof JCTree.JCIdent) {
            JCTree.JCIdent ident = (JCTree.JCIdent)node;
            if (ident.name == null || ident.sym == null) {
                return null;
            }
            if (ident.name.toString().equals("this") && ident.sym.getKind() != ElementKind.CONSTRUCTOR) {
                return null;
            }
            this.emitSymbolOccurrence(ident.sym, ident, Semanticdb.SymbolOccurrence.Role.REFERENCE, CompilerRange.FROM_START_TO_END);
        }
        return (Void)super.visitIdentifier(node, unused);
    }

    @Override
    public Void visitMemberReference(MemberReferenceTree node, Void unused) {
        if (node instanceof JCTree.JCMemberReference) {
            JCTree.JCMemberReference ref = (JCTree.JCMemberReference)node;
            this.emitSymbolOccurrence(ref.sym, ref, Semanticdb.SymbolOccurrence.Role.REFERENCE, CompilerRange.FROM_END_WITH_TEXT_SEARCH);
        }
        return (Void)super.visitMemberReference(node, unused);
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree node, Void unused) {
        if (node instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess select = (JCTree.JCFieldAccess)node;
            this.emitSymbolOccurrence(select.sym, select, Semanticdb.SymbolOccurrence.Role.REFERENCE, CompilerRange.FROM_POINT_TO_SYMBOL_NAME_PLUS_ONE);
        }
        return (Void)super.visitMemberSelect(node, unused);
    }

    @Override
    public Void visitNewClass(NewClassTree node, Void unused) {
        if (node instanceof JCTree.JCNewClass) {
            JCTree.JCNewClass cls = (JCTree.JCNewClass)node;
            if (cls.type != null && cls.type.tsym != null && !cls.type.tsym.isAnonymous()) {
                this.emitSymbolOccurrence(cls.constructor, cls, Semanticdb.SymbolOccurrence.Role.REFERENCE, CompilerRange.FROM_TEXT_SEARCH);
            }
        }
        this.scan(node.getTypeArguments(), unused);
        this.scan(node.getArguments(), unused);
        return (Void)this.scan(node.getClassBody(), unused);
    }

    private Semanticdb.Signature semanticdbSignature(Symbol sym) {
        return new SemanticdbSignatures(this.globals, this.locals).generateSignature(sym);
    }

    private String semanticdbSymbol(Symbol sym) {
        return this.globals.semanticdbSymbol(sym, this.locals);
    }

    private Optional<Semanticdb.Range> semanticdbRange(JCDiagnostic.DiagnosticPosition pos, CompilerRange kind, Symbol sym) {
        int end;
        int start;
        LineMap lineMap = this.event.getCompilationUnit().getLineMap();
        if (sym == null) {
            return Optional.empty();
        }
        if (kind.isFromPoint() && sym.name != null) {
            start = pos.getPreferredPosition();
            if (kind == CompilerRange.FROM_POINT_TO_SYMBOL_NAME_PLUS_ONE) {
                ++start;
            }
            end = start + sym.name.length();
        } else {
            start = pos.getStartPosition();
            end = pos.getEndPosition(this.endPosTable);
        }
        if (kind.isFromTextSearch() && sym.name.length() > 0) {
            Optional<Semanticdb.Range> range = RangeFinder.findRange(this.getCurrentPath(), this.trees, this.getCurrentPath().getCompilationUnit(), sym, start, this.source, kind.isFromEnd());
            if (range.isPresent()) {
                return Optional.of(this.correctForTabs(range.get(), lineMap, start));
            }
            return range;
        }
        if (start != -1 && end != -1 && end > start) {
            Semanticdb.Range range = Semanticdb.Range.newBuilder().setStartLine((int)lineMap.getLineNumber(start) - 1).setStartCharacter((int)lineMap.getColumnNumber(start) - 1).setEndLine((int)lineMap.getLineNumber(end) - 1).setEndCharacter((int)lineMap.getColumnNumber(end) - 1).build();
            range = this.correctForTabs(range, lineMap, start);
            return Optional.of(range);
        }
        return Optional.empty();
    }

    private Semanticdb.Range correctForTabs(Semanticdb.Range range, LineMap lineMap, int start) {
        int startLinePos = (int)lineMap.getPosition(lineMap.getLineNumber(start), 0L);
        if (this.source.charAt(startLinePos) == '\t') {
            int count = 1;
            while (this.source.charAt(++startLinePos) == '\t') {
                ++count;
            }
            range = range.toBuilder().setStartCharacter(range.getStartCharacter() - count * 7).setEndCharacter(range.getEndCharacter() - count * 7).build();
        }
        return range;
    }

    private Optional<Semanticdb.SymbolOccurrence> semanticdbOccurrence(Symbol sym, JCDiagnostic.DiagnosticPosition pos, CompilerRange kind, Semanticdb.SymbolOccurrence.Role role) {
        Optional<Semanticdb.Range> range = this.semanticdbRange(pos, kind, sym);
        if (range.isPresent()) {
            String ssym = this.semanticdbSymbol(sym);
            if (!ssym.equals(SemanticdbSymbols.NONE)) {
                Semanticdb.SymbolOccurrence occ = SemanticdbBuilders.symbolOccurrence(ssym, range.get(), role);
                return Optional.of(occ);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    private String semanticdbText() {
        if (this.source != null) {
            return this.source;
        }
        try {
            this.source = this.event.getSourceFile().getCharContent(true).toString();
        }
        catch (IOException e) {
            this.source = "";
        }
        return this.source;
    }

    private String semanticdbMd5() {
        try {
            return MD5.digest(this.event.getSourceFile().getCharContent(true).toString());
        }
        catch (IOException | NoSuchAlgorithmException e) {
            return "";
        }
    }

    private int semanticdbSymbolInfoProperties(Symbol sym) {
        int properties = 0;
        properties |= sym.isEnum() ? 16384 : 0;
        properties |= sym.isStatic() ? 4096 : 0;
        boolean abstractNotDefault = (sym.flags() & 0x400L) > 0L && (sym.flags() & 0x80000000000L) == 0L;
        properties |= abstractNotDefault ? 4 : 0;
        properties |= (sym.flags() & 0x10L) > 0L ? 8 : 0;
        return properties |= (sym.flags() & 0x80000000000L) > 0L ? 32768 : 0;
    }

    private List<String> semanticdbParentSymbols(Symbol sym, List<String> result) {
        if (!(sym instanceof Symbol.ClassSymbol)) {
            return result;
        }
        Symbol.ClassSymbol csym = (Symbol.ClassSymbol)sym;
        if (csym.getSuperclass() != Type.noType) {
            this.semanticdbParentSymbol(csym.getSuperclass().tsym, result);
        }
        for (Type iType : csym.getInterfaces()) {
            this.semanticdbParentSymbol(iType.tsym, result);
        }
        return result;
    }

    private void semanticdbParentSymbol(Symbol sym, List<String> result) {
        if (sym == null) {
            return;
        }
        String ssym = this.semanticdbSymbol(sym);
        if (!Objects.equals(ssym, SemanticdbSymbols.NONE)) {
            result.add(ssym);
            this.semanticdbParentSymbols(sym, result);
        }
    }

    private List<String> semanticdbOverrides(Symbol sym) {
        ArrayList<String> overriddenSymbols = new ArrayList<String>();
        Set<Symbol.MethodSymbol> overriddenMethods = this.javacTypes.getOverriddenMethods(sym);
        for (Symbol.MethodSymbol meth : overriddenMethods) {
            overriddenSymbols.add(this.semanticdbSymbol(meth));
        }
        return overriddenSymbols;
    }

    private Semanticdb.Access semanticdbAccess(Symbol sym) {
        switch ((int)sym.flags() & 7) {
            case 2: {
                return SemanticdbBuilders.privateAccess();
            }
            case 1: {
                return SemanticdbBuilders.publicAccess();
            }
            case 4: {
                return SemanticdbBuilders.protectedAccess();
            }
            case 0: {
                return SemanticdbBuilders.privateWithinAccess(this.semanticdbSymbol(sym.owner));
            }
        }
        throw new IllegalStateException("access flag " + (sym.flags() & 7L));
    }

    private String semanticdbUri() {
        Path absolutePath = SemanticdbTaskListener.absolutePathFromUri(this.options, this.event.getSourceFile());
        Path uriPath = absolutePath.startsWith(this.options.sourceroot) ? this.options.sourceroot.relativize(absolutePath) : absolutePath;
        StringBuilder out = new StringBuilder();
        Iterator<Path> it = uriPath.iterator();
        if (it.hasNext()) {
            out.append(it.next().getFileName().toString());
        }
        while (it.hasNext()) {
            Path part = it.next();
            out.append('/').append(part.getFileName().toString());
        }
        return out.toString();
    }

    private Path semanticdbPath() {
        return SemanticdbTaskListener.absolutePathFromUri(this.options, this.event.getSourceFile());
    }

    private Semanticdb.Documentation semanticdbDocumentation(Symbol sym) {
        try {
            Elements elements = this.task.getElements();
            if (elements == null) {
                return null;
            }
            String doc = elements.getDocComment(sym);
            if (doc == null) {
                return null;
            }
            return Semanticdb.Documentation.newBuilder().setFormat(Semanticdb.Documentation.Format.JAVADOC).setMessage(doc).build();
        }
        catch (NullPointerException e) {
            return null;
        }
    }
}

