/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac;

import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.CompilerRange;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.GlobalSymbolsCache;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.LocalSymbolsCache;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.MD5;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.RangeFinder;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.Semanticdb;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.SemanticdbBuilders;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.SemanticdbJavacOptions;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.SemanticdbSignatures;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.SemanticdbSymbols;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.SemanticdbTaskListener;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.SemanticdbTrees;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class SemanticdbVisitor
extends TreePathScanner<Void, Void> {
    private final GlobalSymbolsCache globals;
    private final LocalSymbolsCache locals;
    private final Types types;
    private final Trees trees;
    private final CompilationUnitTree compUnitTree;
    private final Elements elements;
    private final SemanticdbJavacOptions options;
    private final ArrayList<Semanticdb.SymbolOccurrence> occurrences;
    private final ArrayList<Semanticdb.SymbolInformation> symbolInfos;
    private String source;
    private String uri;
    private final LinkedHashMap<Tree, TreePath> nodes;

    public SemanticdbVisitor(GlobalSymbolsCache globals, CompilationUnitTree compUnitTree, SemanticdbJavacOptions options, Types types, Trees trees, Elements elements) {
        this.globals = globals;
        this.locals = new LocalSymbolsCache();
        this.options = options;
        this.types = types;
        this.elements = elements;
        this.trees = trees;
        this.compUnitTree = compUnitTree;
        this.occurrences = new ArrayList();
        this.symbolInfos = new ArrayList();
        this.source = this.semanticdbText();
        this.uri = SemanticdbVisitor.semanticdbUri(compUnitTree, options);
        this.nodes = new LinkedHashMap();
    }

    public Semanticdb.TextDocument buildTextDocument(CompilationUnitTree tree) {
        this.scan((Tree)tree, null);
        this.resolveNodes();
        return Semanticdb.TextDocument.newBuilder().setSchema(Semanticdb.Schema.SEMANTICDB4).setLanguage(Semanticdb.Language.JAVA).setUri(this.uri).setText(this.options.includeText ? this.source : "").setMd5(this.semanticdbMd5()).addAllOccurrences(this.occurrences).addAllSymbols(this.symbolInfos).build();
    }

    private Optional<Semanticdb.Range> emitSymbolOccurrence(Element sym, Tree tree, Name name, Semanticdb.SymbolOccurrence.Role role, CompilerRange kind) {
        if (sym == null || name == null) {
            return Optional.empty();
        }
        Optional<Semanticdb.Range> range = this.semanticdbRange(tree, kind, sym, name.toString());
        this.emitSymbolOccurrence(sym, range, role);
        if (role == Semanticdb.SymbolOccurrence.Role.DEFINITION) {
            this.emitSymbolInformation(sym, tree);
        }
        return range;
    }

    private void emitSymbolOccurrence(Element sym, Optional<Semanticdb.Range> range, Semanticdb.SymbolOccurrence.Role role) {
        if (sym == null) {
            return;
        }
        Optional<Semanticdb.SymbolOccurrence> occ = this.semanticdbOccurrence(sym, range, role);
        occ.ifPresent(this.occurrences::add);
    }

    private void emitSymbolInformation(Element sym, Tree tree) {
        List<Semanticdb.AnnotationTree> annotations;
        Semanticdb.Signature signature;
        String symbol = this.semanticdbSymbol(sym);
        Semanticdb.SymbolInformation.Builder builder = SemanticdbBuilders.symbolInformation(symbol);
        Semanticdb.Documentation documentation = this.semanticdbDocumentation(tree);
        if (documentation != null) {
            builder.setDocumentation(documentation);
        }
        if ((signature = this.semanticdbSignature(sym)) != null) {
            builder.setSignature(signature);
        }
        if ((annotations = new SemanticdbTrees(this.globals, this.locals, this.uri, this.types, this.trees, this.nodes).annotations(tree)) != null) {
            builder.addAllAnnotations(annotations);
        }
        builder.setProperties(this.semanticdbSymbolInfoProperties(sym)).setDisplayName(sym.getSimpleName().toString()).setAccess(this.semanticdbAccess(sym));
        switch (sym.getKind()) {
            case ENUM: 
            case CLASS: {
                builder.setKind(Semanticdb.SymbolInformation.Kind.CLASS);
                builder.addAllOverriddenSymbols(this.semanticdbParentSymbols((TypeElement)sym));
                break;
            }
            case INTERFACE: 
            case ANNOTATION_TYPE: {
                builder.setKind(Semanticdb.SymbolInformation.Kind.INTERFACE);
                builder.addAllOverriddenSymbols(this.semanticdbParentSymbols((TypeElement)sym));
                break;
            }
            case FIELD: {
                builder.setKind(Semanticdb.SymbolInformation.Kind.FIELD);
                break;
            }
            case METHOD: {
                builder.setKind(Semanticdb.SymbolInformation.Kind.METHOD);
                builder.addAllOverriddenSymbols(this.semanticdbOverrides((ExecutableElement)sym, sym.getEnclosingElement(), new HashSet<String>()));
                break;
            }
            case CONSTRUCTOR: {
                builder.setKind(Semanticdb.SymbolInformation.Kind.CONSTRUCTOR);
                break;
            }
            case TYPE_PARAMETER: {
                builder.setKind(Semanticdb.SymbolInformation.Kind.TYPE_PARAMETER);
                break;
            }
            case ENUM_CONSTANT: {
                String args = ((NewClassTree)((VariableTree)tree).getInitializer()).getArguments().stream().map(Object::toString).collect(Collectors.joining(", "));
                if (args.isEmpty()) break;
                builder.setDisplayName(sym.getSimpleName().toString() + "(" + args + ")");
            }
        }
        Semanticdb.SymbolInformation info = builder.build();
        this.symbolInfos.add(info);
    }

    void resolveNodes() {
        HashSet<Tree> ignoreNodes = new HashSet<Tree>();
        for (Tree tree : this.nodes.keySet()) {
            NewClassTree newClassTree;
            if (!(tree instanceof NewClassTree) || (newClassTree = (NewClassTree)tree).getClassBody() != null) continue;
            if (newClassTree.getIdentifier() instanceof ParameterizedTypeTree) {
                ParameterizedTypeTree paramNode = (ParameterizedTypeTree)((Object)newClassTree.getIdentifier());
                ignoreNodes.add(paramNode.getType());
            }
            ignoreNodes.add(newClassTree.getIdentifier());
        }
        for (Map.Entry entry : this.nodes.entrySet()) {
            Tree node = (Tree)entry.getKey();
            if (ignoreNodes.contains(node)) continue;
            if (node instanceof TypeParameterTree) {
                this.resolveTypeParameterTree((TypeParameterTree)node, (TreePath)entry.getValue());
                continue;
            }
            if (node instanceof ClassTree) {
                this.resolveClassTree((ClassTree)node, (TreePath)entry.getValue());
                continue;
            }
            if (node instanceof MethodTree) {
                this.resolveMethodTree((MethodTree)node, (TreePath)entry.getValue());
                continue;
            }
            if (node instanceof VariableTree) {
                this.resolveVariableTree((VariableTree)node, (TreePath)entry.getValue());
                continue;
            }
            if (node instanceof IdentifierTree) {
                this.resolveIdentifierTree((IdentifierTree)node, (TreePath)entry.getValue());
                continue;
            }
            if (node instanceof MemberReferenceTree) {
                this.resolveMemberReferenceTree((MemberReferenceTree)node, (TreePath)entry.getValue());
                continue;
            }
            if (node instanceof MemberSelectTree) {
                this.resolveMemberSelectTree((MemberSelectTree)node, (TreePath)entry.getValue());
                continue;
            }
            if (!(node instanceof NewClassTree)) continue;
            this.resolveNewClassTree((NewClassTree)node, (TreePath)entry.getValue());
        }
    }

    @Override
    public Void scan(Tree tree, Void unused) {
        if (tree != null) {
            TreePath path = new TreePath(this.getCurrentPath(), tree);
            this.nodes.put(tree, path);
        }
        return (Void)super.scan(tree, unused);
    }

    private boolean isAnonymous(Element sym) {
        return sym.getSimpleName().length() == 0;
    }

    public static <A extends String, B> B bar(A paramA, B paramB) {
        return paramB;
    }

    private void resolveClassTree(ClassTree node, TreePath treePath) {
        Element sym = this.trees.getElement(treePath);
        if (sym != null && sym.getSimpleName().length() > 0) {
            this.emitSymbolOccurrence(sym, node, sym.getSimpleName(), Semanticdb.SymbolOccurrence.Role.DEFINITION, CompilerRange.FROM_POINT_WITH_TEXT_SEARCH);
        }
    }

    private void resolveTypeParameterTree(TypeParameterTree node, TreePath treePath) {
        Element sym = this.trees.getElement(treePath);
        if (sym != null && sym.getSimpleName().length() > 0) {
            this.emitSymbolOccurrence(sym, node, sym.getSimpleName(), Semanticdb.SymbolOccurrence.Role.DEFINITION, CompilerRange.FROM_POINT_TO_SYMBOL_NAME);
        }
    }

    private void resolveMethodTree(MethodTree node, TreePath treePath) {
        Element sym = this.trees.getElement(treePath);
        if (sym != null) {
            Element enclosingElement = sym.getEnclosingElement();
            if (sym.getKind() != ElementKind.CONSTRUCTOR || !this.isAnonymous(enclosingElement)) {
                Name name = sym.getKind() == ElementKind.CONSTRUCTOR ? enclosingElement.getSimpleName() : sym.getSimpleName();
                this.emitSymbolOccurrence(sym, node, name, Semanticdb.SymbolOccurrence.Role.DEFINITION, CompilerRange.FROM_POINT_WITH_TEXT_SEARCH);
            }
        }
    }

    private void resolveVariableTree(VariableTree node, TreePath treePath) {
        Element sym = this.trees.getElement(treePath);
        if (sym != null) {
            TreePath typeTreePath;
            Element typeSym;
            Optional<Semanticdb.Range> range = this.emitSymbolOccurrence(sym, node, sym.getSimpleName(), Semanticdb.SymbolOccurrence.Role.DEFINITION, CompilerRange.FROM_POINT_WITH_TEXT_SEARCH);
            if (sym.getKind() == ElementKind.ENUM_CONSTANT && (typeSym = this.trees.getElement(typeTreePath = this.nodes.get(node.getInitializer()))) != null) {
                this.emitSymbolOccurrence(typeSym, range, Semanticdb.SymbolOccurrence.Role.REFERENCE);
            }
        }
    }

    private void resolveIdentifierTree(IdentifierTree node, TreePath treePath) {
        Element sym;
        Name nodeName = node.getName();
        if (nodeName != null && (sym = this.trees.getElement(treePath)) != null) {
            TreePath parentPath;
            Element parentSym;
            boolean isThis = nodeName.toString().equals("this");
            boolean isSuper = !isThis && nodeName.toString().equals("super");
            if (!(sym.getKind() == ElementKind.CONSTRUCTOR != isThis && !isSuper || (parentSym = this.trees.getElement(parentPath = treePath.getParentPath())) != null && parentSym.getKind() == null)) {
                this.emitSymbolOccurrence(sym, node, sym.getSimpleName(), Semanticdb.SymbolOccurrence.Role.REFERENCE, CompilerRange.FROM_START_TO_END);
            }
        }
    }

    private void resolveMemberReferenceTree(MemberReferenceTree node, TreePath treePath) {
        Element sym = this.trees.getElement(treePath);
        if (sym != null) {
            this.emitSymbolOccurrence(sym, node, sym.getSimpleName(), Semanticdb.SymbolOccurrence.Role.REFERENCE, CompilerRange.FROM_END_TO_SYMBOL_NAME);
        }
    }

    private void resolveMemberSelectTree(MemberSelectTree node, TreePath treePath) {
        Element sym = this.trees.getElement(treePath);
        if (sym != null) {
            this.emitSymbolOccurrence(sym, node, sym.getSimpleName(), Semanticdb.SymbolOccurrence.Role.REFERENCE, CompilerRange.FROM_END_TO_SYMBOL_NAME);
        }
    }

    private void resolveNewClassTree(NewClassTree node, TreePath treePath) {
        TreePath parentPath;
        Element parentSym;
        Element sym;
        if (node.getIdentifier() != null && node.getClassBody() == null && (sym = this.trees.getElement(treePath)) != null && ((parentSym = this.trees.getElement(parentPath = treePath.getParentPath())) == null || parentSym.getKind() != ElementKind.ENUM_CONSTANT)) {
            TreePath identifierTreePath = this.nodes.get(node.getIdentifier());
            Element identifierSym = this.trees.getElement(identifierTreePath);
            this.emitSymbolOccurrence(sym, node, identifierSym.getSimpleName(), Semanticdb.SymbolOccurrence.Role.REFERENCE, CompilerRange.FROM_TEXT_SEARCH);
        }
    }

    private Semanticdb.Signature semanticdbSignature(Element sym) {
        return new SemanticdbSignatures(this.globals, this.locals, this.types).generateSignature(sym);
    }

    private String semanticdbSymbol(Element sym) {
        return this.globals.semanticdbSymbol(sym, this.locals);
    }

    private Optional<Semanticdb.Range> semanticdbRange(Tree tree, CompilerRange kind, Element sym, String name) {
        if (sym == null) {
            return Optional.empty();
        }
        SourcePositions sourcePositions = this.trees.getSourcePositions();
        int start = (int)sourcePositions.getStartPosition(this.compUnitTree, tree);
        int end = (int)sourcePositions.getEndPosition(this.compUnitTree, tree);
        if (kind.isPlusOne()) {
            ++start;
        }
        if (name != null) {
            int testStart;
            if (kind.isFromTextSearch() && name.length() > 0) {
                Optional<RangeFinder.StartEndRange> startEndRange = RangeFinder.findRange(sym, name, start, end, this.source, kind.isFromEnd());
                if (startEndRange.isPresent()) {
                    start = startEndRange.get().start;
                    end = startEndRange.get().end;
                }
            } else if (kind.isFromPoint()) {
                if ((long)start != -1L) {
                    int testEnd = start + name.length();
                    if (this.source.length() > testEnd && this.source.substring(start, testEnd).equals(name)) {
                        end = testEnd;
                    }
                }
            } else if (kind.isFromEndPoint() && (long)end != -1L && (testStart = end - name.length()) >= 0 && this.source.length() > end && this.source.substring(testStart, end).equals(name)) {
                start = testStart;
            }
        }
        if ((long)start != -1L && (long)end != -1L && end > start) {
            LineMap lineMap = this.compUnitTree.getLineMap();
            Semanticdb.Range range = Semanticdb.Range.newBuilder().setStartLine((int)lineMap.getLineNumber(start) - 1).setStartCharacter((int)lineMap.getColumnNumber(start) - 1).setEndLine((int)lineMap.getLineNumber(end) - 1).setEndCharacter((int)lineMap.getColumnNumber(end) - 1).build();
            range = this.correctForTabs(range, lineMap, start);
            return Optional.of(range);
        }
        return Optional.empty();
    }

    private Semanticdb.Range correctForTabs(Semanticdb.Range range, LineMap lineMap, int start) {
        int startLinePos = (int)lineMap.getPosition(lineMap.getLineNumber(start), 0L);
        if (this.source.charAt(startLinePos) == '\t') {
            int count = 1;
            while (this.source.charAt(++startLinePos) == '\t') {
                ++count;
            }
            range = range.toBuilder().setStartCharacter(range.getStartCharacter() - count * 7).setEndCharacter(range.getEndCharacter() - count * 7).build();
        }
        return range;
    }

    private Optional<Semanticdb.SymbolOccurrence> semanticdbOccurrence(Element sym, Optional<Semanticdb.Range> range, Semanticdb.SymbolOccurrence.Role role) {
        if (range.isPresent()) {
            String ssym = this.semanticdbSymbol(sym);
            if (!ssym.equals(SemanticdbSymbols.NONE)) {
                Semanticdb.SymbolOccurrence occ = SemanticdbBuilders.symbolOccurrence(ssym, range.get(), role);
                return Optional.of(occ);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    private String semanticdbText() {
        if (this.source != null) {
            return this.source;
        }
        try {
            this.source = this.compUnitTree.getSourceFile().getCharContent(true).toString();
        }
        catch (IOException e) {
            this.source = "";
        }
        return this.source;
    }

    private String semanticdbMd5() {
        try {
            return MD5.digest(this.compUnitTree.getSourceFile().getCharContent(true).toString());
        }
        catch (IOException | NoSuchAlgorithmException e) {
            return "";
        }
    }

    private int semanticdbSymbolInfoProperties(Element sym) {
        int properties = 0;
        properties |= sym.getKind() == ElementKind.ENUM || sym.getKind() == ElementKind.ENUM_CONSTANT ? 16384 : 0;
        for (Modifier modifier : sym.getModifiers()) {
            if (modifier == Modifier.STATIC) {
                properties |= 0x1000;
                continue;
            }
            if (modifier == Modifier.DEFAULT) {
                properties |= 0x8000;
                continue;
            }
            if (modifier == Modifier.FINAL) {
                properties |= 8;
                continue;
            }
            if (modifier != Modifier.ABSTRACT) continue;
            properties |= 4;
        }
        if ((properties & 4) > 0 && (properties & 0x8000) > 0) {
            properties ^= 4;
        }
        return properties;
    }

    private List<String> semanticdbParentSymbols(TypeElement typeElement) {
        ArrayList<String> parentSymbols = new ArrayList<String>();
        Set<TypeElement> parentElements = this.semanticdbParentTypeElements(typeElement, new HashSet<TypeElement>());
        for (TypeElement parentElement : parentElements) {
            String ssym = this.semanticdbSymbol(parentElement);
            if (Objects.equals(ssym, SemanticdbSymbols.NONE)) continue;
            parentSymbols.add(ssym);
        }
        return parentSymbols;
    }

    private Set<TypeElement> semanticdbParentTypeElements(TypeElement typeElement, Set<TypeElement> result) {
        TypeMirror superType = typeElement.getSuperclass();
        this.semanticdbParentSymbol(superType, result);
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            this.semanticdbParentSymbol(typeMirror, result);
        }
        return result;
    }

    private void semanticdbParentSymbol(TypeMirror elementType, Set<TypeElement> result) {
        Element superElement;
        if (!(elementType instanceof NoType) && (superElement = this.types.asElement(elementType)) != null && superElement instanceof TypeElement) {
            result.add((TypeElement)superElement);
            this.semanticdbParentTypeElements((TypeElement)superElement, result);
        }
    }

    private Set<String> semanticdbOverrides(ExecutableElement sym, Element enclosingElement, HashSet<String> overriddenSymbols) {
        if (enclosingElement instanceof TypeElement) {
            List<? extends TypeMirror> superTypes = this.types.directSupertypes(enclosingElement.asType());
            for (TypeMirror typeMirror : superTypes) {
                Element superElement;
                if (!(typeMirror instanceof DeclaredType) || !((superElement = ((DeclaredType)typeMirror).asElement()) instanceof TypeElement)) continue;
                boolean methodFound = false;
                List<? extends Element> enclosedElements = ((TypeElement)superElement).getEnclosedElements();
                for (Element element : enclosedElements) {
                    ExecutableElement enclosedExecutableElement;
                    if (!(element instanceof ExecutableElement) || !this.elements.overrides(sym, enclosedExecutableElement = (ExecutableElement)element, (TypeElement)sym.getEnclosingElement())) continue;
                    String symbol = this.semanticdbSymbol(enclosedExecutableElement);
                    overriddenSymbols.add(symbol);
                    methodFound = true;
                    this.semanticdbOverrides(enclosedExecutableElement, superElement, overriddenSymbols);
                }
                if (methodFound) continue;
                this.semanticdbOverrides(sym, superElement, overriddenSymbols);
            }
        }
        return overriddenSymbols;
    }

    private Semanticdb.Access semanticdbAccess(Element sym) {
        for (Modifier modifier : sym.getModifiers()) {
            if (modifier == Modifier.PRIVATE) {
                return SemanticdbBuilders.privateAccess();
            }
            if (modifier == Modifier.PUBLIC) {
                return SemanticdbBuilders.publicAccess();
            }
            if (modifier != Modifier.PROTECTED) continue;
            return SemanticdbBuilders.protectedAccess();
        }
        return SemanticdbBuilders.privateWithinAccess(this.semanticdbSymbol(sym.getEnclosingElement()));
    }

    private static String semanticdbUri(CompilationUnitTree compUnitTree, SemanticdbJavacOptions options) {
        Path absolutePath = SemanticdbTaskListener.absolutePathFromUri(options, compUnitTree.getSourceFile());
        Path uriPath = absolutePath.startsWith(options.sourceroot) ? options.sourceroot.relativize(absolutePath) : absolutePath;
        StringBuilder out = new StringBuilder();
        Iterator<Path> it = uriPath.iterator();
        if (it.hasNext()) {
            out.append(it.next().getFileName().toString());
        }
        while (it.hasNext()) {
            Path part = it.next();
            out.append('/').append(part.getFileName().toString());
        }
        return out.toString();
    }

    private Semanticdb.Documentation semanticdbDocumentation(Tree tree) {
        try {
            TreePath treePath = this.nodes.get(tree);
            String doc = this.trees.getDocComment(treePath);
            if (doc == null) {
                return null;
            }
            return Semanticdb.Documentation.newBuilder().setFormat(Semanticdb.Documentation.Format.JAVADOC).setMessage(doc).build();
        }
        catch (NullPointerException e) {
            return null;
        }
    }
}

