/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac;

import com.sourcegraph.semanticdb_javac.SemanticdbPlugin;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.NoRelativePathMode;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.TargetPaths;
import com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac.UriScheme;
import com.sun.source.util.JavacTask;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class SemanticdbJavacOptions {
    public Path targetroot;
    public Path sourceroot;
    public boolean includeText = false;
    public boolean verboseEnabled = false;
    public final ArrayList<String> errors;
    public boolean alreadyReportedErrors = false;
    public UriScheme uriScheme = UriScheme.DEFAULT;
    public NoRelativePathMode noRelativePath = NoRelativePathMode.INDEX_ANYWAY;
    public Path generatedTargetRoot;
    public static String JAVAC_CLASSES_DIR_ARG = "javac-classes-directory";

    public SemanticdbJavacOptions() {
        this.errors = new ArrayList();
    }

    public static String missingRequiredDirectoryOption(String option) {
        return String.format("missing argument '-%s'. To fix this problem, update the Java compiler option '-Xplugin:semanticdb -%s:DIRECTORY' where DIRECTORY is the path to a valid directory.", option, option);
    }

    public static SemanticdbJavacOptions parse(String[] args, JavacTask task) {
        SemanticdbJavacOptions result = new SemanticdbJavacOptions();
        boolean useJavacClassesDir = false;
        for (String arg : args) {
            if (arg.startsWith("-targetroot:")) {
                String argValue = arg.substring("-targetroot:".length());
                if (argValue.equals(JAVAC_CLASSES_DIR_ARG)) {
                    useJavacClassesDir = true;
                    result.targetroot = SemanticdbJavacOptions.getJavacClassesDir((SemanticdbJavacOptions)result, (JavacTask)task).classes;
                    continue;
                }
                result.targetroot = Paths.get(argValue, new String[0]);
                continue;
            }
            if (arg.startsWith("-sourceroot:")) {
                result.sourceroot = Paths.get(arg.substring("-sourceroot:".length()), new String[0]).normalize();
                continue;
            }
            if (arg.equals("-build-tool:sbt") || arg.equals("-build-tool:mill")) {
                result.uriScheme = UriScheme.ZINC;
                continue;
            }
            if (arg.startsWith("-no-relative-path:")) {
                String value;
                switch (value = arg.substring("-no-relative-path:".length())) {
                    case "index_anyway": {
                        result.noRelativePath = NoRelativePathMode.INDEX_ANYWAY;
                        break;
                    }
                    case "skip": {
                        result.noRelativePath = NoRelativePathMode.SKIP;
                        break;
                    }
                    case "error": {
                        result.noRelativePath = NoRelativePathMode.ERROR;
                        break;
                    }
                    case "warning": {
                        result.noRelativePath = NoRelativePathMode.WARNING;
                        break;
                    }
                    default: {
                        result.errors.add(String.format("unknown -no-relative-path mode '%s'. Valid values are %s.", value, NoRelativePathMode.validStringValues()));
                        break;
                    }
                }
                continue;
            }
            if (arg.equals("-build-tool:bazel")) {
                result.uriScheme = UriScheme.BAZEL;
                useJavacClassesDir = true;
                TargetPaths paths = SemanticdbJavacOptions.getJavacClassesDir(result, task);
                result.targetroot = paths.classes;
                result.generatedTargetRoot = paths.sources;
                continue;
            }
            if (arg.equals("-text:on")) {
                result.includeText = true;
                continue;
            }
            if (arg.equals("-text:off")) {
                result.includeText = false;
                continue;
            }
            if (arg.equals("-verbose")) {
                result.verboseEnabled = true;
                continue;
            }
            if (arg.equals("-verbose:on")) {
                result.verboseEnabled = true;
                continue;
            }
            if (arg.equals("-verbose:off")) {
                result.verboseEnabled = false;
                continue;
            }
            result.errors.add(String.format("unknown flag '%s'\n", arg));
        }
        if (result.targetroot == null && !useJavacClassesDir) {
            result.errors.add(SemanticdbJavacOptions.missingRequiredDirectoryOption("targetroot"));
        }
        if (!SemanticdbJavacOptions.isSourcerootDefined(result)) {
            result.errors.add(SemanticdbJavacOptions.missingRequiredDirectoryOption("sourceroot"));
        }
        return result;
    }

    private static boolean isSourcerootDefined(SemanticdbJavacOptions options) {
        if (options.uriScheme == UriScheme.BAZEL) {
            return true;
        }
        return options.sourceroot != null;
    }

    private static TargetPaths getJavacClassesDir(SemanticdbJavacOptions result, JavacTask task) {
        Path classOutputDir = null;
        Path sourceOutputDir = null;
        try {
            Method getContext = task.getClass().getMethod("getContext", new Class[0]);
            Object context = getContext.invoke((Object)task, new Object[0]);
            Method get = context.getClass().getMethod("get", Class.class);
            JavaFileManager fm = (JavaFileManager)get.invoke(context, JavaFileManager.class);
            JavaFileObject sourceOutputDirStub = fm.getJavaFileForOutput(StandardLocation.SOURCE_OUTPUT, SemanticdbPlugin.stubClassName, JavaFileObject.Kind.SOURCE, null);
            JavaFileObject clasSOutputDirStub = fm.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, SemanticdbPlugin.stubClassName, JavaFileObject.Kind.CLASS, null);
            classOutputDir = Paths.get(clasSOutputDirStub.toUri()).toAbsolutePath().getParent();
            sourceOutputDir = Paths.get(sourceOutputDirStub.toUri()).toAbsolutePath().getParent();
        }
        catch (Exception e) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(out));
            String errorMsg = String.format("exception while processing SemanticDB option '-targetroot:%s'\n%s", JAVAC_CLASSES_DIR_ARG, out.toString());
            result.errors.add(errorMsg);
        }
        return new TargetPaths(classOutputDir, sourceOutputDir);
    }
}

