/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.serialization.yaml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import korlibs.io.serialization.yaml.Yaml;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003&'(B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\b\u001a\u0004\u0018\u00010\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010\u0007\u001a\u0004\u0018\u00010\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0002J6\u0010\u0016\u001a\u0004\u0018\u00010\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\u001aH\u0002J\f\u0010\u001b\u001a\u00020\u0006*\u00020\u001aH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0006H\u0002J\f\u0010!\u001a\u00020\r*\u00020\"H\u0002J\f\u0010#\u001a\u00020\r*\u00020\u0006H\u0002J\f\u0010$\u001a\u00020\u0006*\u00020\u0006H\u0002J\f\u0010%\u001a\u00020\u0006*\u00020\u0006H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006)"}, d2={"Lkorlibs/io/serialization/yaml/Yaml;", "", "<init>", "()V", "decode", "str", "", "read", "parseStr", "toks", "", "Lkorlibs/io/serialization/yaml/Yaml$Token;", "TRACE", "", "EMPTY_SET", "", "SET_COMMA_END_ARRAY", "s", "Lkorlibs/io/serialization/yaml/Yaml$ListReader;", "level", "", "readId", "readOrString", "delimiters", "supportNonSpaceSymbols", "tokenize", "Lkorlibs/io/serialization/yaml/Yaml$StrReader;", "readUntilLineEnd", "invalidOp", "", "getInvalidOp", "()Ljava/lang/Void;", "msg", "isWhitespaceFast", "", "isQuoted", "unquote", "unescape", "Token", "ListReader", "StrReader", "korlibs-serialization-yaml"})
public final class Yaml {
    @NotNull
    public static final Yaml INSTANCE = new Yaml();
    public static final boolean TRACE = false;
    @NotNull
    private static final Set<String> EMPTY_SET = SetsKt.emptySet();
    @NotNull
    private static final Set<String> SET_COMMA_END_ARRAY;

    private Yaml() {
    }

    @Nullable
    public final Object decode(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return this.read(new ListReader<Token>(this.tokenize(str), null, 2, null), 0);
    }

    @Nullable
    public final Object read(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return this.read(new ListReader<Token>(this.tokenize(str), null, 2, null), 0);
    }

    private final Object parseStr(List<? extends Token> toks) {
        if (toks.size() == 1 && toks.get(0) instanceof Token.STR) {
            return toks.get(0).getUstr();
        }
        return this.parseStr(CollectionsKt.joinToString$default((Iterable)toks, (CharSequence)"", null, null, (int)0, null, Yaml::parseStr$lambda$0, (int)30, null));
    }

    private final Object parseStr(String str) {
        Object object;
        switch (str) {
            case "null": {
                object = null;
                break;
            }
            case "true": {
                object = true;
                break;
            }
            case "false": {
                object = false;
                break;
            }
            default: {
                object = StringsKt.toIntOrNull((String)str);
                if (object != null || (object = StringsKt.toDoubleOrNull((String)str)) != null) break;
                object = str;
            }
        }
        return object;
    }

    private final Object read(ListReader<Token> s, int level) {
        ArrayList<Object> arrayList;
        ListReader<Token> $this$read_u24lambda_u241 = s;
        boolean bl = false;
        ArrayList<Object> list = null;
        Object map = null;
        Object lastMapKey = null;
        Object lastMapValue = null;
        String levelStr = "";
        while (s.getHasMore()) {
            Token next;
            Object key;
            Token sp;
            Token.LINE line;
            Token token = s.peek();
            Token.LINE lINE = line = token instanceof Token.LINE ? (Token.LINE)token : null;
            Integer lineLevel = lINE != null ? Integer.valueOf(lINE.getLevel()) : null;
            if (lineLevel != null && lineLevel > level) {
                Object res = INSTANCE.read(s, lineLevel);
                if (list != null) {
                    list.add(res);
                    continue;
                }
                return res;
            }
            if (lineLevel != null && lineLevel < level) {
                break;
            }
            if (line != null) {
                s.read();
            }
            if (s.getEof()) break;
            Token item = s.peek();
            String string = item.getStr();
            if (Intrinsics.areEqual((Object)string, (Object)"-")) {
                if (!Intrinsics.areEqual((Object)s.read().getStr(), (Object)"-")) {
                    INSTANCE.getInvalidOp();
                    throw new KotlinNothingValueException();
                }
                if (list == null) {
                    list = new ArrayList<Object>();
                    if (map != null && lastMapKey != null && lastMapValue == null) {
                        map.put(lastMapKey, list);
                    }
                }
                Object res = INSTANCE.read(s, level + 1);
                list.add(res);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)"[")) {
                if (!Intrinsics.areEqual((Object)s.read().getStr(), (Object)"[")) {
                    INSTANCE.getInvalidOp();
                    throw new KotlinNothingValueException();
                }
                ArrayList olist = new ArrayList();
                while (!Intrinsics.areEqual((Object)s.peek().getStr(), (Object)"]")) {
                    String p;
                    ((Collection)olist).add(INSTANCE.readOrString(s, level, SET_COMMA_END_ARRAY, false));
                    String string2 = p = s.peek().getStr();
                    if (Intrinsics.areEqual((Object)string2, (Object)",")) {
                        s.read();
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)string2, (Object)"]")) break;
                    INSTANCE.invalidOp("Unexpected '" + p + '\'');
                    throw new KotlinNothingValueException();
                }
                if (!Intrinsics.areEqual((Object)s.read().getStr(), (Object)"]")) {
                    INSTANCE.getInvalidOp();
                    throw new KotlinNothingValueException();
                }
                return olist;
            }
            List<Token> keyIds = INSTANCE.readId(s);
            Token token2 = s.peekOrNull();
            if (token2 == null) {
                token2 = sp = (Token)Token.EOF.INSTANCE;
            }
            if (s.getEof() || !Intrinsics.areEqual((Object)sp.getStr(), (Object)":") || sp instanceof Token.SYMBOL && !((Token.SYMBOL)sp).isNextWhite()) {
                key = INSTANCE.parseStr(keyIds);
                return key;
            }
            key = String.valueOf(INSTANCE.parseStr(keyIds));
            if (map == null) {
                map = new LinkedHashMap();
            }
            if (!Intrinsics.areEqual((Object)s.read().getStr(), (Object)":")) {
                INSTANCE.getInvalidOp();
                throw new KotlinNothingValueException();
            }
            Token token3 = next = s.peekOrNull();
            String nextStr = token3 != null ? token3.getStr() : null;
            boolean hasSpaces = next instanceof Token.SYMBOL && ((Token.SYMBOL)next).isNextWhite();
            boolean nextIsSpecialSymbol = Intrinsics.areEqual((Object)nextStr, (Object)"[") || Intrinsics.areEqual((Object)nextStr, (Object)"{") || Intrinsics.areEqual((Object)nextStr, (Object)"-") && hasSpaces;
            Object value = INSTANCE.readOrString(s, level, EMPTY_SET, !nextIsSpecialSymbol);
            lastMapKey = key;
            lastMapValue = value;
            map.put(key, value);
            list = null;
        }
        if ((arrayList = map) == null) {
            arrayList = list;
        }
        return arrayList;
    }

    private final List<Token> readId(ListReader<Token> $this$readId) {
        Token token;
        ArrayList<Token> tokens = new ArrayList<Token>();
        while ($this$readId.getHasMore() && ((token = $this$readId.peek()) instanceof Token.ID || token instanceof Token.STR || token instanceof Token.SYMBOL && Intrinsics.areEqual((Object)((Token.SYMBOL)token).getStr(), (Object)"-") || token instanceof Token.SYMBOL && Intrinsics.areEqual((Object)((Token.SYMBOL)token).getStr(), (Object)":") && !((Token.SYMBOL)token).isNextWhite())) {
            tokens.add(token);
            $this$readId.read();
        }
        return tokens;
    }

    private final Object readOrString(ListReader<Token> s, int level, Set<String> delimiters, boolean supportNonSpaceSymbols) {
        Object object;
        Token sp = s.peek();
        if (sp instanceof Token.ID || supportNonSpaceSymbols && sp instanceof Token.SYMBOL && !((Token.SYMBOL)sp).isNextWhite()) {
            Token p;
            String str = "";
            while (s.getHasMore() && !((p = s.peek()) instanceof Token.LINE) && !delimiters.contains(p.getStr())) {
                str = str + s.read().getStr();
            }
            object = this.parseStr(str);
        } else {
            object = this.read(s, level + 1);
        }
        return object;
    }

    @NotNull
    public final List<Token> tokenize(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return this.tokenize(new StrReader(StringsKt.replace$default((String)str, (String)"\r\n", (String)"\n", (boolean)false, (int)4, null), 0, 2, null));
    }

    private final List<Token> tokenize(StrReader $this$tokenize) {
        ArrayList<Token> out = new ArrayList<Token>();
        StrReader s = $this$tokenize;
        Ref.ObjectRef str = new Ref.ObjectRef();
        str.element = "";
        ArrayList indents = new ArrayList();
        block0: while ($this$tokenize.getHasMore()) {
            Yaml.tokenize$flush((Ref.ObjectRef<String>)str, out);
            String indentStr2 = StringsKt.replace$default((String)$this$tokenize.readWhile((Function1<? super Character, Boolean>)((Function1)tokenize.indentStr.1.INSTANCE)), (String)"\t", (String)"     ", (boolean)false, (int)4, null);
            if (StringsKt.contains$default((CharSequence)indentStr2, (char)'\n', (boolean)false, (int)2, null)) continue;
            int indent = indentStr2.length();
            if (indents.isEmpty() || indent > ((Number)CollectionsKt.last((List)indents)).intValue()) {
                Integer n = indent;
                ((Collection)indents).add(n);
            } else {
                while (!((Collection)indents).isEmpty() && indent < ((Number)CollectionsKt.last((List)indents)).intValue()) {
                    indents.remove(indents.size() - 1);
                }
                if (indents.isEmpty()) {
                    this.getInvalidOp();
                    throw new KotlinNothingValueException();
                }
            }
            int indentLevel = indents.size() - 1;
            while (!((Collection)out).isEmpty() && CollectionsKt.last((List)out) instanceof Token.LINE) {
                out.remove(out.size() - 1);
            }
            ((Collection)out).add(new Token.LINE(indentStr2, indentLevel));
            while ($this$tokenize.getHasMore()) {
                char c = $this$tokenize.read();
                char c2 = c;
                if (c2 == ':' || c2 == '-' || c2 == '[' || c2 == ']' || c2 == ',') {
                    Yaml.tokenize$flush((Ref.ObjectRef<String>)str, out);
                    ((Collection)out).add(new Token.SYMBOL(String.valueOf(c), $this$tokenize.peekChar()));
                    continue;
                }
                if (c2 == '#') {
                    Character c3 = StringsKt.lastOrNull((CharSequence)((CharSequence)str.element));
                    boolean bl = c3 != null ? this.isWhitespaceFast(c3.charValue()) : false;
                    if (bl || Intrinsics.areEqual((Object)str.element, (Object)"") && CollectionsKt.lastOrNull((List)out) instanceof Token.LINE) {
                        Yaml.tokenize$flush((Ref.ObjectRef<String>)str, out);
                        this.readUntilLineEnd($this$tokenize);
                        $this$tokenize.skip();
                        continue block0;
                    }
                    str.element = (String)str.element + c;
                    continue;
                }
                if (c2 == '\n') {
                    Yaml.tokenize$flush((Ref.ObjectRef<String>)str, out);
                    continue block0;
                }
                if (c2 == '\"' || c2 == '\'') {
                    Yaml.tokenize$flush((Ref.ObjectRef<String>)str, out);
                    Token last = (Token)CollectionsKt.lastOrNull((List)out);
                    if (last instanceof Token.SYMBOL && (Intrinsics.areEqual((Object)((Token.SYMBOL)last).getStr(), (Object)":") || Intrinsics.areEqual((Object)((Token.SYMBOL)last).getStr(), (Object)"[") || Intrinsics.areEqual((Object)((Token.SYMBOL)last).getStr(), (Object)"{") || Intrinsics.areEqual((Object)((Token.SYMBOL)last).getStr(), (Object)",") || Intrinsics.areEqual((Object)((Token.SYMBOL)last).getStr(), (Object)"-"))) {
                        s.unread();
                        ((Collection)out).add(new Token.STR(StrReader.readStringLit$default(s, false, 1, null)));
                        continue;
                    }
                    str.element = (String)str.element + c;
                    continue;
                }
                str.element = (String)str.element + c;
            }
        }
        Yaml.tokenize$flush((Ref.ObjectRef<String>)str, out);
        return out;
    }

    private final String readUntilLineEnd(StrReader $this$readUntilLineEnd) {
        return $this$readUntilLineEnd.readUntil((Function1<? super Character, Boolean>)((Function1)Yaml::readUntilLineEnd$lambda$2));
    }

    private final Void getInvalidOp() {
        throw new RuntimeException();
    }

    private final Void invalidOp(String msg) {
        throw new RuntimeException(msg);
    }

    private final boolean isWhitespaceFast(char $this$isWhitespaceFast) {
        return $this$isWhitespaceFast == ' ' || $this$isWhitespaceFast == '\t' || $this$isWhitespaceFast == '\r' || $this$isWhitespaceFast == '\n';
    }

    private final boolean isQuoted(String $this$isQuoted) {
        return StringsKt.startsWith$default((CharSequence)$this$isQuoted, (char)'\"', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)$this$isQuoted, (char)'\"', (boolean)false, (int)2, null);
    }

    private final String unquote(String $this$unquote) {
        String string;
        if (this.isQuoted($this$unquote)) {
            String string2 = $this$unquote.substring(1, $this$unquote.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            string = this.unescape(string2);
        } else {
            string = $this$unquote;
        }
        return string;
    }

    private final String unescape(String $this$unescape) {
        StringBuilder out = new StringBuilder($this$unescape.length());
        int n = 0;
        while (n < $this$unescape.length()) {
            StringBuilder stringBuilder;
            char c;
            if ((c = $this$unescape.charAt(n++)) == '\\') {
                char c2;
                char c3;
                if ((c3 = (c2 = $this$unescape.charAt(n++))) == '\\') {
                    stringBuilder = out.append('\\');
                    continue;
                }
                if (c3 == '\"') {
                    stringBuilder = out.append('\"');
                    continue;
                }
                if (c3 == 'n') {
                    stringBuilder = out.append('\n');
                    continue;
                }
                if (c3 == 'r') {
                    stringBuilder = out.append('\r');
                    continue;
                }
                if (c3 == 't') {
                    stringBuilder = out.append('\t');
                    continue;
                }
                if (c3 == 'x' || c3 == 'u') {
                    String chars;
                    int N = c2 == 'u' ? 4 : 2;
                    Intrinsics.checkNotNullExpressionValue((Object)$this$unescape.substring(n, n + N), (String)"substring(...)");
                    n += N;
                    stringBuilder = out.append((char)Integer.parseInt(chars, CharsKt.checkRadix((int)16)));
                    continue;
                }
                stringBuilder = out.append("" + '\\' + c2);
                continue;
            }
            stringBuilder = out.append(c);
        }
        String string = out.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final CharSequence parseStr$lambda$0(Token it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getUstr();
    }

    private static final void tokenize$flush(Ref.ObjectRef<String> str, ArrayList<Token> out) {
        if (!StringsKt.isBlank((CharSequence)((CharSequence)str.element)) && ((CharSequence)str.element).length() > 0) {
            ((Collection)out).add(new Token.ID(((Object)StringsKt.trim((CharSequence)((String)str.element))).toString()));
            str.element = "";
        }
    }

    private static final boolean readUntilLineEnd$lambda$2(char it) {
        return it == '\n';
    }

    static {
        Object[] objectArray = new String[]{",", "]"};
        SET_COMMA_END_ARRAY = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001 B!\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\u0019\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u001c\u001a\u00020\u000eJ\u000b\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006!"}, d2={"Lkorlibs/io/serialization/yaml/Yaml$ListReader;", "T", "", "list", "", "ctx", "<init>", "(Ljava/util/List;Ljava/lang/Object;)V", "getList", "()Ljava/util/List;", "getCtx", "()Ljava/lang/Object;", "Ljava/lang/Object;", "position", "", "getPosition", "()I", "setPosition", "(I)V", "eof", "", "getEof", "()Z", "hasMore", "getHasMore", "peekOrNull", "peek", "skip", "count", "read", "toString", "", "OutOfBoundsException", "korlibs-serialization-yaml"})
    @SourceDebugExtension(value={"SMAP\nYaml.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Yaml.kt\nkorlibs/io/serialization/yaml/Yaml$ListReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,364:1\n1#2:365\n*E\n"})
    private static final class ListReader<T> {
        @NotNull
        private final List<T> list;
        @Nullable
        private final T ctx;
        private int position;

        public ListReader(@NotNull List<? extends T> list, @Nullable T ctx) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            this.list = list;
            this.ctx = ctx;
        }

        public /* synthetic */ ListReader(List list, Object object, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                object = null;
            }
            this(list, object);
        }

        @NotNull
        public final List<T> getList() {
            return this.list;
        }

        @Nullable
        public final T getCtx() {
            return this.ctx;
        }

        public final int getPosition() {
            return this.position;
        }

        public final void setPosition(int n) {
            this.position = n;
        }

        public final boolean getEof() {
            return this.position >= this.list.size();
        }

        public final boolean getHasMore() {
            return this.position < this.list.size();
        }

        @Nullable
        public final T peekOrNull() {
            return (T)CollectionsKt.getOrNull(this.list, (int)this.position);
        }

        public final T peek() {
            Object object = CollectionsKt.getOrNull(this.list, (int)this.position);
            if (object == null) {
                throw new OutOfBoundsException(this, this.position);
            }
            return (T)object;
        }

        @NotNull
        public final ListReader<T> skip(int count) {
            ListReader listReader;
            ListReader $this$skip_u24lambda_u240 = listReader = this;
            boolean bl = false;
            $this$skip_u24lambda_u240.position += count;
            return listReader;
        }

        public static /* synthetic */ ListReader skip$default(ListReader listReader, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return listReader.skip(n);
        }

        public final T read() {
            T t;
            T $this$read_u24lambda_u241 = t = this.peek();
            boolean bl = false;
            this.skip(1);
            return t;
        }

        @NotNull
        public String toString() {
            return "ListReader(" + this.list + ')';
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00060\u0002j\u0002`\u0001B\u001b\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lkorlibs/io/serialization/yaml/Yaml$ListReader$OutOfBoundsException;", "Lkotlin/RuntimeException;", "Ljava/lang/RuntimeException;", "list", "Lkorlibs/io/serialization/yaml/Yaml$ListReader;", "pos", "", "<init>", "(Lkorlibs/io/serialization/yaml/Yaml$ListReader;I)V", "getList", "()Lkorlibs/io/serialization/yaml/Yaml$ListReader;", "getPos", "()I", "korlibs-serialization-yaml"})
        public static final class OutOfBoundsException
        extends RuntimeException {
            @NotNull
            private final ListReader<?> list;
            private final int pos;

            public OutOfBoundsException(@NotNull ListReader<?> list, int pos) {
                Intrinsics.checkNotNullParameter(list, (String)"list");
                this.list = list;
                this.pos = pos;
            }

            @NotNull
            public final ListReader<?> getList() {
                return this.list;
            }

            public final int getPos() {
                return this.pos;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00110\u0017H\u0086\b\u00f8\u0001\u0000J\u001a\u0010\u0019\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00110\u0017J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u0006\u0010\u001c\u001a\u00020\u0000J\u0006\u0010\u001d\u001a\u00020\u0018J\u0006\u0010\u001e\u001a\u00020\u0018J\u0006\u0010\u001f\u001a\u00020\u0018J\u0006\u0010 \u001a\u00020\u0000J\u0018\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00052\b\b\u0002\u0010#\u001a\u00020\u0005J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0005J\u000e\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0005J\u000e\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0005J\u0017\u0010$\u001a\u00020\u00032\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00150&H\u0082\bJ\u001a\u0010'\u001a\u00020\u00032\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00110\u0017J\u001a\u0010(\u001a\u00020\u00032\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00110\u0017J\u0010\u0010)\u001a\u00020\u00032\b\b\u0002\u0010*\u001a\u00020\u0011J\b\u0010+\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006,"}, d2={"Lkorlibs/io/serialization/yaml/Yaml$StrReader;", "", "str", "", "pos", "", "<init>", "(Ljava/lang/String;I)V", "getStr", "()Ljava/lang/String;", "getPos", "()I", "setPos", "(I)V", "length", "getLength", "hasMore", "", "getHasMore", "()Z", "skipWhile", "", "f", "Lkotlin/Function1;", "", "skipUntil", "posSkip", "count", "skip", "peek", "peekChar", "read", "unread", "substr", "start", "len", "readBlock", "callback", "Lkotlin/Function0;", "readWhile", "readUntil", "readStringLit", "reportErrors", "toString", "korlibs-serialization-yaml"})
    @SourceDebugExtension(value={"SMAP\nYaml.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Yaml.kt\nkorlibs/io/serialization/yaml/Yaml$StrReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,364:1\n258#1:365\n285#1,2:367\n258#1:369\n287#1,2:370\n285#1,4:372\n1#2:366\n*S KotlinDebug\n*F\n+ 1 Yaml.kt\nkorlibs/io/serialization/yaml/Yaml$StrReader\n*L\n259#1:365\n291#1:367,2\n291#1:369\n291#1:370,2\n292#1:372,4\n*E\n"})
    private static final class StrReader {
        @NotNull
        private final String str;
        private int pos;

        public StrReader(@NotNull String str, int pos) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            this.str = str;
            this.pos = pos;
        }

        public /* synthetic */ StrReader(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            this(string, n);
        }

        @NotNull
        public final String getStr() {
            return this.str;
        }

        public final int getPos() {
            return this.pos;
        }

        public final void setPos(int n) {
            this.pos = n;
        }

        public final int getLength() {
            return this.str.length();
        }

        public final boolean getHasMore() {
            return this.pos < this.getLength();
        }

        public final void skipWhile(@NotNull Function1<? super Character, Boolean> f) {
            Intrinsics.checkNotNullParameter(f, (String)"f");
            boolean $i$f$skipWhile = false;
            while (this.getHasMore() && ((Boolean)f.invoke((Object)Character.valueOf(this.peek()))).booleanValue()) {
                this.skip();
            }
        }

        public final void skipUntil(@NotNull Function1<? super Character, Boolean> f) {
            Intrinsics.checkNotNullParameter(f, (String)"f");
            StrReader this_$iv = this;
            boolean $i$f$skipWhile = false;
            while (this_$iv.getHasMore()) {
                char it = this_$iv.peek();
                boolean bl = false;
                if (!((Boolean)f.invoke((Object)Character.valueOf(it)) == false)) break;
                this_$iv.skip();
            }
        }

        private final int posSkip(int count) {
            int out = this.pos;
            this.pos += count;
            return out;
        }

        @NotNull
        public final StrReader skip() {
            return this.skip(1);
        }

        public final char peek() {
            return this.getHasMore() ? this.str.charAt(this.pos) : (char)'\u0000';
        }

        public final char peekChar() {
            return this.peek();
        }

        public final char read() {
            return this.getHasMore() ? this.str.charAt(this.posSkip(1)) : (char)'\u0000';
        }

        @NotNull
        public final StrReader unread() {
            return this.skip(-1);
        }

        @NotNull
        public final String substr(int start, int len) {
            int start2 = RangesKt.coerceIn((int)start, (int)0, (int)this.getLength());
            int end = RangesKt.coerceIn((int)(start2 + len), (int)0, (int)this.getLength());
            String string = this.str.substring(start2, end);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }

        public static /* synthetic */ String substr$default(StrReader strReader, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = strReader.getLength() - strReader.pos;
            }
            return strReader.substr(n, n2);
        }

        @NotNull
        public final StrReader skip(int count) {
            StrReader strReader;
            StrReader $this$skip_u24lambda_u241 = strReader = this;
            boolean bl = false;
            $this$skip_u24lambda_u241.pos += count;
            return strReader;
        }

        @NotNull
        public final String peek(int count) {
            return this.substr(this.pos, count);
        }

        @NotNull
        public final String read(int count) {
            String string;
            String it = string = this.peek(count);
            boolean bl = false;
            this.skip(count);
            return string;
        }

        private final String readBlock(Function0<Unit> callback) {
            boolean $i$f$readBlock = false;
            int start = this.pos;
            callback.invoke();
            int end = this.pos;
            return this.substr(start, end - start);
        }

        @NotNull
        public final String readWhile(@NotNull Function1<? super Character, Boolean> f) {
            Intrinsics.checkNotNullParameter(f, (String)"f");
            StrReader this_$iv = this;
            boolean $i$f$readBlock = false;
            int start$iv = this_$iv.pos;
            boolean bl = false;
            StrReader this_$iv2 = this;
            boolean $i$f$skipWhile = false;
            while (this_$iv2.getHasMore() && ((Boolean)f.invoke((Object)Character.valueOf(this_$iv2.peek()))).booleanValue()) {
                this_$iv2.skip();
            }
            int end$iv = this_$iv.pos;
            return this_$iv.substr(start$iv, end$iv - start$iv);
        }

        @NotNull
        public final String readUntil(@NotNull Function1<? super Character, Boolean> f) {
            Intrinsics.checkNotNullParameter(f, (String)"f");
            StrReader this_$iv = this;
            boolean $i$f$readBlock = false;
            int start$iv = this_$iv.pos;
            boolean bl = false;
            this.skipUntil(f);
            int end$iv = this_$iv.pos;
            return this_$iv.substr(start$iv, end$iv - start$iv);
        }

        @NotNull
        public final String readStringLit(boolean reportErrors) {
            StringBuilder out = new StringBuilder();
            char quotec = this.read();
            char c = quotec;
            if (c != '\"' && c != '\'') {
                throw new RuntimeException("Invalid string literal");
            }
            boolean closed = false;
            while (this.getHasMore()) {
                StringBuilder stringBuilder;
                char c2 = this.read();
                if (c2 == '\\') {
                    char c3;
                    char cc = this.read();
                    char c4 = cc;
                    if (c4 == '\\') {
                        c3 = 92;
                    } else if (c4 == '/') {
                        c3 = 47;
                    } else if (c4 == '\'') {
                        c3 = 39;
                    } else if (c4 == '\"') {
                        c3 = 34;
                    } else if (c4 == 'b') {
                        c3 = 8;
                    } else if (c4 == 'f') {
                        c3 = 12;
                    } else if (c4 == 'n') {
                        c3 = 10;
                    } else if (c4 == 'r') {
                        c3 = 13;
                    } else if (c4 == 't') {
                        c3 = 9;
                    } else if (c4 == 'u') {
                        c3 = (char)Integer.parseInt(this.read(4), CharsKt.checkRadix((int)16));
                    } else {
                        throw new RuntimeException("Invalid char '" + cc + '\'');
                    }
                    stringBuilder = out.append(c3);
                    continue;
                }
                if (c2 == quotec) {
                    closed = true;
                    break;
                }
                stringBuilder = out.append(c2);
            }
            if (!closed && reportErrors) {
                throw new RuntimeException("String literal not closed! '" + this.str + '\'');
            }
            String string = out.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public static /* synthetic */ String readStringLit$default(StrReader strReader, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = true;
            }
            return strReader.readStringLit(bl);
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("StrReader(str=").append(this.str.length()).append(", pos=").append(this.pos).append(", range='");
            String string = this.str.substring(RangesKt.coerceIn((int)this.pos, (ClosedRange)((ClosedRange)StringsKt.getIndices((CharSequence)this.str))), RangesKt.coerceIn((int)(this.pos + 10), (ClosedRange)((ClosedRange)StringsKt.getIndices((CharSequence)this.str))));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return stringBuilder.append(StringsKt.replace$default((String)string, (String)"\n", (String)"\\n", (boolean)false, (int)4, null)).append("')").toString();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\bf\u0018\u00002\u00020\u0001:\u0005\b\t\n\u000b\fR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006\r"}, d2={"Lkorlibs/io/serialization/yaml/Yaml$Token;", "", "str", "", "getStr", "()Ljava/lang/String;", "ustr", "getUstr", "EOF", "LINE", "ID", "STR", "SYMBOL", "korlibs-serialization-yaml"})
    public static interface Token {
        @NotNull
        public String getStr();

        @NotNull
        public String getUstr();

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @NotNull
            public static String getUstr(@NotNull Token $this) {
                return $this.getStr();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lkorlibs/io/serialization/yaml/Yaml$Token$EOF;", "Lkorlibs/io/serialization/yaml/Yaml$Token;", "<init>", "()V", "str", "", "getStr", "()Ljava/lang/String;", "korlibs-serialization-yaml"})
        public static final class EOF
        implements Token {
            @NotNull
            public static final EOF INSTANCE = new EOF();
            @NotNull
            private static final String str = "";

            private EOF() {
            }

            @Override
            @NotNull
            public String getStr() {
                return str;
            }

            @Override
            @NotNull
            public String getUstr() {
                return DefaultImpls.getUstr(this);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lkorlibs/io/serialization/yaml/Yaml$Token$ID;", "Lkorlibs/io/serialization/yaml/Yaml$Token;", "str", "", "<init>", "(Ljava/lang/String;)V", "getStr", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "korlibs-serialization-yaml"})
        public static final class ID
        implements Token {
            @NotNull
            private final String str;

            public ID(@NotNull String str) {
                Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                this.str = str;
            }

            @Override
            @NotNull
            public String getStr() {
                return this.str;
            }

            @NotNull
            public final String component1() {
                return this.str;
            }

            @NotNull
            public final ID copy(@NotNull String str) {
                Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                return new ID(str);
            }

            public static /* synthetic */ ID copy$default(ID iD, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = iD.str;
                }
                return iD.copy(string);
            }

            @NotNull
            public String toString() {
                return "ID(str=" + this.str + ')';
            }

            public int hashCode() {
                return this.str.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ID)) {
                    return false;
                }
                ID iD = (ID)other;
                return Intrinsics.areEqual((Object)this.str, (Object)iD.str);
            }

            @Override
            @NotNull
            public String getUstr() {
                return DefaultImpls.getUstr(this);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u0003H\u0016J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lkorlibs/io/serialization/yaml/Yaml$Token$LINE;", "Lkorlibs/io/serialization/yaml/Yaml$Token;", "str", "", "level", "", "<init>", "(Ljava/lang/String;I)V", "getStr", "()Ljava/lang/String;", "getLevel", "()I", "toString", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "korlibs-serialization-yaml"})
        public static final class LINE
        implements Token {
            @NotNull
            private final String str;
            private final int level;

            public LINE(@NotNull String str, int level) {
                Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                this.str = str;
                this.level = level;
            }

            @Override
            @NotNull
            public String getStr() {
                return this.str;
            }

            public final int getLevel() {
                return this.level;
            }

            @NotNull
            public String toString() {
                return "LINE(" + this.level + ')';
            }

            @NotNull
            public final String component1() {
                return this.str;
            }

            public final int component2() {
                return this.level;
            }

            @NotNull
            public final LINE copy(@NotNull String str, int level) {
                Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                return new LINE(str, level);
            }

            public static /* synthetic */ LINE copy$default(LINE lINE, String string, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    string = lINE.str;
                }
                if ((n2 & 2) != 0) {
                    n = lINE.level;
                }
                return lINE.copy(string, n);
            }

            public int hashCode() {
                int result = this.str.hashCode();
                result = result * 31 + Integer.hashCode(this.level);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LINE)) {
                    return false;
                }
                LINE lINE = (LINE)other;
                if (!Intrinsics.areEqual((Object)this.str, (Object)lINE.str)) {
                    return false;
                }
                return this.level == lINE.level;
            }

            @Override
            @NotNull
            public String getUstr() {
                return DefaultImpls.getUstr(this);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lkorlibs/io/serialization/yaml/Yaml$Token$STR;", "Lkorlibs/io/serialization/yaml/Yaml$Token;", "str", "", "<init>", "(Ljava/lang/String;)V", "getStr", "()Ljava/lang/String;", "ustr", "getUstr", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "korlibs-serialization-yaml"})
        public static final class STR
        implements Token {
            @NotNull
            private final String str;
            @NotNull
            private final String ustr;

            public STR(@NotNull String str) {
                Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                this.str = str;
                this.ustr = INSTANCE.unquote(this.getStr());
            }

            @Override
            @NotNull
            public String getStr() {
                return this.str;
            }

            @Override
            @NotNull
            public String getUstr() {
                return this.ustr;
            }

            @NotNull
            public final String component1() {
                return this.str;
            }

            @NotNull
            public final STR copy(@NotNull String str) {
                Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                return new STR(str);
            }

            public static /* synthetic */ STR copy$default(STR sTR, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = sTR.str;
                }
                return sTR.copy(string);
            }

            @NotNull
            public String toString() {
                return "STR(str=" + this.str + ')';
            }

            public int hashCode() {
                return this.str.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof STR)) {
                    return false;
                }
                STR sTR = (STR)other;
                return Intrinsics.areEqual((Object)this.str, (Object)sTR.str);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lkorlibs/io/serialization/yaml/Yaml$Token$SYMBOL;", "Lkorlibs/io/serialization/yaml/Yaml$Token;", "str", "", "next", "", "<init>", "(Ljava/lang/String;C)V", "getStr", "()Ljava/lang/String;", "getNext", "()C", "isNextWhite", "", "()Z", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "korlibs-serialization-yaml"})
        public static final class SYMBOL
        implements Token {
            @NotNull
            private final String str;
            private final char next;

            public SYMBOL(@NotNull String str, char next) {
                Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                this.str = str;
                this.next = next;
            }

            @Override
            @NotNull
            public String getStr() {
                return this.str;
            }

            public final char getNext() {
                return this.next;
            }

            public final boolean isNextWhite() {
                return this.next == ' ' || this.next == '\t' || this.next == '\n' || this.next == '\r';
            }

            @NotNull
            public final String component1() {
                return this.str;
            }

            public final char component2() {
                return this.next;
            }

            @NotNull
            public final SYMBOL copy(@NotNull String str, char next) {
                Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                return new SYMBOL(str, next);
            }

            public static /* synthetic */ SYMBOL copy$default(SYMBOL sYMBOL, String string, char c, int n, Object object) {
                if ((n & 1) != 0) {
                    string = sYMBOL.str;
                }
                if ((n & 2) != 0) {
                    c = sYMBOL.next;
                }
                return sYMBOL.copy(string, c);
            }

            @NotNull
            public String toString() {
                return "SYMBOL(str=" + this.str + ", next=" + this.next + ')';
            }

            public int hashCode() {
                int result = this.str.hashCode();
                result = result * 31 + Character.hashCode(this.next);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SYMBOL)) {
                    return false;
                }
                SYMBOL sYMBOL = (SYMBOL)other;
                if (!Intrinsics.areEqual((Object)this.str, (Object)sYMBOL.str)) {
                    return false;
                }
                return this.next == sYMBOL.next;
            }

            @Override
            @NotNull
            public String getUstr() {
                return DefaultImpls.getUstr(this);
            }
        }
    }
}

