package korlibs.util

private val formatRegex = Regex("%([-]?\\d+)?(\\w)")

fun String.format(vararg params: Any): String {
    var paramIndex = 0
    return formatRegex.replace(this) { mr ->
        val param = params[paramIndex++]
        //println("param: $param")
        val size = mr.groupValues[1]
        val type = mr.groupValues[2]
        val str = when (type) {
            "d" -> (param as Number).toLong().toString()
            "X", "x" -> {
                val res = when (param) {
                    is Int -> param.toUInt().toString(16)
                    else -> (param as Number).toLong().toULong().toString(16)
                }
                if (type == "X") res.uppercase() else res.lowercase()
            }
            else -> "$param"
        }
        val prefix = if (size.startsWith('0')) '0' else ' '
        val asize = size.toIntOrNull()
        var str2 = str
        if (asize != null) {
            while (str2.length < asize) {
                str2 = prefix + str2
            }
        }
        str2
    }
}
