/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.kds;

import com.soywiz.kds.RingBuffer;
import com.soywiz.kds.internal.InternalKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u0005\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0013\u0010\"\u001a\u00020\u00052\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010$\u001a\u00020\u0003H\u0016J$\u0010\u0015\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u001b2\b\b\u0002\u0010&\u001a\u00020\u00032\b\b\u0002\u0010'\u001a\u00020\u0003H\u0007J\u0006\u0010(\u001a\u00020\u0003J\u0006\u0010)\u001a\u00020*J$\u0010+\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u001b2\b\b\u0002\u0010&\u001a\u00020\u00032\b\b\u0002\u0010'\u001a\u00020\u0003H\u0007J\u000e\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u0003J$\u0010.\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u001b2\b\b\u0002\u0010&\u001a\u00020\u00032\b\b\u0002\u0010'\u001a\u00020\u0003H\u0007J\u000e\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u00020*R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\bR\u0011\u0010\u0010\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000bR\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017\u00a8\u00061"}, d2={"Lcom/soywiz/kds/ByteArrayDeque;", "", "initialBits", "", "allowGrow", "", "(IZ)V", "getAllowGrow", "()Z", "availableRead", "getAvailableRead", "()I", "availableWriteWithoutAllocating", "getAvailableWriteWithoutAllocating", "hasMoreToRead", "getHasMoreToRead", "hasMoreToWrite", "getHasMoreToWrite", "getInitialBits", "<set-?>", "", "read", "getRead", "()J", "ring", "Lcom/soywiz/kds/RingBuffer;", "tempBuffer", "", "written", "getWritten", "clear", "", "ensureWrite", "count", "equals", "other", "hashCode", "buffer", "offset", "size", "readByte", "readOne", "", "write", "writeByte", "v", "writeHead", "writeOne", "value", "kds_release"})
public final class ByteArrayDeque {
    private final int initialBits;
    private final boolean allowGrow;
    @NotNull
    private RingBuffer ring;
    @NotNull
    private final byte[] tempBuffer;
    private long written;
    private long read;

    public ByteArrayDeque(int initialBits, boolean allowGrow) {
        this.initialBits = initialBits;
        this.allowGrow = allowGrow;
        this.ring = new RingBuffer(this.initialBits);
        this.tempBuffer = new byte[1024];
    }

    public /* synthetic */ ByteArrayDeque(int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        if ((n2 & 2) != 0) {
            bl = true;
        }
        this(n, bl);
    }

    public final int getInitialBits() {
        return this.initialBits;
    }

    public final boolean getAllowGrow() {
        return this.allowGrow;
    }

    public final long getWritten() {
        return this.written;
    }

    public final long getRead() {
        return this.read;
    }

    public final int getAvailableWriteWithoutAllocating() {
        return this.ring.getAvailableWrite();
    }

    public final int getAvailableRead() {
        return this.ring.getAvailableRead();
    }

    @JvmOverloads
    public final int writeHead(@NotNull byte[] buffer, int offset, int size) {
        int out = this.ensureWrite((int)size).ring.writeHead(buffer, offset, size);
        if (out > 0) {
            ByteArrayDeque byteArrayDeque = this;
            byteArrayDeque.written += (long)out;
        }
        return out;
    }

    public static /* synthetic */ int writeHead$default(ByteArrayDeque byteArrayDeque, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length - n;
        }
        return byteArrayDeque.writeHead(byArray, n, n2);
    }

    @JvmOverloads
    public final int write(@NotNull byte[] buffer, int offset, int size) {
        int out = this.ensureWrite((int)size).ring.write(buffer, offset, size);
        if (out > 0) {
            ByteArrayDeque byteArrayDeque = this;
            byteArrayDeque.written += (long)out;
        }
        return out;
    }

    public static /* synthetic */ int write$default(ByteArrayDeque byteArrayDeque, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length - n;
        }
        return byteArrayDeque.write(byArray, n, n2);
    }

    @JvmOverloads
    public final int read(@NotNull byte[] buffer, int offset, int size) {
        int out = this.ring.read(buffer, offset, size);
        if (out > 0) {
            ByteArrayDeque byteArrayDeque = this;
            byteArrayDeque.read += (long)out;
        }
        return out;
    }

    public static /* synthetic */ int read$default(ByteArrayDeque byteArrayDeque, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length - n;
        }
        return byteArrayDeque.read(byArray, n, n2);
    }

    public final int readByte() {
        return this.ring.readByte();
    }

    public final boolean writeByte(int v) {
        return this.ensureWrite((int)1).ring.writeByte(v);
    }

    private final ByteArrayDeque ensureWrite(int count) {
        if (count > this.ring.getAvailableWrite()) {
            if (!this.allowGrow) {
                String message = "Can't grow ByteArrayDeque. Need to write " + count + ", but only " + this.ring.getAvailableWrite() + " is available";
                String string = Intrinsics.stringPlus((String)"ERROR: ", (Object)message);
                boolean bl = false;
                System.out.println((Object)string);
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(message.toString());
            }
            int minNewSize = this.ring.getAvailableRead() + count;
            int newBits = InternalKt.ilog2(minNewSize) + 2;
            RingBuffer newRing = new RingBuffer(newBits);
            while (this.ring.getAvailableRead() > 0) {
                int read = this.ring.read(this.tempBuffer, 0, this.tempBuffer.length);
                newRing.write(this.tempBuffer, 0, read);
            }
            this.ring = newRing;
        }
        return this;
    }

    public final void clear() {
        this.ring.clear();
    }

    public final boolean getHasMoreToWrite() {
        return this.ring.getAvailableWrite() > 0;
    }

    public final boolean getHasMoreToRead() {
        return this.ring.getAvailableRead() > 0;
    }

    public final byte readOne() {
        ByteArrayDeque byteArrayDeque = this;
        boolean bl = false;
        boolean bl2 = false;
        ByteArrayDeque $this$readOne_u24lambda_u2d0 = byteArrayDeque;
        boolean bl3 = false;
        $this$readOne_u24lambda_u2d0.read($this$readOne_u24lambda_u2d0.tempBuffer, 0, 1);
        return $this$readOne_u24lambda_u2d0.tempBuffer[0];
    }

    public final void writeOne(byte value) {
        this.tempBuffer[0] = value;
        this.write(this.tempBuffer, 0, 1);
    }

    public int hashCode() {
        return this.ring.contentHashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ByteArrayDeque && Intrinsics.areEqual((Object)this.ring, (Object)((ByteArrayDeque)other).ring);
    }

    @JvmOverloads
    public final int writeHead(@NotNull byte[] buffer, int offset) {
        return ByteArrayDeque.writeHead$default(this, buffer, offset, 0, 4, null);
    }

    @JvmOverloads
    public final int writeHead(@NotNull byte[] buffer) {
        return ByteArrayDeque.writeHead$default(this, buffer, 0, 0, 6, null);
    }

    @JvmOverloads
    public final int write(@NotNull byte[] buffer, int offset) {
        return ByteArrayDeque.write$default(this, buffer, offset, 0, 4, null);
    }

    @JvmOverloads
    public final int write(@NotNull byte[] buffer) {
        return ByteArrayDeque.write$default(this, buffer, 0, 0, 6, null);
    }

    @JvmOverloads
    public final int read(@NotNull byte[] buffer, int offset) {
        return ByteArrayDeque.read$default(this, buffer, offset, 0, 4, null);
    }

    @JvmOverloads
    public final int read(@NotNull byte[] buffer) {
        return ByteArrayDeque.read$default(this, buffer, 0, 0, 6, null);
    }

    public ByteArrayDeque() {
        this(0, false, 3, null);
    }
}

