/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.kds;

import com.soywiz.kds._ExtensionsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.PublishedApi;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.markers.KMutableCollection;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010)\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 G2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001GB'\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0006j\b\u0012\u0004\u0012\u00020\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0002H\u0016J\u0016\u0010#\u001a\u00020\u00142\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\u0011\u0010(\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010)\u001a\u00020\u00142\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020%H\u0016J\u0010\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020\u0002H\u0002J\u0013\u0010,\u001a\u00020\u00142\b\u0010-\u001a\u0004\u0018\u00010.H\u0096\u0002J\u0018\u0010/\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u00022\u0006\u00101\u001a\u00020\u0002H\u0002J\b\u00102\u001a\u00020\u0002H\u0016J\u000e\u00103\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u0002J\b\u00104\u001a\u00020\u0014H\u0016J\u000f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000206H\u0096\u0002J\u0018\u00107\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u00022\u0006\u00101\u001a\u00020\u0002H\u0002J\u0010\u00108\u001a\u00020'2\u0006\u0010+\u001a\u00020\u0002H\u0002J\u0015\u00109\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010:J\u0016\u0010;\u001a\u00020\u00142\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020%H\u0016J\u000e\u0010<\u001a\u00020'2\u0006\u0010+\u001a\u00020\u0002J\u0006\u0010=\u001a\u00020\u0002J\u0016\u0010>\u001a\u00020\u00142\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020%H\u0016J\u0018\u0010?\u001a\u00020'2\u0006\u0010@\u001a\u00020\u00022\u0006\u0010A\u001a\u00020\u0002H\u0002J\u0006\u0010B\u001a\u00020\u0004J\b\u0010C\u001a\u00020DH\u0016J\u000e\u0010E\u001a\u00020'2\u0006\u0010+\u001a\u00020\u0002J\u000e\u0010F\u001a\u00020'2\u0006\u0010\"\u001a\u00020\u0002R\u0014\u0010\t\u001a\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0006j\b\u0012\u0004\u0012\u00020\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u001e\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000bR\u0018\u0010\u0013\u001a\u00020\u0014*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0018\u0010\u0016\u001a\u00020\u0002*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0019\u001a\u00020\u0002*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0018\u0010\u001b\u001a\u00020\u0002*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018R(\u0010\u001d\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u00028B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u0018\"\u0004\b\u001f\u0010 \u00a8\u0006H"}, d2={"Lcom/soywiz/kds/IntPriorityQueue;", "", "", "data", "", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "([ILjava/util/Comparator;)V", "capacity", "getCapacity", "()I", "getComparator", "()Ljava/util/Comparator;", "head", "getHead", "<set-?>", "size", "getSize", "isRoot", "", "(I)Z", "left", "getLeft", "(I)I", "parent", "getParent", "right", "getRight", "value", "getValue", "setValue", "(II)V", "add", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "ensure", "index", "equals", "other", "", "gt", "a", "b", "hashCode", "indexOf", "isEmpty", "iterator", "", "lt", "minHeapify", "remove", "(Ljava/lang/Integer;)Z", "removeAll", "removeAt", "removeHead", "retainAll", "swap", "l", "r", "toArraySorted", "toString", "", "updateAt", "updateObject", "Companion", "kds_release"})
public final class IntPriorityQueue
implements Collection<Integer>,
KMutableCollection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private int[] data;
    @NotNull
    private final Comparator<Integer> comparator;
    private int size;

    @PublishedApi
    public IntPriorityQueue(@NotNull int[] data, @NotNull Comparator<Integer> comparator) {
        this.data = data;
        this.comparator = comparator;
    }

    @NotNull
    public final Comparator<Integer> getComparator() {
        return this.comparator;
    }

    private final int getValue(int $this$value) {
        return this.data[$this$value];
    }

    private final void setValue(int $this$value, int value) {
        int n = $this$value;
        boolean bl = false;
        boolean bl2 = false;
        int $this$_set_value__u24lambda_u2d0 = n;
        boolean bl3 = false;
        this.data[$this$_set_value__u24lambda_u2d0] = value;
    }

    private final boolean isRoot(int $this$isRoot) {
        return $this$isRoot == 0;
    }

    private final int getParent(int $this$parent) {
        return ($this$parent - 1) / 2;
    }

    private final int getLeft(int $this$left) {
        return 2 * $this$left + 1;
    }

    private final int getRight(int $this$right) {
        return 2 * $this$right + 2;
    }

    private final boolean gt(int a, int b) {
        return this.comparator.compare(a, b) > 0;
    }

    private final boolean lt(int a, int b) {
        return this.comparator.compare(a, b) < 0;
    }

    private final int getCapacity() {
        return this.data.length;
    }

    public int getSize() {
        return this.size;
    }

    public final int getHead() {
        if (this.size() <= 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[0];
    }

    @Override
    public boolean add(int element) {
        IntPriorityQueue intPriorityQueue = this;
        int n = intPriorityQueue.size();
        intPriorityQueue.size = n + 1;
        this.ensure(this.size());
        int i = this.size() - 1;
        this.setValue(i, element);
        while (!this.isRoot(i) && this.gt(this.getValue(this.getParent(i)), this.getValue(i))) {
            this.swap(i, this.getParent(i));
            i = this.getParent(i);
        }
        return true;
    }

    public final int removeHead() {
        if (this.size() <= 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.size() == 1) {
            IntPriorityQueue intPriorityQueue = this;
            int n = intPriorityQueue.size();
            intPriorityQueue.size = n + -1;
            return this.getValue(0);
        }
        int root = this.getValue(0);
        this.setValue(0, this.getValue(this.size() - 1));
        IntPriorityQueue intPriorityQueue = this;
        int n = intPriorityQueue.size();
        intPriorityQueue.size = n + -1;
        this.minHeapify(0);
        return root;
    }

    public final int indexOf(int element) {
        int n = 0;
        int n2 = this.size();
        if (n < n2) {
            do {
                int n3;
                if (this.data[n3 = n++] != element) continue;
                return n3;
            } while (n < n2);
        }
        return -1;
    }

    public final void updateObject(int element) {
        int index = this.indexOf(element);
        if (index >= 0) {
            this.updateAt(index);
        }
    }

    public final void updateAt(int index) {
        int value = this.getValue(index);
        this.removeAt(index);
        this.add(value);
    }

    public boolean remove(@Nullable Integer element) {
        int index = this.indexOf(element);
        if (index >= 0) {
            this.removeAt(index);
        }
        return index >= 0;
    }

    public final void removeAt(int index) {
        int i = index;
        while (i != 0) {
            this.swap(i, this.getParent(i));
            i = this.getParent(i);
        }
        this.removeHead();
    }

    private final void ensure(int index) {
        if (index >= this.getCapacity()) {
            int[] nArray = this.data;
            int n = 2 + this.getCapacity() * 2;
            boolean bl = false;
            int[] nArray2 = Arrays.copyOf(nArray, n);
            Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
            this.data = nArray2;
        }
    }

    private final void minHeapify(int index) {
        int i = index;
        while (true) {
            int left = this.getLeft(i);
            int right = this.getRight(i);
            int smallest = i;
            if (left < this.size() && this.lt(this.getValue(left), this.getValue(i))) {
                smallest = left;
            }
            if (right < this.size() && this.lt(this.getValue(right), this.getValue(smallest))) {
                smallest = right;
            }
            if (smallest == i) break;
            this.swap(i, smallest);
            i = smallest;
        }
    }

    private final void swap(int l, int r) {
        int temp = this.getValue(r);
        this.setValue(r, this.getValue(l));
        this.setValue(l, temp);
    }

    public boolean contains(int element) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = (Iterable)RangesKt.until((int)0, (int)this.size());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (!(this.getValue(it) == element)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        boolean bl;
        block3: {
            Set thisSet = CollectionsKt.toSet((Iterable)this);
            Iterable $this$all$iv = elements;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl2 = false;
                    if (thisSet.contains(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Integer> elements) {
        IntPriorityQueue intPriorityQueue = this;
        boolean bl = false;
        boolean bl2 = false;
        IntPriorityQueue $this$addAll_u24lambda_u2d3 = intPriorityQueue;
        boolean bl3 = false;
        Object object = elements.iterator();
        while (object.hasNext()) {
            int e = ((Number)object.next()).intValue();
            $this$addAll_u24lambda_u2d3.add(e);
        }
        object = elements;
        boolean bl4 = false;
        return !object.isEmpty();
    }

    @Override
    public void clear() {
        IntPriorityQueue intPriorityQueue = this;
        boolean bl = false;
        boolean bl2 = false;
        IntPriorityQueue $this$clear_u24lambda_u2d4 = intPriorityQueue;
        boolean bl3 = false;
        $this$clear_u24lambda_u2d4.size = 0;
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        ArrayList temp = new ArrayList(CollectionsKt.toList((Iterable)this));
        boolean res = temp.removeAll(elements);
        this.clear();
        this.addAll(temp);
        return res;
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        ArrayList temp = new ArrayList(CollectionsKt.toList((Iterable)this));
        boolean res = temp.retainAll(elements);
        this.clear();
        this.addAll(temp);
        return res;
    }

    @Override
    @NotNull
    public Iterator<Integer> iterator() {
        Ref.IntRef index = new Ref.IntRef();
        return new Iterator<Integer>(index, this){
            final /* synthetic */ Ref.IntRef $index;
            final /* synthetic */ IntPriorityQueue this$0;
            {
                this.$index = $index;
                this.this$0 = $receiver;
            }

            public boolean hasNext() {
                return this.$index.element < this.this$0.size();
            }

            @NotNull
            public Integer next() {
                int n = this.$index.element;
                this.$index.element = n + 1;
                return IntPriorityQueue.access$getValue(this.this$0, n);
            }

            @NotNull
            public Void remove() {
                boolean bl = false;
                throw (Throwable)new NotImplementedError(null, 1, null);
            }
        };
    }

    @NotNull
    public final int[] toArraySorted() {
        int[] out = new int[this.size()];
        int n = 0;
        int n2 = this.size();
        if (n < n2) {
            do {
                int n3 = n++;
                out[n3] = this.removeHead();
            } while (n < n2);
        }
        for (int v : out) {
            this.add(v);
        }
        return out;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.toList((Iterable)this).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof IntPriorityQueue)) return false;
        int[] nArray = this.data;
        int[] nArray2 = ((IntPriorityQueue)other).data;
        boolean bl = false;
        if (!Arrays.equals(nArray, nArray2)) return false;
        if (!Intrinsics.areEqual(this.comparator, ((IntPriorityQueue)other).comparator)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        int[] nArray = this.data;
        boolean bl = false;
        return Arrays.hashCode(nArray);
    }

    public static final /* synthetic */ int access$getValue(IntPriorityQueue $this, int $receiver) {
        return $this.getValue($receiver);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0086\u0002JK\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u000626\u0010\u0007\u001a2\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\t0\bH\u0086\u0002J+\u0010\u0003\u001a\u00020\u00042\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\u000ej\b\u0012\u0004\u0012\u00020\t`\u000f2\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0010"}, d2={"Lcom/soywiz/kds/IntPriorityQueue$Companion;", "", "()V", "invoke", "Lcom/soywiz/kds/IntPriorityQueue;", "reversed", "", "comparator", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "left", "right", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "kds_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntPriorityQueue invoke(@NotNull Comparator<Integer> comparator, boolean reversed) {
            int[] nArray = new int[16];
            Comparator<Integer> comparator2 = reversed ? comparator.reversed() : comparator;
            Intrinsics.checkNotNullExpressionValue(comparator2, (String)"if (reversed) comparator.reversed() else comparator");
            return new IntPriorityQueue(nArray, comparator2);
        }

        public static /* synthetic */ IntPriorityQueue invoke$default(Companion companion, Comparator comparator, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.invoke(comparator, bl);
        }

        @NotNull
        public final IntPriorityQueue invoke(boolean reversed, @NotNull Function2<? super Integer, ? super Integer, Integer> comparator) {
            Function2<? super Integer, ? super Integer, Integer> function2 = comparator;
            return Companion.invoke((arg_0, arg_1) -> Companion.invoke$lambda-0(function2, arg_0, arg_1), reversed);
        }

        public static /* synthetic */ IntPriorityQueue invoke$default(Companion companion, boolean bl, Function2 function2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            return companion.invoke(bl, (Function2<? super Integer, ? super Integer, Integer>)function2);
        }

        @NotNull
        public final IntPriorityQueue invoke(boolean reversed) {
            return Companion.invoke(_ExtensionsKt.comparator(), reversed);
        }

        public static /* synthetic */ IntPriorityQueue invoke$default(Companion companion, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            return companion.invoke(bl);
        }

        private static final int invoke$lambda-0(Function2 $tmp0, Integer p0, Integer p1) {
            return ((Number)$tmp0.invoke((Object)p0, (Object)p1)).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

