/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.kds;

import com.soywiz.kds.IntRingBuffer;
import com.soywiz.kds.internal.InternalKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\u0013\u0010 \u001a\u00020\u000b2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\"\u001a\u00020\u0003H\u0016J$\u0010\u0013\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00192\b\b\u0002\u0010$\u001a\u00020\u00032\b\b\u0002\u0010%\u001a\u00020\u0003H\u0007J\u0006\u0010&\u001a\u00020\u001dJ$\u0010'\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00192\b\b\u0002\u0010$\u001a\u00020\u00032\b\b\u0002\u0010%\u001a\u00020\u0003H\u0007J$\u0010(\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00192\b\b\u0002\u0010$\u001a\u00020\u00032\b\b\u0002\u0010%\u001a\u00020\u0003H\u0007J\u000e\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u0003R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0007R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015\u00a8\u0006+"}, d2={"Lcom/soywiz/kds/IntArrayDeque;", "", "initialBits", "", "(I)V", "availableRead", "getAvailableRead", "()I", "availableWriteWithoutAllocating", "getAvailableWriteWithoutAllocating", "hasMoreToRead", "", "getHasMoreToRead", "()Z", "hasMoreToWrite", "getHasMoreToWrite", "getInitialBits", "<set-?>", "", "read", "getRead", "()J", "ring", "Lcom/soywiz/kds/IntRingBuffer;", "tempBuffer", "", "written", "getWritten", "clear", "", "ensureWrite", "count", "equals", "other", "hashCode", "buffer", "offset", "size", "readOne", "write", "writeHead", "writeOne", "value", "kds_release"})
public final class IntArrayDeque {
    private final int initialBits;
    @NotNull
    private IntRingBuffer ring;
    @NotNull
    private final int[] tempBuffer;
    private long written;
    private long read;

    public IntArrayDeque(int initialBits) {
        this.initialBits = initialBits;
        this.ring = new IntRingBuffer(this.initialBits);
        this.tempBuffer = new int[1024];
    }

    public /* synthetic */ IntArrayDeque(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    public final int getInitialBits() {
        return this.initialBits;
    }

    public final long getWritten() {
        return this.written;
    }

    public final long getRead() {
        return this.read;
    }

    public final int getAvailableWriteWithoutAllocating() {
        return this.ring.getAvailableWrite();
    }

    public final int getAvailableRead() {
        return this.ring.getAvailableRead();
    }

    @JvmOverloads
    public final int writeHead(@NotNull int[] buffer, int offset, int size) {
        int out = this.ensureWrite((int)size).ring.writeHead(buffer, offset, size);
        if (out > 0) {
            IntArrayDeque intArrayDeque = this;
            intArrayDeque.written += (long)out;
        }
        return out;
    }

    public static /* synthetic */ int writeHead$default(IntArrayDeque intArrayDeque, int[] nArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = nArray.length - n;
        }
        return intArrayDeque.writeHead(nArray, n, n2);
    }

    @JvmOverloads
    public final int write(@NotNull int[] buffer, int offset, int size) {
        int out = this.ensureWrite((int)size).ring.write(buffer, offset, size);
        if (out > 0) {
            IntArrayDeque intArrayDeque = this;
            intArrayDeque.written += (long)out;
        }
        return out;
    }

    public static /* synthetic */ int write$default(IntArrayDeque intArrayDeque, int[] nArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = nArray.length - n;
        }
        return intArrayDeque.write(nArray, n, n2);
    }

    @JvmOverloads
    public final int read(@NotNull int[] buffer, int offset, int size) {
        int out = this.ring.read(buffer, offset, size);
        if (out > 0) {
            IntArrayDeque intArrayDeque = this;
            intArrayDeque.read += (long)out;
        }
        return out;
    }

    public static /* synthetic */ int read$default(IntArrayDeque intArrayDeque, int[] nArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = nArray.length - n;
        }
        return intArrayDeque.read(nArray, n, n2);
    }

    private final IntArrayDeque ensureWrite(int count) {
        if (count > this.ring.getAvailableWrite()) {
            int minNewSize = this.ring.getAvailableRead() + count;
            int newBits = InternalKt.ilog2(minNewSize) + 2;
            IntRingBuffer newRing = new IntRingBuffer(newBits);
            while (this.ring.getAvailableRead() > 0) {
                int read = this.ring.read(this.tempBuffer, 0, this.tempBuffer.length);
                newRing.write(this.tempBuffer, 0, read);
            }
            this.ring = newRing;
        }
        return this;
    }

    public final void clear() {
        this.ring.clear();
    }

    public final boolean getHasMoreToWrite() {
        return this.ring.getAvailableWrite() > 0;
    }

    public final boolean getHasMoreToRead() {
        return this.ring.getAvailableRead() > 0;
    }

    public final void readOne() {
        this.read(this.tempBuffer, 0, 1);
        int cfr_ignored_0 = this.tempBuffer[0];
    }

    public final void writeOne(int value) {
        this.tempBuffer[0] = value;
        this.write(this.tempBuffer, 0, 1);
    }

    public int hashCode() {
        return this.ring.contentHashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof IntArrayDeque && Intrinsics.areEqual((Object)this.ring, (Object)((IntArrayDeque)other).ring);
    }

    @JvmOverloads
    public final int writeHead(@NotNull int[] buffer, int offset) {
        return IntArrayDeque.writeHead$default(this, buffer, offset, 0, 4, null);
    }

    @JvmOverloads
    public final int writeHead(@NotNull int[] buffer) {
        return IntArrayDeque.writeHead$default(this, buffer, 0, 0, 6, null);
    }

    @JvmOverloads
    public final int write(@NotNull int[] buffer, int offset) {
        return IntArrayDeque.write$default(this, buffer, offset, 0, 4, null);
    }

    @JvmOverloads
    public final int write(@NotNull int[] buffer) {
        return IntArrayDeque.write$default(this, buffer, 0, 0, 6, null);
    }

    @JvmOverloads
    public final int read(@NotNull int[] buffer, int offset) {
        return IntArrayDeque.read$default(this, buffer, offset, 0, 4, null);
    }

    @JvmOverloads
    public final int read(@NotNull int[] buffer) {
        return IntArrayDeque.read$default(this, buffer, 0, 0, 6, null);
    }

    public IntArrayDeque() {
        this(0, 1, null);
    }
}

