/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.kds;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0003J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\"\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\r2\b\b\u0002\u0010\u001c\u001a\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\u0003J\u0010\u0010\u001a\u001a\u00020\u001e2\b\b\u0002\u0010\u001c\u001a\u00020\u0003J$\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\r2\b\b\u0002\u0010\u001c\u001a\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\u0003H\u0007J\u0006\u0010 \u001a\u00020\u0003J\u000e\u0010!\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003J$\u0010\"\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\r2\b\b\u0002\u0010\u001c\u001a\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\u0003H\u0007J\u000e\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u0003J$\u0010%\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\r2\b\b\u0002\u0010\u001c\u001a\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\u0003H\u0007R\u001e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\bR\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/soywiz/kds/ByteRingBuffer;", "", "bits", "", "(I)V", "<set-?>", "availableRead", "getAvailableRead", "()I", "availableWrite", "getAvailableWrite", "getBits", "buffer", "", "mask", "readPos", "totalSize", "getTotalSize", "writePos", "clear", "", "contentHashCode", "equals", "", "other", "hashCode", "peek", "data", "offset", "size", "", "read", "readByte", "skip", "write", "writeByte", "v", "writeHead", "kds_release"})
public class ByteRingBuffer {
    private final int bits;
    private final int totalSize;
    private final int mask;
    @NotNull
    private final byte[] buffer;
    private int readPos;
    private int writePos;
    private int availableWrite;
    private int availableRead;

    public ByteRingBuffer(int bits) {
        this.bits = bits;
        this.totalSize = 1 << this.bits;
        this.mask = this.totalSize - 1;
        this.buffer = new byte[this.totalSize];
        this.availableWrite = this.totalSize;
    }

    public final int getBits() {
        return this.bits;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    public final int getAvailableWrite() {
        return this.availableWrite;
    }

    public final int getAvailableRead() {
        return this.availableRead;
    }

    @JvmOverloads
    public final int writeHead(@NotNull byte[] data, int offset, int size) {
        int n = this.availableWrite;
        boolean bl = false;
        n = 0;
        int toWrite = Math.min(n, size);
        if (n < toWrite) {
            do {
                int n2 = n++;
                this.readPos = this.readPos - 1 & this.mask;
                this.buffer[this.readPos] = data[offset + size - n2 - 1];
            } while (n < toWrite);
        }
        ByteRingBuffer byteRingBuffer = this;
        byteRingBuffer.availableRead += toWrite;
        byteRingBuffer = this;
        byteRingBuffer.availableWrite -= toWrite;
        return toWrite;
    }

    public static /* synthetic */ int writeHead$default(ByteRingBuffer byteRingBuffer, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeHead");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length - n;
        }
        return byteRingBuffer.writeHead(byArray, n, n2);
    }

    @JvmOverloads
    public final int write(@NotNull byte[] data, int offset, int size) {
        int n = this.availableWrite;
        boolean bl = false;
        n = 0;
        int toWrite = Math.min(n, size);
        if (n < toWrite) {
            do {
                int n2 = n++;
                this.buffer[this.writePos] = data[offset + n2];
                this.writePos = this.writePos + 1 & this.mask;
            } while (n < toWrite);
        }
        ByteRingBuffer byteRingBuffer = this;
        byteRingBuffer.availableRead += toWrite;
        byteRingBuffer = this;
        byteRingBuffer.availableWrite -= toWrite;
        return toWrite;
    }

    public static /* synthetic */ int write$default(ByteRingBuffer byteRingBuffer, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length - n;
        }
        return byteRingBuffer.write(byArray, n, n2);
    }

    @JvmOverloads
    public final int read(@NotNull byte[] data, int offset, int size) {
        return this.skip(this.peek(data, offset, size));
    }

    public static /* synthetic */ int read$default(ByteRingBuffer byteRingBuffer, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: read");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length - n;
        }
        return byteRingBuffer.read(byArray, n, n2);
    }

    public final int skip(int size) {
        int n = this.availableRead;
        boolean bl = false;
        int toRead = Math.min(n, size);
        this.readPos = this.readPos + toRead & this.mask;
        ByteRingBuffer byteRingBuffer = this;
        byteRingBuffer.availableWrite += toRead;
        byteRingBuffer = this;
        byteRingBuffer.availableRead -= toRead;
        return toRead;
    }

    public final int peek(@NotNull byte[] data, int offset, int size) {
        int n = this.availableRead;
        boolean bl = false;
        int toRead = Math.min(n, size);
        byte[] buffer = this.buffer;
        int readPos = this.readPos;
        int mask = this.mask;
        int n2 = 0;
        if (n2 < toRead) {
            do {
                int n3 = n2++;
                data[offset + n3] = buffer[readPos + n3 & mask];
            } while (n2 < toRead);
        }
        return toRead;
    }

    public static /* synthetic */ int peek$default(ByteRingBuffer byteRingBuffer, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: peek");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length - n;
        }
        return byteRingBuffer.peek(byArray, n, n2);
    }

    public final int readByte() {
        if (this.availableRead <= 0) {
            return -1;
        }
        int out = this.buffer[this.readPos] & 0xFF;
        this.readPos = this.readPos + 1 & this.mask;
        ByteRingBuffer byteRingBuffer = this;
        int n = byteRingBuffer.availableRead;
        byteRingBuffer.availableRead = n + -1;
        byteRingBuffer = this;
        n = byteRingBuffer.availableWrite;
        byteRingBuffer.availableWrite = n + 1;
        return out;
    }

    public final boolean writeByte(int v) {
        if (this.availableWrite <= 0) {
            return false;
        }
        this.buffer[this.writePos] = (byte)v;
        this.writePos = this.writePos + 1 & this.mask;
        ByteRingBuffer byteRingBuffer = this;
        int n = byteRingBuffer.availableWrite;
        byteRingBuffer.availableWrite = n + -1;
        byteRingBuffer = this;
        n = byteRingBuffer.availableRead;
        byteRingBuffer.availableRead = n + 1;
        return true;
    }

    public final void clear() {
        this.readPos = 0;
        this.writePos = 0;
        this.availableRead = 0;
        this.availableWrite = this.totalSize;
    }

    public final byte peek(int offset) {
        return this.buffer[this.readPos + offset & this.mask];
    }

    public static /* synthetic */ byte peek$default(ByteRingBuffer byteRingBuffer, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: peek");
        }
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return byteRingBuffer.peek(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ByteRingBuffer)) return false;
        if (this.availableRead != ((ByteRingBuffer)other).availableRead) return false;
        int count$iv = this.availableRead;
        boolean $i$f$equaler = false;
        int n = 0;
        if (n >= count$iv) return true;
        do {
            int n$iv;
            int it = n$iv = n++;
            boolean bl = false;
            if (this.peek(it) != ((ByteRingBuffer)other).peek(it)) return false;
            boolean bl2 = true;
            if (bl2) continue;
            return false;
        } while (n < count$iv);
        return true;
    }

    public int hashCode() {
        return this.contentHashCode();
    }

    /*
     * WARNING - void declaration
     */
    public final int contentHashCode() {
        void var3_3;
        int count$iv = this.availableRead;
        boolean $i$f$hashCoder = false;
        int out$iv = 0;
        int n = 0;
        if (n < count$iv) {
            do {
                void it;
                int n$iv = n++;
                int n2 = n$iv;
                int n3 = out$iv *= 7;
                boolean bl = false;
                byte by = this.peek((int)it);
                out$iv = n3 + by;
            } while (n < count$iv);
        }
        return (int)var3_3;
    }

    @JvmOverloads
    public final int writeHead(@NotNull byte[] data, int offset) {
        return ByteRingBuffer.writeHead$default(this, data, offset, 0, 4, null);
    }

    @JvmOverloads
    public final int writeHead(@NotNull byte[] data) {
        return ByteRingBuffer.writeHead$default(this, data, 0, 0, 6, null);
    }

    @JvmOverloads
    public final int write(@NotNull byte[] data, int offset) {
        return ByteRingBuffer.write$default(this, data, offset, 0, 4, null);
    }

    @JvmOverloads
    public final int write(@NotNull byte[] data) {
        return ByteRingBuffer.write$default(this, data, 0, 0, 6, null);
    }

    @JvmOverloads
    public final int read(@NotNull byte[] data, int offset) {
        return ByteRingBuffer.read$default(this, data, offset, 0, 4, null);
    }

    @JvmOverloads
    public final int read(@NotNull byte[] data) {
        return ByteRingBuffer.read$default(this, data, 0, 0, 6, null);
    }
}

