/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.kds;

import com.soywiz.kds._ExtensionsKt;
import com.soywiz.kds.internal.InternalKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableCollection;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010)\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\u0016\u0010\u001c\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0016J\u0014\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001fJ\u0014\u0010 \u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018J\u000e\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0002J\u000e\u0010#\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0002J\b\u0010$\u001a\u00020\u001dH\u0016J\u0011\u0010%\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010&\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0016J(\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u0005H\u0002J\u0013\u0010,\u001a\u00020\u00162\b\u0010-\u001a\u0004\u0018\u00010.H\u0096\u0002J\u0011\u0010/\u001a\u00020\u00022\u0006\u00100\u001a\u00020\u0005H\u0086\u0002J\b\u00101\u001a\u00020\u0005H\u0016J\u000e\u00102\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0002J\u0010\u00103\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u0005H\u0002J\b\u00104\u001a\u00020\u0016H\u0016J\u000f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000206H\u0096\u0002J\u0010\u00107\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\u0016\u00108\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0016J\u000e\u00109\u001a\u00020\u00022\u0006\u00100\u001a\u00020\u0005J\u0006\u0010:\u001a\u00020\u0002J\u0006\u0010;\u001a\u00020\u0002J\u0010\u0010<\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u0005H\u0002J\u0016\u0010=\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0016J\u0019\u0010>\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u00052\u0006\u0010?\u001a\u00020\u0002H\u0086\u0002J\b\u0010@\u001a\u00020AH\u0016R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000b\u00a8\u0006B"}, d2={"Lcom/soywiz/kds/FloatDeque;", "", "", "()V", "initialCapacity", "", "(I)V", "_size", "_start", "capacity", "getCapacity", "()I", "data", "", "first", "getFirst", "()F", "last", "getLast", "size", "getSize", "_removeRetainAll", "", "elements", "", "retain", "add", "element", "addAll", "", "items", "", "addAllFirst", "addFirst", "item", "addLast", "clear", "contains", "containsAll", "copyCyclic", "i", "istart", "o", "count", "equals", "other", "", "get", "index", "hashCode", "indexOf", "internalIndex", "isEmpty", "iterator", "", "remove", "removeAll", "removeAt", "removeFirst", "removeLast", "resizeIfRequiredFor", "retainAll", "set", "value", "toString", "", "kds_release"})
public class FloatDeque
implements Collection<Float>,
KMutableCollection {
    private int _start;
    private int _size;
    @NotNull
    private float[] data;

    public FloatDeque(int initialCapacity) {
        this.data = new float[initialCapacity];
    }

    private final int getCapacity() {
        return this.data.length;
    }

    public FloatDeque() {
        this(16);
    }

    public int getSize() {
        return this._size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private final void resizeIfRequiredFor(int count) {
        if (this.size() + count > this.getCapacity()) {
            float[] i = this.data;
            int istart = this._start;
            float[] o = new float[this.data.length * 2];
            this.copyCyclic(i, istart, o, this._size);
            this.data = o;
            this._start = 0;
        }
    }

    private final void copyCyclic(float[] i, int istart, float[] o, int count) {
        int size1 = Math.min(i.length - istart, count);
        int size2 = count - size1;
        InternalKt.arraycopy(i, istart, o, 0, size1);
        if (size2 > 0) {
            InternalKt.arraycopy(i, 0, o, size1, size2);
        }
    }

    public final void addAll(@NotNull Iterable<Float> items) {
        this.resizeIfRequiredFor(CollectionsKt.count(items));
        Iterator<Float> iterator2 = items.iterator();
        while (iterator2.hasNext()) {
            float i = ((Number)iterator2.next()).floatValue();
            this.addLast(i);
        }
    }

    public final void addAllFirst(@NotNull Collection<Float> items) {
        this.resizeIfRequiredFor(items.size());
        this._start = InternalKt.umod(this._start - items.size(), this.getCapacity());
        this._size += items.size();
        int pos = this._start;
        Iterator<Float> iterator2 = items.iterator();
        while (iterator2.hasNext()) {
            float it = ((Number)iterator2.next()).floatValue();
            int n = pos;
            pos = n + 1;
            this.data[InternalKt.umod((int)n, (int)this.getCapacity())] = it;
        }
    }

    public final void addFirst(float item) {
        this.resizeIfRequiredFor(1);
        this._start = InternalKt.umod(this._start - 1, this.getCapacity());
        int n = this._size;
        this._size = n + 1;
        this.data[this._start] = item;
    }

    public final void addLast(float item) {
        this.resizeIfRequiredFor(1);
        this.data[InternalKt.umod((int)(this._start + this.size()), (int)this.getCapacity())] = item;
        int n = this._size;
        this._size = n + 1;
    }

    public final float removeFirst() {
        float f;
        if (this._size <= 0) {
            throw new IndexOutOfBoundsException();
        }
        float $this$removeFirst_u24lambda_u2d0 = f = this.getFirst();
        boolean bl = false;
        this._start = InternalKt.umod(this._start + 1, this.getCapacity());
        int n = this._size;
        this._size = n + -1;
        return f;
    }

    public final float removeLast() {
        float f;
        if (this._size <= 0) {
            throw new IndexOutOfBoundsException();
        }
        float $this$removeLast_u24lambda_u2d1 = f = this.getLast();
        boolean bl = false;
        int n = this._size;
        this._size = n + -1;
        return f;
    }

    public final float removeAt(int index) {
        int n;
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (index == 0) {
            return this.removeFirst();
        }
        if (index == this.size() - 1) {
            return this.removeLast();
        }
        float old = this.get(index);
        if (index < this.size() / 2) {
            n = index;
            if (1 <= n) {
                do {
                    int n2 = n--;
                    this.set(n2, this.get(n2 - 1));
                } while (1 <= n);
            }
            this._start = InternalKt.umod(this._start + 1, this.getCapacity());
        } else {
            n = index;
            int n3 = this.size() - 1;
            while (n < n3) {
                int n4 = n++;
                this.set(n4, this.get(n4 + 1));
            }
        }
        n = this._size;
        this._size = n + -1;
        return old;
    }

    @Override
    public boolean add(float element) {
        boolean bl;
        boolean $this$add_u24lambda_u2d2 = bl = true;
        boolean bl2 = false;
        this.addLast(element);
        return bl;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Float> elements) {
        boolean bl;
        boolean $this$addAll_u24lambda_u2d3 = bl = true;
        boolean bl2 = false;
        this.addAll((Iterable<Float>)elements);
        return bl;
    }

    @Override
    public void clear() {
        this._size = 0;
    }

    public boolean remove(float element) {
        int index = this.indexOf(element);
        if (index >= 0) {
            this.removeAt(index);
        }
        return index >= 0;
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        return this._removeRetainAll(elements, false);
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        return this._removeRetainAll(elements, true);
    }

    private final boolean _removeRetainAll(Collection<Float> elements, boolean retain) {
        Set eset = CollectionsKt.toSet((Iterable)elements);
        float[] fArray = Arrays.copyOf(this.data, this.data.length);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(this, size)");
        float[] temp = fArray;
        int tsize = 0;
        int osize = this.size();
        int n = 0;
        int n2 = this.size();
        while (n < n2) {
            int n3;
            float c;
            if (eset.contains(Float.valueOf(c = this.get(n3 = n++))) != retain) continue;
            int n4 = tsize;
            tsize = n4 + 1;
            temp[n4] = c;
        }
        this.data = temp;
        this._start = 0;
        this._size = tsize;
        return tsize != osize;
    }

    public final float getFirst() {
        return this.data[this._start];
    }

    public final float getLast() {
        return this.data[this.internalIndex(this.size() - 1)];
    }

    private final int internalIndex(int index) {
        return InternalKt.umod(this._start + index, this.getCapacity());
    }

    public final void set(int index, float value) {
        this.data[this.internalIndex((int)index)] = value;
    }

    public final float get(int index) {
        return this.data[this.internalIndex(index)];
    }

    public boolean contains(float element) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = (Iterable)RangesKt.until((int)0, (int)this.size());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (!(this.get(it) == element)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final int indexOf(float element) {
        int n = 0;
        int n2 = this.size();
        while (n < n2) {
            int n3;
            if (!(this.get(n3 = n++) == element)) continue;
            return n3;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        boolean bl;
        block5: {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv322 = elements;
            int $i$f$map = 0;
            Iterable iterable = $this$map$iv322;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv322, (int)10));
            boolean $i$f$mapTo2 = false;
            Object object = $this$mapTo$iv$iv.iterator();
            while (object.hasNext()) {
                void it;
                Object item$iv$iv = object.next();
                float f = ((Number)item$iv$iv).floatValue();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(TuplesKt.to((Object)Float.valueOf((float)it), (Object)0));
            }
            LinkedHashMap emap = _ExtensionsKt.toLinkedMap((List)destination$iv$iv);
            int $this$map$iv322 = 0;
            $i$f$map = this.size();
            while ($this$map$iv322 < $i$f$map) {
                int it;
                float e;
                Map $i$f$mapTo2 = emap;
                if (!$i$f$mapTo2.containsKey(object = Float.valueOf(e = this.get(it = $this$map$iv322++)))) continue;
                $i$f$mapTo2 = emap;
                object = Float.valueOf(e);
                Integer n = 1;
                $i$f$mapTo2.put(object, n);
            }
            Collection $this$map$iv322 = emap.values();
            Intrinsics.checkNotNullExpressionValue($this$map$iv322, (String)"emap.values");
            Iterable $this$all$iv = $this$map$iv322;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Integer it = (Integer)element$iv;
                    boolean bl3 = false;
                    Integer n = it;
                    int n2 = 1;
                    if (n != null && n == n2) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Iterator<Float> iterator() {
        FloatDeque that = this;
        return new Iterator<Float>(that, this){
            private int index;
            final /* synthetic */ FloatDeque $that;
            final /* synthetic */ FloatDeque this$0;
            {
                this.$that = $that;
                this.this$0 = $receiver;
            }

            public final int getIndex() {
                return this.index;
            }

            public final void setIndex(int n) {
                this.index = n;
            }

            @NotNull
            public Float next() {
                int n = this.index;
                this.index = n + 1;
                return Float.valueOf(this.$that.get(n));
            }

            public boolean hasNext() {
                return this.index < this.this$0.size();
            }

            public void remove() {
                this.index += -1;
                this.this$0.removeAt(this.index);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var3_3;
        int size$iv = this.size();
        boolean $i$f$contentHashCode = false;
        int result$iv = 1;
        int n = 0;
        while (n < size$iv) {
            void it;
            Float f;
            int n$iv;
            int n2 = n$iv = n++;
            int n3 = 31 * result$iv;
            boolean bl = false;
            Float f2 = f = Float.valueOf(this.get((int)it));
            result$iv = n3 + ((Object)f2).hashCode();
        }
        return (int)var3_3;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof FloatDeque)) {
            return false;
        }
        if (((FloatDeque)other).size() != this.size()) {
            return false;
        }
        int n = 0;
        int n2 = this.size();
        while (n < n2) {
            int n3;
            if (this.get(n3 = n++) == ((FloatDeque)other).get(n3)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int n = 0;
        int n2 = this.size();
        while (n < n2) {
            int n3 = n++;
            sb.append(this.get(n3));
            if (n3 == this.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(']');
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

