/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.kds;

import com.soywiz.kds._ExtensionsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.PublishedApi;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.markers.KMutableCollection;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010)\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 I2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001IB'\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0006j\b\u0012\u0004\u0012\u00020\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u0002H\u0016J\u0016\u0010&\u001a\u00020\u00162\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\u0011\u0010+\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010,\u001a\u00020\u00162\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020(H\u0016J\u0010\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020\nH\u0002J\u0013\u0010/\u001a\u00020\u00162\b\u00100\u001a\u0004\u0018\u000101H\u0096\u0002J\u0018\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u00022\u0006\u00104\u001a\u00020\u0002H\u0002J\b\u00105\u001a\u00020\nH\u0016J\u000e\u00106\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u0002J\b\u00107\u001a\u00020\u0016H\u0016J\u000f\u00108\u001a\b\u0012\u0004\u0012\u00020\u000209H\u0096\u0002J\u0018\u0010:\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u00022\u0006\u00104\u001a\u00020\u0002H\u0002J\u0010\u0010;\u001a\u00020*2\u0006\u0010.\u001a\u00020\nH\u0002J\u0010\u0010<\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u0002H\u0016J\u0016\u0010=\u001a\u00020\u00162\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020(H\u0016J\u000e\u0010>\u001a\u00020*2\u0006\u0010.\u001a\u00020\nJ\u0006\u0010?\u001a\u00020\u0002J\u0016\u0010@\u001a\u00020\u00162\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020(H\u0016J\u0018\u0010A\u001a\u00020*2\u0006\u0010B\u001a\u00020\n2\u0006\u0010C\u001a\u00020\nH\u0002J\u0006\u0010D\u001a\u00020\u0004J\b\u0010E\u001a\u00020FH\u0016J\u000e\u0010G\u001a\u00020*2\u0006\u0010.\u001a\u00020\nJ\u000e\u0010H\u001a\u00020*2\u0006\u0010%\u001a\u00020\u0002R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0006j\b\u0012\u0004\u0012\u00020\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\fR\u0018\u0010\u0015\u001a\u00020\u0016*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u0018\u0010\u0018\u001a\u00020\n*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001b\u001a\u00020\n*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0018\u0010\u001d\u001a\u00020\n*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001aR(\u0010\u001f\u001a\u00020\u0002*\u00020\n2\u0006\u0010\u001f\u001a\u00020\u00028B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006J"}, d2={"Lcom/soywiz/kds/FloatPriorityQueue;", "", "", "data", "", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "([FLjava/util/Comparator;)V", "capacity", "", "getCapacity", "()I", "getComparator", "()Ljava/util/Comparator;", "head", "getHead", "()F", "<set-?>", "size", "getSize", "isRoot", "", "(I)Z", "left", "getLeft", "(I)I", "parent", "getParent", "right", "getRight", "value", "getValue", "(I)F", "setValue", "(IF)V", "add", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "ensure", "index", "equals", "other", "", "gt", "a", "b", "hashCode", "indexOf", "isEmpty", "iterator", "", "lt", "minHeapify", "remove", "removeAll", "removeAt", "removeHead", "retainAll", "swap", "l", "r", "toArraySorted", "toString", "", "updateAt", "updateObject", "Companion", "kds_debug"})
public final class FloatPriorityQueue
implements Collection<Float>,
KMutableCollection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private float[] data;
    @NotNull
    private final Comparator<Float> comparator;
    private int size;

    @PublishedApi
    public FloatPriorityQueue(@NotNull float[] data, @NotNull Comparator<Float> comparator) {
        this.data = data;
        this.comparator = comparator;
    }

    @NotNull
    public final Comparator<Float> getComparator() {
        return this.comparator;
    }

    private final float getValue(int $this$value) {
        return this.data[$this$value];
    }

    private final void setValue(int $this$value, float value) {
        this.data[$this$value] = value;
    }

    private final boolean isRoot(int $this$isRoot) {
        return $this$isRoot == 0;
    }

    private final int getParent(int $this$parent) {
        return ($this$parent - 1) / 2;
    }

    private final int getLeft(int $this$left) {
        return 2 * $this$left + 1;
    }

    private final int getRight(int $this$right) {
        return 2 * $this$right + 2;
    }

    private final boolean gt(float a, float b) {
        return this.comparator.compare(Float.valueOf(a), Float.valueOf(b)) > 0;
    }

    private final boolean lt(float a, float b) {
        return this.comparator.compare(Float.valueOf(a), Float.valueOf(b)) < 0;
    }

    private final int getCapacity() {
        return this.data.length;
    }

    public int getSize() {
        return this.size;
    }

    public final float getHead() {
        if (this.size() <= 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[0];
    }

    @Override
    public boolean add(float element) {
        int n = this.size();
        this.size = n + 1;
        this.ensure(this.size());
        int i = this.size() - 1;
        this.setValue(i, element);
        while (!this.isRoot(i) && this.gt(this.getValue(this.getParent(i)), this.getValue(i))) {
            this.swap(i, this.getParent(i));
            i = this.getParent(i);
        }
        return true;
    }

    public final float removeHead() {
        if (this.size() <= 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.size() == 1) {
            int n = this.size();
            this.size = n + -1;
            return this.getValue(0);
        }
        float root = this.getValue(0);
        this.setValue(0, this.getValue(this.size() - 1));
        int n = this.size();
        this.size = n + -1;
        this.minHeapify(0);
        return root;
    }

    public final int indexOf(float element) {
        int n = this.size();
        for (int n2 = 0; n2 < n; ++n2) {
            if (!(this.data[n2] == element)) continue;
            return n2;
        }
        return -1;
    }

    public final void updateObject(float element) {
        int index = this.indexOf(element);
        if (index >= 0) {
            this.updateAt(index);
        }
    }

    public final void updateAt(int index) {
        float value = this.getValue(index);
        this.removeAt(index);
        this.add(value);
    }

    public boolean remove(float element) {
        int index = this.indexOf(element);
        if (index >= 0) {
            this.removeAt(index);
        }
        return index >= 0;
    }

    public final void removeAt(int index) {
        int i = index;
        while (i != 0) {
            this.swap(i, this.getParent(i));
            i = this.getParent(i);
        }
        this.removeHead();
    }

    private final void ensure(int index) {
        if (index >= this.getCapacity()) {
            float[] fArray = Arrays.copyOf(this.data, 2 + this.getCapacity() * 2);
            Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(this, newSize)");
            Intrinsics.checkNotNull((Object)fArray, (String)"null cannot be cast to non-null type kotlin.FloatArray");
            this.data = fArray;
        }
    }

    private final void minHeapify(int index) {
        int i = index;
        while (true) {
            int left = this.getLeft(i);
            int right = this.getRight(i);
            int smallest = i;
            if (left < this.size() && this.lt(this.getValue(left), this.getValue(i))) {
                smallest = left;
            }
            if (right < this.size() && this.lt(this.getValue(right), this.getValue(smallest))) {
                smallest = right;
            }
            if (smallest == i) break;
            this.swap(i, smallest);
            i = smallest;
        }
    }

    private final void swap(int l, int r) {
        float temp = this.getValue(r);
        this.setValue(r, this.getValue(l));
        this.setValue(l, temp);
    }

    public boolean contains(float element) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = (Iterable)RangesKt.until((int)0, (int)this.size());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (!(this.getValue(it) == element)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        boolean bl;
        block3: {
            Set thisSet = CollectionsKt.toSet((Iterable)this);
            Iterable $this$all$iv = elements;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    float it = ((Number)element$iv).floatValue();
                    boolean bl2 = false;
                    if (thisSet.contains(Float.valueOf(it))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Float> elements) {
        Iterator<? extends Float> iterator2 = elements.iterator();
        while (iterator2.hasNext()) {
            float e = ((Number)iterator2.next()).floatValue();
            this.add(e);
        }
        return !elements.isEmpty();
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        ArrayList temp = new ArrayList(CollectionsKt.toList((Iterable)this));
        boolean res = temp.removeAll(elements);
        this.clear();
        this.addAll(temp);
        return res;
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        ArrayList temp = new ArrayList(CollectionsKt.toList((Iterable)this));
        boolean res = temp.retainAll(elements);
        this.clear();
        this.addAll(temp);
        return res;
    }

    @Override
    @NotNull
    public Iterator<Float> iterator() {
        Ref.IntRef index = new Ref.IntRef();
        return new Iterator<Float>(index, this){
            final /* synthetic */ Ref.IntRef $index;
            final /* synthetic */ FloatPriorityQueue this$0;
            {
                this.$index = $index;
                this.this$0 = $receiver;
            }

            public boolean hasNext() {
                return this.$index.element < this.this$0.size();
            }

            @NotNull
            public Float next() {
                int n = this.$index.element;
                this.$index.element = n + 1;
                return Float.valueOf(FloatPriorityQueue.access$getValue(this.this$0, n));
            }

            @NotNull
            public Void remove() {
                throw new NotImplementedError(null, 1, null);
            }
        };
    }

    @NotNull
    public final float[] toArraySorted() {
        float[] out = new float[this.size()];
        int n = this.size();
        for (int n2 = 0; n2 < n; ++n2) {
            out[n2] = this.removeHead();
        }
        n = out.length;
        for (int i = 0; i < n; ++i) {
            float v = out[i];
            this.add(v);
        }
        return out;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.toList((Iterable)this).toString();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof FloatPriorityQueue && Arrays.equals(this.data, ((FloatPriorityQueue)other).data) && Intrinsics.areEqual(this.comparator, ((FloatPriorityQueue)other).comparator);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public static final /* synthetic */ float access$getValue(FloatPriorityQueue $this, int $receiver) {
        return $this.getValue($receiver);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0086\u0002JK\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u000626\u0010\u0007\u001a2\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\bH\u0086\u0002J+\u0010\u0003\u001a\u00020\u00042\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\u000fj\b\u0012\u0004\u0012\u00020\t`\u00102\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0011"}, d2={"Lcom/soywiz/kds/FloatPriorityQueue$Companion;", "", "()V", "invoke", "Lcom/soywiz/kds/FloatPriorityQueue;", "reversed", "", "comparator", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "left", "right", "", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "kds_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FloatPriorityQueue invoke(@NotNull Comparator<Float> comparator, boolean reversed) {
            float[] fArray = new float[16];
            Comparator<Float> comparator2 = reversed ? comparator.reversed() : comparator;
            Intrinsics.checkNotNullExpressionValue(comparator2, (String)"if (reversed) comparator\u2026eversed() else comparator");
            return new FloatPriorityQueue(fArray, comparator2);
        }

        public static /* synthetic */ FloatPriorityQueue invoke$default(Companion companion, Comparator comparator, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.invoke(comparator, bl);
        }

        @NotNull
        public final FloatPriorityQueue invoke(boolean reversed, @NotNull Function2<? super Float, ? super Float, Integer> comparator) {
            return Companion.invoke((arg_0, arg_1) -> Companion.invoke$lambda-0(comparator, arg_0, arg_1), reversed);
        }

        public static /* synthetic */ FloatPriorityQueue invoke$default(Companion companion, boolean bl, Function2 function2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            return companion.invoke(bl, (Function2<? super Float, ? super Float, Integer>)function2);
        }

        @NotNull
        public final FloatPriorityQueue invoke(boolean reversed) {
            return Companion.invoke(_ExtensionsKt.comparator(), reversed);
        }

        public static /* synthetic */ FloatPriorityQueue invoke$default(Companion companion, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            return companion.invoke(bl);
        }

        private static final int invoke$lambda-0(Function2 $tmp0, Float p0, Float p1) {
            return ((Number)$tmp0.invoke((Object)p0, (Object)p1)).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

