/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.kds;

import com.soywiz.kds._ExtensionsKt;
import com.soywiz.kds.internal.InternalKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableCollection;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0010\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010)\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\"\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\r2\b\b\u0002\u0010\u001f\u001a\u00020\u00052\b\b\u0002\u0010\u0013\u001a\u00020\u0005J\u0016\u0010\u001c\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0016J\u0014\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020 J\u0014\u0010!\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018J\u000e\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u0002J\"\u0010$\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\r2\b\b\u0002\u0010\u001f\u001a\u00020\u00052\b\b\u0002\u0010\u0013\u001a\u00020\u0005J\u000e\u0010%\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u0002J\"\u0010&\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\r2\b\b\u0002\u0010\u001f\u001a\u00020\u00052\b\b\u0002\u0010\u0013\u001a\u00020\u0005J\b\u0010'\u001a\u00020\u001dH\u0016J\u0011\u0010(\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010)\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0016J(\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020\u0005H\u0002J\u0013\u0010/\u001a\u00020\u00162\b\u00100\u001a\u0004\u0018\u000101H\u0096\u0002J\u0011\u00102\u001a\u00020\u00022\u0006\u00103\u001a\u00020\u0005H\u0086\u0002J\b\u00104\u001a\u00020\u0005H\u0016J\u000e\u00105\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0002J\u0010\u00106\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u0005H\u0002J\b\u00107\u001a\u00020\u0016H\u0016J\u000f\u00108\u001a\b\u0012\u0004\u0012\u00020\u000209H\u0096\u0002J\u0010\u0010:\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\u0016\u0010;\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0016J\u000e\u0010<\u001a\u00020\u00022\u0006\u00103\u001a\u00020\u0005J\u0006\u0010=\u001a\u00020\u0002J\u0006\u0010>\u001a\u00020\u0002J\u0010\u0010?\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u0005H\u0002J\u0016\u0010@\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0016J\u0019\u0010A\u001a\u00020\u001d2\u0006\u00103\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u0002H\u0086\u0002J\b\u0010C\u001a\u00020DH\u0016R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000b\u00a8\u0006E"}, d2={"Lcom/soywiz/kds/ByteDeque;", "", "", "()V", "initialCapacity", "", "(I)V", "_size", "_start", "capacity", "getCapacity", "()I", "data", "", "first", "getFirst", "()B", "last", "getLast", "size", "getSize", "_removeRetainAll", "", "elements", "", "retain", "add", "element", "addAll", "", "items", "offset", "", "addAllFirst", "addFirst", "item", "addFirstAll", "addLast", "addLastAll", "clear", "contains", "containsAll", "copyCyclic", "i", "istart", "o", "count", "equals", "other", "", "get", "index", "hashCode", "indexOf", "internalIndex", "isEmpty", "iterator", "", "remove", "removeAll", "removeAt", "removeFirst", "removeLast", "resizeIfRequiredFor", "retainAll", "set", "value", "toString", "", "kds_release"})
public class ByteDeque
implements Collection<Byte>,
KMutableCollection {
    private int _start;
    private int _size;
    @NotNull
    private byte[] data;

    public ByteDeque(int initialCapacity) {
        this.data = new byte[initialCapacity];
    }

    private final int getCapacity() {
        return this.data.length;
    }

    public ByteDeque() {
        this(16);
    }

    public int getSize() {
        return this._size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private final void resizeIfRequiredFor(int count) {
        if (this.size() + count > this.getCapacity()) {
            byte[] i = this.data;
            int istart = this._start;
            byte[] o = new byte[this.data.length * 2];
            this.copyCyclic(i, istart, o, this._size);
            this.data = o;
            this._start = 0;
        }
    }

    private final void copyCyclic(byte[] i, int istart, byte[] o, int count) {
        int size1 = Math.min(i.length - istart, count);
        int size2 = count - size1;
        InternalKt.arraycopy(i, istart, o, 0, size1);
        if (size2 > 0) {
            InternalKt.arraycopy(i, 0, o, size1, size2);
        }
    }

    public final void addAll(@NotNull Iterable<Byte> items) {
        this.resizeIfRequiredFor(CollectionsKt.count(items));
        Iterator<Byte> iterator2 = items.iterator();
        while (iterator2.hasNext()) {
            byte i = ((Number)iterator2.next()).byteValue();
            this.addLast(i);
        }
    }

    public final void addAllFirst(@NotNull Collection<Byte> items) {
        this.resizeIfRequiredFor(items.size());
        this._start = InternalKt.umod(this._start - items.size(), this.getCapacity());
        this._size += items.size();
        int pos = this._start;
        Iterator<Byte> iterator2 = items.iterator();
        while (iterator2.hasNext()) {
            byte it = ((Number)iterator2.next()).byteValue();
            this.data[InternalKt.umod((int)pos++, (int)this.getCapacity())] = it;
        }
    }

    public final void addFirst(byte item) {
        this.resizeIfRequiredFor(1);
        this._start = InternalKt.umod(this._start - 1, this.getCapacity());
        int n = this._size;
        this._size = n + 1;
        this.data[this._start] = item;
    }

    public final void addLast(byte item) {
        this.resizeIfRequiredFor(1);
        this.data[InternalKt.umod((int)(this._start + this.size()), (int)this.getCapacity())] = item;
        int n = this._size;
        this._size = n + 1;
    }

    public final void addFirstAll(@NotNull byte[] items, int offset, int size) {
        for (int n = 0; n < size; ++n) {
            this.addFirst(items[size - offset + n - 1]);
        }
    }

    public static /* synthetic */ void addFirstAll$default(ByteDeque byteDeque, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addFirstAll");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length - n;
        }
        byteDeque.addFirstAll(byArray, n, n2);
    }

    public final void addLastAll(@NotNull byte[] items, int offset, int size) {
        for (int n = 0; n < size; ++n) {
            this.addLast(items[offset + n]);
        }
    }

    public static /* synthetic */ void addLastAll$default(ByteDeque byteDeque, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addLastAll");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length - n;
        }
        byteDeque.addLastAll(byArray, n, n2);
    }

    public final void addAll(@NotNull byte[] items, int offset, int size) {
        this.addLastAll(items, offset, size);
    }

    public static /* synthetic */ void addAll$default(ByteDeque byteDeque, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addAll");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length - n;
        }
        byteDeque.addAll(byArray, n, n2);
    }

    public final byte removeFirst() {
        byte by;
        if (this._size <= 0) {
            throw new IndexOutOfBoundsException();
        }
        byte $this$removeFirst_u24lambda_u2d0 = by = this.getFirst();
        boolean bl = false;
        this._start = InternalKt.umod(this._start + 1, this.getCapacity());
        int n = this._size;
        this._size = n + -1;
        return by;
    }

    public final byte removeLast() {
        byte by;
        if (this._size <= 0) {
            throw new IndexOutOfBoundsException();
        }
        byte $this$removeLast_u24lambda_u2d1 = by = this.getLast();
        boolean bl = false;
        int n = this._size;
        this._size = n + -1;
        return by;
    }

    public final byte removeAt(int index) {
        int n;
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (index == 0) {
            return this.removeFirst();
        }
        if (index == this.size() - 1) {
            return this.removeLast();
        }
        byte old = this.get(index);
        if (index < this.size() / 2) {
            for (n = index; 0 < n; --n) {
                this.set(n, this.get(n - 1));
            }
            this._start = InternalKt.umod(this._start + 1, this.getCapacity());
        } else {
            int n2 = this.size() - 1;
            for (n = index; n < n2; ++n) {
                this.set(n, this.get(n + 1));
            }
        }
        int n3 = this._size;
        this._size = n3 + -1;
        return old;
    }

    @Override
    public boolean add(byte element) {
        boolean bl;
        boolean $this$add_u24lambda_u2d2 = bl = true;
        boolean bl2 = false;
        this.addLast(element);
        return bl;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Byte> elements) {
        boolean bl;
        boolean $this$addAll_u24lambda_u2d3 = bl = true;
        boolean bl2 = false;
        Intrinsics.checkNotNull(elements, (String)"null cannot be cast to non-null type kotlin.collections.Iterable<kotlin.Byte>");
        this.addAll((Iterable<Byte>)elements);
        return bl;
    }

    @Override
    public void clear() {
        this._size = 0;
    }

    public boolean remove(byte element) {
        int index = this.indexOf(element);
        if (index >= 0) {
            this.removeAt(index);
        }
        return index >= 0;
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        return this._removeRetainAll(elements, false);
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        return this._removeRetainAll(elements, true);
    }

    private final boolean _removeRetainAll(Collection<Byte> elements, boolean retain) {
        Set eset = CollectionsKt.toSet((Iterable)elements);
        byte[] byArray = Arrays.copyOf(this.data, this.data.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, size)");
        byte[] temp = byArray;
        int tsize = 0;
        int osize = this.size();
        int n = this.size();
        for (int n2 = 0; n2 < n; ++n2) {
            byte c = this.get(n2);
            if (eset.contains(c) != retain) continue;
            temp[tsize++] = c;
        }
        this.data = temp;
        this._start = 0;
        this._size = tsize;
        return tsize != osize;
    }

    public final byte getFirst() {
        return this.data[this._start];
    }

    public final byte getLast() {
        return this.data[this.internalIndex(this.size() - 1)];
    }

    private final int internalIndex(int index) {
        return InternalKt.umod(this._start + index, this.getCapacity());
    }

    public final void set(int index, byte value) {
        this.data[this.internalIndex((int)index)] = value;
    }

    public final byte get(int index) {
        return this.data[this.internalIndex(index)];
    }

    public boolean contains(byte element) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = (Iterable)RangesKt.until((int)0, (int)this.size());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (!(this.get(it) == element)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final int indexOf(byte element) {
        int n = this.size();
        for (int n2 = 0; n2 < n; ++n2) {
            if (this.get(n2) != element) continue;
            return n2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        boolean bl;
        block5: {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = elements;
            int $i$f$map = 0;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                byte by = ((Number)item$iv$iv).byteValue();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(TuplesKt.to((Object)((byte)it), (Object)0));
            }
            LinkedHashMap emap = _ExtensionsKt.toLinkedMap((List)destination$iv$iv);
            $i$f$map = this.size();
            for (int it = 0; it < $i$f$map; ++it) {
                byte e = this.get(it);
                Byte $i$f$mapTo2 = e;
                if (!((Map)emap).containsKey($i$f$mapTo2)) continue;
                $i$f$mapTo2 = e;
                ((Map)emap).put($i$f$mapTo2, 1);
            }
            Collection collection = emap.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"emap.values");
            Iterable $this$all$iv = collection;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Integer it = (Integer)element$iv;
                    boolean bl3 = false;
                    Integer n = it;
                    int n2 = 1;
                    if (n != null && n == n2) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Iterator<Byte> iterator() {
        ByteDeque that = this;
        return new Iterator<Byte>(that, this){
            private int index;
            final /* synthetic */ ByteDeque $that;
            final /* synthetic */ ByteDeque this$0;
            {
                this.$that = $that;
                this.this$0 = $receiver;
            }

            public final int getIndex() {
                return this.index;
            }

            public final void setIndex(int n) {
                this.index = n;
            }

            @NotNull
            public Byte next() {
                int n = this.index;
                this.index = n + 1;
                return this.$that.get(n);
            }

            public boolean hasNext() {
                return this.index < this.this$0.size();
            }

            public void remove() {
                this.index += -1;
                this.this$0.removeAt(this.index);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var3_3;
        int size$iv = this.size();
        boolean $i$f$contentHashCode = false;
        int result$iv = 1;
        int n$iv = 0;
        while (n$iv < size$iv) {
            void it;
            int n = n$iv++;
            int n2 = 31 * result$iv;
            boolean bl = false;
            Byte by = this.get((int)it);
            result$iv = n2 + ((Object)by).hashCode();
        }
        return (int)var3_3;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ByteDeque)) {
            return false;
        }
        if (((ByteDeque)other).size() != this.size()) {
            return false;
        }
        int n = this.size();
        for (int n2 = 0; n2 < n; ++n2) {
            if (this.get(n2) == ((ByteDeque)other).get(n2)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int n = this.size();
        for (int n2 = 0; n2 < n; ++n2) {
            sb.append((Object)this.get(n2));
            if (n2 == this.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(']');
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

