/*
 * Decompiled with CFR 0.152.
 */
package korlibs.datastructure;

import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010*\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\t\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\t\u0010\u0011\u001a\u00020\u000eH\u0096\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\b\u0010\u0013\u001a\u00020\u0006H\u0016J\u000e\u0010\u0014\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0006H\u0016J\r\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0018\u001a\u00020\u0006H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lkorlibs/datastructure/GenericListIterator;", "T", "", "list", "", "iindex", "", "(Ljava/util/List;I)V", "getIindex", "()I", "index", "getList", "()Ljava/util/List;", "equals", "", "other", "", "hasNext", "hasPrevious", "hashCode", "next", "()Ljava/lang/Object;", "nextIndex", "previous", "previousIndex", "kds_release"})
public final class GenericListIterator<T>
implements ListIterator<T>,
KMappedMarker {
    @NotNull
    private final List<T> list;
    private final int iindex;
    private int index;

    public GenericListIterator(@NotNull List<? extends T> list2, int iindex) {
        this.list = list2;
        this.iindex = iindex;
        int n = this.list.size();
        int n2 = this.iindex;
        if (!(0 <= n2 ? n2 < n : false)) {
            throw new IndexOutOfBoundsException(String.valueOf(this.iindex));
        }
        this.index = this.iindex;
    }

    public /* synthetic */ GenericListIterator(List list2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(list2, n);
    }

    @NotNull
    public final List<T> getList() {
        return this.list;
    }

    public final int getIindex() {
        return this.iindex;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.list.size();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int n = this.index;
        this.index = n + 1;
        return this.list.get(n);
    }

    @Override
    public boolean hasPrevious() {
        return this.index > 0;
    }

    @Override
    public int nextIndex() {
        return this.index;
    }

    @Override
    public T previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        this.index += -1;
        return this.list.get(this.index);
    }

    @Override
    public int previousIndex() {
        return this.index - 1;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof GenericListIterator && Intrinsics.areEqual(this.list, ((GenericListIterator)other).list) && this.index == ((GenericListIterator)other).index;
    }

    public int hashCode() {
        return ((Object)this.list).hashCode() + Integer.hashCode(this.index);
    }

    @Override
    public void add(T element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void set(T element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

