/*
 * Decompiled with CFR 0.152.
 */
package korlibs.datastructure;

import korlibs.datastructure.internal.InternalKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0017\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0000J\u0006\u0010\u0017\u001a\u00020\u0003J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001b\u001a\u00020\u0003H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u0003J$\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\r2\b\b\u0002\u0010\u001e\u001a\u00020\u00032\b\b\u0002\u0010!\u001a\u00020\u0003H\u0007J\u0006\u0010\"\u001a\u00020\u001dJ$\u0010#\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\r2\b\b\u0002\u0010\u001e\u001a\u00020\u00032\b\b\u0002\u0010!\u001a\u00020\u0003H\u0007J$\u0010$\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\r2\b\b\u0002\u0010\u001e\u001a\u00020\u00032\b\b\u0002\u0010!\u001a\u00020\u0003H\u0007J\u000e\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u001dR\u001e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lkorlibs/datastructure/ShortRingBuffer;", "", "bits", "", "(I)V", "<set-?>", "availableRead", "getAvailableRead", "()I", "availableWrite", "getAvailableWrite", "getBits", "buffer", "", "mask", "readPos", "temp", "totalSize", "getTotalSize", "writePos", "clear", "", "clone", "contentHashCode", "equals", "", "other", "hashCode", "peek", "", "offset", "read", "data", "size", "readOne", "write", "writeHead", "writeOne", "value", "kds_release"})
@SourceDebugExtension(value={"SMAP\nRingBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RingBuffer.kt\nkorlibs/datastructure/ShortRingBuffer\n+ 2 internal.kt\nkorlibs/datastructure/internal/InternalKt\n*L\n1#1,355:1\n104#2,2:356\n83#2,6:358\n*S KotlinDebug\n*F\n+ 1 RingBuffer.kt\nkorlibs/datastructure/ShortRingBuffer\n*L\n235#1:356,2\n237#1:358,6\n*E\n"})
public final class ShortRingBuffer {
    private final int bits;
    private final int totalSize;
    private final int mask;
    @NotNull
    private final short[] buffer;
    private int readPos;
    private int writePos;
    private int availableWrite;
    private int availableRead;
    @NotNull
    private final short[] temp;

    public ShortRingBuffer(int bits) {
        this.bits = bits;
        this.totalSize = 1 << this.bits;
        this.mask = this.totalSize - 1;
        this.buffer = new short[this.totalSize];
        this.availableWrite = this.totalSize;
        this.temp = new short[1];
    }

    public final int getBits() {
        return this.bits;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    public final int getAvailableWrite() {
        return this.availableWrite;
    }

    public final int getAvailableRead() {
        return this.availableRead;
    }

    @NotNull
    public final ShortRingBuffer clone() {
        ShortRingBuffer shortRingBuffer;
        ShortRingBuffer out = shortRingBuffer = new ShortRingBuffer(this.bits);
        boolean bl = false;
        InternalKt.arraycopy(this.buffer, 0, out.buffer, 0, this.buffer.length);
        out.readPos = this.readPos;
        out.writePos = this.writePos;
        out.availableWrite = this.availableWrite;
        out.availableRead = this.availableRead;
        return shortRingBuffer;
    }

    @JvmOverloads
    public final int writeHead(@NotNull short[] data, int offset, int size) {
        int toWrite = Math.min(this.availableWrite, size);
        for (int n = 0; n < toWrite; ++n) {
            this.readPos = this.readPos - 1 & this.mask;
            this.buffer[this.readPos] = data[offset + size - n - 1];
        }
        this.availableRead += toWrite;
        this.availableWrite -= toWrite;
        return toWrite;
    }

    public static /* synthetic */ int writeHead$default(ShortRingBuffer shortRingBuffer, short[] sArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = sArray.length - n;
        }
        return shortRingBuffer.writeHead(sArray, n, n2);
    }

    @JvmOverloads
    public final int write(@NotNull short[] data, int offset, int size) {
        int toWrite = Math.min(this.availableWrite, size);
        for (int n = 0; n < toWrite; ++n) {
            this.buffer[this.writePos] = data[offset + n];
            this.writePos = this.writePos + 1 & this.mask;
        }
        this.availableRead += toWrite;
        this.availableWrite -= toWrite;
        return toWrite;
    }

    public static /* synthetic */ int write$default(ShortRingBuffer shortRingBuffer, short[] sArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = sArray.length - n;
        }
        return shortRingBuffer.write(sArray, n, n2);
    }

    @JvmOverloads
    public final int read(@NotNull short[] data, int offset, int size) {
        int toRead = Math.min(this.availableRead, size);
        for (int n = 0; n < toRead; ++n) {
            data[offset + n] = this.buffer[this.readPos];
            this.readPos = this.readPos + 1 & this.mask;
        }
        this.availableWrite += toRead;
        this.availableRead -= toRead;
        return toRead;
    }

    public static /* synthetic */ int read$default(ShortRingBuffer shortRingBuffer, short[] sArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = sArray.length - n;
        }
        return shortRingBuffer.read(sArray, n, n2);
    }

    public final short readOne() {
        this.read(this.temp, 0, 1);
        return this.temp[0];
    }

    public final void writeOne(short value) {
        this.temp[0] = value;
        this.write(this.temp, 0, 1);
    }

    public final void clear() {
        this.readPos = 0;
        this.writePos = 0;
        this.availableRead = 0;
        this.availableWrite = this.totalSize;
    }

    public final short peek(int offset) {
        return this.buffer[this.readPos + offset & this.mask];
    }

    public static /* synthetic */ short peek$default(ShortRingBuffer shortRingBuffer, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return shortRingBuffer.peek(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ShortRingBuffer)) return false;
        if (this.availableRead != ((ShortRingBuffer)other).availableRead) return false;
        int count$iv = this.availableRead;
        boolean $i$f$equaler = false;
        int n$iv = 0;
        while (n$iv < count$iv) {
            int it = n$iv;
            boolean bl = false;
            if (this.peek(it) != ((ShortRingBuffer)other).peek(it)) return false;
            boolean bl2 = true;
            if (!bl2) {
                return false;
            }
            ++n$iv;
        }
        return true;
    }

    public int hashCode() {
        return this.contentHashCode();
    }

    /*
     * WARNING - void declaration
     */
    public final int contentHashCode() {
        void var3_3;
        int count$iv = this.availableRead;
        boolean $i$f$hashCoder = false;
        int out$iv = 0;
        int n$iv = 0;
        while (n$iv < count$iv) {
            void it;
            int n = n$iv++;
            int n2 = out$iv *= 7;
            boolean bl = false;
            short s = this.peek((int)it);
            out$iv = n2 + s;
        }
        return (int)var3_3;
    }

    @JvmOverloads
    public final int writeHead(@NotNull short[] data, int offset) {
        return ShortRingBuffer.writeHead$default(this, data, offset, 0, 4, null);
    }

    @JvmOverloads
    public final int writeHead(@NotNull short[] data) {
        return ShortRingBuffer.writeHead$default(this, data, 0, 0, 6, null);
    }

    @JvmOverloads
    public final int write(@NotNull short[] data, int offset) {
        return ShortRingBuffer.write$default(this, data, offset, 0, 4, null);
    }

    @JvmOverloads
    public final int write(@NotNull short[] data) {
        return ShortRingBuffer.write$default(this, data, 0, 0, 6, null);
    }

    @JvmOverloads
    public final int read(@NotNull short[] data, int offset) {
        return ShortRingBuffer.read$default(this, data, offset, 0, 4, null);
    }

    @JvmOverloads
    public final int read(@NotNull short[] data) {
        return ShortRingBuffer.read$default(this, data, 0, 0, 6, null);
    }
}

