/*
 * Decompiled with CFR 0.152.
 */
package korlibs.datastructure;

import java.util.Map;
import java.util.Set;
import korlibs.datastructure.BaseCacheMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\t\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B9\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\u0002\u0010\fJ\u001d\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010\u001d\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001a\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001eJ\u001d\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010 J\u001d\u0010!\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010\u001cR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\""}, d2={"Lkorlibs/datastructure/LRUCache;", "K", "V", "Lkorlibs/datastructure/BaseCacheMap;", "maxSize", "", "maxMemory", "", "atLeastOne", "", "getElementMemory", "Lkotlin/Function1;", "(IJZLkotlin/jvm/functions/Function1;)V", "getAtLeastOne", "()Z", "<set-?>", "computedMemory", "getComputedMemory", "()J", "getGetElementMemory", "()Lkotlin/jvm/functions/Function1;", "getMaxMemory", "getMaxSize", "()I", "freed", "", "key", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "mustFree", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "putNew", "kds_release"})
public class LRUCache<K, V>
extends BaseCacheMap<K, V> {
    private final int maxSize;
    private final long maxMemory;
    private final boolean atLeastOne;
    @NotNull
    private final Function1<V, Integer> getElementMemory;
    private long computedMemory;

    public LRUCache(int maxSize, long maxMemory, boolean atLeastOne, @NotNull Function1<? super V, Integer> getElementMemory) {
        this.maxSize = maxSize;
        this.maxMemory = maxMemory;
        this.atLeastOne = atLeastOne;
        this.getElementMemory = getElementMemory;
    }

    public /* synthetic */ LRUCache(int n, long l, boolean bl, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 2) != 0) {
            l = Long.MAX_VALUE;
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        if ((n2 & 8) != 0) {
            function1 = 1.INSTANCE;
        }
        this(n, l, bl, function1);
    }

    public final int getMaxSize() {
        return this.maxSize;
    }

    public final long getMaxMemory() {
        return this.maxMemory;
    }

    public final boolean getAtLeastOne() {
        return this.atLeastOne;
    }

    @NotNull
    public final Function1<V, Integer> getGetElementMemory() {
        return this.getElementMemory;
    }

    public final long getComputedMemory() {
        return this.computedMemory;
    }

    @Override
    protected boolean mustFree(K key, V value) {
        if (this.atLeastOne && this.size() <= 1) {
            return false;
        }
        if (this.size() > this.maxSize) {
            return true;
        }
        return this.computedMemory > this.maxMemory;
    }

    @Override
    protected void putNew(K key, V value) {
        this.computedMemory += ((Number)this.getElementMemory.invoke(value)).longValue();
    }

    @Override
    protected void freed(K key, V value) {
        this.computedMemory -= ((Number)this.getElementMemory.invoke(value)).longValue();
    }

    @Override
    @Nullable
    public V get(Object key) {
        Object value;
        if (!((Map)this.getMap()).isEmpty()) {
            Set set = this.getMap().keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            if (Intrinsics.areEqual((Object)CollectionsKt.last((Iterable)set), (Object)key)) {
                return this.getMap().get(key);
            }
        }
        if ((value = this.getMap().remove(key)) != null) {
            ((Map)this.getMap()).put(key, value);
        }
        return value;
    }

    public LRUCache() {
        this(0, 0L, false, null, 15, null);
    }
}

