/*
 * Decompiled with CFR 0.152.
 */
package korlibs.datastructure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import korlibs.datastructure.PriorityQueueNode;
import korlibs.datastructure._ExtensionsKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.PublishedApi;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableCollection;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010)\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 J2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001JB!\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0010\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u00020\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0002H\u0016J\u0016\u0010%\u001a\u00020\u00142\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\u0011\u0010*\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010+\u001a\u00020\u00142\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020'H\u0016J\u0010\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020\u0002H\u0002J\u0013\u0010.\u001a\u00020\u00142\b\u0010/\u001a\u0004\u0018\u000100H\u0096\u0002J\u0018\u00101\u001a\u00020\u00142\u0006\u00102\u001a\u00020\u00022\u0006\u00103\u001a\u00020\u0002H\u0002J\b\u00104\u001a\u00020\u0002H\u0016J\u000e\u00105\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u0002J\b\u00106\u001a\u00020\u0014H\u0016J\u000f\u00107\u001a\b\u0012\u0004\u0012\u00020\u000208H\u0096\u0002J\u0018\u00109\u001a\u00020\u00142\u0006\u00102\u001a\u00020\u00022\u0006\u00103\u001a\u00020\u0002H\u0002J\u0010\u0010:\u001a\u00020)2\u0006\u0010-\u001a\u00020\u0002H\u0002J\u0015\u0010;\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010<J\u0016\u0010=\u001a\u00020\u00142\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020'H\u0016J\u000e\u0010>\u001a\u00020)2\u0006\u0010-\u001a\u00020\u0002J\u0006\u0010?\u001a\u00020\u0002J\u0016\u0010@\u001a\u00020\u00142\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020'H\u0016J%\u0010A\u001a\u00020)2\u0006\u0010B\u001a\u00020\u00152\u0006\u0010C\u001a\u00020\u0015H\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\bD\u0010\"J\u0006\u0010E\u001a\u00020\u0004J\b\u0010F\u001a\u00020GH\u0016J\u000e\u0010H\u001a\u00020)2\u0006\u0010-\u001a\u00020\u0002J\u000e\u0010I\u001a\u00020)2\u0006\u0010$\u001a\u00020\u0002R\u0014\u0010\t\u001a\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u00020\u0006j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u001e\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000bR\u001b\u0010\u0013\u001a\u00020\u0014*\u00020\u00158BX\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R!\u0010\u0018\u001a\u00020\u0015*\u00020\u00158BX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR!\u0010\u001b\u001a\u00020\u0015*\u00020\u00158BX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR!\u0010\u001d\u001a\u00020\u0015*\u00020\u00158BX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001aR+\u0010\u001f\u001a\u00020\u0002*\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00028B@BX\u0082\u000e\u00f8\u0001\u0000\u00a2\u0006\f\u001a\u0004\b \u0010\u001a\"\u0004\b!\u0010\"\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006K"}, d2={"Lkorlibs/datastructure/IntPriorityQueue;", "", "", "data", "", "comparator", "Ljava/util/Comparator;", "Lkorlibs/datastructure/IntComparator;", "([ILjava/util/Comparator;)V", "capacity", "getCapacity", "()I", "getComparator", "()Ljava/util/Comparator;", "head", "getHead", "<set-?>", "size", "getSize", "isRoot", "", "Lkorlibs/datastructure/PriorityQueueNode;", "isRoot-qwD50o4", "(I)Z", "left", "getLeft-7Jr3yw8", "(I)I", "parent", "getParent-7Jr3yw8", "right", "getRight-7Jr3yw8", "value", "getValue-qwD50o4", "setValue-VgNLI40", "(II)V", "add", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "ensure", "index", "equals", "other", "", "gt", "a", "b", "hashCode", "indexOf", "isEmpty", "iterator", "", "lt", "minHeapify", "remove", "(Ljava/lang/Integer;)Z", "removeAll", "removeAt", "removeHead", "retainAll", "swap", "l", "r", "swap-Vw8Mou8", "toArraySorted", "toString", "", "updateAt", "updateObject", "Companion", "kds_release"})
@SourceDebugExtension(value={"SMAP\nPriorityQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PriorityQueue.kt\nkorlibs/datastructure/IntPriorityQueue\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,735:1\n1747#2,3:736\n1726#2,3:739\n*S KotlinDebug\n*F\n+ 1 PriorityQueue.kt\nkorlibs/datastructure/IntPriorityQueue\n*L\n320#1:736,3\n324#1:739,3\n*E\n"})
public final class IntPriorityQueue
implements Collection<Integer>,
KMutableCollection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private int[] data;
    @NotNull
    private final Comparator<Integer> comparator;
    private int size;

    @PublishedApi
    public IntPriorityQueue(@NotNull int[] data, @NotNull Comparator<Integer> comparator) {
        this.data = data;
        this.comparator = comparator;
    }

    @NotNull
    public final Comparator<Integer> getComparator() {
        return this.comparator;
    }

    private final int getValue-qwD50o4(int $this$value) {
        return this.data[$this$value];
    }

    private final void setValue-VgNLI40(int $this$value, int value) {
        this.data[$this$value] = value;
    }

    private final boolean isRoot-qwD50o4(int $this$isRoot) {
        return $this$isRoot == 0;
    }

    private final int getParent-7Jr3yw8(int $this$parent) {
        return PriorityQueueNode.constructor-impl(($this$parent - 1) / 2);
    }

    private final int getLeft-7Jr3yw8(int $this$left) {
        return PriorityQueueNode.constructor-impl(2 * $this$left + 1);
    }

    private final int getRight-7Jr3yw8(int $this$right) {
        return PriorityQueueNode.constructor-impl(2 * $this$right + 2);
    }

    private final boolean gt(int a, int b) {
        return this.comparator.compare(a, b) > 0;
    }

    private final boolean lt(int a, int b) {
        return this.comparator.compare(a, b) < 0;
    }

    private final int getCapacity() {
        return this.data.length;
    }

    public int getSize() {
        return this.size;
    }

    public final int getHead() {
        if (this.size() <= 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[0];
    }

    @Override
    public boolean add(int element) {
        int n = this.size();
        this.size = n + 1;
        this.ensure(this.size());
        int i = PriorityQueueNode.constructor-impl(this.size() - 1);
        this.setValue-VgNLI40(i, element);
        while (!this.isRoot-qwD50o4(i) && this.gt(this.getValue-qwD50o4(this.getParent-7Jr3yw8(i)), this.getValue-qwD50o4(i))) {
            this.swap-Vw8Mou8(i, this.getParent-7Jr3yw8(i));
            i = this.getParent-7Jr3yw8(i);
        }
        return true;
    }

    public final int removeHead() {
        if (this.size() <= 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.size() == 1) {
            int n = this.size();
            this.size = n + -1;
            return this.getValue-qwD50o4(PriorityQueueNode.constructor-impl(0));
        }
        int root = this.getValue-qwD50o4(PriorityQueueNode.constructor-impl(0));
        this.setValue-VgNLI40(PriorityQueueNode.constructor-impl(0), this.getValue-qwD50o4(PriorityQueueNode.constructor-impl(this.size() - 1)));
        int n = this.size();
        this.size = n + -1;
        this.minHeapify(0);
        return root;
    }

    public final int indexOf(int element) {
        int n = this.size();
        for (int n2 = 0; n2 < n; ++n2) {
            if (this.data[n2] != element) continue;
            return n2;
        }
        return -1;
    }

    public final void updateObject(int element) {
        int index = this.indexOf(element);
        if (index >= 0) {
            this.updateAt(index);
        }
    }

    public final void updateAt(int index) {
        int value = this.getValue-qwD50o4(PriorityQueueNode.constructor-impl(index));
        this.removeAt(index);
        this.add(value);
    }

    public boolean remove(@Nullable Integer element) {
        int index = this.indexOf(element);
        if (index >= 0) {
            this.removeAt(index);
        }
        return index >= 0;
    }

    public final void removeAt(int index) {
        int i = PriorityQueueNode.constructor-impl(index);
        while (i != 0) {
            this.swap-Vw8Mou8(i, this.getParent-7Jr3yw8(i));
            i = this.getParent-7Jr3yw8(i);
        }
        this.removeHead();
    }

    private final void ensure(int index) {
        if (index >= this.getCapacity()) {
            int[] nArray = Arrays.copyOf(this.data, 2 + this.getCapacity() * 2);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(this, newSize)");
            Intrinsics.checkNotNull((Object)nArray, (String)"null cannot be cast to non-null type kotlin.IntArray");
            this.data = nArray;
        }
    }

    private final void minHeapify(int index) {
        int i = PriorityQueueNode.constructor-impl(index);
        while (true) {
            int left = this.getLeft-7Jr3yw8(i);
            int right = this.getRight-7Jr3yw8(i);
            int smallest = i;
            if (left < this.size() && this.lt(this.getValue-qwD50o4(left), this.getValue-qwD50o4(i))) {
                smallest = left;
            }
            if (right < this.size() && this.lt(this.getValue-qwD50o4(right), this.getValue-qwD50o4(smallest))) {
                smallest = right;
            }
            if (PriorityQueueNode.equals-impl0(smallest, i)) break;
            this.swap-Vw8Mou8(i, smallest);
            i = smallest;
        }
    }

    private final void swap-Vw8Mou8(int l, int r) {
        int temp = this.getValue-qwD50o4(r);
        this.setValue-VgNLI40(r, this.getValue-qwD50o4(l));
        this.setValue-VgNLI40(l, temp);
    }

    public boolean contains(int element) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = (Iterable)RangesKt.until((int)0, (int)this.size());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (!(this.getValue-qwD50o4(PriorityQueueNode.constructor-impl(it)) == element)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        boolean bl;
        block3: {
            Set thisSet = CollectionsKt.toSet((Iterable)this);
            Iterable $this$all$iv = elements;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl2 = false;
                    if (thisSet.contains(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Integer> elements) {
        Iterator<? extends Integer> iterator2 = elements.iterator();
        while (iterator2.hasNext()) {
            int e = ((Number)iterator2.next()).intValue();
            this.add(e);
        }
        return !elements.isEmpty();
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        ArrayList temp = new ArrayList(CollectionsKt.toList((Iterable)this));
        boolean res = temp.removeAll(elements);
        this.clear();
        this.addAll(temp);
        return res;
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        ArrayList temp = new ArrayList(CollectionsKt.toList((Iterable)this));
        boolean res = temp.retainAll(elements);
        this.clear();
        this.addAll(temp);
        return res;
    }

    @Override
    @NotNull
    public Iterator<Integer> iterator() {
        Ref.IntRef index = new Ref.IntRef();
        return new Iterator<Integer>(index, this){
            final /* synthetic */ Ref.IntRef $index;
            final /* synthetic */ IntPriorityQueue this$0;
            {
                this.$index = $index;
                this.this$0 = $receiver;
            }

            public boolean hasNext() {
                return this.$index.element < this.this$0.size();
            }

            @NotNull
            public Integer next() {
                int n = this.$index.element;
                this.$index.element = n + 1;
                return IntPriorityQueue.access$getValue-qwD50o4(this.this$0, PriorityQueueNode.constructor-impl(n));
            }

            @NotNull
            public Void remove() {
                throw new NotImplementedError(null, 1, null);
            }
        };
    }

    @NotNull
    public final int[] toArraySorted() {
        int[] out = new int[this.size()];
        int n = this.size();
        for (int n2 = 0; n2 < n; ++n2) {
            out[n2] = this.removeHead();
        }
        n = out.length;
        for (int i = 0; i < n; ++i) {
            int v = out[i];
            this.add(v);
        }
        return out;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.toList((Iterable)this).toString();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof IntPriorityQueue && Arrays.equals(this.data, ((IntPriorityQueue)other).data) && Intrinsics.areEqual(this.comparator, ((IntPriorityQueue)other).comparator);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public static final /* synthetic */ int access$getValue-qwD50o4(IntPriorityQueue $this, int $receiver) {
        return $this.getValue-qwD50o4($receiver);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0010\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0086\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\nH\u0086\u0002JK\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\n26\u0010\u0005\u001a2\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00070\u000bH\u0086\u0002J-\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00072\u0010\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0086\u0002\u00a8\u0006\u0011"}, d2={"Lkorlibs/datastructure/IntPriorityQueue$Companion;", "", "()V", "invoke", "Lkorlibs/datastructure/IntPriorityQueue;", "comparator", "Ljava/util/Comparator;", "", "Lkorlibs/datastructure/IntComparator;", "reversed", "", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "left", "right", "initialCapacity", "kds_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntPriorityQueue invoke(int initialCapacity, @NotNull Comparator<Integer> comparator, boolean reversed) {
            int[] nArray = new int[initialCapacity];
            Comparator<Integer> comparator2 = reversed ? comparator.reversed() : comparator;
            Intrinsics.checkNotNullExpressionValue(comparator2, (String)"if (reversed) comparator\u2026eversed() else comparator");
            return new IntPriorityQueue(nArray, comparator2);
        }

        public static /* synthetic */ IntPriorityQueue invoke$default(Companion companion, int n, Comparator comparator, boolean bl, int n2, Object object) {
            if ((n2 & 4) != 0) {
                bl = false;
            }
            return companion.invoke(n, comparator, bl);
        }

        @NotNull
        public final IntPriorityQueue invoke(@NotNull Comparator<Integer> comparator, boolean reversed) {
            int[] nArray = new int[16];
            Comparator<Integer> comparator2 = reversed ? comparator.reversed() : comparator;
            Intrinsics.checkNotNullExpressionValue(comparator2, (String)"if (reversed) comparator\u2026eversed() else comparator");
            return new IntPriorityQueue(nArray, comparator2);
        }

        public static /* synthetic */ IntPriorityQueue invoke$default(Companion companion, Comparator comparator, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.invoke(comparator, bl);
        }

        @NotNull
        public final IntPriorityQueue invoke(boolean reversed, @NotNull Function2<? super Integer, ? super Integer, Integer> comparator) {
            return Companion.invoke((arg_0, arg_1) -> Companion.invoke$lambda$0(comparator, arg_0, arg_1), reversed);
        }

        public static /* synthetic */ IntPriorityQueue invoke$default(Companion companion, boolean bl, Function2 function2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            return companion.invoke(bl, (Function2<? super Integer, ? super Integer, Integer>)function2);
        }

        @NotNull
        public final IntPriorityQueue invoke(boolean reversed) {
            return Companion.invoke(_ExtensionsKt.comparator(), reversed);
        }

        public static /* synthetic */ IntPriorityQueue invoke$default(Companion companion, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            return companion.invoke(bl);
        }

        private static final int invoke$lambda$0(Function2 $tmp0, Integer p0, Integer p1) {
            return ((Number)$tmp0.invoke((Object)p0, (Object)p1)).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

