/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.kds;

import com.soywiz.kds.internal.InternalKt;
import com.soywiz.kds.internal.KdsInternalApi;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0012\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0005\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020\u0003J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010(\u001a\u00020\u0003H\u0016J\u0010\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020\u0003H\u0007J\u0010\u0010+\u001a\u00020#2\u0006\u0010*\u001a\u00020\u0003H\u0007J\"\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00112\b\b\u0002\u0010.\u001a\u00020\u00032\b\b\u0002\u0010/\u001a\u00020\u0003J\u0010\u0010,\u001a\u0002002\b\b\u0002\u0010.\u001a\u00020\u0003J$\u00101\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00112\b\b\u0002\u0010.\u001a\u00020\u00032\b\b\u0002\u0010/\u001a\u00020\u0003H\u0007J\u0006\u00102\u001a\u00020\u0003J\u000e\u00103\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u0003J\u000e\u00104\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0003J\u000e\u00105\u001a\u00020#2\u0006\u00106\u001a\u00020\u0000J$\u00105\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00112\b\b\u0002\u0010.\u001a\u00020\u00032\b\b\u0002\u0010/\u001a\u00020\u0003H\u0007J\u000e\u00107\u001a\u00020&2\u0006\u00108\u001a\u00020\u0003J$\u00109\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00112\b\b\u0002\u0010.\u001a\u00020\u00032\b\b\u0002\u0010/\u001a\u00020\u0003H\u0007R\u001e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u001e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u00118FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u00038FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0018\u0010\u0014\u001a\u0004\b\u0019\u0010\bR\u001a\u0010\u001a\u001a\u00020\u00038FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001b\u0010\u0014\u001a\u0004\b\u001c\u0010\bR\u000e\u0010\u001d\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\bR\u000e\u0010!\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/soywiz/kds/ByteRingBuffer;", "", "bits", "", "(I)V", "<set-?>", "availableRead", "getAvailableRead", "()I", "availableReadBeforeWrap", "getAvailableReadBeforeWrap", "availableWrite", "getAvailableWrite", "availableWriteBeforeWrap", "getAvailableWriteBeforeWrap", "getBits", "buffer", "", "internalBuffer", "getInternalBuffer$annotations", "()V", "getInternalBuffer", "()[B", "internalReadPos", "getInternalReadPos$annotations", "getInternalReadPos", "internalWritePos", "getInternalWritePos$annotations", "getInternalWritePos", "mask", "readPos", "totalSize", "getTotalSize", "writePos", "clear", "", "contentHashCode", "equals", "", "other", "hashCode", "internalReadSkip", "count", "internalWriteSkip", "peek", "data", "offset", "size", "", "read", "readByte", "readBytes", "skip", "write", "consume", "writeByte", "v", "writeHead", "kds"})
public class ByteRingBuffer {
    private final int bits;
    private final int totalSize;
    private final int mask;
    @NotNull
    private final byte[] buffer;
    private int readPos;
    private int writePos;
    private int availableWrite;
    private int availableRead;

    public ByteRingBuffer(int bits) {
        this.bits = bits;
        this.totalSize = 1 << this.bits;
        this.mask = this.totalSize - 1;
        this.buffer = new byte[this.totalSize];
        this.availableWrite = this.totalSize;
    }

    public final int getBits() {
        return this.bits;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    public final int getAvailableWrite() {
        return this.availableWrite;
    }

    public final int getAvailableRead() {
        return this.availableRead;
    }

    @NotNull
    public final byte[] getInternalBuffer() {
        return this.buffer;
    }

    @KdsInternalApi
    public static /* synthetic */ void getInternalBuffer$annotations() {
    }

    public final int getInternalReadPos() {
        return this.readPos & this.mask;
    }

    @KdsInternalApi
    public static /* synthetic */ void getInternalReadPos$annotations() {
    }

    public final int getInternalWritePos() {
        return this.writePos & this.mask;
    }

    @KdsInternalApi
    public static /* synthetic */ void getInternalWritePos$annotations() {
    }

    @KdsInternalApi
    public final void internalWriteSkip(int count) {
        if (count < 0 || count > this.availableWrite) {
            throw new IllegalStateException("Try to write more than available".toString());
        }
        this.writePos += count;
        this.availableRead += count;
        this.availableWrite -= count;
    }

    @KdsInternalApi
    public final void internalReadSkip(int count) {
        if (count < 0 || count > this.availableRead) {
            throw new IllegalStateException("Try to write more than available".toString());
        }
        this.readPos += count;
        this.availableRead -= count;
        this.availableWrite += count;
    }

    public final int getAvailableReadBeforeWrap() {
        return Math.min(this.availableRead, this.totalSize - (this.readPos & this.mask));
    }

    public final int getAvailableWriteBeforeWrap() {
        return Math.min(this.availableWrite, this.totalSize - (this.writePos & this.mask));
    }

    public final void write(@NotNull ByteRingBuffer consume) {
        while (consume.availableRead > 0) {
            int copySize = Math.min(consume.getAvailableReadBeforeWrap(), this.getAvailableWriteBeforeWrap());
            InternalKt.arraycopy(consume.getInternalBuffer(), consume.getInternalReadPos(), this.getInternalBuffer(), this.getInternalWritePos(), copySize);
            consume.internalReadSkip(copySize);
            this.internalWriteSkip(copySize);
        }
    }

    @JvmOverloads
    public final int writeHead(@NotNull byte[] data, int offset, int size) {
        int toWrite = Math.min(this.availableWrite, size);
        for (int n = 0; n < toWrite; ++n) {
            this.readPos = this.readPos - 1 & this.mask;
            this.buffer[this.readPos] = data[offset + size - n - 1];
        }
        this.availableRead += toWrite;
        this.availableWrite -= toWrite;
        return toWrite;
    }

    public static /* synthetic */ int writeHead$default(ByteRingBuffer byteRingBuffer, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeHead");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length - n;
        }
        return byteRingBuffer.writeHead(byArray, n, n2);
    }

    @JvmOverloads
    public final int write(@NotNull byte[] data, int offset, int size) {
        int chunkSize;
        int remaining = Math.min(this.availableWrite, size);
        int coffset = offset;
        int totalWrite = 0;
        while (remaining > 0 && (chunkSize = Math.min(remaining, this.getAvailableWriteBeforeWrap())) > 0) {
            InternalKt.arraycopy(data, coffset, this.buffer, this.getInternalWritePos(), chunkSize);
            this.internalWriteSkip(chunkSize);
            coffset += chunkSize;
            remaining -= chunkSize;
            totalWrite += chunkSize;
        }
        return totalWrite;
    }

    public static /* synthetic */ int write$default(ByteRingBuffer byteRingBuffer, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length - n;
        }
        return byteRingBuffer.write(byArray, n, n2);
    }

    @JvmOverloads
    public final int read(@NotNull byte[] data, int offset, int size) {
        return this.skip(this.peek(data, offset, size));
    }

    public static /* synthetic */ int read$default(ByteRingBuffer byteRingBuffer, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: read");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length - n;
        }
        return byteRingBuffer.read(byArray, n, n2);
    }

    public final int skip(int size) {
        int toRead = Math.min(this.availableRead, size);
        this.readPos = this.readPos + toRead & this.mask;
        this.availableWrite += toRead;
        this.availableRead -= toRead;
        return toRead;
    }

    public final int peek(@NotNull byte[] data, int offset, int size) {
        int toReadChunk;
        int toRead = Math.min(this.availableRead, size);
        int readCount = 0;
        byte[] buffer = this.buffer;
        int mask = this.mask;
        int coffset = offset;
        int lReadPos = this.readPos;
        while ((toReadChunk = Math.min(toRead, this.getAvailableReadBeforeWrap())) > 0) {
            InternalKt.arraycopy(buffer, lReadPos & mask, data, coffset, toReadChunk);
            toRead -= toReadChunk;
            coffset += toReadChunk;
            lReadPos += toReadChunk;
            readCount += toReadChunk;
        }
        return readCount;
    }

    public static /* synthetic */ int peek$default(ByteRingBuffer byteRingBuffer, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: peek");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length - n;
        }
        return byteRingBuffer.peek(byArray, n, n2);
    }

    @NotNull
    public final byte[] readBytes(int count) {
        byte[] out = new byte[count];
        byte[] byArray = Arrays.copyOf(out, ByteRingBuffer.read$default(this, out, 0, 0, 6, null));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, newSize)");
        return byArray;
    }

    public final int readByte() {
        if (this.availableRead <= 0) {
            return -1;
        }
        int out = this.buffer[this.readPos] & 0xFF;
        this.readPos = this.readPos + 1 & this.mask;
        int n = this.availableRead;
        this.availableRead = n + -1;
        n = this.availableWrite;
        this.availableWrite = n + 1;
        return out;
    }

    public final boolean writeByte(int v) {
        if (this.availableWrite <= 0) {
            return false;
        }
        this.buffer[this.writePos] = (byte)v;
        this.writePos = this.writePos + 1 & this.mask;
        int n = this.availableWrite;
        this.availableWrite = n + -1;
        n = this.availableRead;
        this.availableRead = n + 1;
        return true;
    }

    public final void clear() {
        this.readPos = 0;
        this.writePos = 0;
        this.availableRead = 0;
        this.availableWrite = this.totalSize;
    }

    public final byte peek(int offset) {
        return this.buffer[this.readPos + offset & this.mask];
    }

    public static /* synthetic */ byte peek$default(ByteRingBuffer byteRingBuffer, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: peek");
        }
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return byteRingBuffer.peek(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ByteRingBuffer)) return false;
        if (this.availableRead != ((ByteRingBuffer)other).availableRead) return false;
        int count$iv = this.availableRead;
        boolean $i$f$equaler = false;
        int n$iv = 0;
        while (n$iv < count$iv) {
            int it = n$iv;
            boolean bl = false;
            if (this.peek(it) != ((ByteRingBuffer)other).peek(it)) return false;
            boolean bl2 = true;
            if (!bl2) {
                return false;
            }
            ++n$iv;
        }
        return true;
    }

    public int hashCode() {
        return this.contentHashCode();
    }

    /*
     * WARNING - void declaration
     */
    public final int contentHashCode() {
        void var3_3;
        int count$iv = this.availableRead;
        boolean $i$f$hashCoder = false;
        int out$iv = 0;
        int n$iv = 0;
        while (n$iv < count$iv) {
            void it;
            int n = n$iv++;
            int n2 = out$iv *= 7;
            boolean bl = false;
            byte by = this.peek((int)it);
            out$iv = n2 + by;
        }
        return (int)var3_3;
    }

    @JvmOverloads
    public final int writeHead(@NotNull byte[] data, int offset) {
        return ByteRingBuffer.writeHead$default(this, data, offset, 0, 4, null);
    }

    @JvmOverloads
    public final int writeHead(@NotNull byte[] data) {
        return ByteRingBuffer.writeHead$default(this, data, 0, 0, 6, null);
    }

    @JvmOverloads
    public final int write(@NotNull byte[] data, int offset) {
        return ByteRingBuffer.write$default(this, data, offset, 0, 4, null);
    }

    @JvmOverloads
    public final int write(@NotNull byte[] data) {
        return ByteRingBuffer.write$default(this, data, 0, 0, 6, null);
    }

    @JvmOverloads
    public final int read(@NotNull byte[] data, int offset) {
        return ByteRingBuffer.read$default(this, data, offset, 0, 4, null);
    }

    @JvmOverloads
    public final int read(@NotNull byte[] data) {
        return ByteRingBuffer.read$default(this, data, 0, 0, 6, null);
    }
}

