/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.kds;

import com.soywiz.kds.TGenDeque;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0019\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u000f\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\r\u0010\u0015\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0010J\r\u0010\u0016\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0010R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00028\u00000\bj\b\u0012\u0004\u0012\u00028\u0000`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/soywiz/kds/HistoryStack;", "T", "", "maxLength", "", "initialCapacity", "(II)V", "deque", "Lcom/soywiz/kds/TGenDeque;", "Lcom/soywiz/kds/Deque;", "getMaxLength", "()I", "setMaxLength", "(I)V", "position", "current", "()Ljava/lang/Object;", "push", "", "value", "(Ljava/lang/Object;)V", "redo", "undo", "kds"})
public final class HistoryStack<T> {
    private int maxLength;
    @NotNull
    private final TGenDeque<T> deque;
    private int position;

    public HistoryStack(int maxLength, int initialCapacity) {
        this.maxLength = maxLength;
        this.deque = new TGenDeque(initialCapacity);
    }

    public /* synthetic */ HistoryStack(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 0x7FFFFFF5;
        }
        if ((n3 & 2) != 0) {
            n2 = 7;
        }
        this(n, n2);
    }

    public final int getMaxLength() {
        return this.maxLength;
    }

    public final void setMaxLength(int n) {
        this.maxLength = n;
    }

    public final void push(T value) {
        while (!((Collection)this.deque).isEmpty() && this.deque.size() > this.position) {
            this.deque.removeLast();
        }
        this.deque.add(value);
        this.position = this.deque.size();
        while (!((Collection)this.deque).isEmpty() && this.deque.size() > this.maxLength) {
            this.deque.removeFirst();
            int n = this.position;
            this.position = n + -1;
        }
    }

    @Nullable
    public final T current() {
        return this.deque.getOrNull(this.position - 1);
    }

    @Nullable
    public final T undo() {
        this.position = RangesKt.coerceAtLeast((int)(this.position - 1), (int)0);
        return this.deque.getOrNull(this.position - 1);
    }

    @Nullable
    public final T redo() {
        T t;
        T it = t = this.deque.getOrNull(this.position);
        boolean bl = false;
        this.position = RangesKt.coerceAtMost((int)(this.position + 1), (int)(this.deque.size() + 1));
        return t;
    }

    public HistoryStack() {
        this(0, 0, 3, null);
    }
}

