/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.klock.internal;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0018J\u000e\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0005J\u0006\u0010\u001c\u001a\u00020\u0018J\u001a\u0010\u001d\u001a\u00020\u00032\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0086\b\u00f8\u0001\u0000J\u000e\u0010!\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005J\u0006\u0010\"\u001a\u00020\u0003J\u000e\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u0018J\u000e\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u0003J\r\u0010%\u001a\u0004\u0018\u00010&\u00a2\u0006\u0002\u0010'J\u0015\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u001b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010(J\u0015\u0010)\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010*J\u0010\u0010+\u001a\u0004\u0018\u00010\u00032\u0006\u0010$\u001a\u00020\u0003R\u0011\u0010\u0007\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\t\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006,"}, d2={"Lcom/soywiz/klock/internal/MicroStrReader;", "", "str", "", "offset", "", "(Ljava/lang/String;I)V", "available", "getAvailable", "()I", "eof", "", "getEof", "()Z", "hasMore", "getHasMore", "length", "getLength", "getOffset", "setOffset", "(I)V", "getStr", "()Ljava/lang/String;", "peekChar", "", "peekCharOrZero", "read", "count", "readChar", "readChunk", "callback", "Lkotlin/Function0;", "", "readInt", "readRemaining", "tryRead", "expected", "tryReadDouble", "", "()Ljava/lang/Double;", "(I)Ljava/lang/Double;", "tryReadInt", "(I)Ljava/lang/Integer;", "tryReadOrNull", "klock_debug"})
public final class MicroStrReader {
    @NotNull
    private final String str;
    private int offset;

    public final int getLength() {
        return this.str.length();
    }

    public final int getAvailable() {
        return this.str.length() - this.offset;
    }

    public final boolean getHasMore() {
        return this.offset < this.str.length();
    }

    public final boolean getEof() {
        return !this.getHasMore();
    }

    @NotNull
    public final String readChunk(@NotNull Function0<Unit> callback) {
        int $i$f$readChunk = 0;
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        int start = this.getOffset();
        callback.invoke();
        int end = this.getOffset();
        String string = this.getStr();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(start, end);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    public final char peekCharOrZero() {
        return this.getHasMore() ? this.str.charAt(this.offset) : (char)'\u0000';
    }

    public final char peekChar() {
        return this.str.charAt(this.offset);
    }

    public final char readChar() {
        int n = this.offset;
        this.offset = n + 1;
        return this.str.charAt(n);
    }

    public final boolean tryRead(char expected) {
        if (this.getEof() || this.peekChar() != expected) {
            return false;
        }
        this.readChar();
        return true;
    }

    @Nullable
    public final String tryReadOrNull(@NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return this.tryRead(expected) ? expected : null;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean tryRead(@NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        if (expected.length() > this.getAvailable()) {
            return false;
        }
        int n = 0;
        int n2 = ((CharSequence)expected).length();
        while (n < n2) {
            void n3;
            if (this.str.charAt(this.offset + n3) != expected.charAt((int)n3)) {
                return false;
            }
            ++n3;
        }
        this.offset += expected.length();
        return true;
    }

    @NotNull
    public final String read(int count) {
        String string = this.str;
        int n = this.offset;
        int n2 = RangesKt.coerceAtMost((int)(this.offset + count), (int)this.getLength());
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string = string3;
        n = 0;
        n2 = 0;
        String it = string;
        boolean bl2 = false;
        this.offset += it.length();
        return string;
    }

    @NotNull
    public final String readRemaining() {
        return this.read(this.getAvailable());
    }

    public final int readInt(int count) {
        String string = this.read(count);
        boolean bl = false;
        return Integer.parseInt(string);
    }

    @Nullable
    public final Integer tryReadInt(int count) {
        return StringsKt.toIntOrNull((String)this.read(count));
    }

    @Nullable
    public final Double tryReadDouble(int count) {
        return StringsKt.toDoubleOrNull((String)StringsKt.replace$default((String)this.read(count), (char)',', (char)'.', (boolean)false, (int)4, null));
    }

    @Nullable
    public final Double tryReadDouble() {
        int numCount = 0;
        int num = 0;
        int denCount = 0;
        int den = 0;
        boolean decimals = false;
        while (this.getHasMore()) {
            char pc = this.peekChar();
            if (pc == ',') {
                if (numCount == 0) {
                    return null;
                }
                decimals = true;
                this.readChar();
                continue;
            }
            char c = pc;
            if ('0' > c || '9' < c) break;
            char c2 = this.readChar();
            if (decimals) {
                ++denCount;
                den *= 10;
                den += c2 - 48;
                continue;
            }
            ++numCount;
            num *= 10;
            num += c2 - 48;
        }
        if (numCount == 0) {
            return null;
        }
        double d = 10.0;
        int n = -denCount;
        boolean bl = false;
        return (double)num + (double)den * Math.pow(d, n);
    }

    @NotNull
    public final String getStr() {
        return this.str;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final void setOffset(int n) {
        this.offset = n;
    }

    public MicroStrReader(@NotNull String str, int offset) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.str = str;
        this.offset = offset;
    }

    public /* synthetic */ MicroStrReader(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(string, n);
    }
}

