/*
 * Decompiled with CFR 0.152.
 */
package korlibs.logger;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import korlibs.logger.Console;
import korlibs.logger.DefaultLogOutput;
import korlibs.logger.atomic.KloggerAtomicRef;
import korlibs.logger.atomic.KloggerAtomicRefKt;
import korlibs.logger.internal.EnvironmentVariablesKt;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 92\u00020\u0001:\u00049:;<B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010-\u001a\u00020.2\u0006\u0010\u0014\u001a\u00020\u00132\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u0001J\u0019\u00100\u001a\u00020.2\u000e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000101H\u0086\bJ\u0019\u00102\u001a\u00020.2\u000e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000101H\u0086\bJ\u0019\u00103\u001a\u00020.2\u000e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000101H\u0086\bJ\u0019\u00104\u001a\u00020.2\u000e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000101H\u0086\bJ\u000e\u00105\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0013J!\u00106\u001a\u00020.2\u0006\u0010\u0014\u001a\u00020\u00132\u000e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000101H\u0086\bJ\u0019\u00107\u001a\u00020.2\u000e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000101H\u0086\bJ\u0019\u00108\u001a\u00020.2\u000e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000101H\u0086\bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u00068\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\tR\u0012\u0010\u000b\u001a\u00020\u00068\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0012\u0010\f\u001a\u00020\u00068\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u0012\u0010\r\u001a\u00020\u00068\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\tR\u0011\u0010\u000f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u0012\u0010\u0010\u001a\u00020\u00068\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\tR\u0012\u0010\u0011\u001a\u00020\u00068\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\tR$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001aR\u001c\u0010!\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0016\"\u0004\b#\u0010\u0018R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R$\u0010*\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020%8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010'\"\u0004\b,\u0010)\u00a8\u0006="}, d2={"Lkorlibs/logger/Logger;", "", "name", "", "normalizedName", "dummy", "", "(Ljava/lang/String;Ljava/lang/String;Z)V", "getDummy", "()Z", "isDebugEnabled", "isErrorEnabled", "isFatalEnabled", "isInfoEnabled", "isLocalLevelSet", "isLocalOutputSet", "isTraceEnabled", "isWarnEnabled", "value", "Lkorlibs/logger/Logger$Level;", "level", "getLevel", "()Lkorlibs/logger/Logger$Level;", "setLevel", "(Lkorlibs/logger/Logger$Level;)V", "getName", "()Ljava/lang/String;", "nativeLogger", "getNativeLogger", "()Ljava/lang/Object;", "setNativeLogger", "(Ljava/lang/Object;)V", "getNormalizedName", "optLevel", "getOptLevel", "setOptLevel", "optOutput", "Lkorlibs/logger/Logger$Output;", "getOptOutput", "()Lkorlibs/logger/Logger$Output;", "setOptOutput", "(Lkorlibs/logger/Logger$Output;)V", "output", "getOutput", "setOutput", "actualLog", "", "msg", "debug", "Lkotlin/Function0;", "error", "fatal", "info", "isEnabled", "log", "trace", "warn", "Companion", "ConsoleLogOutput", "Level", "Output", "klogger"})
@SourceDebugExtension(value={"SMAP\nLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Logger.kt\nkorlibs/logger/Logger\n*L\n1#1,160:1\n124#1:161\n124#1:162\n124#1:163\n124#1:164\n124#1:165\n124#1:166\n*S KotlinDebug\n*F\n+ 1 Logger.kt\nkorlibs/logger/Logger\n*L\n127#1:161\n130#1:162\n133#1:163\n136#1:164\n139#1:165\n142#1:166\n*E\n"})
public final class Logger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final String normalizedName;
    private final boolean dummy;
    @Nullable
    private Object nativeLogger;
    @Nullable
    private Level optLevel;
    @Nullable
    private Output optOutput;
    @NotNull
    private static final KloggerAtomicRef<Map<String, Logger>> Logger_loggers = new KloggerAtomicRef<Map>(MapsKt.emptyMap());
    @NotNull
    private static final KloggerAtomicRef<Level> defaultLevel$delegate = new KloggerAtomicRef<Object>(null);
    @NotNull
    private static final KloggerAtomicRef<Output> defaultOutput$delegate = new KloggerAtomicRef<DefaultLogOutput>(DefaultLogOutput.INSTANCE);

    private Logger(String name, String normalizedName, boolean dummy) {
        this.name = name;
        this.normalizedName = normalizedName;
        this.dummy = dummy;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getNormalizedName() {
        return this.normalizedName;
    }

    public final boolean getDummy() {
        return this.dummy;
    }

    @Nullable
    public final Object getNativeLogger() {
        return this.nativeLogger;
    }

    public final void setNativeLogger(@Nullable Object object) {
        this.nativeLogger = object;
    }

    @Nullable
    public final Level getOptLevel() {
        return this.optLevel;
    }

    public final void setOptLevel(@Nullable Level level) {
        this.optLevel = level;
    }

    @Nullable
    public final Output getOptOutput() {
        return this.optOutput;
    }

    public final void setOptOutput(@Nullable Output output) {
        this.optOutput = output;
    }

    @NotNull
    public final Level getLevel() {
        Level level = this.optLevel;
        if (level == null && (level = Companion.getDefaultLevel()) == null) {
            level = Level.WARN;
        }
        return level;
    }

    public final void setLevel(@NotNull Level value) {
        this.optLevel = value;
    }

    @NotNull
    public final Output getOutput() {
        Output output = this.optOutput;
        if (output == null) {
            output = Companion.getDefaultOutput();
        }
        return output;
    }

    public final void setOutput(@NotNull Output value) {
        this.optOutput = value;
    }

    public final boolean isLocalLevelSet() {
        return this.optLevel != null;
    }

    public final boolean isLocalOutputSet() {
        return this.optOutput != null;
    }

    public final boolean isEnabled(@NotNull Level level) {
        return level.getIndex() <= this.getLevel().getIndex();
    }

    public final boolean isFatalEnabled() {
        boolean $i$f$isFatalEnabled = false;
        return this.isEnabled(Level.FATAL);
    }

    public final boolean isErrorEnabled() {
        boolean $i$f$isErrorEnabled = false;
        return this.isEnabled(Level.ERROR);
    }

    public final boolean isWarnEnabled() {
        boolean $i$f$isWarnEnabled = false;
        return this.isEnabled(Level.WARN);
    }

    public final boolean isInfoEnabled() {
        boolean $i$f$isInfoEnabled = false;
        return this.isEnabled(Level.INFO);
    }

    public final boolean isDebugEnabled() {
        boolean $i$f$isDebugEnabled = false;
        return this.isEnabled(Level.DEBUG);
    }

    public final boolean isTraceEnabled() {
        boolean $i$f$isTraceEnabled = false;
        return this.isEnabled(Level.TRACE);
    }

    public final void log(@NotNull Level level, @NotNull Function0<? extends Object> msg) {
        boolean $i$f$log = false;
        if (this.isEnabled(level)) {
            this.actualLog(level, msg.invoke());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void fatal(@NotNull Function0<? extends Object> msg) {
        void this_$iv;
        boolean $i$f$fatal = false;
        Logger logger = this;
        Level level$iv = Level.FATAL;
        boolean $i$f$log = false;
        if (this_$iv.isEnabled(level$iv)) {
            this_$iv.actualLog(level$iv, msg.invoke());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void error(@NotNull Function0<? extends Object> msg) {
        void this_$iv;
        boolean $i$f$error = false;
        Logger logger = this;
        Level level$iv = Level.ERROR;
        boolean $i$f$log = false;
        if (this_$iv.isEnabled(level$iv)) {
            this_$iv.actualLog(level$iv, msg.invoke());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void warn(@NotNull Function0<? extends Object> msg) {
        void this_$iv;
        boolean $i$f$warn = false;
        Logger logger = this;
        Level level$iv = Level.WARN;
        boolean $i$f$log = false;
        if (this_$iv.isEnabled(level$iv)) {
            this_$iv.actualLog(level$iv, msg.invoke());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void info(@NotNull Function0<? extends Object> msg) {
        void this_$iv;
        boolean $i$f$info = false;
        Logger logger = this;
        Level level$iv = Level.INFO;
        boolean $i$f$log = false;
        if (this_$iv.isEnabled(level$iv)) {
            this_$iv.actualLog(level$iv, msg.invoke());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void debug(@NotNull Function0<? extends Object> msg) {
        void this_$iv;
        boolean $i$f$debug = false;
        Logger logger = this;
        Level level$iv = Level.DEBUG;
        boolean $i$f$log = false;
        if (this_$iv.isEnabled(level$iv)) {
            this_$iv.actualLog(level$iv, msg.invoke());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void trace(@NotNull Function0<? extends Object> msg) {
        void this_$iv;
        boolean $i$f$trace = false;
        Logger logger = this;
        Level level$iv = Level.TRACE;
        boolean $i$f$log = false;
        if (this_$iv.isEnabled(level$iv)) {
            this_$iv.actualLog(level$iv, msg.invoke());
        }
    }

    @PublishedApi
    public final void actualLog(@NotNull Level level, @Nullable Object msg) {
        this.getOutput().output(this, level, msg);
    }

    public /* synthetic */ Logger(String name, String normalizedName, boolean dummy, DefaultConstructorMarker $constructor_marker) {
        this(name, normalizedName, dummy);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0019\u001a\u00020\u0007\"\n\b\u0000\u0010\u001a\u0018\u0001*\u00020\u0001H\u0086\nJ\u0011\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0006H\u0086\u0002J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0002R0\u0010\u0003\u001a$\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR+\u0010\u0013\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u00128F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0011\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lkorlibs/logger/Logger$Companion;", "", "()V", "Logger_loggers", "Lkorlibs/logger/atomic/KloggerAtomicRef;", "", "", "Lkorlibs/logger/Logger;", "Lkorlibs/logger/AtomicMap;", "<set-?>", "Lkorlibs/logger/Logger$Level;", "defaultLevel", "getDefaultLevel", "()Lkorlibs/logger/Logger$Level;", "setDefaultLevel", "(Lkorlibs/logger/Logger$Level;)V", "defaultLevel$delegate", "Lkorlibs/logger/atomic/KloggerAtomicRef;", "Lkorlibs/logger/Logger$Output;", "defaultOutput", "getDefaultOutput", "()Lkorlibs/logger/Logger$Output;", "setDefaultOutput", "(Lkorlibs/logger/Logger$Output;)V", "defaultOutput$delegate", "invoke", "T", "name", "normalizeName", "klogger"})
    @SourceDebugExtension(value={"SMAP\nLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Logger.kt\nkorlibs/logger/Logger$Companion\n+ 2 Logger.kt\nkorlibs/logger/LoggerKt\n+ 3 KloggerAtomicRefJvm.kt\nkorlibs/logger/atomic/KloggerAtomicRef\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n156#2:161\n158#2:162\n159#2:168\n156#2:169\n17#3,2:163\n19#3,2:166\n1#4:165\n*S KotlinDebug\n*F\n+ 1 Logger.kt\nkorlibs/logger/Logger$Companion\n*L\n54#1:161\n64#1:162\n64#1:168\n66#1:169\n64#1:163,2\n64#1:166,2\n64#1:165\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @Nullable
        public final Level getDefaultLevel() {
            return (Level)((Object)KloggerAtomicRefKt.getValue(defaultLevel$delegate, this, $$delegatedProperties[0]));
        }

        public final void setDefaultLevel(@Nullable Level level) {
            KloggerAtomicRefKt.setValue(defaultLevel$delegate, this, $$delegatedProperties[0], level);
        }

        @NotNull
        public final Output getDefaultOutput() {
            return (Output)KloggerAtomicRefKt.getValue(defaultOutput$delegate, this, $$delegatedProperties[1]);
        }

        public final void setDefaultOutput(@NotNull Output output) {
            KloggerAtomicRefKt.setValue(defaultOutput$delegate, this, $$delegatedProperties[1], output);
        }

        @NotNull
        public final Logger invoke(@NotNull String name) {
            String normalizedName = this.normalizeName(name);
            KloggerAtomicRef $this$get$iv = Logger_loggers;
            boolean $i$f$get = false;
            if (((Map)$this$get$iv.getValue()).get(normalizedName) == null) {
                Map new$iv$iv;
                Object old$iv$iv;
                String it;
                String string;
                Logger logger = new Logger(name, normalizedName, true, null);
                String string2 = EnvironmentVariablesKt.getMiniEnvironmentVariablesUC().get("LOG_" + normalizedName);
                if (string2 != null) {
                    it = string = string2;
                    boolean bl = false;
                    logger.setLevel(Level.Companion.get(it));
                }
                if (((Map)Logger_loggers.getValue()).isEmpty()) {
                    String string3 = EnvironmentVariablesKt.getMiniEnvironmentVariablesUC().get("LOG_LEVEL");
                    if (string3 != null) {
                        it = string = string3;
                        boolean bl = false;
                        Companion.setDefaultLevel(Level.Companion.get(it));
                    }
                }
                KloggerAtomicRef $this$set$iv = Logger_loggers;
                boolean $i$f$set = false;
                KloggerAtomicRef this_$iv$iv = $this$set$iv;
                boolean $i$f$update = false;
                do {
                    HashMap hashMap;
                    old$iv$iv = KloggerAtomicRef.access$getRef$p(this_$iv$iv).get();
                    Map it$iv = (Map)old$iv$iv;
                    boolean bl = false;
                    HashMap nmap$iv = hashMap = new HashMap(it$iv);
                    boolean bl2 = false;
                    ((Map)nmap$iv).put(normalizedName, logger);
                    new$iv$iv = hashMap;
                } while (!KloggerAtomicRef.access$getRef$p(this_$iv$iv).compareAndSet(old$iv$iv, new$iv$iv));
            }
            $this$get$iv = Logger_loggers;
            $i$f$get = false;
            Object v = ((Map)$this$get$iv.getValue()).get(normalizedName);
            Intrinsics.checkNotNull(v);
            return (Logger)v;
        }

        private final String normalizeName(String name) {
            String string = StringsKt.replace$default((String)StringsKt.replace$default((String)name, (char)'.', (char)'_', (boolean)false, (int)4, null), (char)'/', (char)'_', (boolean)false, (int)4, null).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            return string;
        }

        public final /* synthetic */ <T> Logger invoke() {
            boolean $i$f$invoke = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            String string = Reflection.getOrCreateKotlinClass(Object.class).getSimpleName();
            if (string == null) {
                string = "NoClassName";
            }
            return this.invoke(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Companion.class, "defaultLevel", "getDefaultLevel()Lkorlibs/logger/Logger$Level;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Companion.class, "defaultOutput", "getDefaultOutput()Lkorlibs/logger/Logger$Output;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lkorlibs/logger/Logger$ConsoleLogOutput;", "Lkorlibs/logger/Logger$Output;", "()V", "output", "", "logger", "Lkorlibs/logger/Logger;", "level", "Lkorlibs/logger/Logger$Level;", "msg", "", "klogger"})
    public static final class ConsoleLogOutput
    implements Output {
        @NotNull
        public static final ConsoleLogOutput INSTANCE = new ConsoleLogOutput();

        private ConsoleLogOutput() {
        }

        @Override
        public void output(@NotNull Logger logger, @NotNull Level level, @Nullable Object msg) {
            switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                case 1: {
                    Object[] objectArray = new Object[]{logger.getName(), msg};
                    Console.INSTANCE.error(objectArray);
                    break;
                }
                case 2: {
                    Object[] objectArray = new Object[]{logger.getName(), msg};
                    Console.INSTANCE.warn(objectArray);
                    break;
                }
                default: {
                    Object[] objectArray = new Object[]{logger.getName(), msg};
                    Console.INSTANCE.log(objectArray);
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Level.values().length];
                try {
                    nArray[Level.ERROR.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Level.WARN.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000eB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000f"}, d2={"Lkorlibs/logger/Logger$Level;", "", "index", "", "(Ljava/lang/String;II)V", "getIndex", "()I", "NONE", "FATAL", "ERROR", "WARN", "INFO", "DEBUG", "TRACE", "Companion", "klogger"})
    @SourceDebugExtension(value={"SMAP\nLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Logger.kt\nkorlibs/logger/Logger$Level\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,160:1\n8541#2,2:161\n8801#2,4:163\n*S KotlinDebug\n*F\n+ 1 Logger.kt\nkorlibs/logger/Logger$Level\n*L\n81#1:161,2\n81#1:163,4\n*E\n"})
    public static final class Level
    extends Enum<Level> {
        @NotNull
        public static final Companion Companion;
        private final int index;
        @NotNull
        private static final Map<String, Level> BY_NAME;
        public static final /* enum */ Level NONE;
        public static final /* enum */ Level FATAL;
        public static final /* enum */ Level ERROR;
        public static final /* enum */ Level WARN;
        public static final /* enum */ Level INFO;
        public static final /* enum */ Level DEBUG;
        public static final /* enum */ Level TRACE;
        private static final /* synthetic */ Level[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Level(int index) {
            this.index = index;
        }

        public final int getIndex() {
            return this.index;
        }

        public static Level[] values() {
            return (Level[])$VALUES.clone();
        }

        public static Level valueOf(String value) {
            return Enum.valueOf(Level.class, value);
        }

        @NotNull
        public static EnumEntries<Level> getEntries() {
            return $ENTRIES;
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $this$associateByTo$iv$iv;
            NONE = new Level(0);
            FATAL = new Level(1);
            ERROR = new Level(2);
            WARN = new Level(3);
            INFO = new Level(4);
            DEBUG = new Level(5);
            TRACE = new Level(6);
            $VALUES = levelArray = new Level[]{Level.NONE, Level.FATAL, Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            Level[] $this$associateBy$iv = Level.values();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
            Level[] levelArray = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            int n = ((void)$this$associateByTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void element$iv$iv;
                void var9_9 = element$iv$iv = $this$associateByTo$iv$iv[i];
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(it.name(), element$iv$iv);
            }
            BY_NAME = destination$iv$iv;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0005H\u0086\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lkorlibs/logger/Logger$Level$Companion;", "", "()V", "BY_NAME", "", "", "Lkorlibs/logger/Logger$Level;", "getBY_NAME", "()Ljava/util/Map;", "get", "name", "klogger"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Map<String, Level> getBY_NAME() {
                return BY_NAME;
            }

            @NotNull
            public final Level get(@NotNull String name) {
                Map<String, Level> map = this.getBY_NAME();
                String string = name.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                Level level = map.get(string);
                if (level == null) {
                    level = NONE;
                }
                return level;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0001H&\u00a8\u0006\t"}, d2={"Lkorlibs/logger/Logger$Output;", "", "output", "", "logger", "Lkorlibs/logger/Logger;", "level", "Lkorlibs/logger/Logger$Level;", "msg", "klogger"})
    public static interface Output {
        public void output(@NotNull Logger var1, @NotNull Level var2, @Nullable Object var3);
    }
}

