/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.kmem;

import com.soywiz.kmem.Float32Buffer;
import com.soywiz.kmem.Float64Buffer;
import com.soywiz.kmem.Int16Buffer;
import com.soywiz.kmem.Int32Buffer;
import com.soywiz.kmem.Int8Buffer;
import com.soywiz.kmem.MemBuffer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u00a8\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0013\n\u0002\u0010\u0014\n\u0002\u0010\u0015\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\u0010\n\n\u0002\u0010\u0005\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u000e\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0010\u001a\u000e\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0010\u001a\u000e\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001e\u001a.\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010\u001a.\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010\u001a.\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020%2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010\u001a.\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020&2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010\u001a.\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020'2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010\u001a.\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020(2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010\u001a.\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010\u001a.\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020%2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010\u001a.\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020&2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010\u001ai\u0010\u001f\u001a\u00020 \"\u0004\b\u0000\u0010)2\u0006\u0010\u0017\u001a\u00020\u00102\b\u0010!\u001a\u0004\u0018\u00010*2\u0006\u0010\"\u001a\u00020\u00102\b\u0010#\u001a\u0004\u0018\u00010*2\u0006\u0010$\u001a\u00020\u00102\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u0002H)\u0012\u0004\u0012\u00020 0,2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u0002H)0.H\u0082\b\u001a.\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020'2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010\u001a.\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020(2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010\u001a@\u0010/\u001a\u0002H)\"\b\b\u0000\u0010)*\u000200*\u0002H)2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00102\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u0002H)\u0012\u0004\u0012\u0002H)0.H\u0086\b\u00a2\u0006\u0002\u00102\u001a\u001a\u00103\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010\u001a\u001a\u00104\u001a\u00020\u0007*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010\u001a\u001a\u00105\u001a\u00020\t*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010\u001a\u001a\u00106\u001a\u00020\u000b*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010\u001a\u001a\u00107\u001a\u00020\r*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010\u001a\u001c\u00108\u001a\u00020 *\u0002002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010H\u0001\u001a\n\u00109\u001a\u00020 *\u000200\u001a\n\u0010:\u001a\u00020 *\u000200\u001a\u0015\u0010;\u001a\u00020<*\u00020\u00052\u0006\u0010=\u001a\u00020\u0010H\u0086\u0002\u001a\u0015\u0010;\u001a\u00020>*\u00020\u00072\u0006\u0010=\u001a\u00020\u0010H\u0086\u0002\u001a\u0015\u0010;\u001a\u00020?*\u00020\t2\u0006\u0010=\u001a\u00020\u0010H\u0086\u0002\u001a\u0015\u0010;\u001a\u00020\u0010*\u00020\u000b2\u0006\u0010=\u001a\u00020\u0010H\u0086\u0002\u001a\u0015\u0010;\u001a\u00020@*\u00020\r2\u0006\u0010=\u001a\u00020\u0010H\u0086\u0002\u001a\u0015\u0010;\u001a\u00020@*\u00020\u00012\u0006\u0010=\u001a\u00020\u0010H\u0086\n\u001a\u0016\u0010A\u001a\u00020@*\u00060\u0001j\u0002`\u00022\u0006\u0010=\u001a\u00020\u0010\u001a\u000e\u0010B\u001a\u00060\u0001j\u0002`\u0002*\u00020\u0001\u001a\u0016\u0010C\u001a\u00020>*\u00060\u0001j\u0002`\u00022\u0006\u0010=\u001a\u00020\u0010\u001a\u0016\u0010D\u001a\u00020<*\u00060\u0001j\u0002`\u00022\u0006\u0010=\u001a\u00020\u0010\u001a\u0016\u0010E\u001a\u00020\u0010*\u00060\u0001j\u0002`\u00022\u0006\u0010=\u001a\u00020\u0010\u001a\u0016\u0010F\u001a\u00020?*\u00060\u0001j\u0002`\u00022\u0006\u0010=\u001a\u00020\u0010\u001a&\u0010G\u001a\u0002H)\"\u0004\b\u0000\u0010)*\u0002002\f\u0010H\u001a\b\u0012\u0004\u0012\u0002H)0IH\u0086\b\u00a2\u0006\u0002\u0010J\u001a\u0012\u0010K\u001a\u00020 *\u0002002\u0006\u0010L\u001a\u00020\u0010\u001a\u0012\u0010M\u001a\u00020 *\u0002002\u0006\u0010N\u001a\u00020\u0010\u001a\u001d\u0010O\u001a\u00020 *\u00020\u00052\u0006\u0010=\u001a\u00020\u00102\u0006\u0010P\u001a\u00020<H\u0086\u0002\u001a\u001d\u0010O\u001a\u00020 *\u00020\u00072\u0006\u0010=\u001a\u00020\u00102\u0006\u0010P\u001a\u00020>H\u0086\u0002\u001a\u001d\u0010O\u001a\u00020 *\u00020\t2\u0006\u0010=\u001a\u00020\u00102\u0006\u0010P\u001a\u00020?H\u0086\u0002\u001a\u001d\u0010O\u001a\u00020 *\u00020\u000b2\u0006\u0010=\u001a\u00020\u00102\u0006\u0010P\u001a\u00020\u0010H\u0086\u0002\u001a\u001d\u0010O\u001a\u00020 *\u00020\r2\u0006\u0010=\u001a\u00020\u00102\u0006\u0010P\u001a\u00020@H\u0086\u0002\u001a%\u0010O\u001a\n R*\u0004\u0018\u00010Q0Q*\u00020\u00012\u0006\u0010=\u001a\u00020\u00102\u0006\u0010P\u001a\u00020@H\u0086\n\u001a%\u0010O\u001a\n R*\u0004\u0018\u00010Q0Q*\u00020Q2\u0006\u0010=\u001a\u00020\u00102\u0006\u0010P\u001a\u00020@H\u0086\n\u001a%\u0010O\u001a\n R*\u0004\u0018\u00010S0S*\u00020S2\u0006\u0010=\u001a\u00020\u00102\u0006\u0010P\u001a\u00020>H\u0086\n\u001a%\u0010O\u001a\n R*\u0004\u0018\u00010T0T*\u00020T2\u0006\u0010=\u001a\u00020\u00102\u0006\u0010P\u001a\u00020<H\u0086\n\u001a%\u0010O\u001a\n R*\u0004\u0018\u00010U0U*\u00020U2\u0006\u0010=\u001a\u00020\u00102\u0006\u0010P\u001a\u00020\u0010H\u0086\n\u001a%\u0010O\u001a\n R*\u0004\u0018\u00010V0V*\u00020V2\u0006\u0010=\u001a\u00020\u00102\u0006\u0010P\u001a\u00020?H\u0086\n\u001a\u001e\u0010W\u001a\u00020 *\u00060\u0001j\u0002`\u00022\u0006\u0010=\u001a\u00020\u00102\u0006\u0010P\u001a\u00020@\u001a\u001e\u0010X\u001a\u00020 *\u00060\u0001j\u0002`\u00022\u0006\u0010=\u001a\u00020\u00102\u0006\u0010P\u001a\u00020>\u001a\u001e\u0010Y\u001a\u00020 *\u00060\u0001j\u0002`\u00022\u0006\u0010=\u001a\u00020\u00102\u0006\u0010P\u001a\u00020<\u001a\u001e\u0010Z\u001a\u00020 *\u00060\u0001j\u0002`\u00022\u0006\u0010=\u001a\u00020\u00102\u0006\u0010P\u001a\u00020\u0010\u001a\u001e\u0010[\u001a\u00020 *\u00060\u0001j\u0002`\u00022\u0006\u0010=\u001a\u00020\u00102\u0006\u0010P\u001a\u00020?\u001a\u001a\u0010\\\u001a\u00020Q*\u00020Q2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010\u001a\u001a\u0010\\\u001a\u00020S*\u00020S2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010\u001a\u001a\u0010\\\u001a\u00020T*\u00020T2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010\u001a\u001a\u0010\\\u001a\u00020U*\u00020U2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010\u001a\u001a\u0010\\\u001a\u00020V*\u00020V2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010\"\u0019\u0010\u0000\u001a\u00020\u0001*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\b\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\n\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\f\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u000e\"\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013\"\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0014\"\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0015\"\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0016\"\u0015\u0010\u0017\u001a\u00020\u0010*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012\"\u0015\u0010\u0017\u001a\u00020\u0010*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0013\"\u0015\u0010\u0017\u001a\u00020\u0010*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014\"\u0015\u0010\u0017\u001a\u00020\u0010*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0015\"\u0015\u0010\u0017\u001a\u00020\u0010*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016\"\u0016\u0010\u0017\u001a\u00020\u0010*\u00020\u00018\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019*\n\u0010]\"\u00020\u00012\u00020\u0001\u00a8\u0006^"}, d2={"mem", "Lcom/soywiz/kmem/MemBuffer;", "Lcom/soywiz/kmem/DataBuffer;", "getMem", "(Lcom/soywiz/kmem/MemBuffer;)Lcom/soywiz/kmem/MemBuffer;", "Lcom/soywiz/kmem/Float32Buffer;", "(Lcom/soywiz/kmem/Float32Buffer;)Lcom/soywiz/kmem/MemBuffer;", "Lcom/soywiz/kmem/Float64Buffer;", "(Lcom/soywiz/kmem/Float64Buffer;)Lcom/soywiz/kmem/MemBuffer;", "Lcom/soywiz/kmem/Int16Buffer;", "(Lcom/soywiz/kmem/Int16Buffer;)Lcom/soywiz/kmem/MemBuffer;", "Lcom/soywiz/kmem/Int32Buffer;", "(Lcom/soywiz/kmem/Int32Buffer;)Lcom/soywiz/kmem/MemBuffer;", "Lcom/soywiz/kmem/Int8Buffer;", "(Lcom/soywiz/kmem/Int8Buffer;)Lcom/soywiz/kmem/MemBuffer;", "offset", "", "getOffset", "(Lcom/soywiz/kmem/Float32Buffer;)I", "(Lcom/soywiz/kmem/Float64Buffer;)I", "(Lcom/soywiz/kmem/Int16Buffer;)I", "(Lcom/soywiz/kmem/Int32Buffer;)I", "(Lcom/soywiz/kmem/Int8Buffer;)I", "size", "getSize", "(Lcom/soywiz/kmem/MemBuffer;)I", "MemBufferAlloc", "MemBufferAllocNoDirect", "MemBufferWrap", "array", "", "arraycopy", "", "src", "srcPos", "dst", "dstPos", "", "", "", "", "T", "", "setDst", "Lkotlin/Function2;", "getSrc", "Lkotlin/Function1;", "_slice", "Ljava/nio/Buffer;", "dup", "(Ljava/nio/Buffer;IILkotlin/jvm/functions/Function1;)Ljava/nio/Buffer;", "_sliceFloat32Buffer", "_sliceFloat64Buffer", "_sliceInt16Buffer", "_sliceInt32Buffer", "_sliceInt8Buffer", "checkSliceBounds", "clearSafe", "flipSafe", "get", "", "index", "", "", "", "getByte", "getData", "getDouble", "getFloat", "getInt", "getShort", "keepPositionLimit", "block", "Lkotlin/Function0;", "(Ljava/nio/Buffer;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "limitSafe", "newLimit", "positionSafe", "newPosition", "set", "value", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "Ljava/nio/DoubleBuffer;", "Ljava/nio/FloatBuffer;", "Ljava/nio/IntBuffer;", "Ljava/nio/ShortBuffer;", "setByte", "setDouble", "setFloat", "setInt", "setShort", "slice", "DataBuffer", "kmem_release"})
public final class BufferJvmKt {
    @PublishedApi
    public static final void checkSliceBounds(@NotNull Buffer $this$checkSliceBounds, int offset, int size2) {
    }

    @NotNull
    public static final <T extends Buffer> T _slice(@NotNull T $this$_slice, int offset, int size2, @NotNull Function1<? super T, ? extends T> dup) {
        boolean $i$f$_slice = false;
        BufferJvmKt.checkSliceBounds($this$_slice, offset, size2);
        Buffer out = (Buffer)dup.invoke($this$_slice);
        int start = $this$_slice.position() + offset;
        int end = start + size2;
        BufferJvmKt.positionSafe(out, start);
        BufferJvmKt.limitSafe(out, end);
        return (T)out;
    }

    @NotNull
    public static final ByteBuffer slice(@NotNull ByteBuffer $this$slice, int offset, int size2) {
        Buffer $this$_slice$iv = $this$slice;
        boolean $i$f$_slice = false;
        BufferJvmKt.checkSliceBounds($this$_slice$iv, offset, size2);
        ByteBuffer it = (ByteBuffer)$this$_slice$iv;
        boolean bl = false;
        ByteBuffer byteBuffer = it.duplicate();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"it.duplicate()");
        Buffer out$iv = byteBuffer;
        int start$iv = $this$_slice$iv.position() + offset;
        int end$iv = start$iv + size2;
        BufferJvmKt.positionSafe(out$iv, start$iv);
        BufferJvmKt.limitSafe(out$iv, end$iv);
        return (ByteBuffer)out$iv;
    }

    @NotNull
    public static final ShortBuffer slice(@NotNull ShortBuffer $this$slice, int offset, int size2) {
        Buffer $this$_slice$iv = $this$slice;
        boolean $i$f$_slice = false;
        BufferJvmKt.checkSliceBounds($this$_slice$iv, offset, size2);
        ShortBuffer it = (ShortBuffer)$this$_slice$iv;
        boolean bl = false;
        ShortBuffer shortBuffer = it.duplicate();
        Intrinsics.checkNotNullExpressionValue((Object)shortBuffer, (String)"it.duplicate()");
        Buffer out$iv = shortBuffer;
        int start$iv = $this$_slice$iv.position() + offset;
        int end$iv = start$iv + size2;
        BufferJvmKt.positionSafe(out$iv, start$iv);
        BufferJvmKt.limitSafe(out$iv, end$iv);
        return (ShortBuffer)out$iv;
    }

    @NotNull
    public static final IntBuffer slice(@NotNull IntBuffer $this$slice, int offset, int size2) {
        Buffer $this$_slice$iv = $this$slice;
        boolean $i$f$_slice = false;
        BufferJvmKt.checkSliceBounds($this$_slice$iv, offset, size2);
        IntBuffer it = (IntBuffer)$this$_slice$iv;
        boolean bl = false;
        IntBuffer intBuffer = it.duplicate();
        Intrinsics.checkNotNullExpressionValue((Object)intBuffer, (String)"it.duplicate()");
        Buffer out$iv = intBuffer;
        int start$iv = $this$_slice$iv.position() + offset;
        int end$iv = start$iv + size2;
        BufferJvmKt.positionSafe(out$iv, start$iv);
        BufferJvmKt.limitSafe(out$iv, end$iv);
        return (IntBuffer)out$iv;
    }

    @NotNull
    public static final FloatBuffer slice(@NotNull FloatBuffer $this$slice, int offset, int size2) {
        Buffer $this$_slice$iv = $this$slice;
        boolean $i$f$_slice = false;
        BufferJvmKt.checkSliceBounds($this$_slice$iv, offset, size2);
        FloatBuffer it = (FloatBuffer)$this$_slice$iv;
        boolean bl = false;
        FloatBuffer floatBuffer = it.duplicate();
        Intrinsics.checkNotNullExpressionValue((Object)floatBuffer, (String)"it.duplicate()");
        Buffer out$iv = floatBuffer;
        int start$iv = $this$_slice$iv.position() + offset;
        int end$iv = start$iv + size2;
        BufferJvmKt.positionSafe(out$iv, start$iv);
        BufferJvmKt.limitSafe(out$iv, end$iv);
        return (FloatBuffer)out$iv;
    }

    @NotNull
    public static final DoubleBuffer slice(@NotNull DoubleBuffer $this$slice, int offset, int size2) {
        Buffer $this$_slice$iv = $this$slice;
        boolean $i$f$_slice = false;
        BufferJvmKt.checkSliceBounds($this$_slice$iv, offset, size2);
        DoubleBuffer it = (DoubleBuffer)$this$_slice$iv;
        boolean bl = false;
        DoubleBuffer doubleBuffer = it.duplicate();
        Intrinsics.checkNotNullExpressionValue((Object)doubleBuffer, (String)"it.duplicate()");
        Buffer out$iv = doubleBuffer;
        int start$iv = $this$_slice$iv.position() + offset;
        int end$iv = start$iv + size2;
        BufferJvmKt.positionSafe(out$iv, start$iv);
        BufferJvmKt.limitSafe(out$iv, end$iv);
        return (DoubleBuffer)out$iv;
    }

    @NotNull
    public static final MemBuffer MemBufferAlloc(int size2) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(size2).order(ByteOrder.nativeOrder());
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocateDirect(size).ord\u2026(ByteOrder.nativeOrder())");
        return new MemBuffer(byteBuffer, size2);
    }

    @NotNull
    public static final MemBuffer MemBufferAllocNoDirect(int size2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(size2).order(ByteOrder.nativeOrder());
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocate(size).order(ByteOrder.nativeOrder())");
        return new MemBuffer(byteBuffer, size2);
    }

    @NotNull
    public static final MemBuffer MemBufferWrap(@NotNull byte[] array) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(array).order(ByteOrder.nativeOrder());
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(array).order(ByteOrder.nativeOrder())");
        return new MemBuffer(byteBuffer, array.length);
    }

    public static final int getSize(@NotNull MemBuffer $this$size) {
        boolean $i$f$getSize = false;
        return $this$size.getSize();
    }

    @NotNull
    public static final Int8Buffer _sliceInt8Buffer(@NotNull MemBuffer $this$_sliceInt8Buffer, int offset, int size2) {
        return new Int8Buffer($this$_sliceInt8Buffer, BufferJvmKt.slice($this$_sliceInt8Buffer.getBuffer(), offset, size2));
    }

    @NotNull
    public static final Int16Buffer _sliceInt16Buffer(@NotNull MemBuffer $this$_sliceInt16Buffer, int offset, int size2) {
        ShortBuffer shortBuffer = $this$_sliceInt16Buffer.getBuffer().asShortBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)shortBuffer, (String)"this.buffer.asShortBuffer()");
        return new Int16Buffer($this$_sliceInt16Buffer, BufferJvmKt.slice(shortBuffer, offset, size2));
    }

    @NotNull
    public static final Int32Buffer _sliceInt32Buffer(@NotNull MemBuffer $this$_sliceInt32Buffer, int offset, int size2) {
        IntBuffer intBuffer = $this$_sliceInt32Buffer.getBuffer().asIntBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)intBuffer, (String)"this.buffer.asIntBuffer()");
        return new Int32Buffer($this$_sliceInt32Buffer, BufferJvmKt.slice(intBuffer, offset, size2));
    }

    @NotNull
    public static final Float32Buffer _sliceFloat32Buffer(@NotNull MemBuffer $this$_sliceFloat32Buffer, int offset, int size2) {
        FloatBuffer floatBuffer = $this$_sliceFloat32Buffer.getBuffer().asFloatBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)floatBuffer, (String)"this.buffer.asFloatBuffer()");
        return new Float32Buffer($this$_sliceFloat32Buffer, BufferJvmKt.slice(floatBuffer, offset, size2));
    }

    @NotNull
    public static final Float64Buffer _sliceFloat64Buffer(@NotNull MemBuffer $this$_sliceFloat64Buffer, int offset, int size2) {
        DoubleBuffer doubleBuffer = $this$_sliceFloat64Buffer.getBuffer().asDoubleBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)doubleBuffer, (String)"this.buffer.asDoubleBuffer()");
        return new Float64Buffer($this$_sliceFloat64Buffer, BufferJvmKt.slice(doubleBuffer, offset, size2));
    }

    @NotNull
    public static final MemBuffer getMem(@NotNull MemBuffer $this$mem) {
        return $this$mem;
    }

    @NotNull
    public static final MemBuffer getData(@NotNull MemBuffer $this$getData) {
        return $this$getData;
    }

    public static final byte getByte(@NotNull MemBuffer $this$getByte, int index) {
        return $this$getByte.getBuffer().get(index);
    }

    public static final void setByte(@NotNull MemBuffer $this$setByte, int index, byte value) {
        $this$setByte.getBuffer().put(index, value);
    }

    public static final short getShort(@NotNull MemBuffer $this$getShort, int index) {
        return $this$getShort.getBuffer().getShort(index);
    }

    public static final void setShort(@NotNull MemBuffer $this$setShort, int index, short value) {
        $this$setShort.getBuffer().putShort(index, value);
    }

    public static final int getInt(@NotNull MemBuffer $this$getInt, int index) {
        return $this$getInt.getBuffer().getInt(index);
    }

    public static final void setInt(@NotNull MemBuffer $this$setInt, int index, int value) {
        $this$setInt.getBuffer().putInt(index, value);
    }

    public static final float getFloat(@NotNull MemBuffer $this$getFloat, int index) {
        return $this$getFloat.getBuffer().getFloat(index);
    }

    public static final void setFloat(@NotNull MemBuffer $this$setFloat, int index, float value) {
        $this$setFloat.getBuffer().putFloat(index, value);
    }

    public static final double getDouble(@NotNull MemBuffer $this$getDouble, int index) {
        return $this$getDouble.getBuffer().getDouble(index);
    }

    public static final void setDouble(@NotNull MemBuffer $this$setDouble, int index, double value) {
        $this$setDouble.getBuffer().putDouble(index, value);
    }

    @NotNull
    public static final MemBuffer getMem(@NotNull Int8Buffer $this$mem) {
        return $this$mem.getMbuffer();
    }

    public static final int getOffset(@NotNull Int8Buffer $this$offset) {
        ByteBuffer byteBuffer = $this$offset.getJbuffer();
        Intrinsics.checkNotNull((Object)byteBuffer, (String)"null cannot be cast to non-null type java.nio.Buffer");
        return ((Buffer)byteBuffer).position();
    }

    public static final int getSize(@NotNull Int8Buffer $this$size) {
        ByteBuffer byteBuffer = $this$size.getJbuffer();
        Intrinsics.checkNotNull((Object)byteBuffer, (String)"null cannot be cast to non-null type java.nio.Buffer");
        return ((Buffer)byteBuffer).limit() - BufferJvmKt.getOffset($this$size);
    }

    public static final byte get(@NotNull Int8Buffer $this$get, int index) {
        return $this$get.getJbuffer().get(BufferJvmKt.getOffset($this$get) + index);
    }

    public static final void set(@NotNull Int8Buffer $this$set, int index, byte value) {
        $this$set.getJbuffer().put(BufferJvmKt.getOffset($this$set) + index, value);
    }

    @NotNull
    public static final MemBuffer getMem(@NotNull Int16Buffer $this$mem) {
        return $this$mem.getMbuffer();
    }

    public static final int getOffset(@NotNull Int16Buffer $this$offset) {
        ShortBuffer shortBuffer = $this$offset.getJbuffer();
        Intrinsics.checkNotNull((Object)shortBuffer, (String)"null cannot be cast to non-null type java.nio.Buffer");
        return ((Buffer)shortBuffer).position();
    }

    public static final int getSize(@NotNull Int16Buffer $this$size) {
        ShortBuffer shortBuffer = $this$size.getJbuffer();
        Intrinsics.checkNotNull((Object)shortBuffer, (String)"null cannot be cast to non-null type java.nio.Buffer");
        return ((Buffer)shortBuffer).limit() - BufferJvmKt.getOffset($this$size);
    }

    public static final short get(@NotNull Int16Buffer $this$get, int index) {
        return $this$get.getJbuffer().get(BufferJvmKt.getOffset($this$get) + index);
    }

    public static final void set(@NotNull Int16Buffer $this$set, int index, short value) {
        $this$set.getJbuffer().put(BufferJvmKt.getOffset($this$set) + index, value);
    }

    @NotNull
    public static final MemBuffer getMem(@NotNull Int32Buffer $this$mem) {
        return $this$mem.getMbuffer();
    }

    public static final int getOffset(@NotNull Int32Buffer $this$offset) {
        IntBuffer intBuffer = $this$offset.getJbuffer();
        Intrinsics.checkNotNull((Object)intBuffer, (String)"null cannot be cast to non-null type java.nio.Buffer");
        return ((Buffer)intBuffer).position();
    }

    public static final int getSize(@NotNull Int32Buffer $this$size) {
        IntBuffer intBuffer = $this$size.getJbuffer();
        Intrinsics.checkNotNull((Object)intBuffer, (String)"null cannot be cast to non-null type java.nio.Buffer");
        return ((Buffer)intBuffer).limit() - BufferJvmKt.getOffset($this$size);
    }

    public static final int get(@NotNull Int32Buffer $this$get, int index) {
        return $this$get.getJbuffer().get(BufferJvmKt.getOffset($this$get) + index);
    }

    public static final void set(@NotNull Int32Buffer $this$set, int index, int value) {
        $this$set.getJbuffer().put(BufferJvmKt.getOffset($this$set) + index, value);
    }

    @NotNull
    public static final MemBuffer getMem(@NotNull Float32Buffer $this$mem) {
        return $this$mem.getMbuffer();
    }

    public static final int getOffset(@NotNull Float32Buffer $this$offset) {
        FloatBuffer floatBuffer = $this$offset.getJbuffer();
        Intrinsics.checkNotNull((Object)floatBuffer, (String)"null cannot be cast to non-null type java.nio.Buffer");
        return ((Buffer)floatBuffer).position();
    }

    public static final int getSize(@NotNull Float32Buffer $this$size) {
        FloatBuffer floatBuffer = $this$size.getJbuffer();
        Intrinsics.checkNotNull((Object)floatBuffer, (String)"null cannot be cast to non-null type java.nio.Buffer");
        return ((Buffer)floatBuffer).limit() - BufferJvmKt.getOffset($this$size);
    }

    public static final float get(@NotNull Float32Buffer $this$get, int index) {
        return $this$get.getJbuffer().get(BufferJvmKt.getOffset($this$get) + index);
    }

    public static final void set(@NotNull Float32Buffer $this$set, int index, float value) {
        $this$set.getJbuffer().put(BufferJvmKt.getOffset($this$set) + index, value);
    }

    @NotNull
    public static final MemBuffer getMem(@NotNull Float64Buffer $this$mem) {
        return $this$mem.getMbuffer();
    }

    public static final int getOffset(@NotNull Float64Buffer $this$offset) {
        DoubleBuffer doubleBuffer = $this$offset.getJbuffer();
        Intrinsics.checkNotNull((Object)doubleBuffer, (String)"null cannot be cast to non-null type java.nio.Buffer");
        return ((Buffer)doubleBuffer).position();
    }

    public static final int getSize(@NotNull Float64Buffer $this$size) {
        DoubleBuffer doubleBuffer = $this$size.getJbuffer();
        Intrinsics.checkNotNull((Object)doubleBuffer, (String)"null cannot be cast to non-null type java.nio.Buffer");
        return ((Buffer)doubleBuffer).limit() - BufferJvmKt.getOffset($this$size);
    }

    public static final double get(@NotNull Float64Buffer $this$get, int index) {
        return $this$get.getJbuffer().get(BufferJvmKt.getOffset($this$get) + index);
    }

    public static final void set(@NotNull Float64Buffer $this$set, int index, double value) {
        $this$set.getJbuffer().put(BufferJvmKt.getOffset($this$set) + index, value);
    }

    public static final ByteBuffer set(@NotNull ByteBuffer $this$set, int index, byte value) {
        boolean $i$f$set = false;
        return $this$set.put(index, value);
    }

    public static final ShortBuffer set(@NotNull ShortBuffer $this$set, int index, short value) {
        boolean $i$f$set = false;
        return $this$set.put(index, value);
    }

    public static final IntBuffer set(@NotNull IntBuffer $this$set, int index, int value) {
        boolean $i$f$set = false;
        return $this$set.put(index, value);
    }

    public static final FloatBuffer set(@NotNull FloatBuffer $this$set, int index, float value) {
        boolean $i$f$set = false;
        return $this$set.put(index, value);
    }

    public static final DoubleBuffer set(@NotNull DoubleBuffer $this$set, int index, double value) {
        boolean $i$f$set = false;
        return $this$set.put(index, value);
    }

    public static final ByteBuffer set(@NotNull MemBuffer $this$set, int index, byte value) {
        boolean $i$f$set = false;
        return $this$set.getBuffer().put(index, value);
    }

    public static final byte get(@NotNull MemBuffer $this$get, int index) {
        boolean $i$f$get = false;
        return $this$get.getBuffer().get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T keepPositionLimit(@NotNull Buffer $this$keepPositionLimit, @NotNull Function0<? extends T> block) {
        boolean $i$f$keepPositionLimit = false;
        int oldPos = $this$keepPositionLimit.position();
        int oldLimit = $this$keepPositionLimit.limit();
        try {
            Object object = block.invoke();
            return (T)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            BufferJvmKt.limitSafe($this$keepPositionLimit, oldLimit);
            BufferJvmKt.positionSafe($this$keepPositionLimit, oldPos);
            InlineMarker.finallyEnd((int)1);
        }
    }

    public static final void positionSafe(@NotNull Buffer $this$positionSafe, int newPosition) {
        $this$positionSafe.position(newPosition);
    }

    public static final void limitSafe(@NotNull Buffer $this$limitSafe, int newLimit) {
        $this$limitSafe.limit(newLimit);
    }

    public static final void clearSafe(@NotNull Buffer $this$clearSafe) {
        $this$clearSafe.clear();
    }

    public static final void flipSafe(@NotNull Buffer $this$flipSafe) {
        $this$flipSafe.flip();
    }

    private static final <T> void arraycopy(int size2, Object src, int srcPos, Object dst, int dstPos, Function2<? super Integer, ? super T, Unit> setDst, Function1<? super Integer, ? extends T> getSrc) {
        boolean overlapping;
        boolean $i$f$arraycopy = false;
        boolean bl = overlapping = src == dst && dstPos > srcPos;
        if (overlapping) {
            int n = size2;
            while (--n >= 0) {
                setDst.invoke((Object)(dstPos + n), getSrc.invoke((Object)(srcPos + n)));
            }
        } else {
            for (int n = 0; n < size2; ++n) {
                setDst.invoke((Object)(dstPos + n), getSrc.invoke((Object)(srcPos + n)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void arraycopy(@NotNull MemBuffer src, int srcPos, @NotNull MemBuffer dst, int dstPos, int size2) {
        ByteBuffer srcBuf = src.getBuffer();
        ByteBuffer dstBuf = dst.getBuffer();
        if (!srcBuf.isDirect() && !dstBuf.isDirect()) {
            System.arraycopy(srcBuf.array(), srcPos, dstBuf.array(), dstPos, size2);
            return;
        }
        if (srcBuf == dstBuf) {
            boolean overlapping$iv;
            boolean $i$f$arraycopy = false;
            boolean bl = overlapping$iv = srcBuf == dstBuf && dstPos > srcPos;
            if (overlapping$iv) {
                int n$iv = size2;
                while (--n$iv >= 0) {
                    void value;
                    int it;
                    byte by;
                    int n = srcPos + n$iv;
                    int n2 = dstPos + n$iv;
                    byte by2 = 0;
                    MemBuffer $this$get$iv = src;
                    boolean $i$f$get = false;
                    by2 = by = $this$get$iv.getBuffer().get(it);
                    it = n2;
                    boolean bl2 = false;
                    MemBuffer $this$set$iv = dst;
                    boolean $i$f$set = false;
                    $this$set$iv.getBuffer().put(it, (byte)value);
                }
            } else {
                for (int n$iv = 0; n$iv < size2; ++n$iv) {
                    void value;
                    byte by;
                    int it = srcPos + n$iv;
                    int n = dstPos + n$iv;
                    byte by3 = 0;
                    MemBuffer $this$get$iv = src;
                    boolean $i$f$get = false;
                    by3 = by = $this$get$iv.getBuffer().get(it);
                    it = n;
                    boolean bl3 = false;
                    MemBuffer $this$set$iv = dst;
                    boolean $i$f$set = false;
                    $this$set$iv.getBuffer().put(it, (byte)value);
                }
            }
            return;
        }
        Buffer $this$keepPositionLimit$iv = dstBuf;
        boolean $i$f$keepPositionLimit = false;
        int oldPos$iv = $this$keepPositionLimit$iv.position();
        int oldLimit$iv = $this$keepPositionLimit$iv.limit();
        try {
            ByteBuffer byteBuffer;
            boolean bl = false;
            Buffer $this$keepPositionLimit$iv2 = srcBuf;
            boolean $i$f$keepPositionLimit2 = false;
            int oldPos$iv2 = $this$keepPositionLimit$iv2.position();
            int oldLimit$iv2 = $this$keepPositionLimit$iv2.limit();
            try {
                boolean bl4 = false;
                BufferJvmKt.positionSafe(dstBuf, dstPos);
                BufferJvmKt.positionSafe(srcBuf, srcPos);
                BufferJvmKt.limitSafe(srcBuf, srcPos + size2);
                byteBuffer = dstBuf.put(srcBuf);
            }
            finally {
                BufferJvmKt.limitSafe($this$keepPositionLimit$iv2, oldLimit$iv2);
                BufferJvmKt.positionSafe($this$keepPositionLimit$iv2, oldPos$iv2);
            }
            ByteBuffer byteBuffer2 = byteBuffer;
        }
        finally {
            BufferJvmKt.limitSafe($this$keepPositionLimit$iv, oldLimit$iv);
            BufferJvmKt.positionSafe($this$keepPositionLimit$iv, oldPos$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void arraycopy(@NotNull byte[] src, int srcPos, @NotNull MemBuffer dst, int dstPos, int size2) {
        ByteBuffer dstBuf = dst.getBuffer();
        Buffer $this$keepPositionLimit$iv = dstBuf;
        boolean $i$f$keepPositionLimit = false;
        int oldPos$iv = $this$keepPositionLimit$iv.position();
        int oldLimit$iv = $this$keepPositionLimit$iv.limit();
        try {
            boolean bl = false;
            BufferJvmKt.positionSafe(dstBuf, dstPos);
            ByteBuffer byteBuffer = dstBuf.put(src, srcPos, size2);
        }
        finally {
            BufferJvmKt.limitSafe($this$keepPositionLimit$iv, oldLimit$iv);
            BufferJvmKt.positionSafe($this$keepPositionLimit$iv, oldPos$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void arraycopy(@NotNull MemBuffer src, int srcPos, @NotNull byte[] dst, int dstPos, int size2) {
        ByteBuffer srcBuf = src.getBuffer();
        Buffer $this$keepPositionLimit$iv = srcBuf;
        boolean $i$f$keepPositionLimit = false;
        int oldPos$iv = $this$keepPositionLimit$iv.position();
        int oldLimit$iv = $this$keepPositionLimit$iv.limit();
        try {
            boolean bl = false;
            BufferJvmKt.positionSafe(srcBuf, srcPos);
            ByteBuffer byteBuffer = srcBuf.get(dst, dstPos, size2);
        }
        finally {
            BufferJvmKt.limitSafe($this$keepPositionLimit$iv, oldLimit$iv);
            BufferJvmKt.positionSafe($this$keepPositionLimit$iv, oldPos$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void arraycopy(@NotNull short[] src, int srcPos, @NotNull MemBuffer dst, int dstPos, int size2) {
        boolean overlapping$iv;
        boolean $i$f$arraycopy = false;
        boolean bl = overlapping$iv = src == dst && dstPos > srcPos;
        if (overlapping$iv) {
            int n$iv = size2;
            while (--n$iv >= 0) {
                void value;
                ShortBuffer $this$set$iv;
                int it;
                short s;
                int n = srcPos + n$iv;
                int n2 = dstPos + n$iv;
                short s2 = 0;
                s2 = s = src[it];
                it = n2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)dst.getSbuffer(), (String)"dst.sbuffer");
                boolean $i$f$set = false;
                $this$set$iv.put(it, (short)value);
            }
        } else {
            for (int n$iv = 0; n$iv < size2; ++n$iv) {
                void value;
                ShortBuffer $this$set$iv;
                short s;
                int it = srcPos + n$iv;
                int n = dstPos + n$iv;
                short s3 = 0;
                s3 = s = src[it];
                it = n;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)dst.getSbuffer(), (String)"dst.sbuffer");
                boolean $i$f$set = false;
                $this$set$iv.put(it, (short)value);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void arraycopy(@NotNull MemBuffer src, int srcPos, @NotNull short[] dst, int dstPos, int size2) {
        boolean overlapping$iv;
        boolean $i$f$arraycopy = false;
        boolean bl = overlapping$iv = src == dst && dstPos > srcPos;
        if (overlapping$iv) {
            int n$iv = size2;
            while (--n$iv >= 0) {
                void value;
                int it;
                short s;
                int n = srcPos + n$iv;
                int n2 = dstPos + n$iv;
                short s2 = 0;
                s2 = s = src.getSbuffer().get(it);
                it = n2;
                boolean bl2 = false;
                dst[it] = value;
            }
        } else {
            for (int n$iv = 0; n$iv < size2; ++n$iv) {
                void value;
                short s;
                int it = srcPos + n$iv;
                int n = dstPos + n$iv;
                short s3 = 0;
                s3 = s = src.getSbuffer().get(it);
                it = n;
                boolean bl3 = false;
                dst[it] = value;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void arraycopy(@NotNull int[] src, int srcPos, @NotNull MemBuffer dst, int dstPos, int size2) {
        boolean overlapping$iv;
        boolean $i$f$arraycopy = false;
        boolean bl = overlapping$iv = src == dst && dstPos > srcPos;
        if (overlapping$iv) {
            int n$iv = size2;
            while (--n$iv >= 0) {
                void value;
                IntBuffer $this$set$iv;
                int it;
                int n;
                int n2 = srcPos + n$iv;
                int n3 = dstPos + n$iv;
                int n4 = 0;
                n4 = n = src[it];
                it = n3;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)dst.getIbuffer(), (String)"dst.ibuffer");
                boolean $i$f$set = false;
                $this$set$iv.put(it, (int)value);
            }
        } else {
            for (int n$iv = 0; n$iv < size2; ++n$iv) {
                void value;
                IntBuffer $this$set$iv;
                int n;
                int it = srcPos + n$iv;
                int n5 = dstPos + n$iv;
                int n6 = 0;
                n6 = n = src[it];
                it = n5;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)dst.getIbuffer(), (String)"dst.ibuffer");
                boolean $i$f$set = false;
                $this$set$iv.put(it, (int)value);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void arraycopy(@NotNull MemBuffer src, int srcPos, @NotNull int[] dst, int dstPos, int size2) {
        boolean overlapping$iv;
        boolean $i$f$arraycopy = false;
        boolean bl = overlapping$iv = src == dst && dstPos > srcPos;
        if (overlapping$iv) {
            int n$iv = size2;
            while (--n$iv >= 0) {
                void value;
                int it;
                int n;
                int n2 = srcPos + n$iv;
                int n3 = dstPos + n$iv;
                int n4 = 0;
                n4 = n = src.getIbuffer().get(it);
                it = n3;
                boolean bl2 = false;
                dst[it] = value;
            }
        } else {
            for (int n$iv = 0; n$iv < size2; ++n$iv) {
                void value;
                int n;
                int it = srcPos + n$iv;
                int n5 = dstPos + n$iv;
                int n6 = 0;
                n6 = n = src.getIbuffer().get(it);
                it = n5;
                boolean bl3 = false;
                dst[it] = value;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void arraycopy(@NotNull float[] src, int srcPos, @NotNull MemBuffer dst, int dstPos, int size2) {
        boolean overlapping$iv;
        boolean $i$f$arraycopy = false;
        boolean bl = overlapping$iv = src == dst && dstPos > srcPos;
        if (overlapping$iv) {
            int n$iv = size2;
            while (--n$iv >= 0) {
                void value;
                FloatBuffer $this$set$iv;
                int it;
                float f;
                int n = srcPos + n$iv;
                int n2 = dstPos + n$iv;
                boolean $i$a$-arraycopy-BufferJvmKt$arraycopy$162 = false;
                float $i$a$-arraycopy-BufferJvmKt$arraycopy$162 = f = src[it];
                it = n2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)dst.getFbuffer(), (String)"dst.fbuffer");
                boolean $i$f$set = false;
                $this$set$iv.put(it, (float)value);
            }
        } else {
            for (int n$iv = 0; n$iv < size2; ++n$iv) {
                void value;
                FloatBuffer $this$set$iv;
                float f;
                int it = srcPos + n$iv;
                int n = dstPos + n$iv;
                boolean $i$a$-arraycopy-BufferJvmKt$arraycopy$172 = false;
                float $i$a$-arraycopy-BufferJvmKt$arraycopy$172 = f = src[it];
                it = n;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)dst.getFbuffer(), (String)"dst.fbuffer");
                boolean $i$f$set = false;
                $this$set$iv.put(it, (float)value);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void arraycopy(@NotNull MemBuffer src, int srcPos, @NotNull float[] dst, int dstPos, int size2) {
        boolean overlapping$iv;
        boolean $i$f$arraycopy = false;
        boolean bl = overlapping$iv = src == dst && dstPos > srcPos;
        if (overlapping$iv) {
            int n$iv = size2;
            while (--n$iv >= 0) {
                void value;
                int it;
                float f;
                int n = srcPos + n$iv;
                int n2 = dstPos + n$iv;
                boolean $i$a$-arraycopy-BufferJvmKt$arraycopy$182 = false;
                float $i$a$-arraycopy-BufferJvmKt$arraycopy$182 = f = src.getFbuffer().get(it);
                it = n2;
                boolean bl2 = false;
                dst[it] = value;
            }
        } else {
            for (int n$iv = 0; n$iv < size2; ++n$iv) {
                void value;
                float f;
                int it = srcPos + n$iv;
                int n = dstPos + n$iv;
                boolean $i$a$-arraycopy-BufferJvmKt$arraycopy$192 = false;
                float $i$a$-arraycopy-BufferJvmKt$arraycopy$192 = f = src.getFbuffer().get(it);
                it = n;
                boolean bl3 = false;
                dst[it] = value;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void arraycopy(@NotNull double[] src, int srcPos, @NotNull MemBuffer dst, int dstPos, int size2) {
        boolean overlapping$iv;
        boolean $i$f$arraycopy = false;
        boolean bl = overlapping$iv = src == dst && dstPos > srcPos;
        if (overlapping$iv) {
            int n$iv = size2;
            while (--n$iv >= 0) {
                void value;
                DoubleBuffer $this$set$iv;
                int it;
                double d;
                int n = srcPos + n$iv;
                int n2 = dstPos + n$iv;
                boolean bl2 = false;
                double d2 = d = src[it];
                it = n2;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)dst.getDbuffer(), (String)"dst.dbuffer");
                boolean $i$f$set = false;
                $this$set$iv.put(it, (double)value);
            }
        } else {
            for (int n$iv = 0; n$iv < size2; ++n$iv) {
                DoubleBuffer $this$set$iv;
                double d;
                int it = srcPos + n$iv;
                int n = dstPos + n$iv;
                boolean bl4 = false;
                double value = d = src[it];
                it = n;
                boolean bl5 = false;
                Intrinsics.checkNotNullExpressionValue((Object)dst.getDbuffer(), (String)"dst.dbuffer");
                boolean $i$f$set = false;
                $this$set$iv.put(it, value);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void arraycopy(@NotNull MemBuffer src, int srcPos, @NotNull double[] dst, int dstPos, int size2) {
        boolean overlapping$iv;
        boolean $i$f$arraycopy = false;
        boolean bl = overlapping$iv = src == dst && dstPos > srcPos;
        if (overlapping$iv) {
            int n$iv = size2;
            while (--n$iv >= 0) {
                void value;
                int it;
                double d;
                int n = srcPos + n$iv;
                int n2 = dstPos + n$iv;
                boolean bl2 = false;
                double d2 = d = src.getDbuffer().get(it);
                it = n2;
                boolean bl3 = false;
                dst[it] = value;
            }
        } else {
            for (int n$iv = 0; n$iv < size2; ++n$iv) {
                double d;
                int it = srcPos + n$iv;
                int n = dstPos + n$iv;
                boolean bl4 = false;
                double value = d = src.getDbuffer().get(it);
                it = n;
                boolean bl5 = false;
                dst[it] = value;
            }
        }
    }
}

