/*
 * Decompiled with CFR 0.152.
 */
package korlibs.memory;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import korlibs.memory.BufferJvmKt;
import korlibs.memory.BufferKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\u001a\u0010\u0011\u001a\u00020\u00032\b\b\u0002\u0010\u0012\u001a\u00020\u00052\b\b\u0002\u0010\u0013\u001a\u00020\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lkorlibs/memory/Buffer;", "", "buffer", "Ljava/nio/ByteBuffer;", "offset", "", "size", "(Ljava/nio/ByteBuffer;II)V", "getBuffer", "()Ljava/nio/ByteBuffer;", "getOffset", "()I", "getSize", "equals", "", "other", "hashCode", "slicedBuffer", "roffset", "rsize", "toString", "", "Companion", "kmem_release"})
public final class Buffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBuffer buffer;
    private final int offset;
    private final int size;

    public Buffer(@NotNull ByteBuffer buffer, int offset, int size2) {
        this.buffer = buffer;
        this.offset = offset;
        this.size = size2;
    }

    @NotNull
    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public final ByteBuffer slicedBuffer(int roffset, int rsize) {
        ByteBuffer byteBuffer;
        int pos = this.offset + roffset;
        ByteBuffer it = byteBuffer = this.buffer.duplicate();
        boolean bl = false;
        it.order(ByteOrder.nativeOrder());
        Intrinsics.checkNotNull((Object)it);
        BufferJvmKt.positionSafe(it, pos);
        BufferJvmKt.limitSafe(it, pos + rsize);
        ByteBuffer byteBuffer2 = byteBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"also(...)");
        return byteBuffer2;
    }

    public static /* synthetic */ ByteBuffer slicedBuffer$default(Buffer buffer, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = buffer.size - n;
        }
        return buffer.slicedBuffer(n, n2);
    }

    @NotNull
    public String toString() {
        return BufferKt.NBuffer_toString(this);
    }

    public int hashCode() {
        int h = 1;
        int n = this.size;
        for (int n2 = 0; n2 < n; ++n2) {
            h = 31 * h + this.buffer.get(this.offset + n2);
        }
        return h;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Buffer) || this.size != ((Buffer)other).size) {
            return false;
        }
        ByteBuffer t = this.buffer;
        ByteBuffer o = ((Buffer)other).buffer;
        int n = this.size;
        for (int n2 = 0; n2 < n; ++n2) {
            if (t.get(this.offset + n2) == o.get(((Buffer)other).offset + n2)) continue;
            return false;
        }
        return true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bJ.\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b\u00a8\u0006\u000e"}, d2={"Lkorlibs/memory/Buffer$Companion;", "", "()V", "copy", "", "src", "Lkorlibs/memory/Buffer;", "srcPosBytes", "", "dst", "dstPosBytes", "sizeInBytes", "equals", "", "kmem_release"})
    @SourceDebugExtension(value={"SMAP\nBufferJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferJvm.kt\nkorlibs/memory/Buffer$Companion\n+ 2 Arrays.kt\nkorlibs/memory/ArraysKt\n*L\n1#1,178:1\n90#2,8:179\n*S KotlinDebug\n*F\n+ 1 BufferJvm.kt\nkorlibs/memory/Buffer$Companion\n*L\n63#1:179,8\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean equals(@NotNull Buffer src, int srcPosBytes, @NotNull Buffer dst, int dstPosBytes, int sizeInBytes) {
            return Intrinsics.areEqual((Object)src.slicedBuffer(srcPosBytes, sizeInBytes), (Object)dst.slicedBuffer(dstPosBytes, sizeInBytes));
        }

        /*
         * WARNING - void declaration
         */
        public final void copy(@NotNull Buffer src, int srcPosBytes, @NotNull Buffer dst, int dstPosBytes, int sizeInBytes) {
            ByteBuffer srcBuf = src.getBuffer();
            ByteBuffer dstBuf = dst.getBuffer();
            int srcPos = src.getOffset() + srcPosBytes;
            int dstPos = dst.getOffset() + dstPosBytes;
            int size2 = sizeInBytes;
            if (!srcBuf.isDirect() && !dstBuf.isDirect()) {
                System.arraycopy(srcBuf.array(), srcPos, dstBuf.array(), dstPos, size2);
                return;
            }
            if (srcBuf == dstBuf) {
                boolean overlapping$iv;
                boolean $i$f$arraycopy = false;
                boolean bl = overlapping$iv = srcBuf == dstBuf && dstPosBytes > srcPosBytes;
                if (overlapping$iv) {
                    int n$iv = size2;
                    while (--n$iv >= 0) {
                        void value;
                        int it;
                        int n;
                        int n2 = srcPosBytes + n$iv;
                        int n3 = dstPosBytes + n$iv;
                        int n4 = 0;
                        n4 = n = BufferKt.getUnalignedUInt8(src, it);
                        it = n3;
                        boolean bl2 = false;
                        BufferKt.setUnalignedUInt8(dst, it, (int)value);
                    }
                } else {
                    for (int n$iv = 0; n$iv < size2; ++n$iv) {
                        void value;
                        int n;
                        int it = srcPosBytes + n$iv;
                        int n5 = dstPosBytes + n$iv;
                        int n6 = 0;
                        n6 = n = BufferKt.getUnalignedUInt8(src, it);
                        it = n5;
                        boolean bl3 = false;
                        BufferKt.setUnalignedUInt8(dst, it, (int)value);
                    }
                }
                return;
            }
            dst.slicedBuffer(dstPosBytes, sizeInBytes).put(src.slicedBuffer(srcPosBytes, sizeInBytes));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

