/*
 * Decompiled with CFR 0.152.
 */
package korlibs.memory;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import korlibs.memory.Buffer;
import korlibs.memory.BufferKt;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000z\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0005\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\"\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00012\b\b\u0002\u0010\u0017\u001a\u00020\u0001\u001a\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00012\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u001a@\u0010\u001a\u001a\u0002H\u001b\"\b\b\u0000\u0010\u001b*\u00020\u001c*\u0002H\u001b2\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00012\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u0002H\u001b0\u001eH\u0086\b\u00a2\u0006\u0002\u0010\u001f\u001a\u001c\u0010 \u001a\u00020!*\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0001H\u0001\u001a\n\u0010\"\u001a\u00020!*\u00020\u001c\u001a\n\u0010#\u001a\u00020!*\u00020\u001c\u001a\u0012\u0010$\u001a\u00020%*\u00020\u00022\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0012\u0010&\u001a\u00020'*\u00020\u00022\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0012\u0010(\u001a\u00020)*\u00020\u00022\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0012\u0010*\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0012\u0010+\u001a\u00020,*\u00020\u00022\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0012\u0010-\u001a\u00020.*\u00020\u00022\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0012\u0010/\u001a\u00020!*\u00020\u001c2\u0006\u00100\u001a\u00020\u0001\u001a\u0012\u00101\u001a\u00020!*\u00020\u001c2\u0006\u00102\u001a\u00020\u0001\u001a\u001a\u00103\u001a\u00020!*\u00020\u00022\u0006\u0010\u0000\u001a\u00020\u00012\u0006\u00104\u001a\u00020%\u001a\u001a\u00105\u001a\u00020!*\u00020\u00022\u0006\u0010\u0000\u001a\u00020\u00012\u0006\u00104\u001a\u00020'\u001a\u001a\u00106\u001a\u00020!*\u00020\u00022\u0006\u0010\u0000\u001a\u00020\u00012\u0006\u00104\u001a\u00020)\u001a\u001a\u00107\u001a\u00020!*\u00020\u00022\u0006\u0010\u0000\u001a\u00020\u00012\u0006\u00104\u001a\u00020\u0001\u001a\u001a\u00108\u001a\u00020!*\u00020\u00022\u0006\u0010\u0000\u001a\u00020\u00012\u0006\u00104\u001a\u00020,\u001a\u001a\u00109\u001a\u00020!*\u00020\u00022\u0006\u0010\u0000\u001a\u00020\u00012\u0006\u00104\u001a\u00020.\u001a\u001a\u0010:\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0001\u001a\u001a\u0010:\u001a\u00020;*\u00020;2\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0001\u001a\u001a\u0010:\u001a\u00020\n*\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0001\u001a\u001a\u0010:\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0001\u001a\u001a\u0010:\u001a\u00020<*\u00020<2\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0001\u001a\u001a\u0010=\u001a\u00020\u0002*\u00020\u00022\u0006\u0010>\u001a\u00020\u00012\u0006\u0010?\u001a\u00020\u0001\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0015\u0010\r\u001a\u00020\u000e*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u0015\u0010\u0011\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0004\u00a8\u0006@"}, d2={"byteOffset", "", "Lkorlibs/memory/Buffer;", "getByteOffset", "(Lkorlibs/memory/Buffer;)I", "nioBuffer", "Ljava/nio/ByteBuffer;", "getNioBuffer", "(Lkorlibs/memory/Buffer;)Ljava/nio/ByteBuffer;", "nioFloatBuffer", "Ljava/nio/FloatBuffer;", "getNioFloatBuffer", "(Lkorlibs/memory/Buffer;)Ljava/nio/FloatBuffer;", "nioIntBuffer", "Ljava/nio/IntBuffer;", "getNioIntBuffer", "(Lkorlibs/memory/Buffer;)Ljava/nio/IntBuffer;", "sizeInBytes", "getSizeInBytes", "Buffer", "array", "", "offset", "size", "direct", "", "_slice", "T", "Ljava/nio/Buffer;", "dup", "Lkotlin/Function1;", "(Ljava/nio/Buffer;IILkotlin/jvm/functions/Function1;)Ljava/nio/Buffer;", "checkSliceBounds", "", "clearSafe", "flipSafe", "getUnalignedFloat32", "", "getUnalignedFloat64", "", "getUnalignedInt16", "", "getUnalignedInt32", "getUnalignedInt64", "", "getUnalignedInt8", "", "limitSafe", "newLimit", "positionSafe", "newPosition", "setUnalignedFloat32", "value", "setUnalignedFloat64", "setUnalignedInt16", "setUnalignedInt32", "setUnalignedInt64", "setUnalignedInt8", "slice", "Ljava/nio/DoubleBuffer;", "Ljava/nio/ShortBuffer;", "sliceInternal", "start", "end", "kmem_release"})
@SourceDebugExtension(value={"SMAP\nBufferJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferJvm.kt\nkorlibs/memory/BufferJvmKt\n*L\n1#1,178:1\n160#1,7:179\n160#1,7:186\n160#1,7:193\n160#1,7:200\n160#1,7:207\n*S KotlinDebug\n*F\n+ 1 BufferJvm.kt\nkorlibs/memory/BufferJvmKt\n*L\n169#1:179,7\n170#1:186,7\n171#1:193,7\n172#1:200,7\n173#1:207,7\n*E\n"})
public final class BufferJvmKt {
    @NotNull
    public static final Buffer Buffer(int size2, boolean direct) {
        BufferKt.checkNBufferSize(size2);
        ByteBuffer byteBuffer = direct ? ByteBuffer.allocateDirect(size2).order(ByteOrder.nativeOrder()) : ByteBuffer.wrap(new byte[size2]).order(ByteOrder.nativeOrder());
        Intrinsics.checkNotNull((Object)byteBuffer);
        return new Buffer(byteBuffer, 0, size2);
    }

    public static /* synthetic */ Buffer Buffer$default(int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return BufferJvmKt.Buffer(n, bl);
    }

    @NotNull
    public static final Buffer Buffer(@NotNull byte[] array, int offset, int size2) {
        BufferKt.checkNBufferWrap(array, offset, size2);
        ByteBuffer byteBuffer = ByteBuffer.wrap(array, offset, size2).order(ByteOrder.nativeOrder());
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"order(...)");
        return new Buffer(byteBuffer, offset, size2);
    }

    public static /* synthetic */ Buffer Buffer$default(byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length - n;
        }
        return BufferJvmKt.Buffer(byArray, n, n2);
    }

    public static final int getByteOffset(@NotNull Buffer $this$byteOffset) {
        return $this$byteOffset.getOffset();
    }

    public static final int getSizeInBytes(@NotNull Buffer $this$sizeInBytes) {
        return $this$sizeInBytes.getSize();
    }

    @NotNull
    public static final Buffer sliceInternal(@NotNull Buffer $this$sliceInternal, int start, int end) {
        return new Buffer($this$sliceInternal.getBuffer(), $this$sliceInternal.getOffset() + start, end - start);
    }

    public static final byte getUnalignedInt8(@NotNull Buffer $this$getUnalignedInt8, int byteOffset) {
        return $this$getUnalignedInt8.getBuffer().get($this$getUnalignedInt8.getOffset() + byteOffset);
    }

    public static final short getUnalignedInt16(@NotNull Buffer $this$getUnalignedInt16, int byteOffset) {
        return $this$getUnalignedInt16.getBuffer().getShort($this$getUnalignedInt16.getOffset() + byteOffset);
    }

    public static final int getUnalignedInt32(@NotNull Buffer $this$getUnalignedInt32, int byteOffset) {
        return $this$getUnalignedInt32.getBuffer().getInt($this$getUnalignedInt32.getOffset() + byteOffset);
    }

    public static final long getUnalignedInt64(@NotNull Buffer $this$getUnalignedInt64, int byteOffset) {
        return $this$getUnalignedInt64.getBuffer().getLong($this$getUnalignedInt64.getOffset() + byteOffset);
    }

    public static final float getUnalignedFloat32(@NotNull Buffer $this$getUnalignedFloat32, int byteOffset) {
        return $this$getUnalignedFloat32.getBuffer().getFloat($this$getUnalignedFloat32.getOffset() + byteOffset);
    }

    public static final double getUnalignedFloat64(@NotNull Buffer $this$getUnalignedFloat64, int byteOffset) {
        return $this$getUnalignedFloat64.getBuffer().getDouble($this$getUnalignedFloat64.getOffset() + byteOffset);
    }

    public static final void setUnalignedInt8(@NotNull Buffer $this$setUnalignedInt8, int byteOffset, byte value) {
        $this$setUnalignedInt8.getBuffer().put($this$setUnalignedInt8.getOffset() + byteOffset, value);
    }

    public static final void setUnalignedInt16(@NotNull Buffer $this$setUnalignedInt16, int byteOffset, short value) {
        $this$setUnalignedInt16.getBuffer().putShort($this$setUnalignedInt16.getOffset() + byteOffset, value);
    }

    public static final void setUnalignedInt32(@NotNull Buffer $this$setUnalignedInt32, int byteOffset, int value) {
        $this$setUnalignedInt32.getBuffer().putInt($this$setUnalignedInt32.getOffset() + byteOffset, value);
    }

    public static final void setUnalignedInt64(@NotNull Buffer $this$setUnalignedInt64, int byteOffset, long value) {
        $this$setUnalignedInt64.getBuffer().putLong($this$setUnalignedInt64.getOffset() + byteOffset, value);
    }

    public static final void setUnalignedFloat32(@NotNull Buffer $this$setUnalignedFloat32, int byteOffset, float value) {
        $this$setUnalignedFloat32.getBuffer().putFloat($this$setUnalignedFloat32.getOffset() + byteOffset, value);
    }

    public static final void setUnalignedFloat64(@NotNull Buffer $this$setUnalignedFloat64, int byteOffset, double value) {
        $this$setUnalignedFloat64.getBuffer().putDouble($this$setUnalignedFloat64.getOffset() + byteOffset, value);
    }

    @PublishedApi
    public static final void checkSliceBounds(@NotNull java.nio.Buffer $this$checkSliceBounds, int offset, int size2) {
    }

    public static final void positionSafe(@NotNull java.nio.Buffer $this$positionSafe, int newPosition) {
        $this$positionSafe.position(newPosition);
    }

    public static final void limitSafe(@NotNull java.nio.Buffer $this$limitSafe, int newLimit) {
        $this$limitSafe.limit(newLimit);
    }

    public static final void flipSafe(@NotNull java.nio.Buffer $this$flipSafe) {
        $this$flipSafe.flip();
    }

    public static final void clearSafe(@NotNull java.nio.Buffer $this$clearSafe) {
        $this$clearSafe.clear();
    }

    @NotNull
    public static final <T extends java.nio.Buffer> T _slice(@NotNull T $this$_slice, int offset, int size2, @NotNull Function1<? super T, ? extends T> dup) {
        boolean $i$f$_slice = false;
        BufferJvmKt.checkSliceBounds($this$_slice, offset, size2);
        java.nio.Buffer out = (java.nio.Buffer)dup.invoke($this$_slice);
        int start = $this$_slice.position() + offset;
        int end = start + size2;
        BufferJvmKt.positionSafe(out, start);
        BufferJvmKt.limitSafe(out, end);
        return (T)out;
    }

    @NotNull
    public static final ByteBuffer slice(@NotNull ByteBuffer $this$slice, int offset, int size2) {
        java.nio.Buffer $this$_slice$iv = $this$slice;
        boolean $i$f$_slice = false;
        BufferJvmKt.checkSliceBounds($this$_slice$iv, offset, size2);
        ByteBuffer it = (ByteBuffer)$this$_slice$iv;
        boolean bl = false;
        ByteBuffer byteBuffer = it.duplicate();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"duplicate(...)");
        java.nio.Buffer out$iv = byteBuffer;
        int start$iv = $this$_slice$iv.position() + offset;
        int end$iv = start$iv + size2;
        BufferJvmKt.positionSafe(out$iv, start$iv);
        BufferJvmKt.limitSafe(out$iv, end$iv);
        return (ByteBuffer)out$iv;
    }

    @NotNull
    public static final ShortBuffer slice(@NotNull ShortBuffer $this$slice, int offset, int size2) {
        java.nio.Buffer $this$_slice$iv = $this$slice;
        boolean $i$f$_slice = false;
        BufferJvmKt.checkSliceBounds($this$_slice$iv, offset, size2);
        ShortBuffer it = (ShortBuffer)$this$_slice$iv;
        boolean bl = false;
        ShortBuffer shortBuffer = it.duplicate();
        Intrinsics.checkNotNullExpressionValue((Object)shortBuffer, (String)"duplicate(...)");
        java.nio.Buffer out$iv = shortBuffer;
        int start$iv = $this$_slice$iv.position() + offset;
        int end$iv = start$iv + size2;
        BufferJvmKt.positionSafe(out$iv, start$iv);
        BufferJvmKt.limitSafe(out$iv, end$iv);
        return (ShortBuffer)out$iv;
    }

    @NotNull
    public static final IntBuffer slice(@NotNull IntBuffer $this$slice, int offset, int size2) {
        java.nio.Buffer $this$_slice$iv = $this$slice;
        boolean $i$f$_slice = false;
        BufferJvmKt.checkSliceBounds($this$_slice$iv, offset, size2);
        IntBuffer it = (IntBuffer)$this$_slice$iv;
        boolean bl = false;
        IntBuffer intBuffer = it.duplicate();
        Intrinsics.checkNotNullExpressionValue((Object)intBuffer, (String)"duplicate(...)");
        java.nio.Buffer out$iv = intBuffer;
        int start$iv = $this$_slice$iv.position() + offset;
        int end$iv = start$iv + size2;
        BufferJvmKt.positionSafe(out$iv, start$iv);
        BufferJvmKt.limitSafe(out$iv, end$iv);
        return (IntBuffer)out$iv;
    }

    @NotNull
    public static final FloatBuffer slice(@NotNull FloatBuffer $this$slice, int offset, int size2) {
        java.nio.Buffer $this$_slice$iv = $this$slice;
        boolean $i$f$_slice = false;
        BufferJvmKt.checkSliceBounds($this$_slice$iv, offset, size2);
        FloatBuffer it = (FloatBuffer)$this$_slice$iv;
        boolean bl = false;
        FloatBuffer floatBuffer = it.duplicate();
        Intrinsics.checkNotNullExpressionValue((Object)floatBuffer, (String)"duplicate(...)");
        java.nio.Buffer out$iv = floatBuffer;
        int start$iv = $this$_slice$iv.position() + offset;
        int end$iv = start$iv + size2;
        BufferJvmKt.positionSafe(out$iv, start$iv);
        BufferJvmKt.limitSafe(out$iv, end$iv);
        return (FloatBuffer)out$iv;
    }

    @NotNull
    public static final DoubleBuffer slice(@NotNull DoubleBuffer $this$slice, int offset, int size2) {
        java.nio.Buffer $this$_slice$iv = $this$slice;
        boolean $i$f$_slice = false;
        BufferJvmKt.checkSliceBounds($this$_slice$iv, offset, size2);
        DoubleBuffer it = (DoubleBuffer)$this$_slice$iv;
        boolean bl = false;
        DoubleBuffer doubleBuffer = it.duplicate();
        Intrinsics.checkNotNullExpressionValue((Object)doubleBuffer, (String)"duplicate(...)");
        java.nio.Buffer out$iv = doubleBuffer;
        int start$iv = $this$_slice$iv.position() + offset;
        int end$iv = start$iv + size2;
        BufferJvmKt.positionSafe(out$iv, start$iv);
        BufferJvmKt.limitSafe(out$iv, end$iv);
        return (DoubleBuffer)out$iv;
    }

    @NotNull
    public static final ByteBuffer getNioBuffer(@NotNull Buffer $this$nioBuffer) {
        return Buffer.slicedBuffer$default($this$nioBuffer, 0, 0, 3, null);
    }

    @NotNull
    public static final IntBuffer getNioIntBuffer(@NotNull Buffer $this$nioIntBuffer) {
        IntBuffer intBuffer = Buffer.slicedBuffer$default($this$nioIntBuffer, 0, 0, 3, null).asIntBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)intBuffer, (String)"asIntBuffer(...)");
        return intBuffer;
    }

    @NotNull
    public static final FloatBuffer getNioFloatBuffer(@NotNull Buffer $this$nioFloatBuffer) {
        FloatBuffer floatBuffer = Buffer.slicedBuffer$default($this$nioFloatBuffer, 0, 0, 3, null).asFloatBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)floatBuffer, (String)"asFloatBuffer(...)");
        return floatBuffer;
    }
}

