/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.krypto;

import com.soywiz.krypto.Hash;
import com.soywiz.krypto.Hasher;
import com.soywiz.krypto.MD5;
import com.soywiz.krypto.SHA1;
import com.soywiz.krypto.SHA256;
import com.soywiz.krypto.internal.KryptoToolsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/soywiz/krypto/HMAC;", "", "()V", "Companion", "krypto_release"})
public final class HMAC {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\u000e"}, d2={"Lcom/soywiz/krypto/HMAC$Companion;", "", "()V", "hmac", "Lcom/soywiz/krypto/Hash;", "key", "", "data", "hasher", "Lcom/soywiz/krypto/Hasher;", "hmac$krypto_release", "hmacMD5", "hmacSHA1", "hmacSHA256", "krypto_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Hash hmacSHA1(@NotNull byte[] key, @NotNull byte[] data) {
            return this.hmac$krypto_release(key, data, new SHA1());
        }

        @NotNull
        public final Hash hmacSHA256(@NotNull byte[] key, @NotNull byte[] data) {
            return this.hmac$krypto_release(key, data, new SHA256());
        }

        @NotNull
        public final Hash hmacMD5(@NotNull byte[] key, @NotNull byte[] data) {
            return this.hmac$krypto_release(key, data, new MD5());
        }

        @NotNull
        public final Hash hmac$krypto_release(@NotNull byte[] key, @NotNull byte[] data, @NotNull Hasher hasher) {
            byte[] key2 = key;
            int blockSize = hasher.getChunkSize();
            if (key2.length > blockSize) {
                hasher.reset();
                hasher.update(key2);
                key2 = hasher.digest().getBytes();
            }
            if (key2.length < blockSize) {
                byte[] newKey = new byte[blockSize];
                KryptoToolsKt.arraycopy(key2, 0, newKey, 0, key2.length);
                key2 = newKey;
            }
            int n = 0;
            byte[] byArray = new byte[blockSize];
            while (n < blockSize) {
                int n2 = n++;
                byArray[n2] = (byte)(0x5C ^ key2[n2]);
            }
            byte[] oKeyPad = byArray;
            int n3 = 0;
            byte[] byArray2 = new byte[blockSize];
            while (n3 < blockSize) {
                int n4 = n3++;
                byArray2[n4] = (byte)(0x36 ^ key2[n4]);
            }
            byte[] iKeyPad = byArray2;
            hasher.reset();
            hasher.update(iKeyPad);
            hasher.update(data);
            byte[] h1 = hasher.digest().getBytes();
            hasher.reset();
            hasher.update(oKeyPad);
            hasher.update(h1);
            return hasher.digest();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

